/*
 * Copyright (c) 2018 Apple Inc. All rights reserved.
 */

#ifndef __OSLOG_ENTRY_ACTIVITY_H__
#define __OSLOG_ENTRY_ACTIVITY_H__

#ifndef __INDIRECT_OSLOG_HEADER_USER__
#error "Please use <OSLog/OSLog.h> instead of directly using this file."
#endif

NS_ASSUME_NONNULL_BEGIN

/*!
 * @class OSLogEntryActivity
 *
 * @abstract
 * An entry generated by an activity event.
 */
API_AVAILABLE(macos(10.15)) API_UNAVAILABLE(ios, tvos, watchos)
OS_EXPORT
@interface OSLogEntryActivity : OSLogEntry <OSLogEntryFromProcess>

/*!
 * @property parentActivityIdentifier
 *
 * @abstract
 * This parent activity's activity ID.
 */
@property (nonatomic, readonly) os_activity_id_t parentActivityIdentifier;

@end

NS_ASSUME_NONNULL_END

#endif /* __OSLOG_ENTRY_ACTIVITY_H__ */
