'\"
'\" Generated from file '/Library/Caches/com.apple.xbs/Sources/tcl/tcl-129.100.1/tcl_ext/tcllib/tcllib/modules/ftp/ftp.man' by tcllib/doctools with format 'nroff'
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "ftp" n 2.4.9 ftp "ftp client"
.BS
.SH NAME
ftp \- Client-side tcl implementation of the ftp protocol
.SH SYNOPSIS
package require \fBTcl  8.2\fR
.sp
package require \fBftp  ?2.4.9?\fR
.sp
\fB::ftp::Open\fR \fIserver\fR \fIuser\fR \fIpasswd\fR ?\fIoptions\fR?
.sp
\fB::ftp::Close\fR \fIhandle\fR
.sp
\fB::ftp::Cd\fR \fIhandle\fR \fIdirectory\fR
.sp
\fB::ftp::Pwd\fR \fIhandle\fR
.sp
\fB::ftp::Type\fR \fIhandle\fR ?\fBascii|binary|tenex\fR?
.sp
\fB::ftp::List\fR \fIhandle\fR ?\fIpattern\fR?
.sp
\fB::ftp::NList\fR \fIhandle\fR ?\fIdirectory\fR?
.sp
\fB::ftp::FileSize\fR \fIhandle\fR \fIfile\fR
.sp
\fB::ftp::ModTime\fR \fIhandle\fR \fIfile\fR
.sp
\fB::ftp::Delete\fR \fIhandle\fR \fIfile\fR
.sp
\fB::ftp::Rename\fR \fIhandle\fR \fIfrom\fR \fIto\fR
.sp
\fB::ftp::Put\fR \fIhandle\fR (\fIlocal\fR | -data \fIdata\fR | -channel \fIchan\fR) ?\fIremote\fR?
.sp
\fB::ftp::Append\fR \fIhandle\fR (\fIlocal\fR | -data \fIdata\fR | -channel \fIchan\fR) ?\fIremote\fR?
.sp
\fB::ftp::Get\fR \fIhandle\fR \fIremote\fR ?(\fIlocal\fR | -variable \fIvarname\fR | -channel \fIchan\fR)?
.sp
\fB::ftp::Reget\fR \fIhandle\fR \fIremote\fR ?\fIlocal\fR? ?\fIfrom\fR? ?\fIto\fR?
.sp
\fB::ftp::Newer\fR \fIhandle\fR \fIremote\fR ?\fIlocal\fR?
.sp
\fB::ftp::MkDir\fR \fIhandle\fR \fIdirectory\fR
.sp
\fB::ftp::RmDir\fR \fIhandle\fR \fIdirectory\fR
.sp
\fB::ftp::Quote\fR \fIhandle\fR \fIarg1\fR \fIarg2\fR \fI...\fR
.sp
\fB::ftp::DisplayMsg\fR \fIhandle\fR \fImsg\fR ?\fIstate\fR?
.sp
.BE
.SH DESCRIPTION
.PP
The ftp package provides the client side of the ftp protocol as
specified in RFC 959 (\fIhttp://www.rfc-editor.org/rfc/rfc959.txt\fR).
The package implements both active (default) and passive ftp sessions.
.PP
A new ftp session is started with the \fB::ftp::Open\fR command. To
shutdown an existing ftp session use \fB::ftp::Close\fR. All other
commands are restricted to usage in an an open ftp session. They will
generate errors if they are used out of context.  The ftp package
includes file and directory manipulating commands for remote sites. To
perform the same operations on the local site use commands built into
the core, like \fBcd\fR or \fBfile\fR.
.PP
The output of the package is controlled by two state variables,
\fB::ftp::VERBOSE\fR and \fB::ftp::DEBUG\fR. Setting
\fB::ftp::VERBOSE\fR to "1" forces the package to show all responses
from a remote server. The default value is "0". Setting
\fB::ftp::DEBUG\fR to "1" enables debugging and forces the package to
show all return codes, states, state changes and "real" ftp
commands. The default value is "0".
.PP
The command \fB::ftp::DisplayMsg\fR is used to show the different
messages from the ftp session. The setting of \fB::ftp::VERBOSE\fR
determines if this command is called or not. The current
implementation of the command uses the \fBlog\fR package of tcllib
to write the messages to their final destination. This means that the
behaviour of \fB::ftp::DisplayMsg\fR can be customized without
changing its implementation. For more radical changes overwriting its
implementation by the application is of course still possible. Note
that the default implementation honors the option \fB-output\fR to
\fB::ftp::Open\fR for a session specific log command.
.PP
\fICaution\fR: The default implementation logs error messages like
all other messages. If this behaviour is changed to throwing an error
instead all commands in the API will change their behaviour too. In
such a case they will not return a failure code as described below but
pass the thrown error to their caller.
.SH API
.TP
\fB::ftp::Open\fR \fIserver\fR \fIuser\fR \fIpasswd\fR ?\fIoptions\fR?
This command is used to start a FTP session by establishing a control
connection to the FTP server. The defaults are used for any option not
specified by the caller.
.sp
The command takes a host name \fIserver\fR, a user name \fIuser\fR and
a password \fIpassword\fR as its parameters and returns a session
handle that is an integer number greater than or equal to "0", if the
connection is successfully established. Otherwise it returns "-1".
The \fIserver\fR parameter must be the name or internet address (in
dotted decimal notation) of the ftp server to connect to. The
\fIuser\fR and \fIpasswd\fR parameters must contain a valid user name
and password to complete the login process.
.sp
The options overwrite some default values or set special abilities:
.RS
.TP
\fB-blocksize\fR \fIsize\fR
The blocksize is used during data transfer. At most \fIsize\fR bytes
are transfered at once. The default value for this option is 4096.
The package will evaluate the \fB-progress callback\fR for the
session after the transfer of each block.
.TP
\fB-timeout\fR \fIseconds\fR
If \fIseconds\fR is non-zero, then \fB::ftp::Open\fR sets up a timeout
which will occur after the specified number of seconds. The default
value is 600.
.TP
\fB-port\fR \fInumber\fR
The port \fInumber\fR specifies an alternative remote port on the ftp
server on which the ftp service resides. Most ftp services listen for
connection requests on the default port 21. Sometimes, usually for
security reasons, port numbers other than 21 are used for ftp
connections.
.TP
\fB-mode\fR \fImode\fR
The transfer \fImode\fR option determines if a file transfer occurs in
\fBactive\fR or \fBpassive\fR mode. In passive mode the client
will ask the ftp server to listen on a data port and wait for the
connection rather than to initiate the process by itself when a data
transfer request comes in. Passive mode is normally a requirement when
accessing sites via a firewall. The default mode is \fBactive\fR.
.TP
\fB-progress\fR \fIcallback\fR
This \fIcallback\fR is evaluated whenever a block of data was
transfered. See the option \fB-blocksize\fR for how to specify the
size of the transfered blocks.
.sp
When evaluating the \fIcallback\fR one argument is appended to the
callback script, the current accumulated number of bytes transferred
so far.
.TP
\fB-command\fR \fIcallback\fR
Specifying this option places the connection into asynchronous
mode. The \fIcallback\fR is evaluated after the completion of any
operation. When an operation is running no further operations must be
started until a callback has been received for the currently executing
operation.
.sp
When evaluating the \fIcallback\fR several arguments are appended to
the callback script, namely the keyword of the operation that has
completed and any additional arguments specific to the operation.  If
an error occurred during the execution of the operation the callback is
given the keyword \fBerror\fR.
.TP
\fB-output\fR \fIcallback\fR
This option has no default. If it is set the default implementation of
\fB::ftp::DisplayMsg\fR will use its value as command prefix to log
all internal messages. The callback will have three arguments appended
to it before evaluation, the id of the session, the message itself,
and the connection state, in this order.
.RE
.TP
\fB::ftp::Close\fR \fIhandle\fR
This command terminates the specified ftp session. If no file transfer
is in progress, the server will close the control connection
immediately. If a file transfer is in progress however, the control
connection will remain open until the transfers completes. When that
happens the server will write the result response for the transfer to
it and close the connection afterward.
.TP
\fB::ftp::Cd\fR \fIhandle\fR \fIdirectory\fR
This command changes the current working directory on the ftp server
to a specified target \fIdirectory\fR.  The command returns 1 if the
current working directory was successfully changed to the specified
directory or 0 if it fails.  The target directory can be
.RS
.IP \(bu
a subdirectory of the current directory,
.IP \(bu
Two dots, \fB..\fR  (as an indicator for the parent directory of
the current directory)
.IP \(bu
or a fully qualified path to a new working directory.
.RE
.TP
\fB::ftp::Pwd\fR \fIhandle\fR
This command returns the complete path of the current working
directory on the ftp server, or an empty string in case of an error.
.TP
\fB::ftp::Type\fR \fIhandle\fR ?\fBascii|binary|tenex\fR?
This command sets the ftp file transfer type to either \fBascii\fR,
\fBbinary\fR, or \fBtenex\fR. The command always returns the
currently set type. If called without type no change is made.
.sp
Currently only \fBascii\fR and \fBbinary\fR types are
supported. There is some early (alpha) support for Tenex mode. The
type \fBascii\fR is normally used to convert text files into a
format suitable for text editors on the platform of the destination
machine. This mainly affects end-of-line markers. The type
\fBbinary\fR on the other hand allows the undisturbed transfer of
non-text files, such as compressed files, images and executables.
.TP
\fB::ftp::List\fR \fIhandle\fR ?\fIpattern\fR?
This command returns a human-readable list of files.  Wildcard
expressions such as "\fI*.tcl\fR" are allowed.  If \fIpattern\fR
refers to a specific directory, then the contents of that directory
are returned.  If the \fIpattern\fR is not a fully-qualified path
name, the command lists entries relative to the current remote
directory.  If no \fIpattern\fR is specified, the contents of the
current remote directory is returned.
.sp
The listing includes any system-dependent information that the server
chooses to include. For example most UNIX systems produce output from
the command \fBls -l\fR. The command returns the retrieved
information as a tcl list with one item per entry. Empty lines and
UNIX's "total" lines are ignored and not included in the result as
reported by this command.
.sp
If the command fails an empty list is returned.
.TP
\fB::ftp::NList\fR \fIhandle\fR ?\fIdirectory\fR?
This command has the same behavior as the \fB::ftp::List\fR command,
except that it only retrieves an abbreviated listing. This means only
file names are returned in a sorted list.
.TP
\fB::ftp::FileSize\fR \fIhandle\fR \fIfile\fR
This command returns the size of the specified \fIfile\fR on the ftp
server. If the command fails an empty string is returned.
.sp
\fIATTENTION!\fR It will not work properly when in ascii mode and
is not supported by all ftp server implementations.
.TP
\fB::ftp::ModTime\fR \fIhandle\fR \fIfile\fR
This command retrieves the time of the last modification of the
\fIfile\fR on the ftp server as a system dependent integer value in
seconds or an empty string if an error occurred. Use the built-in
command \fBclock\fR to convert the retrieves value into other formats.
.TP
\fB::ftp::Delete\fR \fIhandle\fR \fIfile\fR
This command deletes the specified \fIfile\fR on the ftp server. The
command returns 1 if the specified file was successfully deleted or 0
if it failed.
.TP
\fB::ftp::Rename\fR \fIhandle\fR \fIfrom\fR \fIto\fR
This command renames the file \fIfrom\fR in the current directory of
the ftp server to the specified new file name \fIto\fR. This new file
name must not be the same as any existing subdirectory or file name.
The command returns 1 if the specified file was successfully renamed
or 0 if it failed.
.TP
\fB::ftp::Put\fR \fIhandle\fR (\fIlocal\fR | -data \fIdata\fR | -channel \fIchan\fR) ?\fIremote\fR?
This command transfers a local file \fIlocal\fR to a remote file
\fIremote\fR on the ftp server. If the file parameters passed to the
command do not fully qualified path names the command will use the
current directory on local and remote host. If the remote file name is
unspecified, the server will use the name of the local file as the
name of the remote file. The command returns 1 to indicate a successful
transfer and 0 in the case of a failure.
.sp
If \fB-data\fR \fIdata\fR is specified instead of a local file, the
system will not transfer a file, but the \fIdata\fR passed into it. In
this case the name of the remote file has to be specified.
.sp
If \fB-channel\fR \fIchan\fR is specified instead of a local file,
the system will not transfer a file, but read the contents of the
channel \fIchan\fR and write this to the remote file. In this case the
name of the remote file has to be specified. After the transfer
\fIchan\fR will be closed.
.TP
\fB::ftp::Append\fR \fIhandle\fR (\fIlocal\fR | -data \fIdata\fR | -channel \fIchan\fR) ?\fIremote\fR?
This command behaves like \fB::ftp::Puts\fR, but appends the
transfered information to the remote file. If the file did not exist
on the server it will be created.
.TP
\fB::ftp::Get\fR \fIhandle\fR \fIremote\fR ?(\fIlocal\fR | -variable \fIvarname\fR | -channel \fIchan\fR)?
This command retrieves a remote file \fIremote\fR on the ftp server
and stores its contents into the local file \fIlocal\fR. If the file
parameters passed to the command are not fully qualified path names
the command will use the current directory on local and remote
host. If the local file name is unspecified, the server will use the
name of the remote file as the name of the local file. The command
returns 1 to indicate a successful transfer and 0 in the case of a
failure. The command will throw an error if the directory the file
\fIlocal\fR is to be placed in does not exist.
.sp
If \fB-variable\fR \fIvarname\fR is specified, the system will
store the retrieved data into the variable \fIvarname\fR instead of a
file.
.sp
If \fB-channel\fR \fIchan\fR is specified, the system will write
the retrieved data into the channel \fIchan\fR instead of a file. The
system will \fInot\fR close \fIchan\fR after the transfer, this is
the responsibility of the caller to \fB::ftp::Get\fR.
.TP
\fB::ftp::Reget\fR \fIhandle\fR \fIremote\fR ?\fIlocal\fR? ?\fIfrom\fR? ?\fIto\fR?
This command behaves like \fB::ftp::Get\fR, except that if local file
\fIlocal\fR exists and is smaller than remote file \fIremote\fR, the
local file is presumed to be a partially transferred copy of the
remote file and the transfer is continued from the apparent point of
failure.  The command will throw an error if the directory the file
\fIlocal\fR is to be placed in does not exist. This command is useful
when transferring very large files over networks that tend to drop
connections.
.sp
Specifying the additional byte offsets \fIfrom\fR and \fIto\fR will
cause the command to change its behaviour and to download exactly the
specified slice of the remote file. This mode is possible only if a
local destination is explicitly provided. Omission of \fIto\fR leads
to downloading till the end of the file.
.TP
\fB::ftp::Newer\fR \fIhandle\fR \fIremote\fR ?\fIlocal\fR?
This command behaves like \fB::ftp::Get\fR, except that it retrieves
the remote file only if the modification time of the remote file is
more recent than the file on the local system. If the file does not
exist on the local system, the remote file is considered newer. The
command will throw an error if the directory the file \fIlocal\fR is
to be placed in does not exist.
.TP
\fB::ftp::MkDir\fR \fIhandle\fR \fIdirectory\fR
This command creates the specified \fIdirectory\fR on the ftp
server. If the specified path is relative the new directory will be
created as a subdirectory of the current working directory. Else the
created directory will have the specified path name. The command
returns 1 to indicate a successful creation of the directory and 0 in
the case of a failure.
.TP
\fB::ftp::RmDir\fR \fIhandle\fR \fIdirectory\fR
This command removes the specified directory on the ftp server. The
remote directory has to be empty or the command will fail. The command
returns 1 to indicate a successful removal of the directory and 0 in
the case of a failure.
.TP
\fB::ftp::Quote\fR \fIhandle\fR \fIarg1\fR \fIarg2\fR \fI...\fR
This command is used to send an arbitrary ftp command to the
server. It cannot be used to obtain a directory listing or for
transferring files. It is included to allow an application to execute
commands on the ftp server which are not provided by this package.
The arguments are sent verbatim, i.e. as is, with no changes.
.sp
In contrast to the other commands in this package this command will
not parse the response it got from the ftp server but return it
verbatim to the caller.
.TP
\fB::ftp::DisplayMsg\fR \fIhandle\fR \fImsg\fR ?\fIstate\fR?
This command is used by the package itself to show the different
messages from the ftp sessions. The package itself declares this
command very simple, writing the messages to \fBstdout\fR (if
\fB::ftp::VERBOSE\fR was set, see below) and throwing tcl errors for
error messages. It is the responsibility of the application to
overwrite it as needed. A state variable for different states assigned
to different colors is recommended by the author. The package
\fBlog\fR is useful for this.
.TP
\fB::ftp::VERBOSE\fR
A state variable controlling the output of the package. Setting
\fB::ftp::VERBOSE\fR to "1" forces the package to show all responses
from a remote server. The default value is "0".
.TP
\fB::ftp::DEBUG\fR
A state variable controlling the output of ftp. Setting
\fB::ftp::DEBUG\fR to "1" enables debugging and forces the package to
show all return codes, states, state changes and "real" ftp
commands. The default value is "0".
.PP
.SH BUGS
.PP
The correct execution of many commands depends upon the proper
behavior by the remote server, network and router configuration.
.PP
An update command placed in the procedure \fB::ftp::DisplayMsg\fR may
run into persistent errors or infinite loops. The solution to this
problem is to use \fBupdate idletasks\fR instead of \fBupdate\fR.
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fIftp\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH "SEE ALSO"
ftpd, mime, pop3, smtp
.SH KEYWORDS
ftp, internet, net, rfc 959
.SH CATEGORY
Networking