'\"
'\" Generated from file '/Library/Caches/com.apple.xbs/Sources/tcl/tcl-129.100.1/tcl_ext/tcllib/tcllib/modules/math/qcomplex.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2004 Arjen Markus <arjenmarkus@users.sourceforge.net>
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "math::complexnumbers" n 1.0.2 math "Tcl Math Library"
.BS
.SH NAME
math::complexnumbers \- Straightforward complex number package
.SH SYNOPSIS
package require \fBTcl  8.3\fR
.sp
package require \fBmath::complexnumbers  ?1.0.2?\fR
.sp
\fB::math::complexnumbers::+\fR \fIz1\fR \fIz2\fR
.sp
\fB::math::complexnumbers::-\fR \fIz1\fR \fIz2\fR
.sp
\fB::math::complexnumbers::*\fR \fIz1\fR \fIz2\fR
.sp
\fB::math::complexnumbers::/\fR \fIz1\fR \fIz2\fR
.sp
\fB::math::complexnumbers::conj\fR \fIz1\fR
.sp
\fB::math::complexnumbers::real\fR \fIz1\fR
.sp
\fB::math::complexnumbers::imag\fR \fIz1\fR
.sp
\fB::math::complexnumbers::mod\fR \fIz1\fR
.sp
\fB::math::complexnumbers::arg\fR \fIz1\fR
.sp
\fB::math::complexnumbers::complex\fR \fIreal\fR \fIimag\fR
.sp
\fB::math::complexnumbers::tostring\fR \fIz1\fR
.sp
\fB::math::complexnumbers::exp\fR \fIz1\fR
.sp
\fB::math::complexnumbers::sin\fR \fIz1\fR
.sp
\fB::math::complexnumbers::cos\fR \fIz1\fR
.sp
\fB::math::complexnumbers::tan\fR \fIz1\fR
.sp
\fB::math::complexnumbers::log\fR \fIz1\fR
.sp
\fB::math::complexnumbers::sqrt\fR \fIz1\fR
.sp
\fB::math::complexnumbers::pow\fR \fIz1\fR \fIz2\fR
.sp
.BE
.SH DESCRIPTION
.PP
The mathematical module \fIcomplexnumbers\fR provides a straightforward
implementation of complex numbers in pure Tcl. The philosophy is that
the user knows he or she is dealing with complex numbers in an abstract
way and wants as high a performance as can be had within the limitations
of an interpreted language.
.PP
Therefore the procedures defined in this package assume that the
arguments are valid (representations of) "complex numbers", that is,
lists of two numbers defining the real and imaginary part of a
complex number (though this is a mere detail: rely on the
\fIcomplex\fR command to construct a valid number.)
.PP
Most procedures implement the basic arithmetic operations or elementary
functions whereas several others convert to and from different
representations:
.PP
.nf

    set z [complex 0 1]
    puts "z = [tostring $z]"
    puts "z**2 = [* $z $z]

.fi
would result in:
.nf

    z = i
    z**2 = -1

.fi
.SH "AVAILABLE PROCEDURES"
The package implements all or most basic operations and elementary
functions.
.PP
\fIThe arithmetic operations are:\fR
.TP
\fB::math::complexnumbers::+\fR \fIz1\fR \fIz2\fR
Add the two arguments and return the resulting complex number
.RS
.TP
complex \fIz1\fR (in)
First argument in the summation
.TP
complex \fIz2\fR (in)
Second argument in the summation
.RE
.sp
.TP
\fB::math::complexnumbers::-\fR \fIz1\fR \fIz2\fR
Subtract the second argument from the first and return the
resulting complex number. If there is only one argument, the
opposite of z1 is returned (i.e. -z1)
.RS
.TP
complex \fIz1\fR (in)
First argument in the subtraction
.TP
complex \fIz2\fR (in)
Second argument in the subtraction (optional)
.RE
.sp
.TP
\fB::math::complexnumbers::*\fR \fIz1\fR \fIz2\fR
Multiply the two arguments and return the resulting complex number
.RS
.TP
complex \fIz1\fR (in)
First argument in the multiplication
.TP
complex \fIz2\fR (in)
Second argument in the multiplication
.RE
.sp
.TP
\fB::math::complexnumbers::/\fR \fIz1\fR \fIz2\fR
Divide the first argument by the second and return the resulting complex
number
.RS
.TP
complex \fIz1\fR (in)
First argument (numerator) in the division
.TP
complex \fIz2\fR (in)
Second argument (denominator) in the division
.RE
.sp
.TP
\fB::math::complexnumbers::conj\fR \fIz1\fR
Return the conjugate of the given complex number
.RS
.TP
complex \fIz1\fR (in)
Complex number in question
.RE
.sp
.PP
.PP
\fIConversion/inquiry procedures:\fR
.TP
\fB::math::complexnumbers::real\fR \fIz1\fR
Return the real part of the given complex number
.RS
.TP
complex \fIz1\fR (in)
Complex number in question
.RE
.sp
.TP
\fB::math::complexnumbers::imag\fR \fIz1\fR
Return the imaginary part of the given complex number
.RS
.TP
complex \fIz1\fR (in)
Complex number in question
.RE
.sp
.TP
\fB::math::complexnumbers::mod\fR \fIz1\fR
Return the modulus of the given complex number
.RS
.TP
complex \fIz1\fR (in)
Complex number in question
.RE
.sp
.TP
\fB::math::complexnumbers::arg\fR \fIz1\fR
Return the argument ("angle" in radians) of the given complex number
.RS
.TP
complex \fIz1\fR (in)
Complex number in question
.RE
.sp
.TP
\fB::math::complexnumbers::complex\fR \fIreal\fR \fIimag\fR
Construct the complex number "real + imag*i" and return it
.RS
.TP
float \fIreal\fR (in)
The real part of the new complex number
.TP
float \fIimag\fR (in)
The imaginary part of the new complex number
.RE
.sp
.TP
\fB::math::complexnumbers::tostring\fR \fIz1\fR
Convert the complex number to the form "real + imag*i" and return the
string
.RS
.TP
float \fIcomplex\fR (in)
The complex number to be converted
.RE
.sp
.PP
.PP
\fIElementary functions:\fR
.TP
\fB::math::complexnumbers::exp\fR \fIz1\fR
Calculate the exponential for the given complex argument and return the
result
.RS
.TP
complex \fIz1\fR (in)
The complex argument for the function
.RE
.sp
.TP
\fB::math::complexnumbers::sin\fR \fIz1\fR
Calculate the sine function for the given complex argument and return
the result
.RS
.TP
complex \fIz1\fR (in)
The complex argument for the function
.RE
.sp
.TP
\fB::math::complexnumbers::cos\fR \fIz1\fR
Calculate the cosine function for the given complex argument and return
the result
.RS
.TP
complex \fIz1\fR (in)
The complex argument for the function
.RE
.sp
.TP
\fB::math::complexnumbers::tan\fR \fIz1\fR
Calculate the tangent function for the given complex argument and
return the result
.RS
.TP
complex \fIz1\fR (in)
The complex argument for the function
.RE
.sp
.TP
\fB::math::complexnumbers::log\fR \fIz1\fR
Calculate the (principle value of the) logarithm for the given complex
argument and return the result
.RS
.TP
complex \fIz1\fR (in)
The complex argument for the function
.RE
.sp
.TP
\fB::math::complexnumbers::sqrt\fR \fIz1\fR
Calculate the (principle value of the) square root for the given complex
argument and return the result
.RS
.TP
complex \fIz1\fR (in)
The complex argument for the function
.RE
.sp
.TP
\fB::math::complexnumbers::pow\fR \fIz1\fR \fIz2\fR
Calculate "z1 to the power of z2" and return the result
.RS
.TP
complex \fIz1\fR (in)
The complex number to be raised to a power
.TP
complex \fIz2\fR (in)
The complex power to be used
.RE
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fImath :: complexnumbers\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH KEYWORDS
complex numbers, math
.SH CATEGORY
Mathematics
.SH COPYRIGHT
.nf
Copyright (c) 2004 Arjen Markus <arjenmarkus@users.sourceforge.net>

.fi