'\"
'\" Generated from file '/Library/Caches/com.apple.xbs/Sources/tcl/tcl-129.100.1/tcl_ext/tcllib/tcllib/modules/math/statistics.man' by tcllib/doctools with format 'nroff'
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "math::statistics" n 0.5 math "Tcl Math Library"
.BS
.SH NAME
math::statistics \- Basic statistical functions and procedures
.SH SYNOPSIS
package require \fBTcl  8\fR
.sp
package require \fBmath::statistics  0.5\fR
.sp
\fB::math::statistics::mean\fR \fIdata\fR
.sp
\fB::math::statistics::min\fR \fIdata\fR
.sp
\fB::math::statistics::max\fR \fIdata\fR
.sp
\fB::math::statistics::number\fR \fIdata\fR
.sp
\fB::math::statistics::stdev\fR \fIdata\fR
.sp
\fB::math::statistics::var\fR \fIdata\fR
.sp
\fB::math::statistics::pstdev\fR \fIdata\fR
.sp
\fB::math::statistics::pvar\fR \fIdata\fR
.sp
\fB::math::statistics::median\fR \fIdata\fR
.sp
\fB::math::statistics::basic-stats\fR \fIdata\fR
.sp
\fB::math::statistics::histogram\fR \fIlimits\fR \fIvalues\fR
.sp
\fB::math::statistics::corr\fR \fIdata1\fR \fIdata2\fR
.sp
\fB::math::statistics::interval-mean-stdev\fR \fIdata\fR \fIconfidence\fR
.sp
\fB::math::statistics::t-test-mean\fR \fIdata\fR \fIest_mean\fR \fIest_stdev\fR \fIconfidence\fR
.sp
\fB::math::statistics::test-normal\fR \fIdata\fR \fIconfidence\fR
.sp
\fB::math::statistics::lillieforsFit\fR \fIdata\fR
.sp
\fB::math::statistics::quantiles\fR \fIdata\fR \fIconfidence\fR
.sp
\fB::math::statistics::quantiles\fR \fIlimits\fR \fIcounts\fR \fIconfidence\fR
.sp
\fB::math::statistics::autocorr\fR \fIdata\fR
.sp
\fB::math::statistics::crosscorr\fR \fIdata1\fR \fIdata2\fR
.sp
\fB::math::statistics::mean-histogram-limits\fR \fImean\fR \fIstdev\fR \fInumber\fR
.sp
\fB::math::statistics::minmax-histogram-limits\fR \fImin\fR \fImax\fR \fInumber\fR
.sp
\fB::math::statistics::linear-model\fR \fIxdata\fR \fIydata\fR \fIintercept\fR
.sp
\fB::math::statistics::linear-residuals\fR \fIxdata\fR \fIydata\fR \fIintercept\fR
.sp
\fB::math::statistics::test-2x2\fR \fIn11\fR \fIn21\fR \fIn12\fR \fIn22\fR
.sp
\fB::math::statistics::print-2x2\fR \fIn11\fR \fIn21\fR \fIn12\fR \fIn22\fR
.sp
\fB::math::statistics::control-xbar\fR \fIdata\fR ?nsamples?
.sp
\fB::math::statistics::control-Rchart\fR \fIdata\fR ?nsamples?
.sp
\fB::math::statistics::test-xbar\fR \fIcontrol\fR \fIdata\fR
.sp
\fB::math::statistics::test-Rchart\fR \fIcontrol\fR \fIdata\fR
.sp
\fB::math::statistics::tstat\fR \fIdof\fR ?alpha?
.sp
\fB::math::statistics::mv-wls\fR \fIwt1\fR \fIweights_and_values\fR
.sp
\fB::math::statistics::mv-ols\fR \fIvalues\fR
.sp
\fB::math::statistics::pdf-normal\fR \fImean\fR \fIstdev\fR \fIvalue\fR
.sp
\fB::math::statistics::pdf-exponential\fR \fImean\fR \fIvalue\fR
.sp
\fB::math::statistics::pdf-uniform\fR \fIxmin\fR \fIxmax\fR \fIvalue\fR
.sp
\fB::math::statistics::pdf-gamma\fR \fIalpha\fR \fIbeta\fR \fIvalue\fR
.sp
\fB::math::statistics::pdf-poisson\fR \fImu\fR \fIk\fR
.sp
\fB::math::statistics::pdf-chisquare\fR \fIdf\fR \fIvalue\fR
.sp
\fB::math::statistics::pdf-student-t\fR \fIdf\fR \fIvalue\fR
.sp
\fB::math::statistics::pdf-beta\fR \fIa\fR \fIb\fR \fIvalue\fR
.sp
\fB::math::statistics::cdf-normal\fR \fImean\fR \fIstdev\fR \fIvalue\fR
.sp
\fB::math::statistics::cdf-exponential\fR \fImean\fR \fIvalue\fR
.sp
\fB::math::statistics::cdf-uniform\fR \fIxmin\fR \fIxmax\fR \fIvalue\fR
.sp
\fB::math::statistics::cdf-students-t\fR \fIdegrees\fR \fIvalue\fR
.sp
\fB::math::statistics::cdf-gamma\fR \fIalpha\fR \fIbeta\fR \fIvalue\fR
.sp
\fB::math::statistics::cdf-poisson\fR \fImu\fR \fIk\fR
.sp
\fB::math::statistics::cdf-beta\fR \fIa\fR \fIb\fR \fIvalue\fR
.sp
\fB::math::statistics::random-normal\fR \fImean\fR \fIstdev\fR \fInumber\fR
.sp
\fB::math::statistics::random-exponential\fR \fImean\fR \fInumber\fR
.sp
\fB::math::statistics::random-uniform\fR \fIxmin\fR \fIxmax\fR \fInumber\fR
.sp
\fB::math::statistics::random-gamma\fR \fIalpha\fR \fIbeta\fR \fInumber\fR
.sp
\fB::math::statistics::random-chisquare\fR \fIdf\fR \fInumber\fR
.sp
\fB::math::statistics::random-student-t\fR \fIdf\fR \fInumber\fR
.sp
\fB::math::statistics::random-beta\fR \fIa\fR \fIb\fR \fInumber\fR
.sp
\fB::math::statistics::histogram-uniform\fR \fIxmin\fR \fIxmax\fR \fIlimits\fR \fInumber\fR
.sp
\fB::math::statistics::incompleteGamma\fR \fIx\fR \fIp\fR ?tol?
.sp
\fB::math::statistics::incompleteBeta\fR \fIa\fR \fIb\fR \fIx\fR ?tol?
.sp
\fB::math::statistics::filter\fR \fIvarname\fR \fIdata\fR \fIexpression\fR
.sp
\fB::math::statistics::map\fR \fIvarname\fR \fIdata\fR \fIexpression\fR
.sp
\fB::math::statistics::samplescount\fR \fIvarname\fR \fIlist\fR \fIexpression\fR
.sp
\fB::math::statistics::subdivide\fR
.sp
\fB::math::statistics::plot-scale\fR \fIcanvas\fR \fIxmin\fR \fIxmax\fR \fIymin\fR \fIymax\fR
.sp
\fB::math::statistics::plot-xydata\fR \fIcanvas\fR \fIxdata\fR \fIydata\fR \fItag\fR
.sp
\fB::math::statistics::plot-xyline\fR \fIcanvas\fR \fIxdata\fR \fIydata\fR \fItag\fR
.sp
\fB::math::statistics::plot-tdata\fR \fIcanvas\fR \fItdata\fR \fItag\fR
.sp
\fB::math::statistics::plot-tline\fR \fIcanvas\fR \fItdata\fR \fItag\fR
.sp
\fB::math::statistics::plot-histogram\fR \fIcanvas\fR \fIcounts\fR \fIlimits\fR \fItag\fR
.sp
.BE
.SH DESCRIPTION
.PP
The \fBmath::statistics\fR package contains functions and procedures for
basic statistical data analysis, such as:
.IP \(bu
Descriptive statistical parameters (mean, minimum, maximum, standard
deviation)
.IP \(bu
Estimates of the distribution in the form of histograms and quantiles
.IP \(bu
Basic testing of hypotheses
.IP \(bu
Probability and cumulative density functions
.PP
It is meant to help in developing data analysis applications or doing
ad hoc data analysis, it is not in itself a full application, nor is it
intended to rival with full (non-)commercial statistical packages.
.PP
The purpose of this document is to describe the implemented procedures
and provide some examples of their usage. As there is ample literature
on the algorithms involved, we refer to relevant text books for more
explanations.
The package contains a fairly large number of public procedures. They
can be distinguished in three sets: general procedures, procedures
that deal with specific statistical distributions, list procedures to
select or transform data and simple plotting procedures (these require
Tk).
\fINote:\fR The data that need to be analyzed are always contained in a
simple list. Missing values are represented as empty list elements.
.SH "GENERAL PROCEDURES"
The general statistical procedures are:
.TP
\fB::math::statistics::mean\fR \fIdata\fR
Determine the \fImean\fR value of the given list of data.
.RS
.TP
list \fIdata\fR
- List of data
.RE
.sp
.TP
\fB::math::statistics::min\fR \fIdata\fR
Determine the \fIminimum\fR value of the given list of data.
.RS
.TP
list \fIdata\fR
- List of data
.RE
.sp
.TP
\fB::math::statistics::max\fR \fIdata\fR
Determine the \fImaximum\fR value of the given list of data.
.RS
.TP
list \fIdata\fR
- List of data
.RE
.sp
.TP
\fB::math::statistics::number\fR \fIdata\fR
Determine the \fInumber\fR of non-missing data in the given list
.RS
.TP
list \fIdata\fR
- List of data
.RE
.sp
.TP
\fB::math::statistics::stdev\fR \fIdata\fR
Determine the \fIsample standard deviation\fR of the data in the
given list
.RS
.TP
list \fIdata\fR
- List of data
.RE
.sp
.TP
\fB::math::statistics::var\fR \fIdata\fR
Determine the \fIsample variance\fR of the data in the given list
.RS
.TP
list \fIdata\fR
- List of data
.RE
.sp
.TP
\fB::math::statistics::pstdev\fR \fIdata\fR
Determine the \fIpopulation standard deviation\fR of the data
in the given list
.RS
.TP
list \fIdata\fR
- List of data
.RE
.sp
.TP
\fB::math::statistics::pvar\fR \fIdata\fR
Determine the \fIpopulation variance\fR of the data in the
given list
.RS
.TP
list \fIdata\fR
- List of data
.RE
.sp
.TP
\fB::math::statistics::median\fR \fIdata\fR
Determine the \fImedian\fR of the data in the given list
(Note that this requires sorting the data, which may be a
costly operation)
.RS
.TP
list \fIdata\fR
- List of data
.RE
.sp
.TP
\fB::math::statistics::basic-stats\fR \fIdata\fR
Determine a list of all the descriptive parameters: mean, minimum,
maximum, number of data, sample standard deviation, sample variance,
population standard deviation and population variance.
.sp
(This routine is called whenever either or all of the basic statistical
parameters are required. Hence all calculations are done and the
relevant values are returned.)
.RS
.TP
list \fIdata\fR
- List of data
.RE
.sp
.TP
\fB::math::statistics::histogram\fR \fIlimits\fR \fIvalues\fR
Determine histogram information for the given list of data. Returns a
list consisting of the number of values that fall into each interval.
(The first interval consists of all values lower than the first limit,
the last interval consists of all values greater than the last limit.
There is one more interval than there are limits.)
.RS
.TP
list \fIlimits\fR
- List of upper limits (in ascending order) for the
intervals of the histogram.
.TP
list \fIvalues\fR
- List of data
.RE
.sp
.TP
\fB::math::statistics::corr\fR \fIdata1\fR \fIdata2\fR
Determine the correlation coefficient between two sets of data.
.RS
.TP
list \fIdata1\fR
- First list of data
.TP
list \fIdata2\fR
- Second list of data
.RE
.sp
.TP
\fB::math::statistics::interval-mean-stdev\fR \fIdata\fR \fIconfidence\fR
Return the interval containing the mean value and one
containing the standard deviation with a certain
level of confidence (assuming a normal distribution)
.RS
.TP
list \fIdata\fR
- List of raw data values (small sample)
.TP
float \fIconfidence\fR
- Confidence level (0.95 or 0.99 for instance)
.RE
.sp
.TP
\fB::math::statistics::t-test-mean\fR \fIdata\fR \fIest_mean\fR \fIest_stdev\fR \fIconfidence\fR
Test whether the mean value of a sample is in accordance with the
estimated normal distribution with a certain level of confidence.
Returns 1 if the test succeeds or 0 if the mean is unlikely to fit
the given distribution.
.RS
.TP
list \fIdata\fR
- List of raw data values (small sample)
.TP
float \fIest_mean\fR
- Estimated mean of the distribution
.TP
float \fIest_stdev\fR
- Estimated stdev of the distribution
.TP
float \fIconfidence\fR
- Confidence level (0.95 or 0.99 for instance)
.RE
.sp
.TP
\fB::math::statistics::test-normal\fR \fIdata\fR \fIconfidence\fR
Test whether the given data follow a normal distribution
with a certain level of confidence.
Returns 1 if the data are normally distributed within the level of
confidence, returns 0 if not. The underlying test is the Lilliefors
test.
.RS
.TP
list \fIdata\fR
- List of raw data values
.TP
float \fIconfidence\fR
- Confidence level (one of 0.80, 0.90, 0.95 or 0.99)
.RE
.sp
.TP
\fB::math::statistics::lillieforsFit\fR \fIdata\fR
Returns the goodness of fit to a normal distribution according to
Lilliefors. The higher the number, the more likely the data are indeed
normally distributed. The test requires at least \fIfive\fR data
points.
.RS
.TP
list \fIdata\fR
- List of raw data values
.RE
.sp
.TP
\fB::math::statistics::quantiles\fR \fIdata\fR \fIconfidence\fR
Return the quantiles for a given set of data
.RS
.sp
.TP
list \fIdata\fR
- List of raw data values
.sp
.TP
float \fIconfidence\fR
- Confidence level (0.95 or 0.99 for instance)
.sp
.RE
.sp
.TP
\fB::math::statistics::quantiles\fR \fIlimits\fR \fIcounts\fR \fIconfidence\fR
Return the quantiles based on histogram information (alternative to the
call with two arguments)
.RS
.TP
list \fIlimits\fR
- List of upper limits from histogram
.TP
list \fIcounts\fR
- List of counts for for each interval in histogram
.TP
float \fIconfidence\fR
-  Confidence level (0.95 or 0.99 for instance)
.RE
.sp
.TP
\fB::math::statistics::autocorr\fR \fIdata\fR
Return the autocorrelation function as a list of values (assuming
equidistance between samples, about 1/2 of the number of raw data)
.sp
The correlation is determined in such a way that the first value is
always 1 and all others are equal to or smaller than 1. The number of
values involved will diminish as the "time" (the index in the list of
returned values) increases
.RS
.TP
list \fIdata\fR
- Raw data for which the autocorrelation must be determined
.RE
.sp
.TP
\fB::math::statistics::crosscorr\fR \fIdata1\fR \fIdata2\fR
Return the cross-correlation function as a list of values (assuming
equidistance between samples, about 1/2 of the number of raw data)
.sp
The correlation is determined in such a way that the values can never
exceed 1 in magnitude. The number of values involved will diminish
as the "time" (the index in the list of returned values) increases.
.RS
.TP
list \fIdata1\fR
- First list of data
.TP
list \fIdata2\fR
- Second list of data
.RE
.sp
.TP
\fB::math::statistics::mean-histogram-limits\fR \fImean\fR \fIstdev\fR \fInumber\fR
Determine reasonable limits based on mean and standard deviation
for a histogram
Convenience function - the result is suitable for the histogram function.
.RS
.TP
float \fImean\fR
- Mean of the data
.TP
float \fIstdev\fR
- Standard deviation
.TP
int \fInumber\fR
- Number of limits to generate (defaults to 8)
.RE
.sp
.TP
\fB::math::statistics::minmax-histogram-limits\fR \fImin\fR \fImax\fR \fInumber\fR
Determine reasonable limits based on a minimum and maximum for a histogram
.sp
Convenience function - the result is suitable for the histogram function.
.RS
.TP
float \fImin\fR
- Expected minimum
.TP
float \fImax\fR
- Expected maximum
.TP
int \fInumber\fR
- Number of limits to generate (defaults to 8)
.RE
.sp
.TP
\fB::math::statistics::linear-model\fR \fIxdata\fR \fIydata\fR \fIintercept\fR
Determine the coefficients for a linear regression between
two series of data (the model: Y = A + B*X). Returns a list of
parameters describing the fit
.RS
.TP
list \fIxdata\fR
- List of independent data
.TP
list \fIydata\fR
- List of dependent data to be fitted
.TP
boolean \fIintercept\fR
- (Optional) compute the intercept (1, default) or fit
to a line through the origin (0)
.sp
The result consists of the following list:
.RS
.IP \(bu
(Estimate of) Intercept A
.IP \(bu
(Estimate of) Slope B
.IP \(bu
Standard deviation of Y relative to fit
.IP \(bu
Correlation coefficient R2
.IP \(bu
Number of degrees of freedom df
.IP \(bu
Standard error of the intercept A
.IP \(bu
Significance level of A
.IP \(bu
Standard error of the slope B
.IP \(bu
Significance level of B
.RE
.RE
.sp
.TP
\fB::math::statistics::linear-residuals\fR \fIxdata\fR \fIydata\fR \fIintercept\fR
Determine the difference between actual data and predicted from
the linear model.
.sp
Returns a list of the differences between the actual data and the
predicted values.
.RS
.TP
list \fIxdata\fR
- List of independent data
.TP
list \fIydata\fR
- List of dependent data to be fitted
.TP
boolean \fIintercept\fR
- (Optional) compute the intercept (1, default) or fit
to a line through the origin (0)
.RE
.sp
.TP
\fB::math::statistics::test-2x2\fR \fIn11\fR \fIn21\fR \fIn12\fR \fIn22\fR
Determine if two set of samples, each from a binomial distribution,
differ significantly or not (implying a different parameter).
.sp
Returns the "chi-square" value, which can be used to the determine the
significance.
.RS
.TP
int \fIn11\fR
- Number of outcomes with the first value from the first sample.
.TP
int \fIn21\fR
- Number of outcomes with the first value from the second sample.
.TP
int \fIn12\fR
- Number of outcomes with the second value from the first sample.
.TP
int \fIn22\fR
- Number of outcomes with the second value from the second sample.
.RE
.sp
.TP
\fB::math::statistics::print-2x2\fR \fIn11\fR \fIn21\fR \fIn12\fR \fIn22\fR
Determine if two set of samples, each from a binomial distribution,
differ significantly or not (implying a different parameter).
.sp
Returns a short report, useful in an interactive session.
.RS
.TP
int \fIn11\fR
- Number of outcomes with the first value from the first sample.
.TP
int \fIn21\fR
- Number of outcomes with the first value from the second sample.
.TP
int \fIn12\fR
- Number of outcomes with the second value from the first sample.
.TP
int \fIn22\fR
- Number of outcomes with the second value from the second sample.
.RE
.sp
.TP
\fB::math::statistics::control-xbar\fR \fIdata\fR ?nsamples?
Determine the control limits for an xbar chart. The number of data
in each subsample defaults to 4. At least 20 subsamples are required.
.sp
Returns the mean, the lower limit, the upper limit and the number of
data per subsample.
.RS
.TP
list \fIdata\fR
- List of observed data
.TP
int \fInsamples\fR
- Number of data per subsample
.RE
.sp
.TP
\fB::math::statistics::control-Rchart\fR \fIdata\fR ?nsamples?
Determine the control limits for an R chart. The number of data
in each subsample (nsamples) defaults to 4. At least 20 subsamples are required.
.sp
Returns the mean range, the lower limit, the upper limit and the number
of data per subsample.
.RS
.TP
list \fIdata\fR
- List of observed data
.TP
int \fInsamples\fR
- Number of data per subsample
.RE
.sp
.TP
\fB::math::statistics::test-xbar\fR \fIcontrol\fR \fIdata\fR
Determine if the data exceed the control limits for the xbar chart.
.sp
Returns a list of subsamples (their indices) that indeed violate the
limits.
.RS
.TP
list \fIcontrol\fR
- Control limits as returned by the "control-xbar" procedure
.TP
list \fIdata\fR
- List of observed data
.RE
.sp
.TP
\fB::math::statistics::test-Rchart\fR \fIcontrol\fR \fIdata\fR
Determine if the data exceed the control limits for the R chart.
.sp
Returns a list of subsamples (their indices) that indeed violate the
limits.
.RS
.TP
list \fIcontrol\fR
- Control limits as returned by the "control-Rchart" procedure
.TP
list \fIdata\fR
- List of observed data
.RE
.sp
.PP
.SH "MULTIVARIATE LINEAR REGRESSION"
Besides the linear regression with a single independent variable, the
statistics package provides two procedures for doing ordinary
least squares (OLS) and weighted least squares (WLS) linear regression
with several variables. They were written by Eric Kemp-Benedict.
.PP
In addition to these two, it provides a procedure (tstat)
for calculating the value of the t-statistic for the specified number of
degrees of freedom that is required to demonstrate a given level of
significance.
.PP
Note: These procedures depend on the math::linearalgebra package.
.PP
\fIDescription of the procedures\fR
.TP
\fB::math::statistics::tstat\fR \fIdof\fR ?alpha?
Returns the value of the t-distribution t* satisfying
.nf

    P(t*)  =  1 - alpha/2
    P(-t*) =  alpha/2

.fi
for the number of degrees of freedom dof.
.sp
Given a sample of normally-distributed data x, with an
estimate xbar for the mean and sbar for the standard deviation,
the alpha confidence interval for the estimate of the mean can
be calculated as
.nf

      ( xbar - t* sbar , xbar + t* sbar)

.fi
The return values from this procedure can be compared to
an estimated t-statistic to determine whether the estimated
value of a parameter is significantly different from zero at
the given confidence level.
.RS
.TP
int \fIdof\fR
Number of degrees of freedom
.TP
float \fIalpha\fR
Confidence level of the t-distribution. Defaults to 0.05.
.RE
.sp
.TP
\fB::math::statistics::mv-wls\fR \fIwt1\fR \fIweights_and_values\fR
Carries out a weighted least squares linear regression for
the data points provided, with weights assigned to each point.
.sp
The linear model is of the form
.nf

    y = b0 + b1 * x1 + b2 * x2 ... + bN * xN + error

.fi
and each point satisfies
.nf

    yi = b0 + b1 * xi1 + b2 * xi2 + ... + bN * xiN + Residual_i

.fi
.sp
The procedure returns a list with the following elements:
.RS
.IP \(bu
The r-squared statistic
.IP \(bu
The adjusted r-squared statistic
.IP \(bu
A list containing the estimated coefficients b1, ... bN, b0
(The constant b0 comes last in the list.)
.IP \(bu
A list containing the standard errors of the coefficients
.IP \(bu
A list containing the 95% confidence bounds of the coefficients,
with each set of bounds returned as a list with two values
.RE
Arguments:
.RS
.TP
list \fIweights_and_values\fR
A list consisting of: the weight for the first observation, the data
for the first observation (as a sublist), the weight for the second
observation (as a sublist) and so on. The sublists of data are organised
as lists of the value of the dependent variable y and the independent
variables x1, x2 to xN.
.RE
.sp
.TP
\fB::math::statistics::mv-ols\fR \fIvalues\fR
Carries out an ordinary least squares linear regression for
the data points provided.
.sp
This procedure simply calls ::mvlinreg::wls with the weights
set to 1.0, and returns the same information.
.PP
\fIExample of the use:\fR
.nf

# Store the value of the unicode value for the "+/-" character
set pm "\\u00B1"

# Provide some data
set data {{  -.67  14.18  60.03 -7.5  }
          { 36.97  15.52  34.24 14.61 }
          {-29.57  21.85  83.36 -7.   }
          {-16.9   11.79  51.67 -6.56 }
          { 14.09  16.24  36.97 -12.84}
          { 31.52  20.93  45.99 -25.4 }
          { 24.05  20.69  50.27  17.27}
          { 22.23  16.91  45.07  -4.3 }
          { 40.79  20.49  38.92  -.73 }
          {-10.35  17.24  58.77  18.78}}

# Call the ols routine
set results [::math::statistics::mv-ols $data]

# Pretty-print the results
puts "R-squared: [lindex $results 0]"
puts "Adj R-squared: [lindex $results 1]"
puts "Coefficients $pm s.e. -- \\[95% confidence interval\\]:"
foreach val [lindex $results 2] se [lindex $results 3] bounds [lindex $results 4] {
    set lb [lindex $bounds 0]
    set ub [lindex $bounds 1]
    puts "   $val $pm $se -- \\[$lb to $ub\\]"
}

.fi
.SH "STATISTICAL DISTRIBUTIONS"
In the literature a large number of probability distributions can be
found. The statistics package supports:
.IP \(bu
The normal or Gaussian distribution
.IP \(bu
The uniform distribution - equal probability for all data within a given
interval
.IP \(bu
The exponential distribution - useful as a model for certain
extreme-value distributions.
.IP \(bu
The gamma distribution - based on the incomplete Gamma integral
.IP \(bu
The chi-square distribution
.IP \(bu
The student's T distribution
.IP \(bu
The Poisson distribution
.IP \(bu
PM - binomial,F.
.PP
In principle for each distribution one has procedures for:
.IP \(bu
The probability density (pdf-*)
.IP \(bu
The cumulative density (cdf-*)
.IP \(bu
Quantiles for the given distribution (quantiles-*)
.IP \(bu
Histograms for the given distribution (histogram-*)
.IP \(bu
List of random values with the given distribution (random-*)
.PP
The following procedures have been implemented:
.TP
\fB::math::statistics::pdf-normal\fR \fImean\fR \fIstdev\fR \fIvalue\fR
Return the probability of a given value for a normal distribution with
given mean and standard deviation.
.RS
.TP
float \fImean\fR
- Mean value of the distribution
.TP
float \fIstdev\fR
- Standard deviation of the distribution
.TP
float \fIvalue\fR
- Value for which the probability is required
.RE
.sp
.TP
\fB::math::statistics::pdf-exponential\fR \fImean\fR \fIvalue\fR
Return the probability of a given value for an exponential
distribution with given mean.
.RS
.TP
float \fImean\fR
- Mean value of the distribution
.TP
float \fIvalue\fR
- Value for which the probability is required
.RE
.sp
.TP
\fB::math::statistics::pdf-uniform\fR \fIxmin\fR \fIxmax\fR \fIvalue\fR
Return the probability of a given value for a uniform
distribution with given extremes.
.RS
.TP
float \fIxmin\fR
- Minimum value of the distribution
.TP
float \fIxmin\fR
- Maximum value of the distribution
.TP
float \fIvalue\fR
- Value for which the probability is required
.RE
.sp
.TP
\fB::math::statistics::pdf-gamma\fR \fIalpha\fR \fIbeta\fR \fIvalue\fR
Return the probability of a given value for a Gamma
distribution with given shape and rate parameters
.RS
.TP
float \fIalpha\fR
- Shape parameter
.TP
float \fIbeta\fR
- Rate parameter
.TP
float \fIvalue\fR
- Value for which the probability is required
.RE
.sp
.TP
\fB::math::statistics::pdf-poisson\fR \fImu\fR \fIk\fR
Return the probability of a given number of occurrences in the same
interval (k) for a Poisson distribution with given mean (mu)
.RS
.TP
float \fImu\fR
- Mean number of occurrences
.TP
int \fIk\fR
- Number of occurences
.RE
.sp
.TP
\fB::math::statistics::pdf-chisquare\fR \fIdf\fR \fIvalue\fR
Return the probability of a given value for a chi square
distribution with given degrees of freedom
.RS
.TP
float \fIdf\fR
- Degrees of freedom
.TP
float \fIvalue\fR
- Value for which the probability is required
.RE
.sp
.TP
\fB::math::statistics::pdf-student-t\fR \fIdf\fR \fIvalue\fR
Return the probability of a given value for a Student's t
distribution with given degrees of freedom
.RS
.TP
float \fIdf\fR
- Degrees of freedom
.TP
float \fIvalue\fR
- Value for which the probability is required
.RE
.sp
.TP
\fB::math::statistics::pdf-beta\fR \fIa\fR \fIb\fR \fIvalue\fR
Return the probability of a given value for a Beta
distribution with given shape parameters
.RS
.TP
float \fIa\fR
- First shape parameter
.TP
float \fIb\fR
- First shape parameter
.TP
float \fIvalue\fR
- Value for which the probability is required
.RE
.sp
.TP
\fB::math::statistics::cdf-normal\fR \fImean\fR \fIstdev\fR \fIvalue\fR
Return the cumulative probability of a given value for a normal
distribution with given mean and standard deviation, that is the
probability for values up to the given one.
.RS
.TP
float \fImean\fR
- Mean value of the distribution
.TP
float \fIstdev\fR
- Standard deviation of the distribution
.TP
float \fIvalue\fR
- Value for which the probability is required
.RE
.sp
.TP
\fB::math::statistics::cdf-exponential\fR \fImean\fR \fIvalue\fR
Return the cumulative probability of a given value for an exponential
distribution with given mean.
.RS
.TP
float \fImean\fR
- Mean value of the distribution
.TP
float \fIvalue\fR
- Value for which the probability is required
.RE
.sp
.TP
\fB::math::statistics::cdf-uniform\fR \fIxmin\fR \fIxmax\fR \fIvalue\fR
Return the cumulative probability of a given value for a uniform
distribution with given extremes.
.RS
.TP
float \fIxmin\fR
- Minimum value of the distribution
.TP
float \fIxmin\fR
- Maximum value of the distribution
.TP
float \fIvalue\fR
- Value for which the probability is required
.RE
.sp
.TP
\fB::math::statistics::cdf-students-t\fR \fIdegrees\fR \fIvalue\fR
Return the cumulative probability of a given value for a Student's t
distribution with given number of degrees.
.RS
.TP
int \fIdegrees\fR
- Number of degrees of freedom
.TP
float \fIvalue\fR
- Value for which the probability is required
.RE
.sp
.TP
\fB::math::statistics::cdf-gamma\fR \fIalpha\fR \fIbeta\fR \fIvalue\fR
Return the cumulative probability of a given value for a Gamma
distribution with given shape and rate parameters
.RS
.TP
float \fIalpha\fR
- Shape parameter
.TP
float \fIbeta\fR
- Rate parameter
.TP
float \fIvalue\fR
- Value for which the cumulative probability is required
.RE
.sp
.TP
\fB::math::statistics::cdf-poisson\fR \fImu\fR \fIk\fR
Return the cumulative probability of a given number of occurrences in
the same interval (k) for a Poisson distribution with given mean (mu)
.RS
.TP
float \fImu\fR
- Mean number of occurrences
.TP
int \fIk\fR
- Number of occurences
.RE
.sp
.TP
\fB::math::statistics::cdf-beta\fR \fIa\fR \fIb\fR \fIvalue\fR
Return the cumulative probability of a given value for a Beta
distribution with given shape parameters
.RS
.TP
float \fIa\fR
- First shape parameter
.TP
float \fIb\fR
- First shape parameter
.TP
float \fIvalue\fR
- Value for which the probability is required
.RE
.sp
.TP
\fB::math::statistics::random-normal\fR \fImean\fR \fIstdev\fR \fInumber\fR
Return a list of "number" random values satisfying a normal
distribution with given mean and standard deviation.
.RS
.TP
float \fImean\fR
- Mean value of the distribution
.TP
float \fIstdev\fR
- Standard deviation of the distribution
.TP
int \fInumber\fR
- Number of values to be returned
.RE
.sp
.TP
\fB::math::statistics::random-exponential\fR \fImean\fR \fInumber\fR
Return a list of "number" random values satisfying an exponential
distribution with given mean.
.RS
.TP
float \fImean\fR
- Mean value of the distribution
.TP
int \fInumber\fR
- Number of values to be returned
.RE
.sp
.TP
\fB::math::statistics::random-uniform\fR \fIxmin\fR \fIxmax\fR \fInumber\fR
Return a list of "number" random values satisfying a uniform
distribution with given extremes.
.RS
.TP
float \fIxmin\fR
- Minimum value of the distribution
.TP
float \fIxmax\fR
- Maximum value of the distribution
.TP
int \fInumber\fR
- Number of values to be returned
.RE
.sp
.TP
\fB::math::statistics::random-gamma\fR \fIalpha\fR \fIbeta\fR \fInumber\fR
Return a list of "number" random values satisfying
a Gamma distribution with given shape and rate parameters
.RS
.TP
float \fIalpha\fR
- Shape parameter
.TP
float \fIbeta\fR
- Rate parameter
.TP
int \fInumber\fR
- Number of values to be returned
.RE
.sp
.TP
\fB::math::statistics::random-chisquare\fR \fIdf\fR \fInumber\fR
Return a list of "number" random values satisfying
a chi square distribution with given degrees of freedom
.RS
.TP
float \fIdf\fR
- Degrees of freedom
.TP
int \fInumber\fR
- Number of values to be returned
.RE
.sp
.TP
\fB::math::statistics::random-student-t\fR \fIdf\fR \fInumber\fR
Return a list of "number" random values satisfying
a Student's t distribution with given degrees of freedom
.RS
.TP
float \fIdf\fR
- Degrees of freedom
.TP
int \fInumber\fR
- Number of values to be returned
.RE
.sp
.TP
\fB::math::statistics::random-beta\fR \fIa\fR \fIb\fR \fInumber\fR
Return a list of "number" random values satisfying
a Beta distribution with given shape parameters
.RS
.TP
float \fIa\fR
- First shape parameter
.TP
float \fIb\fR
- Second shape parameter
.TP
int \fInumber\fR
- Number of values to be returned
.RE
.sp
.TP
\fB::math::statistics::histogram-uniform\fR \fIxmin\fR \fIxmax\fR \fIlimits\fR \fInumber\fR
Return the expected histogram for a uniform distribution.
.RS
.TP
float \fIxmin\fR
- Minimum value of the distribution
.TP
float \fIxmax\fR
- Maximum value of the distribution
.TP
list \fIlimits\fR
- Upper limits for the buckets in the histogram
.TP
int \fInumber\fR
- Total number of "observations" in the histogram
.RE
.sp
.TP
\fB::math::statistics::incompleteGamma\fR \fIx\fR \fIp\fR ?tol?
Evaluate the incomplete Gamma integral
.nf

                    1       / x               p-1
      P(p,x) =  --------   |   dt exp(-t) * t
                Gamma(p)  / 0

.fi
.RS
.TP
float \fIx\fR
- Value of x (limit of the integral)
.TP
float \fIp\fR
- Value of p in the integrand
.TP
float \fItol\fR
- Required tolerance (default: 1.0e-9)
.RE
.sp
.TP
\fB::math::statistics::incompleteBeta\fR \fIa\fR \fIb\fR \fIx\fR ?tol?
Evaluate the incomplete Beta integral
.RS
.TP
float \fIa\fR
- First shape parameter
.TP
float \fIb\fR
- Second shape parameter
.TP
float \fIx\fR
- Value of x (limit of the integral)
.TP
float \fItol\fR
- Required tolerance (default: 1.0e-9)
.RE
.sp
.PP
TO DO: more function descriptions to be added
.SH "DATA MANIPULATION"
The data manipulation procedures act on lists or lists of lists:
.TP
\fB::math::statistics::filter\fR \fIvarname\fR \fIdata\fR \fIexpression\fR
Return a list consisting of the data for which the logical
expression is true (this command works analogously to the command \fBforeach\fR).
.RS
.TP
string \fIvarname\fR
- Name of the variable used in the expression
.TP
list \fIdata\fR
- List of data
.TP
string \fIexpression\fR
- Logical expression using the variable name
.RE
.sp
.TP
\fB::math::statistics::map\fR \fIvarname\fR \fIdata\fR \fIexpression\fR
Return a list consisting of the data that are transformed via the
expression.
.RS
.TP
string \fIvarname\fR
- Name of the variable used in the expression
.TP
list \fIdata\fR
- List of data
.TP
string \fIexpression\fR
- Expression to be used to transform (map) the data
.RE
.sp
.TP
\fB::math::statistics::samplescount\fR \fIvarname\fR \fIlist\fR \fIexpression\fR
Return a list consisting of the \fIcounts\fR of all data in the
sublists of the "list" argument for which the expression is true.
.RS
.TP
string \fIvarname\fR
- Name of the variable used in the expression
.TP
list \fIdata\fR
- List of sublists, each containing the data
.TP
string \fIexpression\fR
- Logical expression to test the data (defaults to
"true").
.RE
.sp
.TP
\fB::math::statistics::subdivide\fR
Routine \fIPM\fR - not implemented yet
.PP
.SH "PLOT PROCEDURES"
The following simple plotting procedures are available:
.TP
\fB::math::statistics::plot-scale\fR \fIcanvas\fR \fIxmin\fR \fIxmax\fR \fIymin\fR \fIymax\fR
Set the scale for a plot in the given canvas. All plot routines expect
this function to be called first. There is no automatic scaling
provided.
.RS
.TP
widget \fIcanvas\fR
- Canvas widget to use
.TP
float \fIxmin\fR
- Minimum x value
.TP
float \fIxmax\fR
- Maximum x value
.TP
float \fIymin\fR
- Minimum y value
.TP
float \fIymax\fR
- Maximum y value
.RE
.sp
.TP
\fB::math::statistics::plot-xydata\fR \fIcanvas\fR \fIxdata\fR \fIydata\fR \fItag\fR
Create a simple XY plot in the given canvas - the data are
shown as a collection of dots. The tag can be used to manipulate the
appearance.
.RS
.TP
widget \fIcanvas\fR
- Canvas widget to use
.TP
float \fIxdata\fR
- Series of independent data
.TP
float \fIydata\fR
- Series of dependent data
.TP
string \fItag\fR
- Tag to give to the plotted data (defaults to xyplot)
.RE
.sp
.TP
\fB::math::statistics::plot-xyline\fR \fIcanvas\fR \fIxdata\fR \fIydata\fR \fItag\fR
Create a simple XY plot in the given canvas - the data are
shown as a line through the data points. The tag can be used to
manipulate the appearance.
.RS
.TP
widget \fIcanvas\fR
- Canvas widget to use
.TP
list \fIxdata\fR
- Series of independent data
.TP
list \fIydata\fR
- Series of dependent data
.TP
string \fItag\fR
- Tag to give to the plotted data (defaults to xyplot)
.RE
.sp
.TP
\fB::math::statistics::plot-tdata\fR \fIcanvas\fR \fItdata\fR \fItag\fR
Create a simple XY plot in the given canvas - the data are
shown as a collection of dots. The horizontal coordinate is equal to the
index. The tag can be used to manipulate the appearance.
This type of presentation is suitable for autocorrelation functions for
instance or for inspecting the time-dependent behaviour.
.RS
.TP
widget \fIcanvas\fR
- Canvas widget to use
.TP
list \fItdata\fR
- Series of dependent data
.TP
string \fItag\fR
- Tag to give to the plotted data (defaults to xyplot)
.RE
.sp
.TP
\fB::math::statistics::plot-tline\fR \fIcanvas\fR \fItdata\fR \fItag\fR
Create a simple XY plot in the given canvas - the data are
shown as a line. See plot-tdata for an explanation.
.RS
.TP
widget \fIcanvas\fR
- Canvas widget to use
.TP
list \fItdata\fR
- Series of dependent data
.TP
string \fItag\fR
- Tag to give to the plotted data (defaults to xyplot)
.RE
.sp
.TP
\fB::math::statistics::plot-histogram\fR \fIcanvas\fR \fIcounts\fR \fIlimits\fR \fItag\fR
Create a simple histogram in the given canvas
.RS
.TP
widget \fIcanvas\fR
- Canvas widget to use
.TP
list \fIcounts\fR
- Series of bucket counts
.TP
list \fIlimits\fR
- Series of upper limits for the buckets
.TP
string \fItag\fR
- Tag to give to the plotted data (defaults to xyplot)
.RE
.sp
.PP
.SH "THINGS TO DO"
The following procedures are yet to be implemented:
.IP \(bu
F-test-stdev
.IP \(bu
interval-mean-stdev
.IP \(bu
histogram-normal
.IP \(bu
histogram-exponential
.IP \(bu
test-histogram
.IP \(bu
test-corr
.IP \(bu
quantiles-*
.IP \(bu
fourier-coeffs
.IP \(bu
fourier-residuals
.IP \(bu
onepar-function-fit
.IP \(bu
onepar-function-residuals
.IP \(bu
plot-linear-model
.IP \(bu
subdivide
.PP
.SH EXAMPLES
The code below is a small example of how you can examine a set of
data:
.PP
.nf


# Simple example:
# - Generate data (as a cheap way of getting some)
# - Perform statistical analysis to describe the data
#
package require math::statistics

#
# Two auxiliary procs
#
proc pause {time} {
   set wait 0
   after [expr {$time*1000}] {set ::wait 1}
   vwait wait
}

proc print-histogram {counts limits} {
   foreach count $counts limit $limits {
      if { $limit != {} } {
         puts [format "<%12.4g\\t%d" $limit $count]
         set prev_limit $limit
      } else {
         puts [format ">%12.4g\\t%d" $prev_limit $count]
      }
   }
}

#
# Our source of arbitrary data
#
proc generateData { data1 data2 } {
   upvar 1 $data1 _data1
   upvar 1 $data2 _data2

   set d1 0.0
   set d2 0.0
   for { set i 0 } { $i < 100 } { incr i } {
      set d1 [expr {10.0-2.0*cos(2.0*3.1415926*$i/24.0)+3.5*rand()}]
      set d2 [expr {0.7*$d2+0.3*$d1+0.7*rand()}]
      lappend _data1 $d1
      lappend _data2 $d2
   }
   return {}
}

#
# The analysis session
#
package require Tk
console show
canvas .plot1
canvas .plot2
pack   .plot1 .plot2 -fill both -side top

generateData data1 data2

puts "Basic statistics:"
set b1 [::math::statistics::basic-stats $data1]
set b2 [::math::statistics::basic-stats $data2]
foreach label {mean min max number stdev var} v1 $b1 v2 $b2 {
   puts "$label\\t$v1\\t$v2"
}
puts "Plot the data as function of \\"time\\" and against each other"
::math::statistics::plot-scale .plot1  0 100  0 20
::math::statistics::plot-scale .plot2  0 20   0 20
::math::statistics::plot-tline .plot1 $data1
::math::statistics::plot-tline .plot1 $data2
::math::statistics::plot-xydata .plot2 $data1 $data2

puts "Correlation coefficient:"
puts [::math::statistics::corr $data1 $data2]

pause 2
puts "Plot histograms"
.plot2 delete all
::math::statistics::plot-scale .plot2  0 20 0 100
set limits         [::math::statistics::minmax-histogram-limits 7 16]
set histogram_data [::math::statistics::histogram $limits $data1]
::math::statistics::plot-histogram .plot2 $histogram_data $limits

puts "First series:"
print-histogram $histogram_data $limits

pause 2
set limits         [::math::statistics::minmax-histogram-limits 0 15 10]
set histogram_data [::math::statistics::histogram $limits $data2]
::math::statistics::plot-histogram .plot2 $histogram_data $limits d2
.plot2 itemconfigure d2 -fill red

puts "Second series:"
print-histogram $histogram_data $limits

puts "Autocorrelation function:"
set  autoc [::math::statistics::autocorr $data1]
puts [::math::statistics::map $autoc {[format "%.2f" $x]}]
puts "Cross-correlation function:"
set  crossc [::math::statistics::crosscorr $data1 $data2]
puts [::math::statistics::map $crossc {[format "%.2f" $x]}]

::math::statistics::plot-scale .plot1  0 100 -1  4
::math::statistics::plot-tline .plot1  $autoc "autoc"
::math::statistics::plot-tline .plot1  $crossc "crossc"
.plot1 itemconfigure autoc  -fill green
.plot1 itemconfigure crossc -fill yellow

puts "Quantiles: 0.1, 0.2, 0.5, 0.8, 0.9"
puts "First:  [::math::statistics::quantiles $data1 {0.1 0.2 0.5 0.8 0.9}]"
puts "Second: [::math::statistics::quantiles $data2 {0.1 0.2 0.5 0.8 0.9}]"


.fi
If you run this example, then the following should be clear:
.IP \(bu
There is a strong correlation between two time series, as displayed by
the raw data and especially by the correlation functions.
.IP \(bu
Both time series show a significant periodic component
.IP \(bu
The histograms are not very useful in identifying the nature of the time
series - they do not show the periodic nature.
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems.
Please report such in the category \fImath :: statistics\fR of the
\fITcllib SF Trackers\fR [http://sourceforge.net/tracker/?group_id=12883].
Please also report any ideas for enhancements you may have for either
package and/or documentation.
.SH KEYWORDS
data analysis, mathematics, statistics
.SH CATEGORY
Mathematics