#!/usr/bin/env bash

set -e

TAPI_VERSION=1600.0.11.8

pushd "${0%/*}" &>/dev/null
source tools/tools.sh

if [[ "$(basename "$0")" == *tapi_tools* ]]; then
  BUILD_TAPI_TOOLS=1
fi

if [ "$NINJA" = 1 ]; then
  command -v ninja &>/dev/null || {
    echo "Missing ninja" 1>&2
    exit 1
  }
  cmakegen="Ninja"
  MAKE="ninja"
else
  cmakegen="Unix Makefiles"
fi

rm -rf build
mkdir build

pushd build &>/dev/null

CMAKE_EXTRA_ARGS=""

if [ "$OPERATING_SYSTEM" = "Android" ]; then
  export CC="$CC -D__ANDROID_API__=26"
  export CXX="$CXX -D__ANDROID_API__=26"
fi

if [ -z "$INSTALLPREFIX" ]; then
  INSTALLPREFIX="/usr/local"
fi

cmake -G "$cmakegen" ../src/llvm \
 -DCMAKE_SHARED_LINKER_FLAGS="$CMAKE_SHARED_LINKER_FLAGS" \
 -DCMAKE_EXE_LINKER_FLAGS="$CMAKE_EXE_LINKER_FLAGS" \
 -DLLVM_INCLUDE_TESTS=OFF \
 -DCMAKE_BUILD_TYPE=RELEASE \
 -DLLVM_ENABLE_PROJECTS="tapi;clang" \
 -DCMAKE_INSTALL_PREFIX="$INSTALLPREFIX" \
 -DTAPI_REPOSITORY_STRING=$TAPI_VERSION \
 -DTAPI_FULL_VERSION=$TAPI_VERSION \
 $CMAKE_EXTRA_ARGS

echo ""
echo "## Building clangBasic and vt_gen ##"
echo ""

$MAKE clangBasic vt_gen -j $JOBS

echo ""
echo "## Building libtapi ##"
echo ""

$MAKE libtapi -j $JOBS

if [ -n "$BUILD_TAPI_TOOLS" ]; then
  echo ""
  echo "## Building tapi tools ##"
  echo ""

  # tapi-run does currently not link
  $MAKE tapi tapi-binary-reader tapi-sdkdb -j $JOBS
fi

popd &>/dev/null
popd &>/dev/null
