/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import com.hbm.blocks.BlockDummyable;
import com.hbm.blocks.ILookOverlay;
import com.hbm.tileentity.TileEntityProxyCombo;
import com.hbm.tileentity.machine.TileEntityTowerLarge;
import com.hbm.util.i18n.I18nUtil;
import java.util.ArrayList;
import net.minecraft.block.material.Material;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.util.ForgeDirection;

public class MachineTowerLarge
extends BlockDummyable
implements ILookOverlay {
    public MachineTowerLarge(Material mat) {
        super(mat);
    }

    public TileEntity func_149915_a(World p_149915_1_, int meta) {
        if (meta >= 12) {
            return new TileEntityTowerLarge();
        }
        if (meta >= 8) {
            return new TileEntityProxyCombo(false, false, true);
        }
        return null;
    }

    @Override
    public int[] getDimensions() {
        return new int[]{12, 0, 4, 4, 4, 4};
    }

    @Override
    public int getOffset() {
        return 4;
    }

    @Override
    public void fillSpace(World world, int x, int y, int z, ForgeDirection dir, int o) {
        super.fillSpace(world, x, y, z, dir, o);
        x += dir.offsetX * o;
        z += dir.offsetZ * o;
        for (int i = 2; i <= 6; ++i) {
            ForgeDirection dr2 = ForgeDirection.getOrientation((int)i);
            ForgeDirection rot = dr2.getRotation(ForgeDirection.UP);
            this.makeExtra(world, x + dr2.offsetX * 4, y, z + dr2.offsetZ * 4);
            this.makeExtra(world, x + dr2.offsetX * 4 + rot.offsetX * 3, y, z + dr2.offsetZ * 4 + rot.offsetZ * 3);
            this.makeExtra(world, x + dr2.offsetX * 4 + rot.offsetX * -3, y, z + dr2.offsetZ * 4 + rot.offsetZ * -3);
        }
    }

    @Override
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        int[] pos = this.findCore(world, x, y, z);
        if (pos == null) {
            return;
        }
        TileEntity te = world.func_147438_o(pos[0], pos[1], pos[2]);
        if (!(te instanceof TileEntityTowerLarge)) {
            return;
        }
        TileEntityTowerLarge tower = (TileEntityTowerLarge)te;
        ArrayList<String> text = new ArrayList<String>();
        for (int i = 0; i < tower.tanks.length; ++i) {
            text.add((i < 1 ? EnumChatFormatting.GREEN + "-> " : EnumChatFormatting.RED + "<- ") + EnumChatFormatting.RESET + tower.tanks[i].getTankType().getLocalizedName() + ": " + tower.tanks[i].getFill() + "/" + tower.tanks[i].getMaxFill() + "mB");
        }
        ILookOverlay.printGeneric(event, I18nUtil.resolveKey(this.func_149739_a() + ".name", new Object[0]), 0xFFFF00, 0x404000, text);
    }
}

