/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.explosion.vanillant.standard;

import com.hbm.explosion.vanillant.ExplosionVNT;
import com.hbm.explosion.vanillant.interfaces.IBlockAllocator;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;

public class BlockAllocatorWater
implements IBlockAllocator {
    protected int resolution;

    public BlockAllocatorWater(int resolution) {
        this.resolution = resolution;
    }

    @Override
    public HashSet<ChunkPosition> allocate(ExplosionVNT explosion, World world, double x, double y, double z, float size) {
        HashSet<ChunkPosition> affectedBlocks = new HashSet<ChunkPosition>();
        for (int i = 0; i < this.resolution; ++i) {
            for (int j = 0; j < this.resolution; ++j) {
                for (int k = 0; k < this.resolution; ++k) {
                    if (i != 0 && i != this.resolution - 1 && j != 0 && j != this.resolution - 1 && k != 0 && k != this.resolution - 1) continue;
                    double d0 = (float)i / ((float)this.resolution - 1.0f) * 2.0f - 1.0f;
                    double d1 = (float)j / ((float)this.resolution - 1.0f) * 2.0f - 1.0f;
                    double d2 = (float)k / ((float)this.resolution - 1.0f) * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double currentX = x;
                    double currentY = y;
                    double currentZ = z;
                    float stepSize = 0.3f;
                    for (float powerRemaining = size * (0.7f + world.field_73012_v.nextFloat() * 0.6f); powerRemaining > 0.0f; powerRemaining -= stepSize * 0.75f) {
                        int blockZ;
                        int blockY;
                        int blockX = MathHelper.func_76128_c((double)currentX);
                        Block block = world.func_147439_a(blockX, blockY = MathHelper.func_76128_c((double)currentY), blockZ = MathHelper.func_76128_c((double)currentZ));
                        Material material = block.func_149688_o();
                        if (material != Material.field_151579_a && !material.func_76224_d()) {
                            float blockResistance = explosion.exploder != null ? explosion.exploder.func_145772_a(explosion.compat, world, blockX, blockY, blockZ, block) : block.getExplosionResistance(null, world, blockX, blockY, blockZ, x, y, z);
                            powerRemaining -= (blockResistance + 0.3f) * stepSize;
                        }
                        if (powerRemaining > 0.0f && (explosion.exploder == null || explosion.exploder.func_145774_a(explosion.compat, world, blockX, blockY, blockZ, block, powerRemaining)) && !material.func_76224_d()) {
                            affectedBlocks.add(new ChunkPosition(blockX, blockY, blockZ));
                        }
                        currentX += d0 * (double)stepSize;
                        currentY += d1 * (double)stepSize;
                        currentZ += d2 * (double)stepSize;
                    }
                }
            }
        }
        return affectedBlocks;
    }
}

