/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.neutron;

import com.hbm.handler.neutron.NeutronNodeWorld;
import com.hbm.handler.neutron.RBMKNeutronHandler;
import com.hbm.tileentity.machine.rbmk.RBMKDials;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.Map;
import net.minecraft.world.World;

public class NeutronHandler {
    private static int ticks = 0;

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        boolean cacheClear;
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        int cacheTime = 20;
        boolean bl = cacheClear = ticks >= cacheTime;
        if (cacheClear) {
            ticks = 0;
        }
        ++ticks;
        NeutronNodeWorld.removeEmptyWorlds();
        for (Map.Entry<World, NeutronNodeWorld.StreamWorld> world : NeutronNodeWorld.streamWorlds.entrySet()) {
            RBMKNeutronHandler.reflectorEfficiency = RBMKDials.getReflectorEfficiency(world.getKey());
            RBMKNeutronHandler.absorberEfficiency = RBMKDials.getAbsorberEfficiency(world.getKey());
            RBMKNeutronHandler.moderatorEfficiency = RBMKDials.getModeratorEfficiency(world.getKey());
            RBMKNeutronHandler.columnHeight = RBMKDials.getColumnHeight(world.getKey()) + 1;
            RBMKNeutronHandler.fluxRange = RBMKDials.getFluxRange(world.getKey());
            world.getValue().runStreamInteractions(world.getKey());
            world.getValue().removeAllStreams();
            if (!cacheClear) continue;
            world.getValue().cleanNodes();
        }
    }
}

