/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.inventory.FluidStack;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.recipes.loader.SerializableRecipe;
import com.hbm.items.machine.ItemFluidIcon;
import com.hbm.util.Tuple;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class FluidBreederRecipes
extends SerializableRecipe {
    public static Map<FluidType, Tuple.Pair<Integer, FluidStack>> recipes = new HashMap<FluidType, Tuple.Pair<Integer, FluidStack>>();

    @Override
    public void registerDefaults() {
        FluidBreederRecipes.register(new FluidStack(Fluids.GAS, 1000), new FluidStack(Fluids.SYNGAS, 1000));
        FluidBreederRecipes.register(new FluidStack(Fluids.LIGHTOIL, 1000), new FluidStack(Fluids.REFORMGAS, 1000));
        FluidBreederRecipes.register(new FluidStack(Fluids.LIGHTOIL_CRACK, 1000), new FluidStack(Fluids.REFORMGAS, 1000));
    }

    public static void register(FluidStack input, FluidStack output) {
        recipes.put(input.type, new Tuple.Pair<Integer, FluidStack>(input.fill, output));
    }

    public static Tuple.Pair<Integer, FluidStack> getOutput(FluidType type) {
        return recipes.get(type);
    }

    public static HashMap getRecipes() {
        HashMap<ItemStack, ItemStack> recipes = new HashMap<ItemStack, ItemStack>();
        for (Map.Entry<FluidType, Tuple.Pair<Integer, FluidStack>> entry : FluidBreederRecipes.recipes.entrySet()) {
            recipes.put(ItemFluidIcon.make(entry.getKey(), entry.getValue().getKey()), ItemFluidIcon.make(entry.getValue().getValue()));
        }
        return recipes;
    }

    @Override
    public void readRecipe(JsonElement recipe) {
        JsonObject obj = (JsonObject)recipe;
        FluidStack input = FluidBreederRecipes.readFluidStack(obj.get("input").getAsJsonArray());
        FluidStack output = FluidBreederRecipes.readFluidStack(obj.get("output").getAsJsonArray());
        recipes.put(input.type, new Tuple.Pair<Integer, FluidStack>(input.fill, output));
    }

    @Override
    public void writeRecipe(Object recipe, JsonWriter writer) throws IOException {
        Map.Entry rec = (Map.Entry)recipe;
        writer.name("input");
        FluidBreederRecipes.writeFluidStack(new FluidStack((FluidType)rec.getKey(), (Integer)((Tuple.Pair)rec.getValue()).getKey()), writer);
        writer.name("output");
        FluidBreederRecipes.writeFluidStack((FluidStack)((Tuple.Pair)rec.getValue()).getValue(), writer);
    }

    @Override
    public String getFileName() {
        return "hbmIrradiationFluids.json";
    }

    @Override
    public Object getRecipeObject() {
        return recipes;
    }

    @Override
    public void deleteRecipes() {
        recipes.clear();
    }
}

