/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.material.MaterialShapes;
import com.hbm.inventory.material.Mats;
import com.hbm.inventory.material.NTMMaterial;
import com.hbm.inventory.recipes.loader.SerializableRecipe;
import com.hbm.items.ItemEnums;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemCircuit;
import com.hbm.items.machine.ItemStamp;
import com.hbm.util.Tuple;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class PressRecipes
extends SerializableRecipe {
    public static HashMap<Tuple.Pair<RecipesCommon.AStack, ItemStamp.StampType>, ItemStack> recipes = new HashMap();

    public static ItemStack getOutput(ItemStack ingredient, ItemStack stamp) {
        if (ingredient == null || stamp == null) {
            return null;
        }
        if (!(stamp.func_77973_b() instanceof ItemStamp)) {
            return null;
        }
        ItemStamp.StampType type = ((ItemStamp)stamp.func_77973_b()).getStampType(stamp.func_77973_b(), stamp.func_77960_j());
        for (Map.Entry<Tuple.Pair<RecipesCommon.AStack, ItemStamp.StampType>, ItemStack> recipe : recipes.entrySet()) {
            if (recipe.getKey().getValue() != type || !recipe.getKey().getKey().matchesRecipe(ingredient, true)) continue;
            return recipe.getValue();
        }
        return null;
    }

    @Override
    public void registerDefaults() {
        PressRecipes.makeRecipe(ItemStamp.StampType.FLAT, (RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.NETHERQUARTZ.dust()), Items.field_151128_bU);
        PressRecipes.makeRecipe(ItemStamp.StampType.FLAT, (RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.LAPIS.dust()), new ItemStack(Items.field_151100_aR, 1, 4));
        PressRecipes.makeRecipe(ItemStamp.StampType.FLAT, (RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.DIAMOND.dust()), Items.field_151045_i);
        PressRecipes.makeRecipe(ItemStamp.StampType.FLAT, (RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.EMERALD.dust()), Items.field_151166_bC);
        PressRecipes.makeRecipe(ItemStamp.StampType.FLAT, (RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.biomass), ModItems.biomass_compressed);
        PressRecipes.makeRecipe(ItemStamp.StampType.FLAT, (RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.ANY_COKE.gem()), ModItems.ingot_graphite);
        PressRecipes.makeRecipe(ItemStamp.StampType.FLAT, (RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.meteorite_sword_reforged), ModItems.meteorite_sword_hardened);
        PressRecipes.makeRecipe(ItemStamp.StampType.FLAT, (RecipesCommon.AStack)new RecipesCommon.ComparableStack(Blocks.field_150364_r, 1, 3), ModItems.ball_resin);
        PressRecipes.makeRecipe(ItemStamp.StampType.FLAT, (RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.COAL.dust()), OreDictManager.DictFrame.fromOne(ModItems.briquette, (Enum)ItemEnums.EnumBriquetteType.COAL));
        PressRecipes.makeRecipe(ItemStamp.StampType.FLAT, (RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.LIGNITE.dust()), OreDictManager.DictFrame.fromOne(ModItems.briquette, (Enum)ItemEnums.EnumBriquetteType.LIGNITE));
        PressRecipes.makeRecipe(ItemStamp.StampType.FLAT, (RecipesCommon.AStack)new RecipesCommon.ComparableStack(ModItems.powder_sawdust), OreDictManager.DictFrame.fromOne(ModItems.briquette, (Enum)ItemEnums.EnumBriquetteType.WOOD));
        PressRecipes.makeRecipe(ItemStamp.StampType.PLATE, (RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.IRON.ingot()), ModItems.plate_iron);
        PressRecipes.makeRecipe(ItemStamp.StampType.PLATE, (RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.GOLD.ingot()), ModItems.plate_gold);
        PressRecipes.makeRecipe(ItemStamp.StampType.PLATE, (RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.TI.ingot()), ModItems.plate_titanium);
        PressRecipes.makeRecipe(ItemStamp.StampType.PLATE, (RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.AL.ingot()), ModItems.plate_aluminium);
        PressRecipes.makeRecipe(ItemStamp.StampType.PLATE, (RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.STEEL.ingot()), ModItems.plate_steel);
        PressRecipes.makeRecipe(ItemStamp.StampType.PLATE, (RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.PB.ingot()), ModItems.plate_lead);
        PressRecipes.makeRecipe(ItemStamp.StampType.PLATE, (RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.CU.ingot()), ModItems.plate_copper);
        PressRecipes.makeRecipe(ItemStamp.StampType.PLATE, (RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.ALLOY.ingot()), ModItems.plate_advanced_alloy);
        PressRecipes.makeRecipe(ItemStamp.StampType.PLATE, (RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.SA326.ingot()), ModItems.plate_schrabidium);
        PressRecipes.makeRecipe(ItemStamp.StampType.PLATE, (RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.CMB.ingot()), ModItems.plate_combine_steel);
        PressRecipes.makeRecipe(ItemStamp.StampType.PLATE, (RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.GUNMETAL.ingot()), ModItems.plate_gunmetal);
        PressRecipes.makeRecipe(ItemStamp.StampType.PLATE, (RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.WEAPONSTEEL.ingot()), ModItems.plate_weaponsteel);
        PressRecipes.makeRecipe(ItemStamp.StampType.PLATE, (RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.BIGMT.ingot()), ModItems.plate_saturnite);
        PressRecipes.makeRecipe(ItemStamp.StampType.PLATE, (RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.DURA.ingot()), ModItems.plate_dura_steel);
        PressRecipes.makeRecipe(ItemStamp.StampType.C9, (RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.GUNMETAL.plate()), OreDictManager.DictFrame.fromOne(ModItems.casing, (Enum)ItemEnums.EnumCasingType.SMALL, 4));
        PressRecipes.makeRecipe(ItemStamp.StampType.C50, (RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.GUNMETAL.plate()), OreDictManager.DictFrame.fromOne(ModItems.casing, (Enum)ItemEnums.EnumCasingType.LARGE, 2));
        PressRecipes.makeRecipe(ItemStamp.StampType.C9, (RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.WEAPONSTEEL.plate()), OreDictManager.DictFrame.fromOne(ModItems.casing, (Enum)ItemEnums.EnumCasingType.SMALL_STEEL, 4));
        PressRecipes.makeRecipe(ItemStamp.StampType.C50, (RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.WEAPONSTEEL.plate()), OreDictManager.DictFrame.fromOne(ModItems.casing, (Enum)ItemEnums.EnumCasingType.LARGE_STEEL, 2));
        for (NTMMaterial mat : Mats.orderedList) {
            if (!mat.autogen.contains(MaterialShapes.WIRE) || !OreDictionary.doesOreNameExist((String)MaterialShapes.INGOT.make(mat))) continue;
            PressRecipes.makeRecipe(ItemStamp.StampType.WIRE, (RecipesCommon.AStack)new RecipesCommon.OreDictStack(MaterialShapes.INGOT.make(mat)), new ItemStack(ModItems.wire_fine, 8, mat.id));
        }
        PressRecipes.makeRecipe(ItemStamp.StampType.CIRCUIT, (RecipesCommon.AStack)new RecipesCommon.OreDictStack(OreDictManager.SI.billet()), OreDictManager.DictFrame.fromOne(ModItems.circuit, (Enum)ItemCircuit.EnumCircuitType.SILICON));
        PressRecipes.makeRecipe(ItemStamp.StampType.PRINTING1, (RecipesCommon.AStack)new RecipesCommon.ComparableStack(Items.field_151121_aF), OreDictManager.DictFrame.fromOne(ModItems.page_of_, (Enum)ItemEnums.EnumPages.PAGE1));
        PressRecipes.makeRecipe(ItemStamp.StampType.PRINTING2, (RecipesCommon.AStack)new RecipesCommon.ComparableStack(Items.field_151121_aF), OreDictManager.DictFrame.fromOne(ModItems.page_of_, (Enum)ItemEnums.EnumPages.PAGE2));
        PressRecipes.makeRecipe(ItemStamp.StampType.PRINTING3, (RecipesCommon.AStack)new RecipesCommon.ComparableStack(Items.field_151121_aF), OreDictManager.DictFrame.fromOne(ModItems.page_of_, (Enum)ItemEnums.EnumPages.PAGE3));
        PressRecipes.makeRecipe(ItemStamp.StampType.PRINTING4, (RecipesCommon.AStack)new RecipesCommon.ComparableStack(Items.field_151121_aF), OreDictManager.DictFrame.fromOne(ModItems.page_of_, (Enum)ItemEnums.EnumPages.PAGE4));
        PressRecipes.makeRecipe(ItemStamp.StampType.PRINTING5, (RecipesCommon.AStack)new RecipesCommon.ComparableStack(Items.field_151121_aF), OreDictManager.DictFrame.fromOne(ModItems.page_of_, (Enum)ItemEnums.EnumPages.PAGE5));
        PressRecipes.makeRecipe(ItemStamp.StampType.PRINTING6, (RecipesCommon.AStack)new RecipesCommon.ComparableStack(Items.field_151121_aF), OreDictManager.DictFrame.fromOne(ModItems.page_of_, (Enum)ItemEnums.EnumPages.PAGE6));
        PressRecipes.makeRecipe(ItemStamp.StampType.PRINTING7, (RecipesCommon.AStack)new RecipesCommon.ComparableStack(Items.field_151121_aF), OreDictManager.DictFrame.fromOne(ModItems.page_of_, (Enum)ItemEnums.EnumPages.PAGE7));
        PressRecipes.makeRecipe(ItemStamp.StampType.PRINTING8, (RecipesCommon.AStack)new RecipesCommon.ComparableStack(Items.field_151121_aF), OreDictManager.DictFrame.fromOne(ModItems.page_of_, (Enum)ItemEnums.EnumPages.PAGE8));
    }

    public static void makeRecipe(ItemStamp.StampType type, RecipesCommon.AStack in, Item out) {
        recipes.put(new Tuple.Pair<RecipesCommon.AStack, ItemStamp.StampType>(in, type), new ItemStack(out));
    }

    public static void makeRecipe(ItemStamp.StampType type, RecipesCommon.AStack in, ItemStack out) {
        recipes.put(new Tuple.Pair<RecipesCommon.AStack, ItemStamp.StampType>(in, type), out);
    }

    @Override
    public String getFileName() {
        return "hbmPress.json";
    }

    @Override
    public Object getRecipeObject() {
        return recipes;
    }

    @Override
    public void readRecipe(JsonElement recipe) {
        JsonObject obj = (JsonObject)recipe;
        RecipesCommon.AStack input = PressRecipes.readAStack(obj.get("input").getAsJsonArray());
        ItemStamp.StampType stamp = ItemStamp.StampType.valueOf(obj.get("stamp").getAsString().toUpperCase());
        ItemStack output = PressRecipes.readItemStack(obj.get("output").getAsJsonArray());
        if (stamp != null) {
            PressRecipes.makeRecipe(stamp, input, output);
        }
    }

    @Override
    public void writeRecipe(Object recipe, JsonWriter writer) throws IOException {
        Map.Entry entry = (Map.Entry)recipe;
        writer.name("input");
        PressRecipes.writeAStack((RecipesCommon.AStack)((Tuple.Pair)entry.getKey()).getKey(), writer);
        writer.name("stamp").value(((ItemStamp.StampType)((Object)((Tuple.Pair)entry.getKey()).getValue())).name().toLowerCase(Locale.US));
        writer.name("output");
        PressRecipes.writeItemStack((ItemStack)entry.getValue(), writer);
    }

    @Override
    public void deleteRecipes() {
        recipes.clear();
    }
}

