/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.module.machine;

import api.hbm.energymk2.IEnergyHandlerMK2;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.recipes.FusionRecipes;
import com.hbm.inventory.recipes.loader.GenericRecipe;
import com.hbm.inventory.recipes.loader.GenericRecipes;
import com.hbm.module.machine.ModuleMachineBase;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ModuleMachineFusion
extends ModuleMachineBase {
    public double processSpeed = 1.0;
    public double bonusSpeed = 0.0;
    public double bonus;

    public ModuleMachineFusion(int index, IEnergyHandlerMK2 battery, ItemStack[] slots) {
        super(index, battery, slots);
        this.inputSlots = new int[0];
        this.outputSlots = new int[1];
        this.inputTanks = new FluidTank[3];
        this.outputTanks = new FluidTank[1];
    }

    @Override
    public GenericRecipes getRecipeSet() {
        return FusionRecipes.INSTANCE;
    }

    public ModuleMachineFusion itemOutput(int slot) {
        this.outputSlots[0] = slot;
        return this;
    }

    public ModuleMachineFusion fluidInput(FluidTank a, FluidTank b, FluidTank c) {
        this.inputTanks[0] = a;
        this.inputTanks[1] = b;
        this.inputTanks[2] = c;
        return this;
    }

    public ModuleMachineFusion fluidOutput(FluidTank a) {
        this.outputTanks[0] = a;
        return this;
    }

    public void preUpdate(double processSpeed, double bonusSpeed) {
        this.processSpeed = processSpeed;
        this.bonusSpeed = bonusSpeed;
    }

    @Override
    protected boolean hasInput(GenericRecipe recipe) {
        if (this.processSpeed <= 0.0) {
            return false;
        }
        if (recipe.inputFluid != null) {
            for (int i = 0; i < Math.min(recipe.inputFluid.length, this.inputTanks.length); ++i) {
                if (this.inputTanks[i].getFill() <= 0 || this.inputTanks[i].getFill() >= (int)Math.ceil((double)recipe.inputFluid[i].fill * this.processSpeed)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void process(GenericRecipe recipe, double speed, double power) {
        this.battery.setPower(this.battery.getPower() - (long)Math.ceil((double)(power == 1.0 ? recipe.power : (long)((double)recipe.power * power)) * this.processSpeed));
        double step = Math.min(speed / (double)recipe.duration * this.processSpeed, 1.0);
        this.progress += step;
        this.bonus += step * this.bonusSpeed;
        this.bonus = Math.min(this.bonus, 1.5);
        if (recipe.inputFluid != null) {
            for (int i = 0; i < Math.min(recipe.inputFluid.length, this.inputTanks.length); ++i) {
                this.inputTanks[i].setFill(Math.max(this.inputTanks[i].getFill() - (int)Math.ceil((double)recipe.inputFluid[i].fill * this.processSpeed), 0));
            }
        }
        if (this.progress >= 1.0) {
            this.produceItem(recipe);
            this.progress = this.canProcess(recipe, speed, power) ? (this.progress -= 1.0) : 0.0;
        }
        if (this.bonus >= 1.0 && this.canFitOutput(recipe)) {
            this.produceItem(recipe);
            this.bonus -= 1.0;
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeDouble(this.bonus);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.bonus = buf.readDouble();
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.bonus = nbt.func_74769_h("bonus" + this.index);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74780_a("bonus" + this.index, this.bonus);
    }
}

