/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.anim;

import com.hbm.render.anim.BusAnimationKeyframe;
import java.util.ArrayList;
import java.util.List;

public class BusAnimationSequence {
    private List<List<BusAnimationKeyframe>> transformKeyframes = new ArrayList<List<BusAnimationKeyframe>>(9);
    public double[] offset = new double[3];
    public double[] rotMode = new double[]{0.0, 1.0, 2.0};

    public BusAnimationSequence() {
        for (int i = 0; i < 9; ++i) {
            this.transformKeyframes.add(new ArrayList());
        }
    }

    public BusAnimationSequence addKeyframe(Dimension dimension, BusAnimationKeyframe keyframe) {
        this.transformKeyframes.get(dimension.ordinal()).add(keyframe);
        return this;
    }

    public BusAnimationSequence addKeyframe(Dimension dimension, double value, int duration) {
        return this.addKeyframe(dimension, new BusAnimationKeyframe(value, duration));
    }

    public BusAnimationSequence setPos(double x, double y, double z) {
        return this.addPos(x, y, z, 0, BusAnimationKeyframe.IType.LINEAR);
    }

    public BusAnimationSequence addPos(double x, double y, double z, int duration) {
        return this.addPos(x, y, z, duration, BusAnimationKeyframe.IType.LINEAR);
    }

    public BusAnimationSequence addPos(double x, double y, double z, int duration, BusAnimationKeyframe.IType type) {
        this.addKeyframe(Dimension.TX, new BusAnimationKeyframe(x, duration, type));
        this.addKeyframe(Dimension.TY, new BusAnimationKeyframe(y, duration, type));
        this.addKeyframe(Dimension.TZ, new BusAnimationKeyframe(z, duration, type));
        return this;
    }

    public BusAnimationSequence addRot(double x, double y, double z, int duration) {
        this.addKeyframe(Dimension.RX, new BusAnimationKeyframe(x, duration));
        this.addKeyframe(Dimension.RY, new BusAnimationKeyframe(y, duration));
        this.addKeyframe(Dimension.RZ, new BusAnimationKeyframe(z, duration));
        return this;
    }

    public BusAnimationSequence hold(int duration) {
        this.addKeyframe(Dimension.TX, new BusAnimationKeyframe(this.getLast(Dimension.TX), duration));
        this.addKeyframe(Dimension.TY, new BusAnimationKeyframe(this.getLast(Dimension.TY), duration));
        this.addKeyframe(Dimension.TZ, new BusAnimationKeyframe(this.getLast(Dimension.TZ), duration));
        return this;
    }

    public BusAnimationSequence holdUntil(int end) {
        int duration = end - this.getTotalTime();
        return this.hold(duration);
    }

    public BusAnimationSequence multiplyTime(double mult) {
        for (Dimension dim : Dimension.values()) {
            List<BusAnimationKeyframe> keyframes = this.transformKeyframes.get(dim.ordinal());
            for (BusAnimationKeyframe keyframe : keyframes) {
                keyframe.duration = (int)((double)keyframe.originalDuration * mult);
            }
        }
        return this;
    }

    private double getLast(Dimension dim) {
        BusAnimationKeyframe frame = this.getLastFrame(dim);
        return frame != null ? frame.value : 0.0;
    }

    private BusAnimationKeyframe getLastFrame(Dimension dim) {
        List<BusAnimationKeyframe> keyframes = this.transformKeyframes.get(dim.ordinal());
        if (keyframes.isEmpty()) {
            return null;
        }
        return keyframes.get(keyframes.size() - 1);
    }

    public double[] getTransformation(int millis) {
        double[] transform = new double[15];
        for (int i = 0; i < 9; ++i) {
            List<BusAnimationKeyframe> keyframes = this.transformKeyframes.get(i);
            BusAnimationKeyframe currentFrame = null;
            BusAnimationKeyframe previousFrame = null;
            int startTime = 0;
            int endTime = 0;
            for (BusAnimationKeyframe keyframe : keyframes) {
                startTime = endTime;
                previousFrame = currentFrame;
                currentFrame = keyframe;
                if (millis >= (endTime += keyframe.duration)) continue;
                break;
            }
            transform[i] = currentFrame == null ? (i >= 6 ? 1.0 : 0.0) : (millis >= endTime ? currentFrame.value : (previousFrame != null && previousFrame.interpolationType == BusAnimationKeyframe.IType.CONSTANT ? previousFrame.value : currentFrame.interpolate(startTime, millis, previousFrame)));
        }
        transform[9] = this.offset[0];
        transform[10] = this.offset[1];
        transform[11] = this.offset[2];
        transform[12] = this.rotMode[0];
        transform[13] = this.rotMode[1];
        transform[14] = this.rotMode[2];
        return transform;
    }

    public int getTotalTime() {
        int highestTime = 0;
        for (List<BusAnimationKeyframe> keyframes : this.transformKeyframes) {
            int time = 0;
            for (BusAnimationKeyframe frame : keyframes) {
                time += frame.duration;
            }
            highestTime = Math.max(time, highestTime);
        }
        return highestTime;
    }

    public static enum Dimension {
        TX,
        TY,
        TZ,
        RX,
        RY,
        RZ,
        SX,
        SY,
        SZ;

    }
}

