/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IEnergyReceiverMK2;
import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.machine.MachineSILEX;
import com.hbm.interfaces.Spaghetti;
import com.hbm.inventory.container.ContainerFEL;
import com.hbm.inventory.gui.GUIFEL;
import com.hbm.items.machine.ItemFELCrystal;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.sound.AudioWrapper;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.tileentity.machine.TileEntitySILEX;
import com.hbm.util.BufferUtil;
import com.hbm.util.ContaminationUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityFEL
extends TileEntityMachineBase
implements IEnergyReceiverMK2,
IGUIProvider {
    public long power;
    public static final long maxPower = 20000000L;
    public static final int powerReq = 1250;
    public ItemFELCrystal.EnumWavelengths mode = ItemFELCrystal.EnumWavelengths.NULL;
    public boolean isOn;
    public boolean missingValidSilex = true;
    public int distance;
    public List<EntityLivingBase> entities = new ArrayList<EntityLivingBase>();
    private int audioDuration = 0;
    private AudioWrapper audio;

    public TileEntityFEL() {
        super(2);
    }

    @Override
    public String getName() {
        return "container.machineFEL";
    }

    @Override
    @Spaghetti(value="What the fuck were you thinking")
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
            this.trySubscribe(this.field_145850_b, this.field_145851_c + dir.offsetX * -5, this.field_145848_d + 1, this.field_145849_e + dir.offsetZ * -5, dir.getOpposite());
            this.power = Library.chargeTEFromItems(this.slots, 0, this.power, 20000000L);
            if (this.isOn && this.slots[1] != null) {
                if (this.slots[1].func_77973_b() instanceof ItemFELCrystal) {
                    ItemFELCrystal crystal = (ItemFELCrystal)this.slots[1].func_77973_b();
                    this.mode = crystal.wavelength;
                } else {
                    this.mode = ItemFELCrystal.EnumWavelengths.NULL;
                }
            } else {
                this.mode = ItemFELCrystal.EnumWavelengths.NULL;
            }
            int range = 24;
            boolean silexSpacing = false;
            int req = (int)(1250.0 * (this.mode.ordinal() == 0 ? 0.0 : Math.pow(3.0, this.mode.ordinal())));
            if (this.isOn && this.mode != ItemFELCrystal.EnumWavelengths.NULL && this.power < (long)req) {
                this.power = 0L;
            }
            if (this.isOn && this.power >= (long)req && this.mode != ItemFELCrystal.EnumWavelengths.NULL) {
                int distance = this.distance - 1;
                double blx = (double)Math.min(this.field_145851_c, this.field_145851_c + dir.offsetX * distance) + 0.2;
                double bux = (double)Math.max(this.field_145851_c, this.field_145851_c + dir.offsetX * distance) + 0.8;
                double bly = (double)Math.min(this.field_145848_d, 1 + this.field_145848_d + dir.offsetY * distance) + 0.2;
                double buy = (double)Math.max(this.field_145848_d, 1 + this.field_145848_d + dir.offsetY * distance) + 0.8;
                double blz = (double)Math.min(this.field_145849_e, this.field_145849_e + dir.offsetZ * distance) + 0.2;
                double buz = (double)Math.max(this.field_145849_e, this.field_145849_e + dir.offsetZ * distance) + 0.8;
                List list = this.field_145850_b.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)blx, (double)bly, (double)blz, (double)bux, (double)buy, (double)buz));
                for (EntityLivingBase entity : list) {
                    switch (this.mode) {
                        case VISIBLE: {
                            entity.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 0xE100000, 0));
                        }
                        case IR: 
                        case UV: {
                            entity.func_70015_d(10);
                            break;
                        }
                        case GAMMA: {
                            ContaminationUtil.contaminate(entity, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.CREATIVE, 25.0f);
                            break;
                        }
                        case DRX: {
                            ContaminationUtil.applyDigammaData((Entity)entity, 0.1f);
                        }
                    }
                }
                this.power -= (long)req;
                for (int i = 3; i < range; ++i) {
                    int x = this.field_145851_c + dir.offsetX * i;
                    int y = this.field_145848_d + 1;
                    int z = this.field_145849_e + dir.offsetZ * i;
                    Block b = this.field_145850_b.func_147439_a(x, y, z);
                    if (!b.func_149688_o().func_76218_k() && b != Blocks.field_150335_W) {
                        this.distance = range;
                        silexSpacing = false;
                        continue;
                    }
                    if (b == ModBlocks.machine_silex) {
                        TileEntity te = this.field_145850_b.func_147438_o(x + dir.offsetX, this.field_145848_d, z + dir.offsetZ);
                        if (!(te instanceof TileEntitySILEX)) continue;
                        TileEntitySILEX silex = (TileEntitySILEX)te;
                        int meta = silex.func_145832_p() - 10;
                        if (this.rotationIsValid(meta, this.func_145832_p() - 10) && i >= 5 && !silexSpacing) {
                            if (silex.mode == this.mode) continue;
                            silex.mode = this.mode;
                            this.missingValidSilex = false;
                            silexSpacing = true;
                            continue;
                        }
                        MachineSILEX silexBlock = (MachineSILEX)silex.func_145838_q();
                        silexBlock.func_149749_a(this.field_145850_b, silex.field_145851_c, silex.field_145848_d, silex.field_145849_e, (Block)silexBlock, 0);
                        this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, new ItemStack(Item.func_150898_a((Block)ModBlocks.machine_silex))));
                        continue;
                    }
                    if (!b.func_149688_o().func_76218_k() && b != Blocks.field_150335_W) continue;
                    this.distance = i;
                    if (b.func_149688_o().func_76224_d()) {
                        this.field_145850_b.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.fizz", 1.0f, 1.0f);
                        this.field_145850_b.func_147468_f(x, y, z);
                        break;
                    }
                    float hardness = b.func_149638_a(null);
                    if (!(hardness < 75.0f) || this.field_145850_b.field_73012_v.nextInt(5) != 0) break;
                    this.field_145850_b.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "random.fizz", 1.0f, 1.0f);
                    BlockFire block = this.mode != ItemFELCrystal.EnumWavelengths.DRX ? Blocks.field_150480_ab : (MainRegistry.polaroidID == 11 ? ModBlocks.digamma_matter : ModBlocks.fire_digamma);
                    this.field_145850_b.func_147449_b(x, y, z, (Block)block);
                    if (this.mode != ItemFELCrystal.EnumWavelengths.DRX) break;
                    this.field_145850_b.func_147449_b(x, y - 1, z, ModBlocks.ash_digamma);
                    break;
                }
            }
            this.networkPackNT(250);
        } else {
            this.audioDuration = (double)this.power > 1250.0 * Math.pow(2.0, this.mode.ordinal()) && this.isOn && this.mode != ItemFELCrystal.EnumWavelengths.NULL && this.distance - 3 > 0 ? (this.audioDuration += 2) : (this.audioDuration -= 3);
            this.audioDuration = MathHelper.func_76125_a((int)this.audioDuration, (int)0, (int)60);
            if (this.audioDuration > 10) {
                if (this.audio == null) {
                    this.audio = this.createAudioLoop();
                    this.audio.startSound();
                } else if (!this.audio.isPlaying()) {
                    this.audio = this.rebootAudio(this.audio);
                }
                this.audio.updateVolume(this.getVolume(2.0f));
                this.audio.updatePitch((float)(this.audioDuration - 10) / 100.0f + 0.5f);
            } else if (this.audio != null) {
                this.audio.stopSound();
                this.audio = null;
            }
        }
    }

    public boolean rotationIsValid(int silexMeta, int felMeta) {
        ForgeDirection felDir;
        ForgeDirection silexDir = ForgeDirection.getOrientation((int)silexMeta);
        return silexDir == (felDir = ForgeDirection.getOrientation((int)felMeta)) || silexDir == felDir.getOpposite();
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeLong(this.power);
        BufferUtil.writeString(buf, this.mode.toString());
        buf.writeBoolean(this.isOn);
        buf.writeBoolean(this.missingValidSilex);
        buf.writeInt(this.distance);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.power = buf.readLong();
        this.mode = ItemFELCrystal.EnumWavelengths.valueOf(BufferUtil.readString(buf));
        this.isOn = buf.readBoolean();
        this.missingValidSilex = buf.readBoolean();
        this.distance = buf.readInt();
    }

    @Override
    public void handleButtonPacket(int value, int meta) {
        if (meta == 2) {
            this.isOn = !this.isOn;
        }
    }

    public long getPowerScaled(long i) {
        return this.power * i / 20000000L;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.mode = ItemFELCrystal.EnumWavelengths.valueOf(nbt.func_74779_i("mode"));
        this.isOn = nbt.func_74767_n("isOn");
        this.missingValidSilex = nbt.func_74767_n("valid");
        this.distance = nbt.func_74762_e("distance");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        nbt.func_74778_a("mode", this.mode.toString());
        nbt.func_74757_a("isOn", this.isOn);
        nbt.func_74757_a("valid", this.missingValidSilex);
        nbt.func_74768_a("distance", this.distance);
    }

    @Override
    public AudioWrapper createAudioLoop() {
        return MainRegistry.proxy.getLoopedSound("hbm:block.fel", this.field_145851_c, this.field_145848_d, this.field_145849_e, 2.0f, 10.0f, 2.0f);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 20000000L;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerFEL(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIFEL(player.field_71071_by, this);
    }
}

