/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.items.ModItems;
import com.hbm.items.tool.ItemKey;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.TileEntityLoadedBase;
import com.hbm.util.ArmorUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class TileEntityLockableBase
extends TileEntityLoadedBase {
    protected int lock;
    private boolean isLocked = false;
    protected double lockMod = 0.1;

    public boolean isLocked() {
        return this.isLocked;
    }

    public void lock() {
        if (this.lock == 0) {
            MainRegistry.logger.error("A block has been set to locked state before setting pins, this should not happen and may cause errors! " + this.toString());
        }
        this.isLocked = true;
        this.func_70296_d();
    }

    public void setPins(int pins) {
        this.lock = pins;
        this.func_70296_d();
    }

    public int getPins() {
        return this.lock;
    }

    public void setMod(double mod) {
        this.lockMod = mod;
        this.func_70296_d();
    }

    public double getMod() {
        return this.lockMod;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.lock = nbt.func_74762_e("lock");
        this.isLocked = nbt.func_74767_n("isLocked");
        this.lockMod = nbt.func_74769_h("lockMod");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("lock", this.lock);
        nbt.func_74757_a("isLocked", this.isLocked);
        nbt.func_74780_a("lockMod", this.lockMod);
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeInt(this.lock);
        buf.writeBoolean(this.isLocked);
        buf.writeDouble(this.lockMod);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.lock = buf.readInt();
        this.isLocked = buf.readBoolean();
        this.lockMod = buf.readDouble();
    }

    public boolean canAccess(EntityPlayer player) {
        if (!this.isLocked) {
            return true;
        }
        if (player == null) {
            return false;
        }
        ItemStack stack = player.func_70694_bm();
        if (stack != null && stack.func_77973_b() instanceof ItemKey && ItemKey.getPins(stack) == this.lock) {
            this.field_145850_b.func_72956_a((Entity)player, "hbm:block.lockOpen", 1.0f, 1.0f);
            return true;
        }
        if (stack != null && stack.func_77973_b() == ModItems.key_red) {
            this.field_145850_b.func_72956_a((Entity)player, "hbm:block.lockOpen", 1.0f, 1.0f);
            return true;
        }
        return this.tryPick(player);
    }

    private boolean tryPick(EntityPlayer player) {
        boolean canPick = false;
        ItemStack stack = player.func_70694_bm();
        double chanceOfSuccess = this.lockMod * 100.0;
        if (stack != null && stack.func_77973_b() == ModItems.pin && (player.field_71071_by.func_146028_b(ModItems.screwdriver) || player.field_71071_by.func_146028_b(ModItems.screwdriver_desh))) {
            --stack.field_77994_a;
            canPick = true;
        }
        if (stack != null && (stack.func_77973_b() == ModItems.screwdriver || stack.func_77973_b() == ModItems.screwdriver_desh) && player.field_71071_by.func_146028_b(ModItems.pin)) {
            player.field_71071_by.func_146026_a(ModItems.pin);
            player.field_71069_bz.func_75142_b();
            canPick = true;
        }
        if (canPick) {
            double rand;
            if (ArmorUtil.checkArmorPiece((EntityLivingBase)player, ModItems.jackt, 2) || ArmorUtil.checkArmorPiece((EntityLivingBase)player, ModItems.jackt2, 2)) {
                chanceOfSuccess *= 100.0;
            }
            if (chanceOfSuccess > (rand = player.field_70170_p.field_73012_v.nextDouble() * 100.0)) {
                this.field_145850_b.func_72956_a((Entity)player, "hbm:item.pinUnlock", 1.0f, 1.0f);
                return true;
            }
            this.field_145850_b.func_72956_a((Entity)player, "hbm:item.pinBreak", 1.0f, 0.8f + player.field_70170_p.field_73012_v.nextFloat() * 0.2f);
        }
        return false;
    }
}

