/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.fluid.IFluidStandardTransceiver;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.blocks.ModBlocks;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.IBufPacketReceiver;
import com.hbm.tileentity.IConfigurableMachine;
import com.hbm.tileentity.IFluidCopiable;
import com.hbm.tileentity.TileEntityLoadedBase;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;

public abstract class TileEntityMachinePumpBase
extends TileEntityLoadedBase
implements IFluidStandardTransceiver,
IBufPacketReceiver,
IConfigurableMachine,
IFluidCopiable {
    public static final HashSet<Block> validBlocks = new HashSet();
    public FluidTank water;
    public boolean isOn = false;
    public float rotor;
    public float lastRotor;
    public boolean onGround = false;
    public int groundCheckDelay = 0;
    public static int groundHeight;
    public static int groundDepth;
    public static int steamSpeed;
    public static int electricSpeed;
    AxisAlignedBB bb = null;

    @Override
    public String getConfigName() {
        return "waterpump";
    }

    @Override
    public void readIfPresent(JsonObject obj) {
        groundHeight = IConfigurableMachine.grab(obj, "I:groundHeight", groundHeight);
        groundDepth = IConfigurableMachine.grab(obj, "I:groundDepth", groundDepth);
        steamSpeed = IConfigurableMachine.grab(obj, "I:steamSpeed", steamSpeed);
        electricSpeed = IConfigurableMachine.grab(obj, "I:electricSpeed", electricSpeed);
    }

    @Override
    public void writeConfig(JsonWriter writer) throws IOException {
        writer.name("I:groundHeight").value((long)groundHeight);
        writer.name("I:groundDepth").value((long)groundDepth);
        writer.name("I:steamSpeed").value((long)steamSpeed);
        writer.name("I:electricSpeed").value((long)electricSpeed);
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            for (DirPos pos : this.getConPos()) {
                if (this.water.getFill() <= 0) continue;
                this.sendFluid(this.water, this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            }
            if (this.groundCheckDelay > 0) {
                --this.groundCheckDelay;
            } else {
                this.onGround = this.checkGround();
            }
            this.isOn = false;
            if (this.canOperate() && this.field_145848_d <= groundHeight && this.onGround) {
                this.isOn = true;
                this.operate();
            }
            this.networkPackNT(150);
        } else {
            this.lastRotor = this.rotor;
            if (this.isOn) {
                this.rotor += 10.0f;
            }
            if (this.rotor >= 360.0f) {
                this.rotor -= 360.0f;
                this.lastRotor -= 360.0f;
                MainRegistry.proxy.playSoundClient(this.field_145851_c, this.field_145848_d, this.field_145849_e, "hbm:block.steamEngineOperate", 0.5f, 0.75f);
                MainRegistry.proxy.playSoundClient(this.field_145851_c, this.field_145848_d, this.field_145849_e, "game.neutral.swim.splash", 1.0f, 0.5f);
            }
        }
    }

    protected boolean checkGround() {
        if (this.field_145850_b.field_73011_w.field_76576_e) {
            return false;
        }
        int validBlocks = 0;
        int invalidBlocks = 0;
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y >= -groundDepth; --y) {
                for (int z = -1; z <= 1; ++z) {
                    Block b = this.field_145850_b.func_147439_a(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z);
                    if (y == -1 && !b.func_149721_r()) {
                        return false;
                    }
                    if (TileEntityMachinePumpBase.validBlocks.contains(b)) {
                        ++validBlocks;
                        continue;
                    }
                    ++invalidBlocks;
                }
            }
        }
        return validBlocks >= invalidBlocks;
    }

    @Override
    public void serialize(ByteBuf buf) {
        buf.writeBoolean(this.isOn);
        buf.writeBoolean(this.onGround);
        this.water.serialize(buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        this.isOn = buf.readBoolean();
        this.onGround = buf.readBoolean();
        this.water.deserialize(buf);
    }

    protected abstract boolean canOperate();

    protected abstract void operate();

    protected DirPos[] getConPos() {
        return new DirPos[]{new DirPos(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e, Library.POS_X), new DirPos(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e, Library.NEG_X), new DirPos(this.field_145851_c, this.field_145848_d, this.field_145849_e + 2, Library.POS_Z), new DirPos(this.field_145851_c, this.field_145848_d, this.field_145849_e - 2, Library.NEG_Z)};
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.water};
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.water};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[0];
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 5), (double)(this.field_145849_e + 2));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public FluidTank getTankToPaste() {
        return null;
    }

    static {
        validBlocks.add((Block)Blocks.field_150349_c);
        validBlocks.add(Blocks.field_150346_d);
        validBlocks.add((Block)Blocks.field_150354_m);
        validBlocks.add((Block)Blocks.field_150391_bh);
        validBlocks.add(ModBlocks.waste_earth);
        validBlocks.add(ModBlocks.dirt_dead);
        validBlocks.add(ModBlocks.dirt_oily);
        validBlocks.add(ModBlocks.sand_dirty);
        validBlocks.add(ModBlocks.sand_dirty_red);
        groundHeight = 70;
        groundDepth = 4;
        steamSpeed = 1000;
        electricSpeed = 10000;
    }
}

