/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.storage;

import com.hbm.inventory.container.ContainerBatteryREDD;
import com.hbm.inventory.gui.GUIBatteryREDD;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.sound.AudioWrapper;
import com.hbm.tileentity.IPersistentNBT;
import com.hbm.tileentity.machine.storage.TileEntityBatteryBase;
import com.hbm.util.fauxpointtwelve.BlockPos;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.common.Optional;
import io.netty.buffer.ByteBuf;
import java.math.BigInteger;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityBatteryREDD
extends TileEntityBatteryBase
implements IPersistentNBT {
    public float prevRotation = 0.0f;
    public float rotation = 0.0f;
    public BigInteger[] log = new BigInteger[20];
    public BigInteger delta = BigInteger.valueOf(0L);
    public BigInteger power = BigInteger.valueOf(0L);
    private AudioWrapper audio;
    AxisAlignedBB bb = null;

    public TileEntityBatteryREDD() {
        super(2);
    }

    @Override
    public String getName() {
        return "container.batteryREDD";
    }

    @Override
    public void func_145845_h() {
        BigInteger prevPower = new BigInteger(this.power.toByteArray());
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            long toRemove;
            long toAdd = Library.chargeTEFromItems(this.slots, 0, 0L, this.getMaxPower());
            if (toAdd > 0L) {
                this.power = this.power.add(BigInteger.valueOf(toAdd));
            }
            if ((toRemove = this.getPower() - Library.chargeItemsFromTE(this.slots, 1, this.getPower(), this.getMaxPower())) > 0L) {
                this.power = this.power.subtract(BigInteger.valueOf(toRemove));
            }
            BigInteger avg = this.power.add(prevPower).divide(BigInteger.valueOf(2L));
            this.delta = avg.subtract(this.log[0] == null ? BigInteger.ZERO : this.log[0]);
            for (int i = 1; i < this.log.length; ++i) {
                this.log[i - 1] = this.log[i];
            }
            this.log[19] = avg;
        } else {
            this.prevRotation = this.rotation;
            this.rotation += this.getSpeed();
            if (this.rotation >= 360.0f) {
                this.rotation -= 360.0f;
                this.prevRotation -= 360.0f;
            }
            float pitch = 0.5f + this.getSpeed() / 15.0f * 1.5f;
            if (this.prevRotation != this.rotation && MainRegistry.proxy.me().func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 5.5, (double)this.field_145849_e + 0.5) < 900.0) {
                if (this.audio == null || !this.audio.isPlaying()) {
                    this.audio = MainRegistry.proxy.getLoopedSound("hbm:block.fensuHum", this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getVolume(1.5f), 25.0f, pitch, 5);
                    this.audio.startSound();
                }
                this.audio.updateVolume(this.getVolume(1.5f));
                this.audio.updatePitch(pitch);
                this.audio.keepAlive();
            } else if (this.audio != null) {
                this.audio.stopSound();
                this.audio = null;
            }
        }
    }

    public float getSpeed() {
        return (float)Math.min(Math.pow(Math.log(this.power.doubleValue() * 0.05 + 1.0) * (double)0.05f, 5.0), 15.0);
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        byte[] array0 = this.power.toByteArray();
        buf.writeInt(array0.length);
        for (byte b : array0) {
            buf.writeByte((int)b);
        }
        byte[] array1 = this.delta.toByteArray();
        buf.writeInt(array1.length);
        for (byte b : array1) {
            buf.writeByte((int)b);
        }
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        byte[] array0 = new byte[buf.readInt()];
        for (int i = 0; i < array0.length; ++i) {
            array0[i] = buf.readByte();
        }
        this.power = new BigInteger(array0);
        byte[] array1 = new byte[buf.readInt()];
        for (int i = 0; i < array1.length; ++i) {
            array1[i] = buf.readByte();
        }
        this.delta = new BigInteger(array1);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = new BigInteger(nbt.func_74770_j("power"));
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74773_a("power", this.power.toByteArray());
    }

    @Override
    public BlockPos[] getPortPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new BlockPos[]{new BlockPos(this.field_145851_c + dir.offsetX * 2 + rot.offsetX * 2, this.field_145848_d, this.field_145849_e + dir.offsetZ * 2 + rot.offsetZ * 2), new BlockPos(this.field_145851_c + dir.offsetX * 2 - rot.offsetX * 2, this.field_145848_d, this.field_145849_e + dir.offsetZ * 2 - rot.offsetZ * 2), new BlockPos(this.field_145851_c - dir.offsetX * 2 + rot.offsetX * 2, this.field_145848_d, this.field_145849_e - dir.offsetZ * 2 + rot.offsetZ * 2), new BlockPos(this.field_145851_c - dir.offsetX * 2 - rot.offsetX * 2, this.field_145848_d, this.field_145849_e - dir.offsetZ * 2 - rot.offsetZ * 2), new BlockPos(this.field_145851_c + rot.offsetX * 4, this.field_145848_d, this.field_145849_e + rot.offsetZ * 4), new BlockPos(this.field_145851_c - rot.offsetX * 4, this.field_145848_d, this.field_145849_e - rot.offsetZ * 4)};
    }

    @Override
    public DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new DirPos[]{new DirPos(this.field_145851_c + dir.offsetX * 3 + rot.offsetX * 2, this.field_145848_d, this.field_145849_e + dir.offsetZ * 3 + rot.offsetZ * 2, dir), new DirPos(this.field_145851_c + dir.offsetX * 3 - rot.offsetX * 2, this.field_145848_d, this.field_145849_e + dir.offsetZ * 3 - rot.offsetZ * 2, dir), new DirPos(this.field_145851_c - dir.offsetX * 3 + rot.offsetX * 2, this.field_145848_d, this.field_145849_e - dir.offsetZ * 3 + rot.offsetZ * 2, dir.getOpposite()), new DirPos(this.field_145851_c - dir.offsetX * 3 - rot.offsetX * 2, this.field_145848_d, this.field_145849_e - dir.offsetZ * 3 - rot.offsetZ * 2, dir.getOpposite()), new DirPos(this.field_145851_c + rot.offsetX * 5, this.field_145848_d, this.field_145849_e + rot.offsetZ * 5, rot), new DirPos(this.field_145851_c - rot.offsetX * 5, this.field_145848_d, this.field_145849_e - rot.offsetZ * 5, rot.getOpposite())};
    }

    @Override
    public void usePower(long power) {
        this.power = this.power.subtract(BigInteger.valueOf(power));
    }

    @Override
    public long transferPower(long power) {
        this.power = this.power.add(BigInteger.valueOf(power));
        return 0L;
    }

    @Override
    public long getPower() {
        return this.power.min(BigInteger.valueOf(this.getMaxPower() / 2L)).longValue();
    }

    @Override
    public void setPower(long power) {
    }

    @Override
    public long getMaxPower() {
        return 92233720368547758L;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerBatteryREDD(player.field_71071_by, this);
    }

    @Override
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIBatteryREDD(player.field_71071_by, this);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 4), (double)this.field_145848_d, (double)(this.field_145849_e - 4), (double)(this.field_145851_c + 5), (double)(this.field_145848_d + 10), (double)(this.field_145849_e + 5));
        }
        return this.bb;
    }

    @Override
    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getEnergyInfo(Context context, Arguments args) {
        return new Object[]{this.power.doubleValue(), this.delta.longValue()};
    }

    @Override
    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getInfo(Context context, Arguments args) {
        return new Object[]{this.power.doubleValue(), this.delta.longValue(), this.redLow, this.redHigh, this.getPriority().ordinal() - 1};
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String[] methods() {
        return new String[]{"getEnergyInfo", "getModeInfo", "setModeLow", "setModeHigh", "setPriority", "getInfo"};
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public Object[] invoke(String method, Context context, Arguments args) throws Exception {
        switch (method) {
            case "getEnergyInfo": {
                return this.getEnergyInfo(context, args);
            }
            case "getModeInfo": {
                return this.getModeInfo(context, args);
            }
            case "setModeLow": {
                return this.setModeLow(context, args);
            }
            case "setModeHigh": {
                return this.setModeHigh(context, args);
            }
            case "setPriority": {
                return this.setPriority(context, args);
            }
            case "getInfo": {
                return this.getInfo(context, args);
            }
        }
        throw new NoSuchMethodException();
    }

    @Override
    public void writeNBT(NBTTagCompound nbt) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74773_a("power", this.power.toByteArray());
        data.func_74757_a("muffled", this.muffled);
        nbt.func_74782_a("persistent", (NBTBase)data);
    }

    @Override
    public void readNBT(NBTTagCompound nbt) {
        NBTTagCompound data = nbt.func_74775_l("persistent");
        this.power = new BigInteger(data.func_74770_j("power"));
        this.muffled = data.func_74767_n("muffled");
    }
}

