/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.storage;

import api.hbm.energymk2.IBatteryItem;
import api.hbm.energymk2.IEnergyConductorMK2;
import api.hbm.energymk2.IEnergyProviderMK2;
import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.energymk2.Nodespace;
import api.hbm.energymk2.PowerNetMK2;
import api.hbm.redstoneoverradio.IRORInteractive;
import api.hbm.redstoneoverradio.IRORValueProvider;
import api.hbm.tile.IInfoProviderEC;
import com.hbm.blocks.machine.MachineBattery;
import com.hbm.handler.CompatHandler;
import com.hbm.inventory.container.ContainerMachineBattery;
import com.hbm.inventory.gui.GUIMachineBattery;
import com.hbm.lib.Library;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.IPersistentNBT;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.uninos.UniNodespace;
import com.hbm.util.EnumUtil;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="opencomputers")})
public class TileEntityMachineBattery
extends TileEntityMachineBase
implements IEnergyConductorMK2,
IEnergyProviderMK2,
IEnergyReceiverMK2,
IPersistentNBT,
SimpleComponent,
IGUIProvider,
IInfoProviderEC,
CompatHandler.OCComponent,
IRORValueProvider,
IRORInteractive {
    public long[] log = new long[20];
    public long delta = 0L;
    public long power = 0L;
    public long prevPowerState = 0L;
    protected Nodespace.PowerNode node;
    public static final int mode_input = 0;
    public static final int mode_buffer = 1;
    public static final int mode_output = 2;
    public static final int mode_none = 3;
    public short redLow = 0;
    public short redHigh = (short)2;
    public IEnergyReceiverMK2.ConnectionPriority priority = IEnergyReceiverMK2.ConnectionPriority.LOW;
    public byte lastRedstone = 0;
    private static final int[] slots_top = new int[]{0};
    private static final int[] slots_bottom = new int[]{0, 1};
    private static final int[] slots_side = new int[]{1};
    private String customName;
    private short modeCache = 0;
    private long bufferedMax;

    public TileEntityMachineBattery() {
        super(2);
        this.slots = new ItemStack[2];
    }

    @Override
    public String getName() {
        return "container.battery";
    }

    @Override
    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : this.getName();
    }

    @Override
    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    @Override
    public void setCustomName(String name) {
        this.customName = name;
        this.func_70296_d();
    }

    @Override
    public boolean func_94041_b(int i, ItemStack stack) {
        switch (i) {
            case 0: 
            case 1: {
                if (!(stack.func_77973_b() instanceof IBatteryItem)) break;
                return true;
            }
        }
        return true;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.redLow = nbt.func_74765_d("redLow");
        this.redHigh = nbt.func_74765_d("redHigh");
        this.lastRedstone = nbt.func_74771_c("lastRedstone");
        this.priority = IEnergyReceiverMK2.ConnectionPriority.values()[nbt.func_74771_c("priority")];
        this.customName = nbt.func_74779_i("name");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        nbt.func_74777_a("redLow", this.redLow);
        nbt.func_74777_a("redHigh", this.redHigh);
        nbt.func_74774_a("lastRedstone", this.lastRedstone);
        nbt.func_74774_a("priority", (byte)this.priority.ordinal());
        if (this.customName != null) {
            nbt.func_74778_a("name", this.customName);
        }
    }

    @Override
    public int[] func_94128_d(int p_94128_1_) {
        return p_94128_1_ == 0 ? slots_bottom : (p_94128_1_ == 1 ? slots_top : slots_side);
    }

    @Override
    public boolean func_102007_a(int i, ItemStack itemStack, int j) {
        return this.func_94041_b(i, itemStack);
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        if (itemStack.func_77973_b() instanceof IBatteryItem) {
            if (i == 0 && ((IBatteryItem)itemStack.func_77973_b()).getCharge(itemStack) == 0L) {
                return true;
            }
            if (i == 1 && ((IBatteryItem)itemStack.func_77973_b()).getCharge(itemStack) == ((IBatteryItem)itemStack.func_77973_b()).getMaxCharge(itemStack)) {
                return true;
            }
        }
        return false;
    }

    public long getPowerRemainingScaled(long i) {
        return this.power * i / this.getMaxPower();
    }

    public byte getComparatorPower() {
        if (this.power == 0L) {
            return 0;
        }
        double frac = (double)this.power / (double)this.getMaxPower() * 15.0;
        return (byte)MathHelper.func_76125_a((int)((int)frac + 1), (int)0, (int)15);
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e) instanceof MachineBattery) {
            byte comp;
            if (this.priority == null || this.priority.ordinal() == 0 || this.priority.ordinal() == 4) {
                this.priority = IEnergyReceiverMK2.ConnectionPriority.LOW;
            }
            short mode = this.getRelevantMode(false);
            long prevPower = this.power;
            this.power = Library.chargeItemsFromTE(this.slots, 1, this.power, this.getMaxPower());
            if (mode == 1) {
                if (this.node == null || this.node.expired) {
                    this.node = (Nodespace.PowerNode)UniNodespace.getNode(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, Nodespace.THE_POWER_PROVIDER);
                    if (this.node == null || this.node.expired) {
                        this.node = this.createNode();
                        UniNodespace.createNode(this.field_145850_b, this.node);
                    }
                }
                this.tryProvide(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, ForgeDirection.UNKNOWN);
                if (this.node != null && this.node.hasValidNet()) {
                    ((PowerNetMK2)this.node.net).addReceiver(this);
                }
            } else {
                if (this.node != null) {
                    UniNodespace.destroyNode(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, Nodespace.THE_POWER_PROVIDER);
                    this.node = null;
                }
                for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                    Nodespace.PowerNode dirNode = (Nodespace.PowerNode)UniNodespace.getNode(this.field_145850_b, this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ, Nodespace.THE_POWER_PROVIDER);
                    if (mode == 2) {
                        this.tryProvide(this.field_145850_b, this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ, dir);
                    } else if (dirNode != null && dirNode.hasValidNet()) {
                        ((PowerNetMK2)dirNode.net).removeProvider(this);
                    }
                    if (mode == 0) {
                        if (dirNode == null || !dirNode.hasValidNet()) continue;
                        ((PowerNetMK2)dirNode.net).addReceiver(this);
                        continue;
                    }
                    if (dirNode == null || !dirNode.hasValidNet()) continue;
                    ((PowerNetMK2)dirNode.net).removeReceiver(this);
                }
            }
            if ((comp = this.getComparatorPower()) != this.lastRedstone) {
                this.func_70296_d();
            }
            this.lastRedstone = comp;
            this.power = Library.chargeTEFromItems(this.slots, 0, this.power, this.getMaxPower());
            long avg = (this.power + prevPower) / 2L;
            this.delta = avg - this.log[0];
            for (int i = 1; i < this.log.length; ++i) {
                this.log[i - 1] = this.log[i];
            }
            this.log[19] = avg;
            this.prevPowerState = this.power;
            this.networkPackNT(20);
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K && this.node != null) {
            UniNodespace.destroyNode(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, Nodespace.THE_POWER_PROVIDER);
        }
    }

    @Override
    public long getProviderSpeed() {
        short mode = this.getRelevantMode(true);
        return mode == 2 || mode == 1 ? this.getMaxPower() / 600L : 0L;
    }

    @Override
    public long getReceiverSpeed() {
        short mode = this.getRelevantMode(true);
        return mode == 0 || mode == 1 ? this.getMaxPower() / 200L : 0L;
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeLong(this.power);
        buf.writeLong(this.delta);
        buf.writeShort((int)this.redLow);
        buf.writeShort((int)this.redHigh);
        buf.writeByte(this.priority.ordinal());
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.power = buf.readLong();
        this.delta = buf.readLong();
        this.redLow = buf.readShort();
        this.redHigh = buf.readShort();
        this.priority = IEnergyReceiverMK2.ConnectionPriority.values()[buf.readByte()];
    }

    @Override
    public long getPower() {
        return this.power;
    }

    public short getRelevantMode(boolean useCache) {
        if (useCache) {
            return this.modeCache;
        }
        this.modeCache = this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e) ? this.redHigh : this.redLow;
        return this.modeCache;
    }

    @Override
    public long getMaxPower() {
        if (this.bufferedMax == 0L) {
            this.bufferedMax = ((MachineBattery)this.field_145850_b.func_147439_a((int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e)).maxPower;
        }
        return this.bufferedMax;
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        return true;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public IEnergyReceiverMK2.ConnectionPriority getPriority() {
        return this.priority;
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return "ntm_energy_storage_legacy";
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getEnergyInfo(Context context, Arguments args) {
        return new Object[]{this.getPower(), this.getMaxPower()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getInfo(Context context, Arguments args) {
        return new Object[]{this.getPower(), this.getMaxPower()};
    }

    @Override
    public void writeNBT(NBTTagCompound nbt) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74772_a("power", this.power);
        data.func_74772_a("prevPowerState", this.prevPowerState);
        data.func_74777_a("redLow", this.redLow);
        data.func_74777_a("redHigh", this.redHigh);
        data.func_74768_a("priority", this.priority.ordinal());
        nbt.func_74782_a("persistent", (NBTBase)data);
    }

    @Override
    public void readNBT(NBTTagCompound nbt) {
        NBTTagCompound data = nbt.func_74775_l("persistent");
        this.power = data.func_74763_f("power");
        this.prevPowerState = data.func_74763_f("prevPowerState");
        this.redLow = data.func_74765_d("redLow");
        this.redHigh = data.func_74765_d("redHigh");
        this.priority = IEnergyReceiverMK2.ConnectionPriority.values()[data.func_74762_e("priority")];
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerMachineBattery(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineBattery(player.field_71071_by, this);
    }

    @Override
    public void provideExtraInfo(NBTTagCompound data) {
        data.func_74772_a("diff", (this.log[0] - this.log[19]) / 20L);
    }

    @Override
    public String[] getFunctionInfo() {
        return new String[]{"VAL:fill", "VAL:fillpercent", "VAL:delta", "FUN:setmode!mode", "FUN:setmode!mode:fallback", "FUN:setredmode!mode", "FUN:setredmode!mode:fallback", "FUN:setpriority!priority"};
    }

    @Override
    public String provideRORValue(String name) {
        if ("VAL:fill".equals(name)) {
            return "" + this.power;
        }
        if ("VAL:fillpercent".equals(name)) {
            return "" + this.getPowerRemainingScaled(100L);
        }
        if ("VAL:delta".equals(name)) {
            return "" + this.delta;
        }
        return null;
    }

    @Override
    public String runRORFunction(String name, String[] params) {
        if ("FUN:setmode".equals(name) && params.length > 0) {
            int mode = IRORInteractive.parseInt(params[0], 0, 3);
            if (mode != this.redLow) {
                this.redLow = (short)mode;
                this.markChanged();
                return null;
            }
            if (params.length > 1) {
                int altmode = IRORInteractive.parseInt(params[1], 0, 3);
                this.redLow = (short)altmode;
                this.markChanged();
                return null;
            }
            return null;
        }
        if ("FUN:setredmode".equals(name) && params.length > 0) {
            int mode = IRORInteractive.parseInt(params[0], 0, 3);
            if (mode != this.redHigh) {
                this.redHigh = (short)mode;
                this.markChanged();
                return null;
            }
            if (params.length > 1) {
                int altmode = IRORInteractive.parseInt(params[1], 0, 3);
                this.redHigh = (short)altmode;
                this.markChanged();
                return null;
            }
            return null;
        }
        if ("FUN:setpriority".equals(name) && params.length > 0) {
            IEnergyReceiverMK2.ConnectionPriority p;
            int priority = IRORInteractive.parseInt(params[0], 0, 2) + 1;
            this.priority = p = (IEnergyReceiverMK2.ConnectionPriority)((Object)EnumUtil.grabEnumSafely(IEnergyReceiverMK2.ConnectionPriority.class, priority));
            this.markChanged();
            return null;
        }
        return null;
    }
}

