/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.world.gen.nbt;

import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.generic.BlockWand;
import com.hbm.blocks.generic.BlockWandTandem;
import com.hbm.config.GeneralConfig;
import com.hbm.config.StructureConfig;
import com.hbm.handler.ThreeInts;
import com.hbm.interfaces.Untested;
import com.hbm.main.MainRegistry;
import com.hbm.util.Tuple;
import com.hbm.util.fauxpointtwelve.BlockPos;
import com.hbm.world.gen.nbt.INBTBlockTransformable;
import com.hbm.world.gen.nbt.INBTTileEntityTransformable;
import com.hbm.world.gen.nbt.JigsawPiece;
import com.hbm.world.gen.nbt.JigsawPool;
import com.hbm.world.gen.nbt.SpawnCondition;
import com.hbm.world.gen.nbt.selector.BiomeBlockSelector;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockRotatedPillar;
import net.minecraft.block.BlockSign;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.BlockTripWireHook;
import net.minecraft.block.BlockVine;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.io.IOUtils;

public class NBTStructure {
    private static Map<String, SpawnCondition> namedMap = new HashMap<String, SpawnCondition>();
    protected static Map<Integer, List<SpawnCondition>> spawnMap = new HashMap<Integer, List<SpawnCondition>>();
    protected static Map<Integer, List<SpawnCondition>> customSpawnMap = new HashMap<Integer, List<SpawnCondition>>();
    private static Map<Integer, Map<Integer, WeightedSpawnList>> validBiomeCache = new HashMap<Integer, Map<Integer, WeightedSpawnList>>();
    private String name;
    private boolean isLoaded;
    protected ThreeInts size;
    private List<Tuple.Pair<Short, String>> itemPalette;
    private BlockState[][][] blockArray;
    private List<List<JigsawConnection>> fromConnections;
    private Map<String, List<JigsawConnection>> toTopConnections;
    private Map<String, List<JigsawConnection>> toBottomConnections;
    private Map<String, List<JigsawConnection>> toHorizontalConnections;
    @Untested
    private static Map<String, String> substitutions = new HashMap(){
        {
            this.put("hbm:tile.ore_coal_oil", "coal_ore");
        }
    };

    public NBTStructure(ResourceLocation resource) {
        InputStream stream = NBTStructure.class.getResourceAsStream("/assets/" + resource.func_110624_b() + "/" + resource.func_110623_a());
        if (stream != null) {
            this.name = resource.func_110623_a();
            this.loadStructure(stream);
        } else {
            MainRegistry.logger.error("NBT Structure not found: " + resource.func_110623_a());
        }
    }

    public NBTStructure(String name, InputStream stream) {
        this.name = name;
        this.loadStructure(stream);
    }

    public NBTStructure(File file) throws FileNotFoundException {
        this.name = file.getName();
        FileInputStream stream = new FileInputStream(file);
        this.loadStructure(stream);
        IOUtils.closeQuietly((InputStream)stream);
    }

    public String getName() {
        return this.name.substring(0, this.name.length() - 4);
    }

    public int getSizeX() {
        return this.size.x;
    }

    public int getSizeY() {
        return this.size.y;
    }

    public int getSizeZ() {
        return this.size.z;
    }

    public static void register() {
        MapGenStructureIO.func_143034_b(Start.class, (String)"NBTStructures");
        MapGenStructureIO.func_143031_a(Component.class, (String)"NBTComponents");
    }

    public static void registerStructure(int dimensionId, SpawnCondition spawn) {
        if (namedMap.containsKey(spawn.name) && namedMap.get(spawn.name) != spawn) {
            throw new IllegalStateException("A severe error has occurred in NBTStructure! A SpawnCondition has been registered with the same name as another: " + spawn.name);
        }
        namedMap.put(spawn.name, spawn);
        if (spawn.checkCoordinates != null) {
            List spawnList = customSpawnMap.computeIfAbsent(dimensionId, integer -> new ArrayList());
            spawnList.add(spawn);
            return;
        }
        List spawnList = spawnMap.computeIfAbsent(dimensionId, integer -> new ArrayList());
        spawnList.add(spawn);
    }

    public static void registerStructure(SpawnCondition spawn, int[] dimensionIds) {
        for (int dimensionId : dimensionIds) {
            NBTStructure.registerStructure(dimensionId, spawn);
        }
    }

    public static void registerNullWeight(int dimensionId, int weight) {
        NBTStructure.registerNullWeight(dimensionId, weight, null);
    }

    public static void registerNullWeight(int dimensionId, int weight, Predicate<BiomeGenBase> predicate) {
        SpawnCondition spawn = new SpawnCondition(weight, predicate);
        List spawnList = spawnMap.computeIfAbsent(dimensionId, integer -> new ArrayList());
        spawnList.add(spawn);
    }

    public static List<String> listStructures() {
        ArrayList<String> names = new ArrayList<String>(namedMap.keySet());
        names.sort((a, b) -> a.compareTo((String)b));
        return names;
    }

    public static SpawnCondition getStructure(String name) {
        return namedMap.get(name);
    }

    public static NBTTagCompound saveArea(World world, int x1, int y1, int z1, int x2, int y2, int z2, Set<Tuple.Pair<Block, Integer>> exclude) {
        NBTTagCompound structure = new NBTTagCompound();
        NBTTagList nbtBlocks = new NBTTagList();
        NBTTagList nbtPalette = new NBTTagList();
        NBTTagList nbtItemPalette = new NBTTagList();
        HashMap<Tuple.Pair<Block, Integer>, Integer> palette = new HashMap<Tuple.Pair<Block, Integer>, Integer>();
        HashMap<Short, Integer> itemPalette = new HashMap<Short, Integer>();
        structure.func_74768_a("version", 1);
        int ox = Math.min(x1, x2);
        int oy = Math.min(y1, y2);
        int oz = Math.min(z1, z2);
        for (int x = ox; x <= Math.max(x1, x2); ++x) {
            for (int y = oy; y <= Math.max(y1, y2); ++y) {
                for (int z = oz; z <= Math.max(z1, z2); ++z) {
                    NBTTagCompound nbtBlock;
                    Tuple.Pair<Block, Integer> block = new Tuple.Pair<Block, Integer>(world.func_147439_a(x, y, z), world.func_72805_g(x, y, z));
                    if (exclude.contains(block)) continue;
                    if (block.key instanceof BlockWand) {
                        block.key = ((BlockWand)((Object)block.key)).exportAs;
                    }
                    int paletteId = palette.size();
                    if (palette.containsKey(block)) {
                        paletteId = (Integer)palette.get(block);
                    } else {
                        palette.put(block, paletteId);
                        nbtBlock = new NBTTagCompound();
                        nbtBlock.func_74778_a("Name", GameRegistry.findUniqueIdentifierFor((Block)((Block)block.key)).toString());
                        NBTTagCompound nbtProp = new NBTTagCompound();
                        nbtProp.func_74778_a("meta", ((Integer)block.value).toString());
                        nbtBlock.func_74782_a("Properties", (NBTBase)nbtProp);
                        nbtPalette.func_74742_a((NBTBase)nbtBlock);
                    }
                    nbtBlock = new NBTTagCompound();
                    nbtBlock.func_74768_a("state", paletteId);
                    NBTTagList nbtPos = new NBTTagList();
                    nbtPos.func_74742_a((NBTBase)new NBTTagInt(x - ox));
                    nbtPos.func_74742_a((NBTBase)new NBTTagInt(y - oy));
                    nbtPos.func_74742_a((NBTBase)new NBTTagInt(z - oz));
                    nbtBlock.func_74782_a("pos", (NBTBase)nbtPos);
                    TileEntity te = world.func_147438_o(x, y, z);
                    if (te != null) {
                        NBTTagCompound nbt = new NBTTagCompound();
                        te.func_145841_b(nbt);
                        nbt.func_82580_o("x");
                        nbt.func_82580_o("y");
                        nbt.func_82580_o("z");
                        nbtBlock.func_74782_a("nbt", (NBTBase)nbt);
                        String itemKey = null;
                        if (nbt.func_74764_b("items")) {
                            itemKey = "items";
                        }
                        if (nbt.func_74764_b("Items")) {
                            itemKey = "Items";
                        }
                        if (nbt.func_74764_b(itemKey)) {
                            NBTTagList items = nbt.func_150295_c(itemKey, 10);
                            for (int i = 0; i < items.func_74745_c(); ++i) {
                                NBTTagCompound item = items.func_150305_b(i);
                                short id = item.func_74765_d("id");
                                String name = GameRegistry.findUniqueIdentifierFor((Item)Item.func_150899_d((int)id)).toString();
                                if (itemPalette.containsKey(id)) continue;
                                int itemPaletteId = itemPalette.size();
                                itemPalette.put(id, itemPaletteId);
                                NBTTagCompound nbtItem = new NBTTagCompound();
                                nbtItem.func_74777_a("ID", id);
                                nbtItem.func_74778_a("Name", name);
                                nbtItemPalette.func_74742_a((NBTBase)nbtItem);
                            }
                        }
                    }
                    nbtBlocks.func_74742_a((NBTBase)nbtBlock);
                }
            }
        }
        structure.func_74782_a("blocks", (NBTBase)nbtBlocks);
        structure.func_74782_a("palette", (NBTBase)nbtPalette);
        structure.func_74782_a("itemPalette", (NBTBase)nbtItemPalette);
        NBTTagList nbtSize = new NBTTagList();
        nbtSize.func_74742_a((NBTBase)new NBTTagInt(Math.abs(x1 - x2) + 1));
        nbtSize.func_74742_a((NBTBase)new NBTTagInt(Math.abs(y1 - y2) + 1));
        nbtSize.func_74742_a((NBTBase)new NBTTagInt(Math.abs(z1 - z2) + 1));
        structure.func_74782_a("size", (NBTBase)nbtSize);
        structure.func_74782_a("entities", (NBTBase)new NBTTagList());
        return structure;
    }

    public static File quickSaveArea(String filename, World world, int x1, int y1, int z1, int x2, int y2, int z2, Set<Tuple.Pair<Block, Integer>> exclude) {
        NBTTagCompound structure = NBTStructure.saveArea(world, x1, y1, z1, x2, y2, z2, exclude);
        try {
            File structureDirectory = new File(Minecraft.func_71410_x().field_71412_D, "structures");
            structureDirectory.mkdir();
            File structureFile = new File(structureDirectory, filename);
            CompressedStreamTools.func_74799_a((NBTTagCompound)structure, (OutputStream)new FileOutputStream(structureFile));
            return structureFile;
        }
        catch (Exception ex) {
            MainRegistry.logger.warn("Failed to save NBT structure", (Throwable)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadStructure(InputStream inputStream) {
        try {
            NBTTagCompound data = CompressedStreamTools.func_74796_a((InputStream)inputStream);
            this.size = this.parsePos(data.func_150295_c("size", 3));
            NBTTagList paletteList = data.func_150295_c("palette", 10);
            BlockDefinition[] palette = new BlockDefinition[paletteList.func_74745_c()];
            for (int i = 0; i < paletteList.func_74745_c(); ++i) {
                NBTTagCompound p = paletteList.func_150305_b(i);
                String blockName = p.func_74779_i("Name");
                NBTTagCompound prop = p.func_74775_l("Properties");
                if (substitutions.containsKey(blockName)) {
                    blockName = substitutions.get(blockName);
                }
                int meta = 0;
                try {
                    meta = Integer.parseInt(prop.func_74779_i("meta"));
                }
                catch (NumberFormatException ex) {
                    MainRegistry.logger.info("Failed to parse: " + prop.func_74779_i("meta"));
                    meta = 0;
                }
                palette[i] = new BlockDefinition(blockName, meta);
                if (!StructureConfig.debugStructures || palette[i].block != Blocks.field_150350_a) continue;
                palette[i] = new BlockDefinition(ModBlocks.wand_air, meta);
            }
            if (data.func_74764_b("itemPalette")) {
                NBTTagList itemPaletteList = data.func_150295_c("itemPalette", 10);
                this.itemPalette = new ArrayList<Tuple.Pair<Short, String>>(itemPaletteList.func_74745_c());
                for (int i = 0; i < itemPaletteList.func_74745_c(); ++i) {
                    NBTTagCompound p = itemPaletteList.func_150305_b(i);
                    short id = p.func_74765_d("ID");
                    String name2 = p.func_74779_i("Name");
                    this.itemPalette.add(new Tuple.Pair<Short, String>(id, name2));
                }
            } else {
                this.itemPalette = null;
            }
            NBTTagList blockData = data.func_150295_c("blocks", 10);
            this.blockArray = new BlockState[this.size.x][this.size.y][this.size.z];
            ArrayList<JigsawConnection> connections = new ArrayList<JigsawConnection>();
            for (int i = 0; i < blockData.func_74745_c(); ++i) {
                NBTTagCompound block = blockData.func_150305_b(i);
                int state = block.func_74762_e("state");
                ThreeInts pos = this.parsePos(block.func_150295_c("pos", 3));
                BlockState blockState = new BlockState(palette[state]);
                if (block.func_74764_b("nbt")) {
                    NBTTagCompound nbt;
                    blockState.nbt = nbt = block.func_74775_l("nbt");
                    if (blockState.definition.block == ModBlocks.wand_jigsaw) {
                        if (this.toTopConnections == null) {
                            this.toTopConnections = new HashMap<String, List<JigsawConnection>>();
                        }
                        if (this.toBottomConnections == null) {
                            this.toBottomConnections = new HashMap<String, List<JigsawConnection>>();
                        }
                        if (this.toHorizontalConnections == null) {
                            this.toHorizontalConnections = new HashMap<String, List<JigsawConnection>>();
                        }
                        int selectionPriority = nbt.func_74762_e("selection");
                        int placementPriority = nbt.func_74762_e("placement");
                        ForgeDirection direction = ForgeDirection.getOrientation((int)nbt.func_74762_e("direction"));
                        String poolName = nbt.func_74779_i("pool");
                        String ourName = nbt.func_74779_i("name");
                        String targetName = nbt.func_74779_i("target");
                        String replaceBlock = nbt.func_74779_i("block");
                        int replaceMeta = nbt.func_74762_e("meta");
                        boolean isRollable = nbt.func_74767_n("roll");
                        JigsawConnection connection = new JigsawConnection(pos, direction, poolName, targetName, isRollable, selectionPriority, placementPriority);
                        connections.add(connection);
                        Map<String, List<JigsawConnection>> toConnections = null;
                        toConnections = direction == ForgeDirection.UP ? this.toTopConnections : (direction == ForgeDirection.DOWN ? this.toBottomConnections : this.toHorizontalConnections);
                        List namedConnections = toConnections.computeIfAbsent(ourName, name -> new ArrayList());
                        namedConnections.add(connection);
                        if (!StructureConfig.debugStructures) {
                            blockState = new BlockState(new BlockDefinition(replaceBlock, replaceMeta));
                        }
                    }
                }
                this.blockArray[pos.x][pos.y][pos.z] = blockState;
            }
            if (connections.size() > 0) {
                this.fromConnections = new ArrayList<List<JigsawConnection>>();
                connections.sort((a, b) -> ((JigsawConnection)b).selectionPriority - ((JigsawConnection)a).selectionPriority);
                ArrayList<JigsawConnection> innerList = null;
                int currentPriority = 0;
                for (JigsawConnection connection : connections) {
                    if (innerList == null || currentPriority != connection.selectionPriority) {
                        innerList = new ArrayList<JigsawConnection>();
                        this.fromConnections.add(innerList);
                        currentPriority = connection.selectionPriority;
                    }
                    innerList.add(connection);
                }
            }
            this.isLoaded = true;
        }
        catch (Exception e) {
            MainRegistry.logger.error("Exception reading NBT Structure format", (Throwable)e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private HashMap<Short, Short> getWorldItemPalette() {
        if (this.itemPalette == null) {
            return null;
        }
        HashMap<Short, Short> worldItemPalette = new HashMap<Short, Short>();
        for (Tuple.Pair<Short, String> entry : this.itemPalette) {
            Item item = (Item)Item.field_150901_e.func_82594_a(entry.getValue());
            worldItemPalette.put(entry.getKey(), (short)Item.func_150891_b((Item)item));
        }
        return worldItemPalette;
    }

    private TileEntity buildTileEntity(World world, Block block, HashMap<Short, Short> worldItemPalette, NBTTagCompound nbt, int coordBaseMode, String structureName) {
        TileEntity te;
        nbt = (NBTTagCompound)nbt.func_74737_b();
        if (worldItemPalette != null) {
            this.relinkItems(worldItemPalette, nbt);
        }
        if ((te = TileEntity.func_145827_c((NBTTagCompound)nbt)) instanceof INBTTileEntityTransformable) {
            ((INBTTileEntityTransformable)te).transformTE(world, coordBaseMode);
        }
        if (te instanceof BlockWandTandem.TileEntityWandTandem) {
            ((BlockWandTandem.TileEntityWandTandem)te).arm(NBTStructure.getStructure(structureName));
        }
        return te;
    }

    public void build(World world, int x, int y, int z) {
        this.build(world, x, y, z, 0, true, false);
    }

    public void build(World world, int x, int y, int z, int coordBaseMode) {
        this.build(world, x, y, z, coordBaseMode, true, false);
    }

    public void build(World world, int x, int y, int z, int coordBaseMode, boolean center, boolean wipeExisting) {
        if (!this.isLoaded) {
            MainRegistry.logger.info("NBTStructure is invalid");
            return;
        }
        HashMap<Short, Short> worldItemPalette = this.getWorldItemPalette();
        if (center) {
            boolean swizzle = coordBaseMode == 1 || coordBaseMode == 3;
            x -= (swizzle ? this.size.z : this.size.x) / 2;
            z -= (swizzle ? this.size.x : this.size.z) / 2;
        }
        int maxX = this.size.x;
        int maxZ = this.size.z;
        for (int bx = 0; bx < maxX; ++bx) {
            for (int bz = 0; bz < maxZ; ++bz) {
                int rx = this.rotateX(bx, bz, coordBaseMode) + x;
                int rz = this.rotateZ(bx, bz, coordBaseMode) + z;
                for (int by = 0; by < this.size.y; ++by) {
                    BlockState state = this.blockArray[bx][by][bz];
                    if (state == null) {
                        if (!wipeExisting) continue;
                        world.func_147465_d(rx, by + y, rz, Blocks.field_150350_a, 0, 2);
                        continue;
                    }
                    int ry = by + y;
                    Block block = this.transformBlock(state.definition, null, world.field_73012_v);
                    int meta = this.transformMeta(state.definition, null, coordBaseMode);
                    if (ry < 1) continue;
                    world.func_147465_d(rx, ry, rz, block, meta, 2);
                    if (state.nbt == null) continue;
                    TileEntity te = this.buildTileEntity(world, block, worldItemPalette, state.nbt, coordBaseMode, null);
                    world.func_147455_a(rx, ry, rz, te);
                }
            }
        }
    }

    public void build(World world, JigsawPiece piece, int x, int y, int z, int coordBaseMode, String structureName) {
        StructureBoundingBox bb;
        switch (coordBaseMode) {
            case 1: 
            case 3: {
                bb = new StructureBoundingBox(x, y, z, x + piece.structure.size.z - 1, y + piece.structure.size.y - 1, z + piece.structure.size.x - 1);
                break;
            }
            default: {
                bb = new StructureBoundingBox(x, y, z, x + piece.structure.size.x - 1, y + piece.structure.size.y - 1, z + piece.structure.size.z - 1);
            }
        }
        this.build(world, piece, bb, bb, coordBaseMode, structureName);
    }

    protected boolean build(World world, JigsawPiece piece, StructureBoundingBox totalBounds, StructureBoundingBox generatingBounds, int coordBaseMode, String structureName) {
        if (!this.isLoaded) {
            MainRegistry.logger.info("NBTStructure is invalid");
            return false;
        }
        HashMap<Short, Short> worldItemPalette = this.getWorldItemPalette();
        int sizeX = totalBounds.field_78893_d - totalBounds.field_78897_a;
        int sizeZ = totalBounds.field_78892_f - totalBounds.field_78896_c;
        int absMinX = Math.max(generatingBounds.field_78897_a - totalBounds.field_78897_a, 0);
        int absMaxX = Math.min(generatingBounds.field_78893_d - totalBounds.field_78897_a, sizeX);
        int absMinZ = Math.max(generatingBounds.field_78896_c - totalBounds.field_78896_c, 0);
        int absMaxZ = Math.min(generatingBounds.field_78892_f - totalBounds.field_78896_c, sizeZ);
        if (absMinX > sizeX || absMaxX < 0 || absMinZ > sizeZ || absMaxZ < 0) {
            return true;
        }
        int rotMinX = this.unrotateX(absMinX, absMinZ, coordBaseMode);
        int rotMaxX = this.unrotateX(absMaxX, absMaxZ, coordBaseMode);
        int rotMinZ = this.unrotateZ(absMinX, absMinZ, coordBaseMode);
        int rotMaxZ = this.unrotateZ(absMaxX, absMaxZ, coordBaseMode);
        int minX = Math.min(rotMinX, rotMaxX);
        int maxX = Math.max(rotMinX, rotMaxX);
        int minZ = Math.min(rotMinZ, rotMaxZ);
        int maxZ = Math.max(rotMinZ, rotMaxZ);
        if (piece.blockTable != null || piece.platform != null) {
            BiomeGenBase biome = world.func_72959_q().func_76935_a(generatingBounds.func_78881_e(), generatingBounds.func_78891_g());
            if (piece.blockTable != null) {
                for (StructureComponent.BlockSelector selector : piece.blockTable.values()) {
                    if (!(selector instanceof BiomeBlockSelector)) continue;
                    ((BiomeBlockSelector)selector).nextBiome = biome;
                }
            }
            if (piece.platform instanceof BiomeBlockSelector) {
                ((BiomeBlockSelector)piece.platform).nextBiome = biome;
            }
        }
        for (int bx = minX; bx <= maxX; ++bx) {
            for (int bz = minZ; bz <= maxZ; ++bz) {
                int rx = this.rotateX(bx, bz, coordBaseMode) + totalBounds.field_78897_a;
                int rz = this.rotateZ(bx, bz, coordBaseMode) + totalBounds.field_78896_c;
                int oy = piece.conformToTerrain ? world.func_72825_h(rx, rz) + piece.heightOffset : totalBounds.field_78895_b;
                boolean hasBase = false;
                for (int by = 0; by < this.size.y; ++by) {
                    BlockState state = this.blockArray[bx][by][bz];
                    if (state == null) continue;
                    int ry = by + oy;
                    Block block = this.transformBlock(state.definition, piece.blockTable, world.field_73012_v);
                    int meta = this.transformMeta(state.definition, piece.blockTable, coordBaseMode);
                    if (ry < 1) continue;
                    world.func_147465_d(rx, ry, rz, block, meta, 2);
                    if (state.nbt != null) {
                        TileEntity te = this.buildTileEntity(world, block, worldItemPalette, state.nbt, coordBaseMode, structureName);
                        world.func_147455_a(rx, ry, rz, te);
                    }
                    if (by != 0 || piece.platform == null || block.func_149688_o().func_76222_j()) continue;
                    hasBase = true;
                }
                if (!hasBase || piece.conformToTerrain) continue;
                for (int y = oy - 1; y > 0 && world.func_147439_a(rx, y, rz).isReplaceable((IBlockAccess)world, rx, y, rz); --y) {
                    piece.platform.func_75062_a(world.field_73012_v, 0, 0, 0, false);
                    world.func_147465_d(rx, y, rz, piece.platform.func_151561_a(), piece.platform.func_75064_b(), 2);
                }
            }
        }
        return true;
    }

    public List<JigsawConnection> getConnectionPool(ForgeDirection dir, String target) {
        if (dir == ForgeDirection.DOWN) {
            return this.toTopConnections.get(target);
        }
        if (dir == ForgeDirection.UP) {
            return this.toBottomConnections.get(target);
        }
        return this.toHorizontalConnections.get(target);
    }

    private ThreeInts parsePos(NBTTagList pos) {
        NBTBase xb = (NBTBase)pos.field_74747_a.get(0);
        int x = ((NBTTagInt)xb).func_150287_d();
        NBTBase yb = (NBTBase)pos.field_74747_a.get(1);
        int y = ((NBTTagInt)yb).func_150287_d();
        NBTBase zb = (NBTBase)pos.field_74747_a.get(2);
        int z = ((NBTTagInt)zb).func_150287_d();
        return new ThreeInts(x, y, z);
    }

    private void relinkItems(HashMap<Short, Short> palette, NBTTagCompound nbt) {
        NBTTagList items = null;
        if (nbt.func_74764_b("items")) {
            items = nbt.func_150295_c("items", 10);
        }
        if (nbt.func_74764_b("Items")) {
            items = nbt.func_150295_c("Items", 10);
        }
        if (items == null) {
            return;
        }
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound item = items.func_150305_b(i);
            item.func_74777_a("id", palette.getOrDefault(item.func_74765_d("id"), (short)0).shortValue());
        }
    }

    private Block transformBlock(BlockDefinition definition, Map<Block, StructureComponent.BlockSelector> blockTable, Random rand) {
        if (blockTable != null && blockTable.containsKey(definition.block)) {
            StructureComponent.BlockSelector selector = blockTable.get(definition.block);
            selector.func_75062_a(rand, 0, 0, 0, false);
            return selector.func_151561_a();
        }
        if (definition.block instanceof INBTBlockTransformable) {
            return ((INBTBlockTransformable)definition.block).transformBlock(definition.block);
        }
        return definition.block;
    }

    private int transformMeta(BlockDefinition definition, Map<Block, StructureComponent.BlockSelector> blockTable, int coordBaseMode) {
        if (blockTable != null && blockTable.containsKey(definition.block)) {
            return blockTable.get(definition.block).func_75064_b();
        }
        if (definition.block instanceof INBTBlockTransformable) {
            return ((INBTBlockTransformable)definition.block).transformMeta(definition.meta, coordBaseMode);
        }
        if (coordBaseMode == 0) {
            return definition.meta;
        }
        if (definition.block instanceof BlockStairs) {
            return INBTBlockTransformable.transformMetaStairs(definition.meta, coordBaseMode);
        }
        if (definition.block instanceof BlockRotatedPillar) {
            return INBTBlockTransformable.transformMetaPillar(definition.meta, coordBaseMode);
        }
        if (definition.block instanceof BlockDirectional) {
            return INBTBlockTransformable.transformMetaDirectional(definition.meta, coordBaseMode);
        }
        if (definition.block instanceof BlockTorch) {
            return INBTBlockTransformable.transformMetaTorch(definition.meta, coordBaseMode);
        }
        if (definition.block instanceof BlockButton) {
            return INBTBlockTransformable.transformMetaTorch(definition.meta, coordBaseMode);
        }
        if (definition.block instanceof BlockDoor) {
            return INBTBlockTransformable.transformMetaDoor(definition.meta, coordBaseMode);
        }
        if (definition.block instanceof BlockLever) {
            return INBTBlockTransformable.transformMetaLever(definition.meta, coordBaseMode);
        }
        if (definition.block instanceof BlockSign) {
            return INBTBlockTransformable.transformMetaDeco(definition.meta, coordBaseMode);
        }
        if (definition.block instanceof BlockLadder) {
            return INBTBlockTransformable.transformMetaDeco(definition.meta, coordBaseMode);
        }
        if (definition.block instanceof BlockTripWireHook) {
            return INBTBlockTransformable.transformMetaDirectional(definition.meta, coordBaseMode);
        }
        if (definition.block instanceof BlockVine) {
            return INBTBlockTransformable.transformMetaVine(definition.meta, coordBaseMode);
        }
        if (definition.block instanceof BlockTrapDoor) {
            return INBTBlockTransformable.transformMetaTrapdoor(definition.meta, coordBaseMode);
        }
        return definition.meta;
    }

    public int rotateX(int x, int z, int coordBaseMode) {
        switch (coordBaseMode) {
            case 1: {
                return this.size.z - 1 - z;
            }
            case 2: {
                return this.size.x - 1 - x;
            }
            case 3: {
                return z;
            }
        }
        return x;
    }

    public int rotateZ(int x, int z, int coordBaseMode) {
        switch (coordBaseMode) {
            case 1: {
                return x;
            }
            case 2: {
                return this.size.z - 1 - z;
            }
            case 3: {
                return this.size.x - 1 - x;
            }
        }
        return z;
    }

    private int unrotateX(int x, int z, int coordBaseMode) {
        switch (coordBaseMode) {
            case 3: {
                return this.size.x - 1 - z;
            }
            case 2: {
                return this.size.x - 1 - x;
            }
            case 1: {
                return z;
            }
        }
        return x;
    }

    private int unrotateZ(int x, int z, int coordBaseMode) {
        switch (coordBaseMode) {
            case 3: {
                return x;
            }
            case 2: {
                return this.size.z - 1 - z;
            }
            case 1: {
                return this.size.z - 1 - x;
            }
        }
        return z;
    }

    private static class WeightedSpawnList
    extends ArrayList<SpawnCondition> {
        public int totalWeight = 0;

        private WeightedSpawnList() {
        }
    }

    public static class GenStructure
    extends MapGenStructure {
        private SpawnCondition nextSpawn;

        public void generateStructures(World world, Random rand, IChunkProvider chunkProvider, int chunkX, int chunkZ) {
            this.func_151539_a(chunkProvider, world, chunkX, chunkZ, null);
            this.func_75051_a(world, rand, chunkX, chunkZ);
        }

        public String func_143025_a() {
            return "NBTStructures";
        }

        protected boolean func_75047_a(int chunkX, int chunkZ) {
            this.nextSpawn = this.getSpawnAtCoords(chunkX, chunkZ);
            return this.nextSpawn != null;
        }

        public SpawnCondition getStructureAt(World world, int chunkX, int chunkZ) {
            this.field_75039_c = world;
            this.field_75038_b.setSeed(world.func_72905_C());
            long l = this.field_75038_b.nextLong();
            long i1 = this.field_75038_b.nextLong();
            long l1 = (long)chunkX * l;
            long i2 = (long)chunkZ * i1;
            this.field_75038_b.setSeed(l1 ^ i2 ^ world.func_72905_C());
            this.field_75038_b.nextInt();
            return this.getSpawnAtCoords(chunkX, chunkZ);
        }

        private SpawnCondition getSpawnAtCoords(int chunkX, int chunkZ) {
            BiomeGenBase biome;
            SpawnCondition spawn2;
            if (customSpawnMap.containsKey(this.field_75039_c.field_73011_w.field_76574_g)) {
                SpawnCondition.WorldCoordinate coords = new SpawnCondition.WorldCoordinate(this.field_75039_c, new ChunkCoordIntPair(chunkX, chunkZ), this.field_75038_b);
                List<SpawnCondition> spawnList = customSpawnMap.get(this.field_75039_c.field_73011_w.field_76574_g);
                for (SpawnCondition spawn2 : spawnList) {
                    if (spawn2.pools == null && spawn2.structure == null || !spawn2.checkCoordinates.test(coords)) continue;
                    return spawn2;
                }
            }
            if (!spawnMap.containsKey(this.field_75039_c.field_73011_w.field_76574_g)) {
                return null;
            }
            int x = chunkX;
            int z = chunkZ;
            if (x < 0) {
                x -= StructureConfig.structureMaxChunks - 1;
            }
            if (z < 0) {
                z -= StructureConfig.structureMaxChunks - 1;
            }
            this.field_75038_b.setSeed((long)(x /= StructureConfig.structureMaxChunks) * 341873128712L + (long)(z /= StructureConfig.structureMaxChunks) * 132897987541L + this.field_75039_c.func_72912_H().func_76063_b() + 996996996L - (long)this.field_75039_c.field_73011_w.field_76574_g);
            x *= StructureConfig.structureMaxChunks;
            z *= StructureConfig.structureMaxChunks;
            if (chunkX == (x += this.field_75038_b.nextInt(StructureConfig.structureMaxChunks - StructureConfig.structureMinChunks)) && chunkZ == (z += this.field_75038_b.nextInt(StructureConfig.structureMaxChunks - StructureConfig.structureMinChunks)) && (spawn2 = this.findSpawn(biome = this.field_75039_c.func_72959_q().func_76935_a(chunkX * 16 + 8, chunkZ * 16 + 8))) != null && (spawn2.pools != null || spawn2.start != null || spawn2.structure != null)) {
                return spawn2;
            }
            return null;
        }

        protected StructureStart func_75049_b(int chunkX, int chunkZ) {
            if (this.nextSpawn.start != null) {
                return this.nextSpawn.start.apply(new Tuple.Quartet<World, Random, Integer, Integer>(this.field_75039_c, this.field_75038_b, chunkX, chunkZ));
            }
            return new Start(this.field_75039_c, this.field_75038_b, this.nextSpawn, chunkX, chunkZ);
        }

        private SpawnCondition findSpawn(BiomeGenBase biome) {
            WeightedSpawnList filteredList;
            Map dimensionCache = validBiomeCache.computeIfAbsent(this.field_75039_c.field_73011_w.field_76574_g, integer -> new HashMap());
            if (!dimensionCache.containsKey(biome.field_76756_M)) {
                List<SpawnCondition> spawnList = spawnMap.get(this.field_75039_c.field_73011_w.field_76574_g);
                filteredList = new WeightedSpawnList();
                for (SpawnCondition spawn : spawnList) {
                    if (!spawn.isValid(biome)) continue;
                    filteredList.add(spawn);
                    filteredList.totalWeight += spawn.spawnWeight;
                }
                dimensionCache.put(biome.field_76756_M, filteredList);
            } else {
                filteredList = (WeightedSpawnList)dimensionCache.get(biome.field_76756_M);
            }
            if (filteredList.totalWeight == 0) {
                return null;
            }
            int weight = this.field_75038_b.nextInt(filteredList.totalWeight);
            for (SpawnCondition spawn : filteredList) {
                if ((weight -= spawn.spawnWeight) >= 0) continue;
                return spawn;
            }
            return null;
        }
    }

    public static class Start
    extends StructureStart {
        public String name;

        public Start() {
        }

        public Start(World world, Random rand, SpawnCondition spawn, int chunkX, int chunkZ) {
            super(chunkX, chunkZ);
            this.name = spawn.name;
            int x = chunkX << 4;
            int z = chunkZ << 4;
            JigsawPiece startPiece = spawn.structure != null ? spawn.structure : spawn.pools.get(spawn.startPool).get(rand);
            Component startComponent = new Component(spawn, startPiece, rand, x, z);
            startComponent.parent = this;
            this.field_75075_a.add(startComponent);
            ArrayList<Component> queuedComponents = new ArrayList<Component>();
            if (spawn.structure == null) {
                queuedComponents.add(startComponent);
            }
            Set<JigsawPiece> requiredPieces = this.findRequiredPieces(spawn);
            while (!queuedComponents.isEmpty()) {
                int max;
                queuedComponents.sort((a, b) -> b.priority - a.priority);
                int matchPriority = ((Component)((Object)queuedComponents.get((int)0))).priority;
                for (max = 1; max < queuedComponents.size() && ((Component)((Object)queuedComponents.get((int)max))).priority == matchPriority; ++max) {
                }
                int i = rand.nextInt(max);
                Component fromComponent = (Component)((Object)queuedComponents.remove(i));
                if (fromComponent.piece.structure.fromConnections == null) continue;
                int distance = this.getDistanceTo(fromComponent.func_74874_b());
                boolean fallbacksOnly = requiredPieces.size() == 0 && (this.field_75075_a.size() >= spawn.sizeLimit || distance >= spawn.rangeLimit) || this.field_75075_a.size() > 1024;
                for (List unshuffledList : fromComponent.piece.structure.fromConnections) {
                    ArrayList connectionList = new ArrayList(unshuffledList);
                    Collections.shuffle(connectionList, rand);
                    for (JigsawConnection fromConnection : connectionList) {
                        BlockPos checkPos;
                        if (fromComponent.connectedFrom == fromConnection) continue;
                        if (fallbacksOnly) {
                            String fallback = spawn.pools.get((Object)((JigsawConnection)fromConnection).poolName).fallback;
                            if (fallback == null) continue;
                            Component fallbackComponent = this.buildNextComponent(rand, spawn, spawn.pools.get(fallback), fromComponent, fromConnection);
                            this.addComponent(fallbackComponent, fromConnection.placementPriority);
                            continue;
                        }
                        JigsawPool nextPool = spawn.getPool(fromConnection.poolName);
                        if (nextPool == null) {
                            MainRegistry.logger.warn("[Jigsaw] Jigsaw block points to invalid pool: " + fromConnection.poolName);
                            continue;
                        }
                        Component nextComponent = null;
                        while (nextPool.totalWeight > 0 && ((nextComponent = this.buildNextComponent(rand, spawn, nextPool, fromComponent, fromConnection)) == null || fromComponent.hasIntersectionIgnoringSelf(this.field_75075_a, nextComponent.func_74874_b()))) {
                            nextComponent = null;
                        }
                        if (nextComponent != null) {
                            this.addComponent(nextComponent, fromConnection.placementPriority);
                            queuedComponents.add(nextComponent);
                            requiredPieces.remove(nextComponent.piece);
                            continue;
                        }
                        if (nextPool.fallback == null || fromComponent.isInsideIgnoringSelf(this.field_75075_a, (checkPos = this.getConnectionTargetPosition(fromComponent, fromConnection)).getX(), checkPos.getY(), checkPos.getZ())) continue;
                        nextComponent = this.buildNextComponent(rand, spawn, spawn.pools.get(nextPool.fallback), fromComponent, fromConnection);
                        this.addComponent(nextComponent, fromConnection.placementPriority);
                    }
                }
            }
            if (GeneralConfig.enableDebugMode) {
                MainRegistry.logger.info("[Debug] Spawning NBT structure " + this.name + " with " + this.field_75075_a.size() + " piece(s) at: " + chunkX * 16 + ", " + chunkZ * 16);
                String componentList = "[Debug] Components: ";
                for (Object component : this.field_75075_a) {
                    componentList = componentList + ((Component)((Object)component)).piece.structure.name + " ";
                }
                MainRegistry.logger.info(componentList);
            }
            this.func_75072_c();
        }

        private void addComponent(Component component, int placementPriority) {
            if (component == null) {
                return;
            }
            this.field_75075_a.add(component);
            component.parent = this;
            component.priority = placementPriority;
        }

        private BlockPos getConnectionTargetPosition(Component component, JigsawConnection connection) {
            ForgeDirection extendDir = component.rotateDir(connection.dir);
            int x = component.func_74865_a(connection.pos.x, connection.pos.z) + extendDir.offsetX;
            int y = component.func_74862_a(connection.pos.y) + extendDir.offsetY;
            int z = component.func_74873_b(connection.pos.x, connection.pos.z) + extendDir.offsetZ;
            return new BlockPos(x, y, z);
        }

        private Set<JigsawPiece> findRequiredPieces(SpawnCondition spawn) {
            HashSet<JigsawPiece> requiredPieces = new HashSet<JigsawPiece>();
            if (spawn.pools == null) {
                return requiredPieces;
            }
            for (JigsawPool pool : spawn.pools.values()) {
                for (Tuple.Pair<JigsawPiece, Integer> weight : pool.pieces) {
                    if (!weight.getKey().required) continue;
                    requiredPieces.add(weight.getKey());
                }
            }
            return requiredPieces;
        }

        private Component buildNextComponent(Random rand, SpawnCondition spawn, JigsawPool pool, Component fromComponent, JigsawConnection fromConnection) {
            List<JigsawConnection> connectionPool;
            JigsawPiece nextPiece = pool.get(rand);
            if (nextPiece == null) {
                MainRegistry.logger.warn("[Jigsaw] Pool returned null piece: " + fromConnection.poolName);
                return null;
            }
            if (nextPiece.instanceLimit > 0) {
                int instances = 0;
                for (Object component : this.field_75075_a) {
                    if (!(component instanceof Component) || ((Component)((Object)component)).piece != nextPiece || ++instances < nextPiece.instanceLimit) continue;
                    return null;
                }
            }
            if ((connectionPool = nextPiece.structure.getConnectionPool(fromConnection.dir, fromConnection.targetName)) == null || connectionPool.isEmpty()) {
                MainRegistry.logger.warn("[Jigsaw] No valid connections for: " + fromConnection.targetName + " - in piece: " + nextPiece.name);
                return null;
            }
            JigsawConnection toConnection = connectionPool.get(rand.nextInt(connectionPool.size()));
            int nextCoordBase = fromComponent.getNextCoordBase(fromConnection, toConnection, rand);
            BlockPos pos = this.getConnectionTargetPosition(fromComponent, fromConnection);
            int ox = nextPiece.structure.rotateX(toConnection.pos.x, toConnection.pos.z, nextCoordBase);
            int oy = toConnection.pos.y;
            int oz = nextPiece.structure.rotateZ(toConnection.pos.x, toConnection.pos.z, nextCoordBase);
            return new Component(spawn, nextPiece, rand, pos.getX() - ox, pos.getY() - oy, pos.getZ() - oz, nextCoordBase).connectedFrom(toConnection);
        }

        private int getDistanceTo(StructureBoundingBox box) {
            int x = box.func_78881_e();
            int z = box.func_78891_g();
            return Math.max(Math.abs(x - (this.func_143019_e() << 4)), Math.abs(z - (this.func_143018_f() << 4)));
        }

        public void func_143017_b(NBTTagCompound nbt) {
            this.name = nbt.func_74779_i("name");
            for (Object o : this.field_75075_a) {
                ((Component)((Object)o)).parent = this;
            }
        }

        public void func_143022_a(NBTTagCompound nbt) {
            nbt.func_74778_a("name", this.name);
        }

        public void offsetYHeight(int y) {
            for (Object o : this.field_75075_a) {
                Component component = (Component)((Object)o);
                if (component.heightUpdated || component.piece.conformToTerrain || component.piece.alignToTerrain) continue;
                component.offsetYHeight(y);
            }
        }
    }

    public static class Component
    extends StructureComponent {
        JigsawPiece piece;
        int minHeight = 1;
        int maxHeight = 128;
        boolean heightUpdated = false;
        int priority;
        private Start parent;
        private JigsawConnection connectedFrom;

        public Component() {
        }

        public Component(SpawnCondition spawn, JigsawPiece piece, Random rand, int x, int z) {
            this(spawn, piece, rand, x, 0, z, rand.nextInt(4));
        }

        public Component(SpawnCondition spawn, JigsawPiece piece, Random rand, int x, int y, int z, int coordBaseMode) {
            super(0);
            this.field_74885_f = coordBaseMode;
            this.piece = piece;
            this.minHeight = spawn.minHeight;
            this.maxHeight = spawn.maxHeight;
            switch (this.field_74885_f) {
                case 1: 
                case 3: {
                    this.field_74887_e = new StructureBoundingBox(x, y, z, x + piece.structure.size.z - 1, y + piece.structure.size.y - 1, z + piece.structure.size.x - 1);
                    break;
                }
                default: {
                    this.field_74887_e = new StructureBoundingBox(x, y, z, x + piece.structure.size.x - 1, y + piece.structure.size.y - 1, z + piece.structure.size.z - 1);
                }
            }
        }

        public Component connectedFrom(JigsawConnection connection) {
            this.connectedFrom = connection;
            return this;
        }

        protected void func_143012_a(NBTTagCompound nbt) {
            nbt.func_74778_a("piece", this.piece != null ? this.piece.name : "NULL");
            nbt.func_74768_a("min", this.minHeight);
            nbt.func_74768_a("max", this.maxHeight);
            nbt.func_74757_a("hasHeight", this.heightUpdated);
        }

        protected void func_143011_b(NBTTagCompound nbt) {
            this.piece = JigsawPiece.jigsawMap.get(nbt.func_74779_i("piece"));
            this.minHeight = nbt.func_74762_e("min");
            this.maxHeight = nbt.func_74762_e("max");
            this.heightUpdated = nbt.func_74767_n("hasHeight");
        }

        public boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            if (this.piece == null) {
                return false;
            }
            if (!this.piece.conformToTerrain && !this.heightUpdated) {
                int y;
                int averageHeight = this.getAverageHeight(world, box) + this.piece.heightOffset;
                boolean isFlatWorld = world.func_72912_H().func_76067_t() == WorldType.field_77138_c;
                int n = y = isFlatWorld ? averageHeight : MathHelper.func_76125_a((int)averageHeight, (int)this.minHeight, (int)this.maxHeight);
                if (!this.piece.alignToTerrain) {
                    this.parent.offsetYHeight(y);
                } else {
                    this.offsetYHeight(y);
                }
            }
            return this.piece.structure.build(world, this.piece, this.field_74887_e, box, this.field_74885_f, this.parent.name);
        }

        public void offsetYHeight(int y) {
            this.field_74887_e.field_78895_b += y;
            this.field_74887_e.field_78894_e += y;
            this.heightUpdated = true;
        }

        protected int func_74865_a(int x, int z) {
            return this.field_74887_e.field_78897_a + this.piece.structure.rotateX(x, z, this.field_74885_f);
        }

        protected int func_74862_a(int y) {
            return this.field_74887_e.field_78895_b + y;
        }

        protected int func_74873_b(int x, int z) {
            return this.field_74887_e.field_78896_c + this.piece.structure.rotateZ(x, z, this.field_74885_f);
        }

        private ForgeDirection rotateDir(ForgeDirection dir) {
            if (dir == ForgeDirection.UP || dir == ForgeDirection.DOWN) {
                return dir;
            }
            switch (this.field_74885_f) {
                default: {
                    return dir;
                }
                case 1: {
                    return dir.getRotation(ForgeDirection.UP);
                }
                case 2: {
                    return dir.getOpposite();
                }
                case 3: 
            }
            return dir.getRotation(ForgeDirection.DOWN);
        }

        private int getAverageHeight(World world, StructureBoundingBox box) {
            int total = 0;
            int iterations = 0;
            for (int z = box.field_78896_c; z <= box.field_78892_f; ++z) {
                for (int x = box.field_78897_a; x <= box.field_78893_d; ++x) {
                    total += world.func_72825_h(x, z);
                    ++iterations;
                }
            }
            if (iterations == 0) {
                return 64;
            }
            return total / iterations;
        }

        private int getNextCoordBase(JigsawConnection fromConnection, JigsawConnection toConnection, Random rand) {
            if (fromConnection.dir == ForgeDirection.DOWN || fromConnection.dir == ForgeDirection.UP) {
                if (fromConnection.isRollable) {
                    return rand.nextInt(4);
                }
                return this.field_74885_f;
            }
            return this.directionOffsetToCoordBase(fromConnection.dir.getOpposite(), toConnection.dir);
        }

        private int directionOffsetToCoordBase(ForgeDirection from, ForgeDirection to) {
            for (int i = 0; i < 4; ++i) {
                if (from == to) {
                    return (i + this.field_74885_f) % 4;
                }
                from = from.getRotation(ForgeDirection.DOWN);
            }
            return this.field_74885_f;
        }

        protected boolean hasIntersectionIgnoringSelf(LinkedList<StructureComponent> components, StructureBoundingBox box) {
            for (StructureComponent component : components) {
                if (component == this || component.func_74874_b() == null || !component.func_74874_b().func_78884_a(box)) continue;
                return true;
            }
            return false;
        }

        protected boolean isInsideIgnoringSelf(LinkedList<StructureComponent> components, int x, int y, int z) {
            for (StructureComponent component : components) {
                if (component == this || component.func_74874_b() == null || !component.func_74874_b().func_78890_b(x, y, z)) continue;
                return true;
            }
            return false;
        }
    }

    public static class JigsawConnection {
        public final ThreeInts pos;
        public final ForgeDirection dir;
        private final String poolName;
        private final String targetName;
        private final boolean isRollable;
        private final int selectionPriority;
        private final int placementPriority;

        private JigsawConnection(ThreeInts pos, ForgeDirection dir, String poolName, String targetName, boolean isRollable, int selectionPriority, int placementPriority) {
            this.pos = pos;
            this.dir = dir;
            this.poolName = poolName;
            this.targetName = targetName;
            this.isRollable = isRollable;
            this.selectionPriority = selectionPriority;
            this.placementPriority = placementPriority;
        }
    }

    private static class BlockDefinition {
        final Block block;
        final int meta;

        BlockDefinition(String name, int meta) {
            Block block = Block.func_149684_b((String)name);
            if (block == null) {
                block = Blocks.field_150350_a;
            }
            this.block = block;
            this.meta = meta;
        }

        BlockDefinition(Block block, int meta) {
            this.block = block;
            this.meta = meta;
        }
    }

    private static class BlockState {
        final BlockDefinition definition;
        NBTTagCompound nbt;

        BlockState(BlockDefinition definition) {
            this.definition = definition;
        }
    }
}

