/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.network;

import com.hbm.blocks.BlockDummyable;
import com.hbm.blocks.ILookOverlay;
import com.hbm.blocks.ITooltipProvider;
import com.hbm.tileentity.TileEntityProxyCombo;
import com.hbm.tileentity.machine.storage.TileEntityBatterySocket;
import com.hbm.util.BobMathUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.util.ForgeDirection;

public class MachineBatterySocket
extends BlockDummyable
implements ITooltipProvider,
ILookOverlay {
    public MachineBatterySocket() {
        super(Material.field_151573_f);
    }

    public TileEntity func_149915_a(World world, int meta) {
        if (meta >= 12) {
            return new TileEntityBatterySocket();
        }
        if (meta >= 6) {
            return new TileEntityProxyCombo().inventory().power().conductor();
        }
        return null;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        return this.standardOpenBehavior(world, x, y, z, player, side);
    }

    @Override
    public int[] getDimensions() {
        return new int[]{1, 0, 1, 0, 1, 0};
    }

    @Override
    public int getOffset() {
        return 0;
    }

    @Override
    protected void fillSpace(World world, int x, int y, int z, ForgeDirection dir, int o) {
        super.fillSpace(world, x, y, z, dir, o);
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        this.makeExtra(world, x - dir.offsetX, y, z - dir.offsetZ);
        this.makeExtra(world, x + rot.offsetX, y, z + rot.offsetZ);
        this.makeExtra(world, x - dir.offsetX + rot.offsetX, y, z - dir.offsetZ + rot.offsetZ);
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean ext) {
        this.addStandardInfo(stack, player, list, ext);
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int side) {
        if (world.func_72805_g(x, y, z) < 6) {
            return 0;
        }
        int[] pos = this.findCore(world, x, y, z);
        if (pos == null) {
            return 0;
        }
        TileEntity te = world.func_147438_o(pos[0], pos[1], pos[2]);
        if (!(te instanceof TileEntityBatterySocket)) {
            return 0;
        }
        TileEntityBatterySocket battery = (TileEntityBatterySocket)te;
        return battery.getComparatorPower();
    }

    @Override
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        int[] pos = this.findCore(world, x, y, z);
        if (pos == null) {
            return;
        }
        TileEntity te = world.func_147438_o(pos[0], pos[1], pos[2]);
        if (!(te instanceof TileEntityBatterySocket)) {
            return;
        }
        TileEntityBatterySocket socket = (TileEntityBatterySocket)te;
        if (socket.syncStack == null) {
            return;
        }
        ArrayList<String> text = new ArrayList<String>();
        text.add(BobMathUtil.getShortNumber(TileEntityBatterySocket.powerFromStack(socket.syncStack)) + " / " + BobMathUtil.getShortNumber(TileEntityBatterySocket.maxPowerFromStack(socket.syncStack)) + "HE");
        double percent = (double)TileEntityBatterySocket.powerFromStack(socket.syncStack) / (double)TileEntityBatterySocket.maxPowerFromStack(socket.syncStack);
        int charge = (int)Math.floor(percent * 10000.0);
        int color = (int)(255.0 - 255.0 * percent) << 16 | (int)(255.0 * percent) << 8;
        text.add("&[" + color + "&]" + (double)charge / 100.0 + "%");
        ILookOverlay.printGeneric(event, socket.syncStack.func_82833_r(), 0xFFFF00, 0x404000, text);
    }
}

