/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.dim;

import com.hbm.entity.missile.EntityRideableRocket;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayDeque;
import java.util.Queue;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.util.MathHelper;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class CelestialTeleporter
extends Teleporter {
    private final WorldServer sourceServer;
    private final WorldServer targetServer;
    private double x;
    private double y;
    private double z;
    private boolean grounded;
    private Entity entity;
    private static Queue<CelestialTeleporter> queue = new ArrayDeque<CelestialTeleporter>();

    public CelestialTeleporter(WorldServer sourceServer, WorldServer targetServer, Entity entity, double x, double y, double z, boolean grounded) {
        super(targetServer);
        this.sourceServer = sourceServer;
        this.targetServer = targetServer;
        this.entity = entity;
        this.x = x;
        this.y = y;
        this.z = z;
        this.grounded = grounded;
    }

    public void func_77185_a(Entity entity, double ox, double oy, double oz, float yaw) {
        int ix = (int)this.x;
        int iy = (int)this.y;
        int iz = (int)this.z;
        if (this.grounded) {
            for (int i = this.targetServer.func_72800_K(); i > 0; --i) {
                if (this.targetServer.func_147439_a(ix, i, iz) == Blocks.field_150350_a) continue;
                this.y = i + 5;
                break;
            }
        } else {
            this.targetServer.func_147439_a(ix, MathHelper.func_76125_a((int)iy, (int)1, (int)255), iz);
        }
        entity.func_70107_b(this.x, this.y, this.z);
    }

    private void runTeleport() {
        MinecraftServer mcServer = MinecraftServer.func_71276_C();
        ServerConfigurationManager manager = mcServer.func_71203_ab();
        if (this.entity.field_70153_n instanceof EntityPlayerMP) {
            this.entity = this.entity.field_70153_n;
        }
        int fromDimension = this.entity.field_71093_bK;
        this.entity.field_70165_t = this.x;
        this.entity.field_70161_v = this.z;
        if (this.entity instanceof EntityPlayerMP) {
            EntityPlayerMP playerMP = (EntityPlayerMP)this.entity;
            Entity ridingEntity = this.entity.field_70154_o;
            manager.transferPlayerToDimension(playerMP, this.targetServer.field_73011_w.field_76574_g, (Teleporter)this);
            if (ridingEntity != null && !ridingEntity.field_70128_L) {
                ridingEntity.field_71093_bK = fromDimension;
                ridingEntity.field_70170_p.func_72900_e(ridingEntity);
                ridingEntity.field_70128_L = false;
                manager.transferEntityToWorld(ridingEntity, fromDimension, this.sourceServer, this.targetServer, (Teleporter)this);
                Entity newEntity = EntityList.func_75620_a((String)EntityList.func_75621_b((Entity)ridingEntity), (World)this.targetServer);
                if (newEntity != null) {
                    newEntity.func_82141_a(ridingEntity, true);
                    newEntity.field_70165_t = this.x;
                    newEntity.field_70161_v = this.z;
                    this.targetServer.func_72838_d(newEntity);
                    newEntity.field_71093_bK = this.targetServer.field_73011_w.field_76574_g;
                }
                ridingEntity.field_70128_L = true;
                this.sourceServer.func_82742_i();
                this.targetServer.func_82742_i();
                playerMP.func_70078_a(newEntity);
                if (newEntity instanceof EntityRideableRocket) {
                    ((EntityRideableRocket)newEntity).setThrower((EntityLivingBase)playerMP);
                }
                playerMP.func_70634_a(this.x, 900.0, this.z);
            }
        } else {
            this.entity.field_70170_p.func_72900_e(this.entity);
            this.entity.field_70128_L = false;
            manager.transferEntityToWorld(this.entity, fromDimension, this.sourceServer, this.targetServer, (Teleporter)this);
            Entity newEntity = EntityList.func_75620_a((String)EntityList.func_75621_b((Entity)this.entity), (World)this.targetServer);
            if (newEntity != null) {
                newEntity.func_82141_a(this.entity, true);
                newEntity.field_70165_t = this.x;
                newEntity.field_70161_v = this.z;
                this.targetServer.func_72838_d(newEntity);
                newEntity.field_71093_bK = this.targetServer.field_73011_w.field_76574_g;
            }
            this.entity.field_70128_L = true;
            this.sourceServer.func_82742_i();
            this.targetServer.func_82742_i();
        }
    }

    public static void runQueuedTeleport() {
        CelestialTeleporter teleporter = queue.poll();
        if (teleporter != null) {
            teleporter.runTeleport();
        }
    }

    public static void teleport(Entity entity, int dim, double x, double y, double z, boolean grounded) {
        if (entity.field_71093_bK == dim) {
            return;
        }
        MinecraftServer mcServer = MinecraftServer.func_71276_C();
        Side sidex = FMLCommonHandler.instance().getEffectiveSide();
        if (sidex == Side.SERVER) {
            WorldServer sourceServer = mcServer.func_71218_a(entity.field_71093_bK);
            WorldServer targetServer = mcServer.func_71218_a(dim);
            queue.add(new CelestialTeleporter(sourceServer, targetServer, entity, x, y, z, grounded));
        }
    }
}

