/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.dim.noise;

import com.hbm.dim.noise.PerlinNoiseSampler;
import com.hbm.util.BobMathUtil;
import com.hbm.util.Tuple;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.LongFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class OctavePerlinNoiseSampler {
    private final PerlinNoiseSampler[] octaveSamplers;
    private final List<Double> amplitudes;
    private final double persistence;
    private final double lacunarity;

    public OctavePerlinNoiseSampler(Random random, IntStream octaves) {
        this(random, octaves.boxed().collect(Collectors.toList()));
    }

    public OctavePerlinNoiseSampler(Random random, List<Integer> octaves) {
        this(random, new TreeSet<Integer>(octaves));
    }

    public static OctavePerlinNoiseSampler create(Random Random2, int i, double ... octaves) {
        ArrayList<Double> list = new ArrayList<Double>();
        for (double octave : octaves) {
            list.add(octave);
        }
        return OctavePerlinNoiseSampler.create(Random2, i, list);
    }

    public static OctavePerlinNoiseSampler create(Random random, int offset, List<Double> amplitudes) {
        return new OctavePerlinNoiseSampler(random, new Tuple.Pair<Integer, List<Double>>(offset, amplitudes));
    }

    private static Tuple.Pair<Integer, List<Double>> calculateAmplitudes(SortedSet<Integer> octaves) {
        int j;
        if (octaves.isEmpty()) {
            throw new IllegalArgumentException("Need some octaves!");
        }
        int i = -octaves.first().intValue();
        int k = i + (j = octaves.last().intValue()) + 1;
        if (k < 1) {
            throw new IllegalArgumentException("Total number of octaves needs to be >= 1");
        }
        ArrayList<Double> doubleList = new ArrayList<Double>();
        Iterator intBidirectionalIterator = octaves.iterator();
        while (intBidirectionalIterator.hasNext()) {
            int l = (Integer)intBidirectionalIterator.next();
            doubleList.set(l + i, 1.0);
        }
        return new Tuple.Pair<Integer, List<Double>>(-i, doubleList);
    }

    private OctavePerlinNoiseSampler(Random random, SortedSet<Integer> octaves) {
        this(random, octaves, Random::new);
    }

    private OctavePerlinNoiseSampler(Random random, SortedSet<Integer> octaves, LongFunction<Random> randomFunction) {
        this(random, OctavePerlinNoiseSampler.calculateAmplitudes(octaves), randomFunction);
    }

    protected OctavePerlinNoiseSampler(Random random, Tuple.Pair<Integer, List<Double>> offsetAndAmplitudes) {
        this(random, offsetAndAmplitudes, Random::new);
    }

    protected OctavePerlinNoiseSampler(Random random, Tuple.Pair<Integer, List<Double>> octaves, LongFunction<Random> randomFunction) {
        double d;
        int i = octaves.getKey();
        this.amplitudes = octaves.getValue();
        PerlinNoiseSampler perlinNoiseSampler = new PerlinNoiseSampler(random);
        int j = this.amplitudes.size();
        int k = -i;
        this.octaveSamplers = new PerlinNoiseSampler[j];
        if (k >= 0 && k < j && (d = this.amplitudes.get(k).doubleValue()) != 0.0) {
            this.octaveSamplers[k] = perlinNoiseSampler;
        }
        for (int l = k - 1; l >= 0; --l) {
            if (l < j) {
                double e = this.amplitudes.get(l);
                if (e != 0.0) {
                    this.octaveSamplers[l] = new PerlinNoiseSampler(random);
                    continue;
                }
                OctavePerlinNoiseSampler.skipCalls(random);
                continue;
            }
            OctavePerlinNoiseSampler.skipCalls(random);
        }
        if (k < j - 1) {
            throw new IllegalArgumentException("Positive octaves are temporarily disabled");
        }
        this.lacunarity = Math.pow(2.0, -k);
        this.persistence = Math.pow(2.0, j - 1) / (Math.pow(2.0, j) - 1.0);
    }

    private static void skipCalls(Random random) {
    }

    public double sample(double x, double y, double z) {
        return this.sample(x, y, z, 0.0, 0.0, false);
    }

    @Deprecated
    public double sample(double x, double y, double z, double yScale, double yMax, boolean useOrigin) {
        double d = 0.0;
        double e = this.lacunarity;
        double f = this.persistence;
        for (int i = 0; i < this.octaveSamplers.length; ++i) {
            PerlinNoiseSampler perlinNoiseSampler = this.octaveSamplers[i];
            if (perlinNoiseSampler != null) {
                double g = perlinNoiseSampler.sample(OctavePerlinNoiseSampler.maintainPrecision(x * e), useOrigin ? -perlinNoiseSampler.originY : OctavePerlinNoiseSampler.maintainPrecision(y * e), OctavePerlinNoiseSampler.maintainPrecision(z * e), yScale * e, yMax * e);
                d += this.amplitudes.get(i) * g * f;
            }
            e *= 2.0;
            f /= 2.0;
        }
        return d;
    }

    public PerlinNoiseSampler getOctave(int octave) {
        return this.octaveSamplers[this.octaveSamplers.length - 1 - octave];
    }

    public static double maintainPrecision(double value) {
        return value - (double)BobMathUtil.lfloor(value / 3.3554432E7 + 0.5) * 3.3554432E7;
    }

    public double sample(double x, double y, double yScale, double yMax) {
        return this.sample(x, y, 0.0, yScale, yMax, false);
    }
}

