/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.config.GeneralConfig;
import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.recipes.loader.SerializableRecipe;
import com.hbm.items.ModItems;
import com.hbm.items.machine.IItemFluidIdentifier;
import com.hbm.items.machine.ItemBlueprints;
import com.hbm.items.machine.ItemCircuit;
import com.hbm.items.machine.ItemFluidIcon;
import com.hbm.items.weapon.sedna.factory.GunFactory;
import com.hbm.util.ItemStackUtil;
import com.hbm.util.Tuple;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;

public class AnnihilatorRecipes
extends SerializableRecipe {
    public static HashMap<Object, AnnihilatorRecipe> recipes = new HashMap();

    @Override
    public void registerDefaults() {
        if (GeneralConfig.enable528) {
            recipes.put(OreDictManager.STEEL.ingot(), new AnnihilatorRecipe(new Tuple.Pair<BigInteger, ItemStack>(new BigInteger("256"), ItemBlueprints.make("528.steel"))));
            recipes.put(OreDictManager.SI.billet(), new AnnihilatorRecipe(new Tuple.Pair<BigInteger, ItemStack>(new BigInteger("256"), ItemBlueprints.make("528.chip"))));
            recipes.put(OreDictManager.BI.nugget(), new AnnihilatorRecipe(new Tuple.Pair<BigInteger, ItemStack>(new BigInteger("128"), ItemBlueprints.make("528.chip_bismoid"))));
            recipes.put(ModItems.pellet_charged, new AnnihilatorRecipe(new Tuple.Pair<BigInteger, ItemStack>(new BigInteger("1024"), ItemBlueprints.make("528.chip_quantum"))));
            recipes.put(OreDictManager.U.billet(), new AnnihilatorRecipe(new Tuple.Pair<BigInteger, ItemStack>(new BigInteger("256"), ItemBlueprints.make("528.gascent"))));
            recipes.put(OreDictManager.ANY_PLASTIC.ingot(), new AnnihilatorRecipe(new Tuple.Pair<BigInteger, ItemStack>(new BigInteger("512"), ItemBlueprints.make("528.plastic"))));
            recipes.put(OreDictManager.RUBBER.ingot(), new AnnihilatorRecipe(new Tuple.Pair<BigInteger, ItemStack>(new BigInteger("512"), ItemBlueprints.make("528.rubber"))));
            recipes.put(OreDictManager.FERRO.ingot(), new AnnihilatorRecipe(new Tuple.Pair<BigInteger, ItemStack>(new BigInteger("1024"), ItemBlueprints.make("528.ferrouranium"))));
            recipes.put(OreDictManager.SR.dust(), new AnnihilatorRecipe(new Tuple.Pair<BigInteger, ItemStack>(new BigInteger("256"), ItemBlueprints.make("528.strontium"))));
            recipes.put(OreDictManager.ANY_HARDPLASTIC.ingot(), new AnnihilatorRecipe(new Tuple.Pair<BigInteger, ItemStack>(new BigInteger("1024"), ItemBlueprints.make("528.hardplastic"))));
            recipes.put(OreDictManager.ANY_RESISTANTALLOY.ingot(), new AnnihilatorRecipe(new Tuple.Pair<BigInteger, ItemStack>(new BigInteger("1024"), ItemBlueprints.make("528.tcalloy"))));
            recipes.put(ModItems.powder_chlorophyte, new AnnihilatorRecipe(new Tuple.Pair<BigInteger, ItemStack>(new BigInteger("1024"), ItemBlueprints.make("528.chlorophyte"))));
            recipes.put(new RecipesCommon.ComparableStack(ModItems.ammo_standard, 1, (Enum)GunFactory.EnumAmmo.BMG50_FMJ), new AnnihilatorRecipe(new Tuple.Pair<BigInteger, ItemStack>(new BigInteger("256"), ItemBlueprints.make("528.bmg"))));
            recipes.put(new RecipesCommon.ComparableStack(ModItems.ammo_arty, 1, 0), new AnnihilatorRecipe(new Tuple.Pair<BigInteger, ItemStack>(new BigInteger("128"), ItemBlueprints.make("528.arty"))));
            recipes.put(new RecipesCommon.ComparableStack(ModItems.circuit, 1, (Enum)ItemCircuit.EnumCircuitType.CONTROLLER), new AnnihilatorRecipe(new Tuple.Pair<BigInteger, ItemStack>(new BigInteger("128"), ItemBlueprints.make("528.controller"))));
        }
    }

    @Override
    public String getFileName() {
        return "hbmAnnihilator.json";
    }

    @Override
    public Object getRecipeObject() {
        return recipes;
    }

    @Override
    public void deleteRecipes() {
        recipes.clear();
    }

    public static HashMap getRecipes() {
        HashMap<ItemStack, ItemStack> recipes = new HashMap<ItemStack, ItemStack>();
        for (Map.Entry<Object, AnnihilatorRecipe> entry : AnnihilatorRecipes.recipes.entrySet()) {
            for (Tuple.Pair<BigInteger, ItemStack> milestone : entry.getValue().milestones) {
                ItemStack[][] input = new ItemStack[1];
                if (entry.getKey() instanceof Item) {
                    input = new ItemStack((Item)entry.getKey());
                }
                if (entry.getKey() instanceof RecipesCommon.ComparableStack) {
                    input = ((RecipesCommon.ComparableStack)entry.getKey()).toStack();
                }
                if (entry.getKey() instanceof FluidType) {
                    input = ItemFluidIcon.make((FluidType)entry.getKey(), 0);
                }
                if (entry.getKey() instanceof String) {
                    input = new RecipesCommon.OreDictStack((String)entry.getKey()).extractForNEI();
                }
                if (input == null) continue;
                if (input instanceof ItemStack) {
                    ItemStackUtil.addTooltipToStack((ItemStack)input, EnumChatFormatting.RED + String.format(Locale.US, "%,d", milestone.getKey()));
                }
                if (input instanceof List) {
                    List list = (List)input;
                    for (ItemStack stack : list) {
                        ItemStackUtil.addTooltipToStack(stack, EnumChatFormatting.RED + String.format(Locale.US, "%,d", milestone.getKey()));
                    }
                    input = new ItemStack[][]{list.toArray(new ItemStack[0])};
                }
                recipes.put((ItemStack)input, milestone.getValue().func_77946_l());
            }
        }
        return recipes;
    }

    public static ItemStack getHighestPayoutFromKey(Object key, BigInteger prevAmount, BigInteger currentAmount) {
        ItemStack payout;
        AnnihilatorRecipe recipe = recipes.get(key);
        if (recipe != null && (payout = AnnihilatorRecipes.getHighestPayoutFromRecipe(recipe, prevAmount, currentAmount)) != null) {
            return payout;
        }
        return null;
    }

    public static ItemStack getHighestPayoutFromStack(ItemStack stack, BigInteger prevAmount, BigInteger currentAmount) {
        ItemStack payout;
        AnnihilatorRecipe recipe;
        if (stack.func_77973_b() instanceof IItemFluidIdentifier) {
            IItemFluidIdentifier id = (IItemFluidIdentifier)stack.func_77973_b();
            return AnnihilatorRecipes.getHighestPayoutFromFluid(id.getType(null, 0, 0, 0, stack), prevAmount, currentAmount);
        }
        List<String> dictKeys = ItemStackUtil.getOreDictNames(stack);
        for (String key : dictKeys) {
            ItemStack payout2;
            recipe = recipes.get(key);
            if (recipe == null || (payout2 = AnnihilatorRecipes.getHighestPayoutFromRecipe(recipe, prevAmount, currentAmount)) == null) continue;
            return payout2;
        }
        RecipesCommon.ComparableStack comp = new RecipesCommon.ComparableStack(stack).makeSingular();
        recipe = recipes.get(comp);
        if (recipe != null && (payout = AnnihilatorRecipes.getHighestPayoutFromRecipe(recipe, prevAmount, currentAmount)) != null) {
            return payout;
        }
        recipe = recipes.get(stack.func_77973_b());
        if (recipe != null && (payout = AnnihilatorRecipes.getHighestPayoutFromRecipe(recipe, prevAmount, currentAmount)) != null) {
            return payout;
        }
        return null;
    }

    public static ItemStack getHighestPayoutFromFluid(FluidType fluid, BigInteger prevAmount, BigInteger currentAmount) {
        ItemStack payout;
        AnnihilatorRecipe recipe = recipes.get(fluid);
        if (recipe != null && (payout = AnnihilatorRecipes.getHighestPayoutFromRecipe(recipe, prevAmount, currentAmount)) != null) {
            return payout;
        }
        return null;
    }

    public static ItemStack getHighestPayoutFromRecipe(AnnihilatorRecipe recipe, BigInteger prevAmount, BigInteger currentAmount) {
        BigInteger highestYet = BigInteger.ZERO;
        ItemStack highestPayout = null;
        for (Tuple.Pair<BigInteger, ItemStack> milestone : recipe.milestones) {
            if (prevAmount != null && prevAmount.compareTo(milestone.getKey()) != -1 || currentAmount.compareTo(highestYet) != 1 || currentAmount.compareTo(milestone.getKey()) == -1) continue;
            highestYet = milestone.getKey();
            highestPayout = milestone.getValue();
        }
        return highestPayout != null ? highestPayout.func_77946_l() : null;
    }

    @Override
    public void readRecipe(JsonElement recipe) {
        JsonObject obj = (JsonObject)recipe;
        JsonObject key = obj.get("key").getAsJsonObject();
        Object keyObject = null;
        String keyType = key.get("type").getAsString();
        if ("item".equals(keyType)) {
            keyObject = Item.field_150901_e.func_82594_a(key.get("item").getAsString());
        }
        if ("comp".equals(keyType)) {
            keyObject = new RecipesCommon.ComparableStack((Item)Item.field_150901_e.func_82594_a(key.get("item").getAsString()), 1, key.get("meta").getAsInt());
        }
        if ("fluid".equals(keyType)) {
            keyObject = Fluids.fromName(key.get("fluid").getAsString());
        }
        if ("dict".equals(keyType)) {
            keyObject = key.get("dict").getAsString();
        }
        JsonArray milestones = obj.get("milestones").getAsJsonArray();
        ArrayList<Tuple.Pair<BigInteger, ItemStack>> milestoneList = new ArrayList<Tuple.Pair<BigInteger, ItemStack>>();
        for (JsonElement e : milestones) {
            JsonObject milestone = e.getAsJsonObject();
            milestoneList.add(new Tuple.Pair<BigInteger, ItemStack>(milestone.get("amount").getAsBigInteger(), AnnihilatorRecipes.readItemStack(milestone.get("payout").getAsJsonArray())));
        }
        if (keyObject != null) {
            AnnihilatorRecipe newRecipe = new AnnihilatorRecipe(new Tuple.Pair[0]);
            newRecipe.milestones.addAll(milestoneList);
            recipes.put(keyObject, newRecipe);
        }
    }

    @Override
    public void writeRecipe(Object recipe, JsonWriter writer) throws IOException {
        Map.Entry rec = (Map.Entry)recipe;
        writer.name("key").beginObject();
        if (rec.getKey() instanceof Item) {
            Item item = (Item)rec.getKey();
            writer.name("type").value("item");
            writer.name("item").value(Item.field_150901_e.func_148750_c((Object)item));
        }
        if (rec.getKey() instanceof RecipesCommon.ComparableStack) {
            RecipesCommon.ComparableStack comp = (RecipesCommon.ComparableStack)rec.getKey();
            writer.name("type").value("comp");
            writer.name("item").value(Item.field_150901_e.func_148750_c((Object)comp.item));
            writer.name("meta").value((long)comp.meta);
        }
        if (rec.getKey() instanceof FluidType) {
            FluidType fluid = (FluidType)rec.getKey();
            writer.name("type").value("fluid");
            writer.name("fluid").value(fluid.getUnlocalizedName());
        }
        if (rec.getKey() instanceof String) {
            writer.name("type").value("dict");
            writer.name("dict").value((String)rec.getKey());
        }
        writer.endObject();
        writer.name("milestones").beginArray();
        for (Tuple.Pair<BigInteger, ItemStack> milestone : ((AnnihilatorRecipe)rec.getValue()).milestones) {
            writer.beginObject();
            writer.name("amount").value((Number)milestone.getKey());
            writer.name("payout");
            AnnihilatorRecipes.writeItemStack(milestone.getValue(), writer);
            writer.endObject();
        }
        writer.endArray();
    }

    public static class AnnihilatorRecipe {
        public List<Tuple.Pair<BigInteger, ItemStack>> milestones = new ArrayList<Tuple.Pair<BigInteger, ItemStack>>();

        public AnnihilatorRecipe(Tuple.Pair<BigInteger, ItemStack> ... milestones) {
            for (Tuple.Pair<BigInteger, ItemStack> milestone : milestones) {
                this.milestones.add(milestone);
            }
        }
    }
}

