/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.armor;

import com.hbm.extprop.HbmPlayerProps;
import com.hbm.handler.ArmorModHandler;
import com.hbm.items.ModItems;
import com.hbm.items.armor.ArmorFSB;
import com.hbm.main.ResourceManager;
import com.hbm.render.item.ItemRenderBase;
import com.hbm.render.model.ModelArmorTrenchmaster;
import com.hbm.render.tileentity.IItemRendererProvider;
import com.hbm.util.i18n.I18nUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import org.lwjgl.opengl.GL11;

public class ArmorTrenchmaster
extends ArmorFSB
implements IItemRendererProvider {
    @SideOnly(value=Side.CLIENT)
    ModelArmorTrenchmaster[] models;

    public ArmorTrenchmaster(ItemArmor.ArmorMaterial material, int slot, String texture) {
        super(material, slot, texture);
        this.func_77656_e(0);
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot) {
        if (this.models == null) {
            this.models = new ModelArmorTrenchmaster[4];
            for (int i = 0; i < 4; ++i) {
                this.models[i] = new ModelArmorTrenchmaster(i);
            }
        }
        return this.models[armorSlot];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean ext) {
        super.func_77624_a(stack, player, list, ext);
        list.add(EnumChatFormatting.RED + "  " + I18nUtil.resolveKey("armor.moreAmmo", new Object[0]));
    }

    @Override
    public void handleHurt(LivingHurtEvent event) {
        EntityPlayer player;
        super.handleHurt(event);
        EntityLivingBase e = event.entityLiving;
        if (e instanceof EntityPlayer && ArmorFSB.hasFSBArmor(player = (EntityPlayer)e) && event.source.func_94541_c() && event.source.func_76364_f() == player) {
            event.ammount = 0.0f;
            return;
        }
    }

    @Override
    public void handleAttack(LivingAttackEvent event) {
        EntityPlayer player;
        super.handleAttack(event);
        EntityLivingBase e = event.entityLiving;
        if (e instanceof EntityPlayer && ArmorFSB.hasFSBArmor(player = (EntityPlayer)e) && e.func_70681_au().nextInt(3) == 0) {
            HbmPlayerProps.plink(player, "random.break", 0.5f, 1.0f + e.func_70681_au().nextFloat() * 0.5f);
            event.setCanceled(true);
        }
    }

    public static boolean isTrenchMaster(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        return player.field_71071_by.field_70460_b[2] != null && player.field_71071_by.field_70460_b[2].func_77973_b() == ModItems.trenchmaster_plate && ArmorFSB.hasFSBArmor(player);
    }

    public static boolean hasAoS(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        if (player.field_71071_by.field_70460_b[3] != null) {
            ItemStack[] mods = ArmorModHandler.pryMods(player.field_71071_by.field_70460_b[3]);
            ItemStack helmet = mods[0];
            return helmet != null && helmet.func_77973_b() == ModItems.card_aos;
        }
        return false;
    }

    @Override
    public Item getItemForRenderer() {
        return this;
    }

    @Override
    public IItemRenderer getRenderer() {
        return new ItemRenderBase(){

            @Override
            public void renderInventory() {
                if (ArmorTrenchmaster.this.field_77881_a == 0) {
                    GL11.glTranslated((double)0.0, (double)1.0, (double)0.0);
                }
                if (ArmorTrenchmaster.this.field_77881_a == 1) {
                    GL11.glTranslated((double)0.0, (double)1.5, (double)0.0);
                }
                ArmorFSB.setupRenderInv();
            }

            @Override
            public void renderNonInv() {
                ArmorFSB.setupRenderNonInv();
            }

            @Override
            public void renderCommon() {
                ArmorFSB.renderStandard(ResourceManager.armor_trenchmaster, ArmorTrenchmaster.this.field_77881_a, ResourceManager.trenchmaster_helmet, ResourceManager.trenchmaster_chest, ResourceManager.trenchmaster_arm, ResourceManager.trenchmaster_leg, "Helmet,Light", "Chest", "LeftArm", "RightArm", "LeftLeg", "RightLeg", "LeftBoot", "RightBoot");
            }
        };
    }
}

