/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.armor;

import com.hbm.dim.CelestialBody;
import com.hbm.handler.ArmorModHandler;
import com.hbm.items.armor.ItemArmorMod;
import com.hbm.util.i18n.I18nUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderPlayerEvent;

public class ItemModHeavyBoots
extends ItemArmorMod {
    public ItemModHeavyBoots() {
        super(3, false, false, false, true);
    }

    @Override
    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List list, boolean bool) {
        list.add(EnumChatFormatting.BLUE + "Increases fall speed in low gravity");
        list.add(EnumChatFormatting.BLUE + "Activated by crouching");
        list.add("");
        super.func_77624_a(itemstack, player, list, bool);
        list.add(EnumChatFormatting.GOLD + "Can be worn on its own!");
        list.add(EnumChatFormatting.DARK_GRAY + "" + EnumChatFormatting.ITALIC + "We take no responsibility for any deaths that may");
        list.add(EnumChatFormatting.DARK_GRAY + "" + EnumChatFormatting.ITALIC + "occur while using these boots without a space suit.");
    }

    @Override
    public void addDesc(List list, ItemStack stack, ItemStack armor) {
        list.add(EnumChatFormatting.DARK_PURPLE + "  " + stack.func_82833_r() + " (" + I18nUtil.resolveKey("armor.fastFall", new Object[0]) + ")");
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        if (player.func_70093_af() && !player.field_70122_E && !player.func_70090_H()) {
            float gravity = CelestialBody.getGravity((EntityLivingBase)player);
            if (gravity > 1.5f) {
                return;
            }
            if (gravity == 0.0f) {
                return;
            }
            if (gravity < 0.2f) {
                gravity = 0.2f;
            }
            player.field_70181_x /= (double)0.98f;
            player.field_70181_x += (double)(gravity / 20.0f);
            player.field_70181_x -= (double)0.08f;
            player.field_70181_x *= (double)0.98f;
        }
    }

    @Override
    public void modUpdate(EntityLivingBase entity, ItemStack armor) {
        if (!(entity instanceof EntityPlayer)) {
            return;
        }
        ItemStack boots = ArmorModHandler.pryMods(armor)[3];
        if (boots == null) {
            return;
        }
        this.onArmorTick(entity.field_70170_p, (EntityPlayer)entity, boots);
        ArmorModHandler.applyMod(armor, boots);
    }

    public boolean isValidArmor(ItemStack stack, int armorType, Entity entity) {
        return armorType == 3;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return "hbm:textures/armor/heavy_boots.png";
    }

    @SideOnly(value=Side.CLIENT)
    public void armorRender(RenderPlayerEvent.SetArmorModel event, ItemStack armor) {
        RenderPlayer renderer = event.renderer;
        ModelBiped modelbiped = renderer.field_77111_i;
        modelbiped.field_78116_c.field_78806_j = false;
        modelbiped.field_78114_d.field_78806_j = false;
        modelbiped.field_78115_e.field_78806_j = false;
        modelbiped.field_78112_f.field_78806_j = false;
        modelbiped.field_78113_g.field_78806_j = false;
        modelbiped.field_78123_h.field_78806_j = true;
        modelbiped.field_78124_i.field_78806_j = true;
        modelbiped.field_78095_p = renderer.field_77109_a.field_78095_p;
        modelbiped.field_78093_q = renderer.field_77109_a.field_78093_q;
        modelbiped.field_78091_s = renderer.field_77109_a.field_78091_s;
        EntityPlayer player = event.entityPlayer;
        float interp = event.partialRenderTick;
        float swingRight = player.field_70722_aY + (player.field_70721_aZ - player.field_70722_aY) * interp;
        float swingLeft = player.field_70754_ba - player.field_70721_aZ * (1.0f - interp);
        if (player.func_70631_g_()) {
            swingLeft *= 3.0f;
        }
        if (swingRight > 1.0f) {
            swingRight = 1.0f;
        }
        float yawHead = player.field_70758_at + (player.field_70759_as - player.field_70758_at) * interp;
        float yawOffset = player.field_70760_ar + (player.field_70761_aq - player.field_70760_ar) * interp;
        float yaw = yawHead - yawOffset;
        float yawWrapped = MathHelper.func_76142_g((float)(yawHead - yawOffset));
        float pitch = player.field_70125_A;
        modelbiped.func_78086_a((EntityLivingBase)player, swingLeft, swingRight, interp);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation(this.getArmorTexture(armor, event.entity, 3, null)));
        modelbiped.func_78088_a((Entity)event.entityPlayer, swingLeft, swingRight, yawWrapped, yaw, pitch, 0.0625f);
    }
}

