/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.packet;

import com.hbm.dim.CelestialBody;
import com.hbm.dim.SolarSystemWorldSavedData;
import com.hbm.dim.WorldProviderCelestial;
import com.hbm.dim.orbit.OrbitalStation;
import com.hbm.dim.trait.CBT_War;
import com.hbm.dim.trait.CelestialBodyTrait;
import com.hbm.handler.ImpactWorldHandler;
import com.hbm.handler.pollution.PollutionHandler;
import com.hbm.main.MainRegistry;
import com.hbm.potion.HbmPotion;
import com.hbm.saveddata.SatelliteSavedData;
import com.hbm.saveddata.TomSaveData;
import com.hbm.saveddata.satellites.Satellite;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;

public class PermaSyncHandler {
    public static HashSet<Integer> boykissers = new HashSet();
    public static float[] pollution = new float[PollutionHandler.PollutionType.values().length];

    public static void writePacket(ByteBuf buf, World world, EntityPlayerMP player) {
        TomSaveData data = TomSaveData.forWorld(world);
        buf.writeFloat(data.fire);
        buf.writeFloat(data.dust);
        buf.writeBoolean(data.impact);
        buf.writeLong(data.time);
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (Object o : world.field_73010_i) {
            EntityPlayer p = (EntityPlayer)o;
            if (!p.func_82165_m(HbmPotion.death.field_76415_H)) continue;
            ids.add(p.func_145782_y());
        }
        buf.writeShort((int)((short)ids.size()));
        for (Integer i : ids) {
            buf.writeInt(i.intValue());
        }
        PollutionHandler.PollutionData pollution = PollutionHandler.getPollutionData(world, (int)Math.floor(player.field_70165_t), (int)Math.floor(player.field_70163_u), (int)Math.floor(player.field_70161_v));
        if (pollution == null) {
            pollution = new PollutionHandler.PollutionData();
        }
        for (int i = 0; i < PollutionHandler.PollutionType.values().length; ++i) {
            buf.writeFloat(pollution.pollution[i]);
        }
        if (world.func_82737_E() % 5L == 1L) {
            buf.writeBoolean(true);
            SolarSystemWorldSavedData solarSystemData = SolarSystemWorldSavedData.get(world);
            for (CelestialBody celestialBody : CelestialBody.getAllBodies()) {
                HashMap<Class<? extends CelestialBodyTrait>, CelestialBodyTrait> traits = solarSystemData.getTraits(celestialBody.name);
                if (traits != null) {
                    buf.writeBoolean(true);
                    buf.writeInt(traits.size());
                    for (int i = 0; i < CelestialBodyTrait.traitList.size(); ++i) {
                        Class<? extends CelestialBodyTrait> traitClass = CelestialBodyTrait.traitList.get(i);
                        CelestialBodyTrait trait = traits.get(traitClass);
                        if (trait == null) continue;
                        buf.writeInt(i);
                        trait.writeToBytes(buf);
                    }
                    continue;
                }
                buf.writeBoolean(false);
            }
            List stations = solarSystemData.getStations().values().stream().filter(station -> station.hasStation && station.orbiting.dimensionId == player.field_71093_bK).collect(Collectors.toList());
            buf.writeInt(stations.size());
            Iterator iterator = stations.iterator();
            while (iterator.hasNext()) {
                OrbitalStation station2 = (OrbitalStation)iterator.next();
                buf.writeInt(station2.dX);
                buf.writeInt(station2.dZ);
            }
        } else {
            buf.writeBoolean(false);
        }
        HashMap<Integer, Satellite> sats = SatelliteSavedData.getData((World)world, (int)((int)player.field_70165_t), (int)((int)player.field_70161_v)).sats;
        buf.writeInt(sats.size());
        for (Map.Entry entry : sats.entrySet()) {
            buf.writeInt(((Integer)entry.getKey()).intValue());
            buf.writeInt(((Satellite)entry.getValue()).getID());
            ((Satellite)entry.getValue()).serialize(buf);
        }
        if (world.field_73011_w instanceof WorldProviderCelestial && world.field_73011_w.field_76574_g != 0) {
            buf.writeBoolean(true);
            ((WorldProviderCelestial)world.field_73011_w).serialize(buf);
        } else {
            buf.writeBoolean(false);
        }
        if (player.field_70154_o != null) {
            buf.writeInt(player.field_70154_o.func_145782_y());
        } else {
            buf.writeInt(-1);
        }
        CBT_War war = CelestialBody.getTrait(world, CBT_War.class);
        if (war != null) {
            List<CBT_War.Projectile> list = war.getProjectiles();
            for (CBT_War.Projectile projectile : list) {
                buf.writeFloat(projectile.getFlashtime());
                buf.writeFloat(projectile.getTravel());
            }
        }
    }

    public static void readPacket(ByteBuf buf, World world, EntityPlayer player) {
        CBT_War war;
        int ridingId;
        int i;
        int i2;
        ImpactWorldHandler.lastSyncWorld = player.field_70170_p;
        ImpactWorldHandler.fire = buf.readFloat();
        ImpactWorldHandler.dust = buf.readFloat();
        ImpactWorldHandler.impact = buf.readBoolean();
        ImpactWorldHandler.time = buf.readLong();
        boykissers.clear();
        int ids = buf.readShort();
        for (i2 = 0; i2 < ids; ++i2) {
            boykissers.add(buf.readInt());
        }
        for (i2 = 0; i2 < PollutionHandler.PollutionType.values().length; ++i2) {
            PermaSyncHandler.pollution[i2] = buf.readFloat();
        }
        if (buf.readBoolean()) {
            try {
                HashMap<String, HashMap<Class<CelestialBodyTrait>, CelestialBodyTrait>> traitMap = SolarSystemWorldSavedData.clientTraits;
                if (traitMap == null) {
                    traitMap = new HashMap();
                    SolarSystemWorldSavedData.updateClientTraits(traitMap);
                }
                for (CelestialBody body : CelestialBody.getAllBodies()) {
                    if (buf.readBoolean()) {
                        HashMap<Class<CelestialBodyTrait>, CelestialBodyTrait> traits = traitMap.get(body.name);
                        if (traits == null) {
                            traits = new HashMap();
                            traitMap.put(body.name, traits);
                        }
                        ArrayList<Class<? extends CelestialBodyTrait>> sentTraits = new ArrayList<Class<? extends CelestialBodyTrait>>();
                        int cbtSize = buf.readInt();
                        for (int i3 = 0; i3 < cbtSize; ++i3) {
                            Class<? extends CelestialBodyTrait> clazz = CelestialBodyTrait.traitList.get(buf.readInt());
                            sentTraits.add(clazz);
                            CelestialBodyTrait trait = traits.getOrDefault(clazz, clazz.newInstance());
                            trait.readFromBytes(buf);
                            traits.put(trait.getClass(), trait);
                        }
                        traits.keySet().removeIf(traitClass -> !sentTraits.contains(traitClass));
                        continue;
                    }
                    traitMap.remove(body.name);
                }
                OrbitalStation.orbitingStations.clear();
                int count = buf.readInt();
                for (i = 0; i < count; ++i) {
                    OrbitalStation.orbitingStations.add(new OrbitalStation(null, buf.readInt(), buf.readInt()));
                }
            }
            catch (Exception ex) {
                MainRegistry.logger.catching((Throwable)ex);
                SolarSystemWorldSavedData.updateClientTraits(null);
                return;
            }
        }
        int satSize = buf.readInt();
        HashMap<Integer, Satellite> sats = new HashMap<Integer, Satellite>();
        for (i = 0; i < satSize; ++i) {
            int satelliteID = buf.readInt();
            Satellite satellite = Satellite.create(buf.readInt());
            sats.put(satelliteID, satellite);
            satellite.deserialize(buf);
        }
        SatelliteSavedData.setClientSats(sats);
        if (buf.readBoolean() && world.field_73011_w instanceof WorldProviderCelestial) {
            ((WorldProviderCelestial)world.field_73011_w).deserialize(buf);
        }
        if ((ridingId = buf.readInt()) >= 0 && player.field_70154_o == null) {
            Entity entity = world.func_73045_a(ridingId);
            player.func_70078_a(entity);
        }
        if ((war = CelestialBody.getTrait(world, CBT_War.class)) != null) {
            List<CBT_War.Projectile> projectiles = war.getProjectiles();
            for (CBT_War.Projectile projectile : projectiles) {
                float flashtime = buf.readFloat();
                float traveltime = buf.readFloat();
                projectile.setFlashtime(flashtime);
                projectile.setTravel(traveltime);
            }
        }
    }
}

