/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.entity.projectile;

import com.hbm.entity.projectile.EntityChemical;
import java.awt.Color;
import java.util.Random;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import org.lwjgl.opengl.GL11;

public class RenderChemical
extends Render {
    private static ResourceLocation gas = new ResourceLocation("hbm:textures/particle/particle_base.png");

    public void func_76986_a(Entity entity, double x, double y, double z, float f0, float f1) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        EntityChemical chem = (EntityChemical)entity;
        EntityChemical.ChemicalStyle style = chem.getStyle();
        if (style == EntityChemical.ChemicalStyle.AMAT || style == EntityChemical.ChemicalStyle.LIGHTNING) {
            this.renderAmatBeam(chem, f1);
        }
        if (style == EntityChemical.ChemicalStyle.GAS) {
            this.func_110777_b(chem);
            this.renderGasCloud(chem, f1);
        }
        if (style == EntityChemical.ChemicalStyle.GASFLAME) {
            this.func_110777_b(chem);
            this.renderGasFire(chem, f1);
        }
        GL11.glPopMatrix();
    }

    private void renderGasFire(EntityChemical chem, float interp) {
        float exp = ((float)chem.field_70173_aa + interp) / (float)chem.getMaxAge();
        double size = 0.0 + (double)(exp * 2.0f);
        Color color = Color.getHSBColor(Math.max((60.0f - exp * 100.0f) / 360.0f, 0.0f), 1.0f - exp * 0.25f, 1.0f - exp * 0.5f);
        GL11.glEnable((int)3042);
        GL11.glAlphaFunc((int)516, (float)0.0f);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glDisable((int)3008);
        GL11.glDepthMask((boolean)false);
        Tessellator tess = Tessellator.field_78398_a;
        GL11.glRotatef((float)(180.0f - this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-this.field_76990_c.field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
        tess.func_78382_b();
        tess.func_78375_b(0.0f, 1.0f, 0.0f);
        tess.func_78384_a(color.getRGB(), (int)Math.max(255.0f * (1.0f - exp), 0.0f));
        tess.func_78374_a(-size, -size, 0.0, 1.0, 1.0);
        tess.func_78374_a(size, -size, 0.0, 0.0, 1.0);
        tess.func_78374_a(size, size, 0.0, 0.0, 0.0);
        tess.func_78374_a(-size, size, 0.0, 1.0, 0.0);
        tess.func_78381_a();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)3008);
        GL11.glDisable((int)3042);
        GL11.glAlphaFunc((int)518, (float)0.1f);
    }

    private void renderGasCloud(EntityChemical chem, float interp) {
        double exp = (double)((float)chem.field_70173_aa + interp) / (double)chem.getMaxAge();
        double size = 0.0 + exp * 10.0;
        int color = chem.getType().getColor();
        GL11.glEnable((int)3042);
        GL11.glAlphaFunc((int)516, (float)0.0f);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glDisable((int)3008);
        GL11.glDepthMask((boolean)false);
        Tessellator tess = Tessellator.field_78398_a;
        GL11.glRotatef((float)(180.0f - this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-this.field_76990_c.field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
        Random rand = new Random(chem.func_145782_y());
        int i = rand.nextInt(2);
        int j = rand.nextInt(2);
        tess.func_78382_b();
        tess.func_78375_b(0.0f, 1.0f, 0.0f);
        tess.func_78384_a(color, (int)Math.max(127.0 * (1.0 - exp), 0.0));
        tess.func_78374_a(-size, -size, 0.0, (double)(1 - i), (double)(1 - j));
        tess.func_78374_a(size, -size, 0.0, (double)i, (double)(1 - j));
        tess.func_78374_a(size, size, 0.0, (double)i, (double)j);
        tess.func_78374_a(-size, size, 0.0, (double)(1 - i), (double)j);
        tess.func_78381_a();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)3008);
        GL11.glDisable((int)3042);
        GL11.glAlphaFunc((int)518, (float)0.1f);
    }

    private void renderAmatBeam(EntityChemical chem, float interp) {
        float yaw = chem.field_70126_B + (chem.field_70177_z - chem.field_70126_B) * interp;
        float pitch = chem.field_70127_C + (chem.field_70125_A - chem.field_70127_C) * interp;
        GL11.glRotatef((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-pitch - 90.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glDisable((int)3008);
        GL11.glShadeModel((int)7425);
        GL11.glDepthMask((boolean)false);
        double length = Vec3.func_72443_a((double)chem.field_70159_w, (double)chem.field_70181_x, (double)chem.field_70179_y).func_72433_c() * (double)((float)chem.field_70173_aa + interp) * 0.75;
        double size = 0.0625;
        float o = 0.2f;
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78382_b();
        tess.func_78369_a(1.0f, 1.0f, 1.0f, o);
        tess.func_78377_a(-size, 0.0, -size);
        tess.func_78377_a(size, 0.0, -size);
        tess.func_78369_a(1.0f, 1.0f, 1.0f, 0.0f);
        tess.func_78377_a(size, length, -size);
        tess.func_78377_a(-size, length, -size);
        tess.func_78369_a(1.0f, 1.0f, 1.0f, o);
        tess.func_78377_a(-size, 0.0, size);
        tess.func_78377_a(size, 0.0, size);
        tess.func_78369_a(1.0f, 1.0f, 1.0f, 0.0f);
        tess.func_78377_a(size, length, size);
        tess.func_78377_a(-size, length, size);
        tess.func_78369_a(1.0f, 1.0f, 1.0f, o);
        tess.func_78377_a(-size, 0.0, -size);
        tess.func_78377_a(-size, 0.0, size);
        tess.func_78369_a(1.0f, 1.0f, 1.0f, 0.0f);
        tess.func_78377_a(-size, length, size);
        tess.func_78377_a(-size, length, -size);
        tess.func_78369_a(1.0f, 1.0f, 1.0f, o);
        tess.func_78377_a(size, 0.0, -size);
        tess.func_78377_a(size, 0.0, size);
        tess.func_78369_a(1.0f, 1.0f, 1.0f, 0.0f);
        tess.func_78377_a(size, length, size);
        tess.func_78377_a(size, length, -size);
        tess.func_78381_a();
        GL11.glDepthMask((boolean)true);
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3008);
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        return gas;
    }
}

