/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.tileentity;

import com.hbm.blocks.ModBlocks;
import com.hbm.main.ResourceManager;
import com.hbm.render.item.ItemRenderBase;
import com.hbm.render.tileentity.IItemRendererProvider;
import com.hbm.tileentity.machine.TileEntityStirling;
import com.hbm.wiaj.WorldInAJar;
import com.hbm.wiaj.actors.ITileActorRenderer;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderStirling
extends TileEntitySpecialRenderer
implements IItemRendererProvider,
ITileActorRenderer {
    public void func_147500_a(TileEntity tile, double x, double y, double z, float interp) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)y, (double)(z + 0.5));
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2884);
        switch (tile.func_145832_p() - 10) {
            case 3: {
                GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 5: {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 2: {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 4: {
                GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        TileEntityStirling stirling = (TileEntityStirling)tile;
        float rot = stirling.lastSpin + (stirling.spin - stirling.lastSpin) * interp;
        this.renderCommon(rot, stirling.hasCog, stirling.getGeatMeta());
        GL11.glPopMatrix();
    }

    private void renderCommon(float rot, boolean hasCog, int type) {
        if (type == 0) {
            this.func_147499_a(ResourceManager.stirling_tex);
        } else if (type == 2) {
            this.func_147499_a(ResourceManager.stirling_creative_tex);
        } else {
            this.func_147499_a(ResourceManager.stirling_steel_tex);
        }
        ResourceManager.stirling.renderPart("Base");
        if (hasCog) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)0.0, (double)1.375, (double)0.0);
            GL11.glRotatef((float)(-rot), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslated((double)0.0, (double)-1.375, (double)0.0);
            ResourceManager.stirling.renderPart("Cog");
            GL11.glPopMatrix();
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)1.375, (double)0.25);
        GL11.glRotatef((float)(rot * 2.0f + 3.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslated((double)0.0, (double)-1.375, (double)-0.25);
        ResourceManager.stirling.renderPart("CogSmall");
        GL11.glPopMatrix();
        GL11.glTranslated((double)(Math.sin((double)rot * Math.PI / 90.0) * 0.25 + 0.125), (double)0.0, (double)0.0);
        ResourceManager.stirling.renderPart("Piston");
    }

    protected void func_147499_a(ResourceLocation tex) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(tex);
    }

    @Override
    public Item getItemForRenderer() {
        return Item.func_150898_a((Block)ModBlocks.machine_stirling);
    }

    @Override
    public Item[] getItemsForRenderer() {
        return new Item[]{Item.func_150898_a((Block)ModBlocks.machine_stirling), Item.func_150898_a((Block)ModBlocks.machine_stirling_steel), Item.func_150898_a((Block)ModBlocks.machine_stirling_creative)};
    }

    @Override
    public IItemRenderer getRenderer() {
        return new ItemRenderBase(){

            @Override
            public void renderInventory() {
                GL11.glTranslated((double)0.0, (double)-1.5, (double)0.0);
                GL11.glScaled((double)3.25, (double)3.25, (double)3.25);
            }

            @Override
            public void renderCommonWithStack(ItemStack item) {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                boolean cog = item.func_77960_j() != 1;
                RenderStirling.this.renderCommon(cog ? (float)(System.currentTimeMillis() % 3600L) * 0.1f : 0.0f, cog, item.func_77973_b() == Item.func_150898_a((Block)ModBlocks.machine_stirling) ? 0 : (item.func_77973_b() == Item.func_150898_a((Block)ModBlocks.machine_stirling_creative) ? 2 : 1));
            }
        };
    }

    @Override
    public void renderActor(WorldInAJar world, int ticks, float interp, NBTTagCompound data) {
        double x = data.func_74769_h("x");
        double y = data.func_74769_h("y");
        double z = data.func_74769_h("z");
        int rotation = data.func_74762_e("rotation");
        int type = data.func_74762_e("type");
        boolean hasCog = data.func_74767_n("hasCog");
        float lastSpin = data.func_74760_g("lastSpin");
        float spin = data.func_74760_g("spin");
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)y, (double)(z + 0.5));
        switch (rotation) {
            case 3: {
                GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 5: {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 2: {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case 4: {
                GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        this.renderCommon(lastSpin + (spin - lastSpin) * interp, hasCog, type);
        GL11.glPopMatrix();
    }

    @Override
    public void updateActor(int ticks, NBTTagCompound data) {
        float lastSpin = 0.0f;
        float spin = data.func_74760_g("spin");
        float speed = data.func_74760_g("speed");
        lastSpin = spin;
        if ((spin += speed) >= 360.0f) {
            lastSpin -= 360.0f;
            spin -= 360.0f;
        }
        data.func_74776_a("lastSpin", lastSpin);
        data.func_74776_a("spin", spin);
    }
}

