/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.block.ICrucibleAcceptor;
import api.hbm.tile.IHeatSource;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.handler.pollution.PollutionHandler;
import com.hbm.handler.threading.PacketThreading;
import com.hbm.inventory.container.ContainerCrucible;
import com.hbm.inventory.gui.GUICrucible;
import com.hbm.inventory.material.MaterialShapes;
import com.hbm.inventory.material.Mats;
import com.hbm.inventory.material.NTMMaterial;
import com.hbm.inventory.recipes.CrucibleRecipes;
import com.hbm.items.ModItems;
import com.hbm.main.MainRegistry;
import com.hbm.packet.toclient.AuxParticlePacketNT;
import com.hbm.tileentity.IConfigurableMachine;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.IMetalCopiable;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.BobMathUtil;
import com.hbm.util.CrucibleUtil;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityCrucible
extends TileEntityMachineBase
implements IGUIProvider,
ICrucibleAcceptor,
IConfigurableMachine,
IMetalCopiable {
    public int heat;
    public int progress;
    public List<Mats.MaterialStack> recipeStack = new ArrayList<Mats.MaterialStack>();
    public List<Mats.MaterialStack> wasteStack = new ArrayList<Mats.MaterialStack>();
    public static int recipeZCapacity = MaterialShapes.BLOCK.q(16);
    public static int wasteZCapacity = MaterialShapes.BLOCK.q(16);
    public static int processTime = 20000;
    public static double diffusion = 0.25;
    public static int maxHeat = 100000;
    AxisAlignedBB bb = null;

    @Override
    public String getConfigName() {
        return "crucible";
    }

    @Override
    public void readIfPresent(JsonObject obj) {
        recipeZCapacity = IConfigurableMachine.grab(obj, "I:recipeCapacity", recipeZCapacity);
        wasteZCapacity = IConfigurableMachine.grab(obj, "I:wasteCapacity", wasteZCapacity);
        processTime = IConfigurableMachine.grab(obj, "I:processHeat", processTime);
        diffusion = IConfigurableMachine.grab(obj, "D:diffusion", diffusion);
        maxHeat = IConfigurableMachine.grab(obj, "I:heatCap", maxHeat);
    }

    @Override
    public void writeConfig(JsonWriter writer) throws IOException {
        writer.name("I:recipeCapacity").value((long)recipeZCapacity);
        writer.name("I:wasteCapacity").value((long)wasteZCapacity);
        writer.name("I:processHeat").value((long)processTime);
        writer.name("D:diffusion").value(diffusion);
        writer.name("I:heatCap").value((long)maxHeat);
    }

    public TileEntityCrucible() {
        super(10);
    }

    @Override
    public String getName() {
        return "container.machineCrucible";
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            ForgeDirection dir;
            this.tryPullHeat();
            if (this.field_145850_b.func_82737_E() % 5L == 0L) {
                List list = this.field_145850_b.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e - 0.5), (double)((double)this.field_145851_c + 1.5), (double)(this.field_145848_d + 1), (double)((double)this.field_145849_e + 1.5)));
                block0: for (EntityItem item : list) {
                    Mats.MaterialStack stack;
                    if (item.field_70128_L || !this.isItemSmeltable((ItemStack)(stack = item.func_92059_d()))) continue;
                    for (int i = 1; i < 10; ++i) {
                        if (this.slots[i] != null) continue;
                        if (((ItemStack)stack).field_77994_a == 1) {
                            this.slots[i] = stack.func_77946_l();
                            item.func_70106_y();
                            item.field_145804_b = 60;
                            continue block0;
                        }
                        this.slots[i] = stack.func_77946_l();
                        this.slots[i].field_77994_a = 1;
                        --((ItemStack)stack).field_77994_a;
                        this.markChanged();
                    }
                }
            }
            int totalCap = recipeZCapacity + wasteZCapacity;
            int totalMass = 0;
            for (Mats.MaterialStack stack : this.recipeStack) {
                totalMass += stack.amount;
            }
            for (Mats.MaterialStack stack : this.wasteStack) {
                totalMass += stack.amount;
            }
            double level = (double)totalMass / (double)totalCap * 0.875;
            List living = this.field_145850_b.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5 + level), (double)((double)this.field_145849_e + 0.5)).func_72314_b(1.0, 0.0, 1.0));
            for (EntityLivingBase entity : living) {
                entity.func_70097_a(DamageSource.field_76371_c, 5.0f);
                entity.func_70015_d(5);
            }
            if (!this.trySmelt()) {
                this.progress = 0;
            }
            this.tryRecipe();
            if (!this.wasteStack.isEmpty()) {
                dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10)).getOpposite();
                Vec3 impact = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
                Mats.MaterialStack didPour = CrucibleUtil.pourFullStack(this.field_145850_b, (double)this.field_145851_c + 0.5 + (double)dir.offsetX * 1.875, (double)this.field_145848_d + 0.25, (double)this.field_145849_e + 0.5 + (double)dir.offsetZ * 1.875, 6.0, true, this.wasteStack, MaterialShapes.NUGGET.q(3), impact);
                if (didPour != null) {
                    NBTTagCompound data = new NBTTagCompound();
                    data.func_74778_a("type", "foundry");
                    data.func_74768_a("color", didPour.material.moltenColor);
                    data.func_74774_a("dir", (byte)dir.ordinal());
                    data.func_74776_a("off", 0.625f);
                    data.func_74776_a("base", 0.625f);
                    data.func_74776_a("len", Math.max(1.0f, (float)this.field_145848_d - (float)(Math.ceil(impact.field_72448_b) - 0.875)));
                    PacketThreading.createAllAroundThreadedPacket(new AuxParticlePacketNT(data, (double)this.field_145851_c + 0.5 + (double)dir.offsetX * 1.875, this.field_145848_d, (double)this.field_145849_e + 0.5 + (double)dir.offsetZ * 1.875), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c + 0.5, (double)(this.field_145848_d + 1), (double)this.field_145849_e + 0.5, 50.0));
                }
                PollutionHandler.incrementPollution(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, PollutionHandler.PollutionType.SOOT, 0.0019999999f);
            }
            if (!this.recipeStack.isEmpty()) {
                dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
                ArrayList<Mats.MaterialStack> toCast = new ArrayList<Mats.MaterialStack>();
                CrucibleRecipes.CrucibleRecipe recipe = this.getLoadedRecipe();
                if (recipe == null) {
                    toCast.addAll(this.recipeStack);
                } else {
                    block5: for (Mats.MaterialStack stack : this.recipeStack) {
                        for (Mats.MaterialStack output : recipe.output) {
                            if (stack.material != output.material) continue;
                            toCast.add(stack);
                            continue block5;
                        }
                    }
                }
                Vec3 impact = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
                Mats.MaterialStack didPour = CrucibleUtil.pourFullStack(this.field_145850_b, (double)this.field_145851_c + 0.5 + (double)dir.offsetX * 1.875, (double)this.field_145848_d + 0.25, (double)this.field_145849_e + 0.5 + (double)dir.offsetZ * 1.875, 6.0, true, toCast, MaterialShapes.NUGGET.q(3), impact);
                if (didPour != null) {
                    NBTTagCompound data = new NBTTagCompound();
                    data.func_74778_a("type", "foundry");
                    data.func_74768_a("color", didPour.material.moltenColor);
                    data.func_74774_a("dir", (byte)dir.ordinal());
                    data.func_74776_a("off", 0.625f);
                    data.func_74776_a("base", 0.625f);
                    data.func_74776_a("len", Math.max(1.0f, (float)this.field_145848_d - (float)(Math.ceil(impact.field_72448_b) - 0.875)));
                    PacketThreading.createAllAroundThreadedPacket(new AuxParticlePacketNT(data, (double)this.field_145851_c + 0.5 + (double)dir.offsetX * 1.875, this.field_145848_d, (double)this.field_145849_e + 0.5 + (double)dir.offsetZ * 1.875), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c + 0.5, (double)(this.field_145848_d + 1), (double)this.field_145849_e + 0.5, 50.0));
                }
                PollutionHandler.incrementPollution(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, PollutionHandler.PollutionType.SOOT, 0.0019999999f);
            }
            this.recipeStack.removeIf(o -> o.amount <= 0);
            this.wasteStack.removeIf(x -> x.amount <= 0);
            this.networkPackNT(25);
        } else if (!(this.recipeStack.isEmpty() && this.wasteStack.isEmpty() || this.field_145850_b.func_82737_E() % 10L != 0L)) {
            NBTTagCompound fx = new NBTTagCompound();
            fx.func_74778_a("type", "tower");
            fx.func_74776_a("lift", 10.0f);
            fx.func_74776_a("base", 0.75f);
            fx.func_74776_a("max", 3.5f);
            fx.func_74768_a("life", 100 + this.field_145850_b.field_73012_v.nextInt(20));
            fx.func_74768_a("color", 0x202020);
            fx.func_74780_a("posX", (double)this.field_145851_c + 0.5);
            fx.func_74780_a("posY", (double)(this.field_145848_d + 1));
            fx.func_74780_a("posZ", (double)this.field_145849_e + 0.5);
            MainRegistry.proxy.effectNT(fx);
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeInt(this.progress);
        buf.writeInt(this.heat);
        buf.writeShort(this.recipeStack.size());
        for (Mats.MaterialStack sta : this.recipeStack) {
            if (sta.material == null) {
                buf.writeInt(-1);
            } else {
                buf.writeInt(sta.material.id);
            }
            buf.writeInt(sta.amount);
        }
        buf.writeShort(this.wasteStack.size());
        for (Mats.MaterialStack sta : this.wasteStack) {
            if (sta.material == null) {
                buf.writeInt(-1);
            } else {
                buf.writeInt(sta.material.id);
            }
            buf.writeInt(sta.amount);
        }
    }

    @Override
    public void deserialize(ByteBuf buf) {
        int id;
        int i;
        super.deserialize(buf);
        this.progress = buf.readInt();
        this.heat = buf.readInt();
        this.recipeStack.clear();
        this.wasteStack.clear();
        int mats = buf.readShort();
        for (i = 0; i < mats; ++i) {
            id = buf.readInt();
            if (id == -1) continue;
            this.recipeStack.add(new Mats.MaterialStack(Mats.matById.get(id), buf.readInt()));
        }
        mats = buf.readShort();
        for (i = 0; i < mats; ++i) {
            id = buf.readInt();
            if (id == -1) continue;
            this.wasteStack.add(new Mats.MaterialStack(Mats.matById.get(id), buf.readInt()));
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        int[] rec = nbt.func_74759_k("rec");
        for (int i = 0; i < rec.length / 2; ++i) {
            NTMMaterial mat = Mats.matById.get(rec[i * 2]);
            if (mat == null) continue;
            this.recipeStack.add(new Mats.MaterialStack(mat, rec[i * 2 + 1]));
        }
        int[] was = nbt.func_74759_k("was");
        for (int i = 0; i < was.length / 2; ++i) {
            NTMMaterial mat = Mats.matById.get(was[i * 2]);
            if (mat == null) continue;
            this.wasteStack.add(new Mats.MaterialStack(mat, was[i * 2 + 1]));
        }
        this.progress = nbt.func_74762_e("progress");
        this.heat = nbt.func_74762_e("heat");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        Mats.MaterialStack sta;
        int i;
        super.func_145841_b(nbt);
        int[] rec = new int[this.recipeStack.size() * 2];
        int[] was = new int[this.wasteStack.size() * 2];
        for (i = 0; i < this.recipeStack.size(); ++i) {
            sta = this.recipeStack.get(i);
            rec[i * 2] = sta.material.id;
            rec[i * 2 + 1] = sta.amount;
        }
        for (i = 0; i < this.wasteStack.size(); ++i) {
            sta = this.wasteStack.get(i);
            was[i * 2] = sta.material.id;
            was[i * 2 + 1] = sta.amount;
        }
        nbt.func_74783_a("rec", rec);
        nbt.func_74783_a("was", was);
        nbt.func_74768_a("progress", this.progress);
        nbt.func_74768_a("heat", this.heat);
    }

    protected void tryPullHeat() {
        if (this.heat >= maxHeat) {
            return;
        }
        TileEntity con = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
        if (con instanceof IHeatSource) {
            IHeatSource source = (IHeatSource)con;
            int diff = source.getHeatStored() - this.heat;
            if (diff == 0) {
                return;
            }
            if ((diff = Math.min(diff, maxHeat - this.heat)) > 0) {
                diff = (int)Math.ceil((double)diff * diffusion);
                source.useUpHeat(diff);
                this.heat += diff;
                if (this.heat > maxHeat) {
                    this.heat = maxHeat;
                }
                return;
            }
        }
        this.heat = Math.max(this.heat - Math.max(this.heat / 1000, 1), 0);
    }

    protected boolean trySmelt() {
        if (this.heat < maxHeat / 2) {
            return false;
        }
        int slot = this.getFirstSmeltableSlot();
        if (slot == -1) {
            return false;
        }
        int delta = this.heat - maxHeat / 2;
        delta = (int)((double)delta * 0.05);
        this.progress += delta;
        this.heat -= delta;
        if (this.progress >= processTime) {
            this.progress = 0;
            List<Mats.MaterialStack> materials = Mats.getSmeltingMaterialsFromItem(this.slots[slot]);
            CrucibleRecipes.CrucibleRecipe recipe = this.getLoadedRecipe();
            for (Mats.MaterialStack material : materials) {
                boolean mainStack;
                boolean bl = mainStack = recipe != null && (this.getQuantaFromType(recipe.input, material.material) > 0 || this.getQuantaFromType(recipe.output, material.material) > 0);
                if (mainStack) {
                    this.addToStack(this.recipeStack, material);
                    continue;
                }
                this.addToStack(this.wasteStack, material);
            }
            this.func_70298_a(slot, 1);
        }
        return true;
    }

    protected void tryRecipe() {
        CrucibleRecipes.CrucibleRecipe recipe = this.getLoadedRecipe();
        if (recipe == null) {
            return;
        }
        if (this.field_145850_b.func_82737_E() % (long)recipe.frequency > 0L) {
            return;
        }
        for (Mats.MaterialStack stack : recipe.input) {
            if (this.getQuantaFromType(this.recipeStack, stack.material) >= stack.amount) continue;
            return;
        }
        for (Mats.MaterialStack stack : this.recipeStack) {
            stack.amount -= this.getQuantaFromType(recipe.input, stack.material);
        }
        block2: for (Mats.MaterialStack out : recipe.output) {
            for (Mats.MaterialStack stack : this.recipeStack) {
                if (stack.material != out.material) continue;
                stack.amount += out.amount;
                continue block2;
            }
            this.recipeStack.add(out.copy());
        }
    }

    protected int getFirstSmeltableSlot() {
        for (int i = 1; i < 10; ++i) {
            ItemStack stack = this.slots[i];
            if (stack == null || !this.isItemSmeltable(stack)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean func_94041_b(int i, ItemStack stack) {
        if (i == 0) {
            return stack.func_77973_b() == ModItems.crucible_template;
        }
        return this.isItemSmeltable(stack);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isItemSmeltable(ItemStack stack) {
        List<Mats.MaterialStack> materials = Mats.getSmeltingMaterialsFromItem(stack);
        if (materials.isEmpty()) {
            return false;
        }
        CrucibleRecipes.CrucibleRecipe recipe = this.getLoadedRecipe();
        boolean matchesRecipe = recipe == null;
        int recipeContent = recipe != null ? recipe.getInputAmount() : 0;
        int recipeAmount = this.getQuantaFromType(this.recipeStack, null);
        int wasteAmount = this.getQuantaFromType(this.wasteStack, null);
        for (Mats.MaterialStack mat : materials) {
            int recipeInputRequired;
            int n = recipeInputRequired = recipe != null ? this.getQuantaFromType(recipe.input, mat.material) : 0;
            if (recipe != null && this.getQuantaFromType(recipe.output, mat.material) > 0) {
                recipeAmount += mat.amount;
                matchesRecipe = true;
                continue;
            }
            if (recipeInputRequired == 0) {
                wasteAmount += mat.amount;
                continue;
            }
            int matMaximum = recipeInputRequired * recipeZCapacity / recipeContent;
            int amountStored = this.getQuantaFromType(this.recipeStack, mat.material);
            matchesRecipe = true;
            recipeAmount += mat.amount;
            if (recipe == null || amountStored + mat.amount <= matMaximum) continue;
            return false;
        }
        if (recipeAmount > recipeZCapacity) return false;
        if (wasteAmount > wasteZCapacity) return false;
        if (!matchesRecipe) return false;
        return true;
    }

    public void addToStack(List<Mats.MaterialStack> stack, Mats.MaterialStack matStack) {
        for (Mats.MaterialStack mat : stack) {
            if (mat.material != matStack.material) continue;
            mat.amount += matStack.amount;
            return;
        }
        stack.add(matStack.copy());
    }

    public CrucibleRecipes.CrucibleRecipe getLoadedRecipe() {
        if (this.slots[0] != null && this.slots[0].func_77973_b() == ModItems.crucible_template) {
            return CrucibleRecipes.indexMapping.get(this.slots[0].func_77960_j());
        }
        return null;
    }

    public int getQuantaFromType(Mats.MaterialStack[] stacks, NTMMaterial mat) {
        for (Mats.MaterialStack stack : stacks) {
            if (mat != null && stack.material != mat) continue;
            return stack.amount;
        }
        return 0;
    }

    public int getQuantaFromType(List<Mats.MaterialStack> stacks, NTMMaterial mat) {
        int sum = 0;
        for (Mats.MaterialStack stack : stacks) {
            if (stack.material == mat) {
                return stack.amount;
            }
            if (mat != null) continue;
            sum += stack.amount;
        }
        return sum;
    }

    @Override
    public int[] func_94128_d(int meta) {
        return new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerCrucible(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUICrucible(player.field_71071_by, this);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 2));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canAcceptPartialPour(World world, int x, int y, int z, double dX, double dY, double dZ, ForgeDirection side, Mats.MaterialStack stack) {
        CrucibleRecipes.CrucibleRecipe recipe = this.getLoadedRecipe();
        if (recipe == null) {
            if (this.getQuantaFromType(this.wasteStack, null) >= wasteZCapacity) return false;
            return true;
        }
        int recipeContent = recipe.getInputAmount();
        int recipeInputRequired = this.getQuantaFromType(recipe.input, stack.material);
        int matMaximum = recipeInputRequired * recipeZCapacity / recipeContent;
        int amountStored = this.getQuantaFromType(this.recipeStack, stack.material);
        if (amountStored >= matMaximum) return false;
        if (this.getQuantaFromType(this.recipeStack, null) >= recipeZCapacity) return false;
        return true;
    }

    @Override
    public Mats.MaterialStack pour(World world, int x, int y, int z, double dX, double dY, double dZ, ForgeDirection side, Mats.MaterialStack stack) {
        CrucibleRecipes.CrucibleRecipe recipe = this.getLoadedRecipe();
        if (recipe == null) {
            int amount = this.getQuantaFromType(this.wasteStack, null);
            if (amount + stack.amount <= wasteZCapacity) {
                this.addToStack(this.wasteStack, stack.copy());
                return null;
            }
            int toAdd = wasteZCapacity - amount;
            this.addToStack(this.wasteStack, new Mats.MaterialStack(stack.material, toAdd));
            return new Mats.MaterialStack(stack.material, stack.amount - toAdd);
        }
        int recipeContent = recipe.getInputAmount();
        int recipeInputRequired = this.getQuantaFromType(recipe.input, stack.material);
        int matMaximum = recipeInputRequired * recipeZCapacity / recipeContent;
        if (recipeInputRequired + stack.amount <= matMaximum) {
            this.addToStack(this.recipeStack, stack.copy());
            return null;
        }
        int toAdd = matMaximum - stack.amount;
        toAdd = Math.min(toAdd, recipeZCapacity - this.getQuantaFromType(this.recipeStack, null));
        this.addToStack(this.recipeStack, new Mats.MaterialStack(stack.material, toAdd));
        return new Mats.MaterialStack(stack.material, stack.amount - toAdd);
    }

    @Override
    public boolean canAcceptPartialFlow(World world, int x, int y, int z, ForgeDirection side, Mats.MaterialStack stack) {
        return false;
    }

    @Override
    public Mats.MaterialStack flow(World world, int x, int y, int z, ForgeDirection side, Mats.MaterialStack stack) {
        return null;
    }

    @Override
    public int[] getMatsToCopy() {
        ArrayList<Integer> types = new ArrayList<Integer>();
        for (Mats.MaterialStack stack : this.recipeStack) {
            types.add(stack.material.id);
        }
        for (Mats.MaterialStack stack : this.wasteStack) {
            types.add(stack.material.id);
        }
        return BobMathUtil.intCollectionToArray(types);
    }
}

