/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.config.SpaceConfig;
import com.hbm.dim.CelestialBody;
import com.hbm.dim.SolarSystemWorldSavedData;
import com.hbm.handler.CompatHandler;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.container.ContainerStardar;
import com.hbm.inventory.gui.GUIMachineStardar;
import com.hbm.items.ItemVOTVdrive;
import com.hbm.items.ModItems;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Iterator;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")})
public class TileEntityMachineStardar
extends TileEntityMachineBase
implements IGUIProvider,
IControlReceiver,
SimpleComponent,
CompatHandler.OCComponent {
    private static long pointAtTime = 0L;
    public float dishYaw = 0.0f;
    public float dishPitch = 0.0f;
    public float prevDishYaw = 0.0f;
    public float prevDishPitch = 0.0f;
    public boolean radarMode;
    public static float targetYaw = 0.0f;
    public static float targetPitch = 0.0f;
    private float maxSpeedYaw = 0.5f;
    public int[] heightmap;
    public boolean updateHeightmap = false;
    private ItemStack previousStack;

    public TileEntityMachineStardar() {
        super(1);
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_82737_E() >= pointAtTime) {
                pointAtTime = this.field_145850_b.func_82737_E() + (long)this.field_145850_b.field_73012_v.nextInt(300) + 300L;
                targetYaw = MathHelper.func_76142_g((float)(this.field_145850_b.field_73012_v.nextFloat() * 360.0f));
                targetPitch = this.field_145850_b.field_73012_v.nextFloat() * 80.0f;
            }
            if (this.slots[0] != null && this.slots[0].func_77973_b() == ModItems.full_drive) {
                if (this.heightmap == null || !this.slots[0].func_77969_a(this.previousStack)) {
                    this.previousStack = this.slots[0];
                    ItemVOTVdrive.Destination destination = ItemVOTVdrive.getApproximateDestination(this.slots[0]);
                    CelestialBody body = destination.body.getBody();
                    ChunkCoordIntPair chunk = destination.getChunk();
                    if (body != null) {
                        this.heightmap = new int[65536];
                        this.updateHeightmap = true;
                        for (int cx = 0; cx < 16; ++cx) {
                            for (int cz = 0; cz < 16; ++cz) {
                                int[] map = body.getHeightmap(chunk.field_77276_a + cx - 8, chunk.field_77275_b + cz - 8);
                                int ox = cx * 16;
                                int oz = cz * 16;
                                for (int x = 0; x < 16; ++x) {
                                    for (int z = 0; z < 16; ++z) {
                                        this.heightmap[(z + oz) * 256 + (x + ox)] = map[z * 16 + x];
                                    }
                                }
                            }
                        }
                    }
                }
            } else if (this.heightmap != null) {
                this.heightmap = null;
                this.updateHeightmap = true;
            }
            this.networkPackNT(250);
            this.updateHeightmap = false;
        } else {
            float yawOffset = MathHelper.func_76142_g((float)(targetYaw - this.dishYaw));
            float moveYaw = MathHelper.func_76131_a((float)yawOffset, (float)(-this.maxSpeedYaw), (float)this.maxSpeedYaw);
            float pitchOffset = targetPitch - this.dishPitch;
            float pitchSpeed = moveYaw / yawOffset * Math.abs(pitchOffset);
            float movePitch = MathHelper.func_76131_a((float)pitchOffset, (float)(-pitchSpeed), (float)pitchSpeed);
            this.prevDishYaw = this.dishYaw;
            this.prevDishPitch = this.dishPitch;
            this.dishYaw += moveYaw;
            this.dishPitch += movePitch;
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            this.updateHeightmap = true;
        }
        return new ContainerStardar(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIMachineStardar(player.field_71071_by, this);
    }

    @Override
    public String getName() {
        return "container.machineStardar";
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74757_a("radarmode", this.radarMode);
        nbt.func_74776_a("yaw", targetYaw);
        nbt.func_74776_a("pitch", targetPitch);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.radarMode = nbt.func_74767_n("radarmode");
        targetYaw = nbt.func_74760_g("yaw");
        targetPitch = nbt.func_74760_g("pitch");
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeFloat(targetYaw);
        buf.writeFloat(targetPitch);
        buf.writeBoolean(this.radarMode);
        buf.writeBoolean(this.updateHeightmap);
        if (this.updateHeightmap) {
            if (this.heightmap != null) {
                buf.writeInt(this.heightmap.length);
                for (int h : this.heightmap) {
                    buf.writeByte(h);
                }
            } else {
                buf.writeInt(0);
            }
        }
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        targetYaw = buf.readFloat();
        targetPitch = buf.readFloat();
        this.radarMode = buf.readBoolean();
        if (buf.readBoolean()) {
            this.updateHeightmap = true;
            int count = buf.readInt();
            if (count > 0) {
                this.heightmap = new int[count];
                for (int i = 0; i < count; ++i) {
                    this.heightmap[i] = buf.readUnsignedByte();
                }
            } else {
                this.heightmap = null;
            }
        }
    }

    private void processDrive(int targetDimensionId, int ix, int iz) {
        CelestialBody body = CelestialBody.getBodyOrNull(targetDimensionId);
        if (body == null && targetDimensionId != SpaceConfig.orbitDimension) {
            return;
        }
        if (this.slots[0] == null || this.slots[0].func_77973_b() != ModItems.hard_drive) {
            return;
        }
        int meta = body != null ? body.getEnum().ordinal() : 0;
        this.slots[0] = new ItemStack((Item)ModItems.full_drive, 1, meta);
        if ((ix != 0 || iz != 0) && this.field_145850_b.field_73011_w.field_76574_g != SpaceConfig.orbitDimension) {
            this.slots[0].field_77990_d = new NBTTagCompound();
            this.slots[0].field_77990_d.func_74768_a("ax", ix);
            this.slots[0].field_77990_d.func_74768_a("az", iz);
            this.slots[0].field_77990_d.func_74757_a("Processed", true);
        } else if (targetDimensionId == SpaceConfig.orbitDimension) {
            ChunkCoordIntPair pos = this.field_145850_b.field_73011_w.field_76574_g == SpaceConfig.orbitDimension ? new ChunkCoordIntPair(MathHelper.func_76141_d((float)((float)this.field_145851_c / 1024.0f)), MathHelper.func_76141_d((float)((float)this.field_145849_e / 1024.0f))) : SolarSystemWorldSavedData.get(this.field_145850_b).findFreeSpace();
            this.slots[0].field_77990_d = new NBTTagCompound();
            this.slots[0].field_77990_d.func_74768_a("x", pos.field_77276_a);
            this.slots[0].field_77990_d.func_74768_a("z", pos.field_77275_b);
            this.slots[0].field_77990_d.func_74757_a("Processed", true);
        }
        pointAtTime = this.field_145850_b.field_73012_v.nextInt(300) + 300;
        targetYaw = MathHelper.func_76142_g((float)(this.field_145850_b.field_73012_v.nextFloat() * 360.0f));
        targetPitch = this.field_145850_b.field_73012_v.nextFloat() * 80.0f;
        this.func_70296_d();
    }

    private void updateDriveCoords(int x, int z) {
        if (this.slots[0] == null || this.slots[0].func_77973_b() != ModItems.full_drive) {
            return;
        }
        ItemVOTVdrive.Destination destination = ItemVOTVdrive.getApproximateDestination(this.slots[0]);
        ItemVOTVdrive.setCoordinates(this.slots[0], destination.x + x - 128, destination.z + z - 128);
        this.func_70296_d();
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return "ntm_stardar";
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getPlanetStats(Context context, Arguments args) {
        CelestialBody body = CelestialBody.getBody(args.checkString(0));
        if (body != null) {
            return new Object[]{body.name, body.parent.name, body.getStar().name, body.tidallyLockedTo, Float.valueOf(body.axialTilt), body.canLand, Float.valueOf(body.massKg), body.getProcessingLevel(CelestialBody.getBody(this.field_145850_b)), Float.valueOf(body.radiusKm), Float.valueOf(body.semiMajorAxisKm), Float.valueOf(body.getSunPower()), Float.valueOf(body.getSurfaceGravity()), body.getRotationalPeriod(), body.getOrbitalPeriod()};
        }
        return new Object[]{null, "No body with that name found."};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getCurrentPlanet(Context context, Arguments args) {
        CelestialBody body = CelestialBody.getBody(this.field_145850_b);
        return new Object[]{body.name};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getSatellites(Context context, Arguments args) {
        CelestialBody body = CelestialBody.getBody(args.checkString(0));
        if (body != null) {
            ArrayList<String> returnValues = new ArrayList<String>();
            Iterator<CelestialBody> iterator = body.satellites.iterator();
            if (iterator.hasNext()) {
                CelestialBody planet = iterator.next();
                returnValues.add(planet.name);
                return returnValues.toArray();
            }
        }
        return new Object[]{null, "No body with that name found."};
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("pid")) {
            this.processDrive(data.func_74762_e("pid"), data.func_74762_e("ix"), data.func_74762_e("iz"));
        }
        if (data.func_74764_b("px") && data.func_74764_b("pz")) {
            this.updateDriveCoords(data.func_74762_e("px"), data.func_74762_e("pz"));
        }
        if (data.func_74764_b("radarmode")) {
            this.radarMode = data.func_74767_n("radarmode");
        }
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return this.func_70300_a(player);
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }
}

