/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.fluidmk2.IFluidStandardReceiverMK2;
import com.hbm.dim.CelestialBody;
import com.hbm.dim.SolarSystem;
import com.hbm.entity.missile.EntityRideableRocket;
import com.hbm.handler.RocketStruct;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.SlotRocket;
import com.hbm.inventory.container.ContainerOrbitalStationLauncher;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUIOrbitalStationLauncher;
import com.hbm.items.ISatChip;
import com.hbm.items.ItemVOTVdrive;
import com.hbm.items.ModItems;
import com.hbm.items.weapon.ItemCustomRocket;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.tileentity.bomb.TileEntityLaunchPadRocket;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityOrbitalStationLauncher
extends TileEntityMachineBase
implements IGUIProvider,
IControlReceiver,
SlotRocket.IStage,
IFluidStandardReceiverMK2 {
    public RocketStruct rocket;
    private EntityRideableRocket docked;
    public FluidTank[] tanks;
    public TileEntityLaunchPadRocket.SolidFuelTank solidFuel = new TileEntityLaunchPadRocket.SolidFuelTank();
    public float rot;
    public float prevRot;
    public int currentStage;
    public boolean isBreaking;
    public boolean hasDocked = false;
    public boolean hasRider = false;

    public TileEntityOrbitalStationLauncher() {
        super(29);
        this.tanks = new FluidTank[10];
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i] = new FluidTank(Fluids.NONE, 64000);
        }
    }

    @Override
    public String getName() {
        return "container.orbitalStationLauncher";
    }

    @Override
    public void func_145845_h() {
        if (!CelestialBody.inOrbit(this.field_145850_b)) {
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            ItemStack fromStack = this.slots[this.slots.length - (5 - this.currentStage) * 2];
            ItemStack toStack = this.slots[this.slots.length - (5 - this.currentStage) * 2 + 1];
            ItemVOTVdrive.getTarget(this.slots[0], this.field_145850_b);
            ItemVOTVdrive.getTarget(fromStack, this.field_145850_b);
            ItemVOTVdrive.getTarget(toStack, this.field_145850_b);
            this.rocket = new RocketStruct(this.slots[3]);
            if (this.slots[3] != null && this.slots[3].func_77973_b() instanceof ISatChip) {
                this.rocket.satFreq = ISatChip.getFreqS(this.slots[3]);
            }
            for (int i = 4; i < 18; i += 3) {
                if (this.slots[i] == null && this.slots[i + 1] == null && this.slots[i + 2] == null) {
                    if (i + 3 >= 15 || this.slots[i + 3] == null && this.slots[i + 4] == null && this.slots[i + 5] == null) break;
                    this.slots[i] = this.slots[i + 3];
                    this.slots[i + 1] = this.slots[i + 4];
                    this.slots[i + 2] = this.slots[i + 5];
                    this.slots[i + 3] = null;
                    this.slots[i + 4] = null;
                    this.slots[i + 5] = null;
                }
                this.rocket.addStage(this.slots[i], this.slots[i + 1], this.slots[i + 2]);
            }
            this.updateTanks();
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                for (DirPos pos : this.getConPos()) {
                    if (!this.rocket.validate()) continue;
                    for (FluidTank tank : this.tanks) {
                        if (tank.getTankType() == Fluids.NONE) continue;
                        this.trySubscribe(tank.getTankType(), this.field_145850_b, pos);
                    }
                }
            }
            for (FluidTank tank : this.tanks) {
                tank.loadTank(1, 2, this.slots);
            }
            if (this.slots[1] != null && this.slots[1].func_77973_b() == ModItems.rocket_fuel && this.solidFuel.level < this.solidFuel.max) {
                this.func_70298_a(1, 1);
                this.solidFuel.level += 250;
                if (this.solidFuel.level > this.solidFuel.max) {
                    this.solidFuel.level = this.solidFuel.max;
                }
            }
            if (this.docked != null && (this.docked.field_70128_L || this.docked.getState() == EntityRideableRocket.RocketState.UNDOCKING)) {
                this.undockRocket();
            }
            this.hasDocked = this.docked != null;
            this.hasRider = this.hasDocked && this.docked.field_70153_n != null;
            this.networkPackNT(250);
        } else {
            this.prevRot = this.rot;
            if (this.hasDocked) {
                this.rot += 2.25f;
                if (this.rot > 90.0f) {
                    this.rot = 90.0f;
                }
            } else {
                this.rot -= 2.25f;
                if (this.rot < 0.0f) {
                    this.rot = 0.0f;
                }
            }
        }
    }

    public void enterCapsule(EntityPlayer player) {
        if (this.docked == null || this.docked.field_70153_n != null) {
            return;
        }
        this.docked.func_130002_c(player);
    }

    public void dockRocket(EntityRideableRocket rocket) {
        this.docked = rocket;
    }

    public void undockRocket() {
        this.docked = null;
    }

    private boolean hasDrive() {
        return this.slots[0] != null && this.slots[0].func_77973_b() instanceof ItemVOTVdrive;
    }

    private boolean areTanksFull() {
        for (FluidTank tank : this.tanks) {
            if (tank.getTankType() == Fluids.NONE || tank.getFill() >= tank.getMaxFill()) continue;
            return false;
        }
        return this.solidFuel.level >= this.solidFuel.max;
    }

    private boolean canReachDestination() {
        if (!ItemVOTVdrive.getProcessed(this.slots[0])) {
            return false;
        }
        SolarSystem.Body target = ItemVOTVdrive.getDestination((ItemStack)this.slots[0]).body;
        if (target == SolarSystem.Body.ORBIT && this.rocket.capsule.part != ModItems.rp_capsule_20 && this.rocket.capsule.part != ModItems.rp_station_core_20) {
            return false;
        }
        ItemVOTVdrive.Target from = CelestialBody.getTarget(this.field_145850_b, this.field_145851_c, this.field_145849_e);
        ItemVOTVdrive.Target to = ItemVOTVdrive.getTarget(this.slots[0], this.field_145850_b);
        if (!to.isValid && this.rocket.capsule.part != ModItems.rp_station_core_20) {
            return false;
        }
        if (to.isValid && this.rocket.capsule.part == ModItems.rp_station_core_20) {
            return false;
        }
        return this.rocket.hasSufficientFuel(from.body, to.body, from.inOrbit, to.inOrbit);
    }

    public boolean canLaunch() {
        return this.rocket.validate() && this.hasDrive() && this.areTanksFull() && this.canReachDestination();
    }

    public void launch(EntityPlayer player) {
        int i;
        if (!this.canLaunch()) {
            return;
        }
        ItemStack stack = ItemCustomRocket.build(this.rocket);
        EntityRideableRocket rocket = new EntityRideableRocket(this.field_145850_b, (float)this.field_145851_c + 0.5f, (float)this.field_145848_d + 1.5f, (float)this.field_145849_e + 0.5f, stack).withProgram(this.slots[0]).launchedBy((EntityLivingBase)player);
        rocket.field_70163_u -= (double)rocket.field_70131_O;
        this.field_145850_b.func_72838_d((Entity)rocket);
        for (i = 0; i < this.tanks.length; ++i) {
            this.tanks[i] = new FluidTank(Fluids.NONE, 64000);
        }
        this.solidFuel.max = 0;
        this.solidFuel.level = 0;
        this.slots[0] = null;
        for (i = 3; i < this.slots.length; ++i) {
            this.slots[i] = null;
        }
        this.dockRocket(rocket);
    }

    @Override
    public int func_70302_i_() {
        if (this.isBreaking) {
            return super.func_70302_i_() - 10;
        }
        return super.func_70302_i_();
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        if (stack == null) {
            return true;
        }
        return index != 0 || stack.func_77973_b() instanceof ItemVOTVdrive;
    }

    private void updateTanks() {
        if (!this.rocket.validate()) {
            return;
        }
        TileEntityLaunchPadRocket.updateStorageTanks(this.rocket, this.tanks, this.solidFuel, false);
    }

    public DirPos[] getConPos() {
        return new DirPos[]{new DirPos(this.field_145851_c - 1, this.field_145848_d + 1, this.field_145849_e + 3, ForgeDirection.NORTH), new DirPos(this.field_145851_c + 0, this.field_145848_d + 1, this.field_145849_e + 3, ForgeDirection.NORTH), new DirPos(this.field_145851_c + 1, this.field_145848_d + 1, this.field_145849_e + 3, ForgeDirection.NORTH), new DirPos(this.field_145851_c - 1, this.field_145848_d + 1, this.field_145849_e - 3, ForgeDirection.SOUTH), new DirPos(this.field_145851_c + 0, this.field_145848_d + 1, this.field_145849_e - 3, ForgeDirection.SOUTH), new DirPos(this.field_145851_c + 1, this.field_145848_d + 1, this.field_145849_e - 3, ForgeDirection.SOUTH), new DirPos(this.field_145851_c + 3, this.field_145848_d + 1, this.field_145849_e - 1, ForgeDirection.EAST), new DirPos(this.field_145851_c + 3, this.field_145848_d + 1, this.field_145849_e + 0, ForgeDirection.EAST), new DirPos(this.field_145851_c + 3, this.field_145848_d + 1, this.field_145849_e + 1, ForgeDirection.EAST), new DirPos(this.field_145851_c - 3, this.field_145848_d + 1, this.field_145849_e - 1, ForgeDirection.WEST), new DirPos(this.field_145851_c - 3, this.field_145848_d + 1, this.field_145849_e + 0, ForgeDirection.WEST), new DirPos(this.field_145851_c - 3, this.field_145848_d + 1, this.field_145849_e + 1, ForgeDirection.WEST)};
    }

    public List<String> findIssues() {
        ArrayList<String> issues = new ArrayList<String>();
        if (!this.rocket.validate()) {
            return issues;
        }
        TileEntityLaunchPadRocket.findTankIssues(issues, this.tanks, this.solidFuel);
        if (TileEntityLaunchPadRocket.findDriveIssues(issues, this.rocket, this.slots[0])) {
            return issues;
        }
        ItemVOTVdrive.Target from = CelestialBody.getTarget(this.field_145850_b, this.field_145851_c, this.field_145849_e);
        ItemVOTVdrive.Target to = ItemVOTVdrive.getTarget(this.slots[0], this.field_145850_b);
        TileEntityLaunchPadRocket.findTravelIssues(issues, this.rocket, from, to);
        return issues;
    }

    @Override
    public void serialize(ByteBuf buf) {
        this.rocket.writeToByteBuffer(buf);
        buf.writeBoolean(this.hasDocked);
        buf.writeBoolean(this.hasRider);
        buf.writeInt(this.solidFuel.level);
        buf.writeInt(this.solidFuel.max);
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].serialize(buf);
        }
    }

    @Override
    public void deserialize(ByteBuf buf) {
        this.rocket = RocketStruct.readFromByteBuffer(buf);
        this.hasDocked = buf.readBoolean();
        this.hasRider = buf.readBoolean();
        this.solidFuel.level = buf.readInt();
        this.solidFuel.max = buf.readInt();
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].deserialize(buf);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("solid", this.solidFuel.level);
        nbt.func_74768_a("maxSolid", this.solidFuel.max);
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].writeToNBT(nbt, "t" + i);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.solidFuel.level = nbt.func_74762_e("solid");
        this.solidFuel.max = nbt.func_74762_e("maxSolid");
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].readFromNBT(nbt, "t" + i);
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return this.func_70300_a(player);
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
    }

    @Override
    public void receiveControl(EntityPlayer player, NBTTagCompound data) {
        if (data.func_74767_n("launch")) {
            this.launch(player);
        }
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerOrbitalStationLauncher(player.field_71071_by, this);
    }

    @Override
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIOrbitalStationLauncher(player.field_71071_by, this);
    }

    @Override
    public void setCurrentStage(int stage) {
        this.currentStage = stage;
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return this.tanks;
    }
}

