/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.tile.IInfoProviderEC;
import com.hbm.blocks.ModBlocks;
import com.hbm.config.MobConfig;
import com.hbm.config.RadiationConfig;
import com.hbm.handler.CompatHandler;
import com.hbm.handler.radiation.ChunkRadiationManager;
import com.hbm.hazard.type.HazardTypeNeutron;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.container.ContainerReactorResearch;
import com.hbm.inventory.gui.GUIReactorResearch;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemPlateFuel;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.BufferUtil;
import com.hbm.util.ContaminationUtil;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")})
public class TileEntityReactorResearch
extends TileEntityMachineBase
implements IControlReceiver,
SimpleComponent,
IGUIProvider,
IInfoProviderEC,
CompatHandler.OCComponent {
    @SideOnly(value=Side.CLIENT)
    public double lastLevel;
    public double level;
    public double speed = 0.04;
    public double targetLevel;
    public int heat;
    public byte water;
    public final int maxHeat = 50000;
    public int[] slotFlux = new int[12];
    public int totalFlux = 0;
    private static final int[] slot_io = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
    private static final HashMap<RecipesCommon.ComparableStack, ItemStack> fuelMap = new HashMap();

    public TileEntityReactorResearch() {
        super(12);
    }

    @Override
    public String getName() {
        return "container.reactorResearch";
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemStack) {
        return i < 12 && i <= 0 && itemStack.func_77973_b().getClass() == ItemPlateFuel.class;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.heat = nbt.func_74762_e("heat");
        this.water = nbt.func_74771_c("water");
        this.level = nbt.func_74769_h("level");
        this.targetLevel = nbt.func_74769_h("targetLevel");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("heat", this.heat);
        nbt.func_74774_a("water", this.water);
        nbt.func_74780_a("level", this.level);
        nbt.func_74780_a("targetLevel", this.targetLevel);
    }

    @Override
    public int[] func_94128_d(int side) {
        return slot_io;
    }

    @Override
    public boolean func_102008_b(int i, ItemStack stack, int j) {
        return i < 12 && i >= 0 && fuelMap.containsValue(stack);
    }

    @Override
    public void func_145845_h() {
        this.rodControl();
        if (!this.field_145850_b.field_72995_K) {
            this.totalFlux = 0;
            if (this.level > 0.0) {
                this.reaction();
            }
            if (this.heat > 0) {
                this.water = this.getWater();
                if (this.water > 0) {
                    this.heat = (int)((float)this.heat - (float)this.heat * 0.07f * (float)this.water / 12.0f);
                } else if (this.water == 0) {
                    --this.heat;
                }
                if (this.heat < 0) {
                    this.heat = 0;
                }
            }
            if (this.heat > 50000) {
                this.explode();
            }
            if (!(!(this.level > 0.0) || this.heat <= 0 || this.blocksRad(this.field_145851_c + 1, this.field_145848_d + 1, this.field_145849_e) && this.blocksRad(this.field_145851_c - 1, this.field_145848_d + 1, this.field_145849_e) && this.blocksRad(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e + 1) && this.blocksRad(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e - 1))) {
                float rad = (float)this.heat / 50000.0f * 50.0f;
                double range = 25.0;
                ChunkRadiationManager.proxy.incrementRad(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, rad);
                List entities = this.field_145850_b.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5)).func_72314_b(range, range, range));
                if (!RadiationConfig.disableNeutron) {
                    for (EntityLivingBase e : entities) {
                        int i;
                        Vec3 vec = Vec3.func_72443_a((double)(e.field_70165_t - ((double)this.field_145851_c + 0.5)), (double)(e.field_70163_u + (double)e.func_70047_e() - ((double)this.field_145848_d + 0.5)), (double)(e.field_70161_v - ((double)this.field_145849_e + 0.5)));
                        double len = vec.func_72433_c();
                        vec = vec.func_72432_b();
                        float res = 0.0f;
                        int i2 = 1;
                        while ((double)i2 < len) {
                            int ix = (int)Math.floor((double)this.field_145851_c + 0.5 + vec.field_72450_a * (double)i2);
                            int iy = (int)Math.floor((double)this.field_145848_d + 0.5 + vec.field_72448_b * (double)i2);
                            int iz = (int)Math.floor((double)this.field_145849_e + 0.5 + vec.field_72449_c * (double)i2);
                            res += this.field_145850_b.func_147439_a(ix, iy, iz).func_149638_a(null);
                            ++i2;
                        }
                        if (res < 1.0f) {
                            res = 1.0f;
                        }
                        float eRads = rad;
                        eRads /= res;
                        ContaminationUtil.contaminate(e, ContaminationUtil.HazardType.NEUTRON, ContaminationUtil.ContaminationType.CREATIVE, eRads /= (float)(len * len));
                        if (!(e instanceof EntityPlayer)) continue;
                        EntityPlayer player = (EntityPlayer)e;
                        for (i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
                            HazardTypeNeutron.apply(player.field_71071_by.func_70301_a(i), eRads);
                        }
                        for (i = 0; i < player.field_71071_by.field_70460_b.length; ++i) {
                            HazardTypeNeutron.apply(player.field_71071_by.func_70440_f(i), eRads);
                        }
                    }
                }
            }
            this.networkPackNT(150);
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeInt(this.heat);
        buf.writeByte((int)this.water);
        buf.writeDouble(this.level);
        buf.writeDouble(this.targetLevel);
        BufferUtil.writeIntArray(buf, this.slotFlux);
        buf.writeInt(this.totalFlux);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.heat = buf.readInt();
        this.water = buf.readByte();
        this.level = buf.readDouble();
        this.targetLevel = buf.readDouble();
        this.slotFlux = BufferUtil.readIntArray(buf);
        this.totalFlux = buf.readInt();
    }

    public byte getWater() {
        byte water = 0;
        for (int d = 0; d < 6; d = (int)((byte)(d + 1))) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)d);
            if (d < 2) {
                if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1 + dir.offsetY * 2, this.field_145849_e).func_149688_o() != Material.field_151586_h) continue;
                water = (byte)(water + 1);
                continue;
            }
            for (int i = 0; i < 3; i = (int)((byte)(i + 1))) {
                if (this.field_145850_b.func_147439_a(this.field_145851_c + dir.offsetX, this.field_145848_d + i, this.field_145849_e + dir.offsetZ).func_149688_o() != Material.field_151586_h) continue;
                water = (byte)(water + 1);
            }
        }
        return water;
    }

    public boolean isSubmerged() {
        return this.field_145850_b.func_147439_a(this.field_145851_c + 1, this.field_145848_d + 1, this.field_145849_e).func_149688_o() == Material.field_151586_h || this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e + 1).func_149688_o() == Material.field_151586_h || this.field_145850_b.func_147439_a(this.field_145851_c - 1, this.field_145848_d + 1, this.field_145849_e).func_149688_o() == Material.field_151586_h || this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e - 1).func_149688_o() == Material.field_151586_h;
    }

    private boolean blocksRad(int x, int y, int z) {
        Block b = this.field_145850_b.func_147439_a(x, y, z);
        if ((b == Blocks.field_150355_j || b == Blocks.field_150358_i) && this.field_145850_b.func_72805_g(x, y, z) == 0) {
            return true;
        }
        if (b == ModBlocks.block_lead || b == ModBlocks.block_desh || b == ModBlocks.reactor_research || b == ModBlocks.machine_reactor_breeding) {
            return true;
        }
        return b.func_149638_a(null) >= 100.0f;
    }

    private int[] getNeighboringSlots(int id) {
        switch (id) {
            case 0: {
                return new int[]{1, 5};
            }
            case 1: {
                return new int[]{0, 6};
            }
            case 2: {
                return new int[]{3, 7};
            }
            case 3: {
                return new int[]{2, 4, 8};
            }
            case 4: {
                return new int[]{3, 9};
            }
            case 5: {
                return new int[]{0, 6, 10};
            }
            case 6: {
                return new int[]{1, 5, 11};
            }
            case 7: {
                return new int[]{2, 8};
            }
            case 8: {
                return new int[]{3, 7, 9};
            }
            case 9: {
                return new int[]{4, 8};
            }
            case 10: {
                return new int[]{5, 11};
            }
            case 11: {
                return new int[]{6, 10};
            }
        }
        return null;
    }

    private void reaction() {
        for (int i = 0; i < 12; i = (int)((byte)(i + 1))) {
            if (this.slots[i] == null) {
                this.slotFlux[i] = 0;
                continue;
            }
            if (this.slots[i].func_77973_b() instanceof ItemPlateFuel) {
                ItemPlateFuel rod = (ItemPlateFuel)this.slots[i].func_77973_b();
                int outFlux = rod.react(this.field_145850_b, this.slots[i], this.slotFlux[i]);
                this.heat += outFlux * 2;
                this.slotFlux[i] = 0;
                this.totalFlux += outFlux;
                int[] neighborSlots = this.getNeighboringSlots(i);
                if (ItemPlateFuel.getLifeTime(this.slots[i]) > rod.lifeTime) {
                    this.slots[i] = fuelMap.get(new RecipesCommon.ComparableStack(this.slots[i])).func_77946_l();
                }
                for (int j = 0; j < neighborSlots.length; j = (int)((byte)(j + 1))) {
                    int n = neighborSlots[j];
                    this.slotFlux[n] = this.slotFlux[n] + (int)((double)outFlux * this.level);
                }
                continue;
            }
            if (this.slots[i].func_77973_b() == ModItems.meteorite_sword_bred) {
                this.slots[i] = new ItemStack(ModItems.meteorite_sword_irradiated);
            }
            this.slotFlux[i] = 0;
        }
    }

    private void explode() {
        for (int i = 0; i < this.slots.length; ++i) {
            this.slots[i] = null;
        }
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        for (int d = 0; d < 6; d = (int)((byte)(d + 1))) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)d);
            if (d < 2) {
                if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1 + dir.offsetY * 2, this.field_145849_e).func_149688_o() != Material.field_151586_h) continue;
                this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d + 1 + dir.offsetY * 2, this.field_145849_e);
                continue;
            }
            for (int i = 0; i < 3; i = (int)((byte)(i + 1))) {
                if (this.field_145850_b.func_147439_a(this.field_145851_c + dir.offsetX, this.field_145848_d + i, this.field_145849_e + dir.offsetZ).func_149688_o() != Material.field_151586_h) continue;
                this.field_145850_b.func_147468_f(this.field_145851_c + dir.offsetX, this.field_145848_d + i, this.field_145849_e + dir.offsetZ);
            }
        }
        this.field_145850_b.func_72876_a(null, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 18.0f, true);
        this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, ModBlocks.deco_steel);
        this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, ModBlocks.corium_block);
        this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d + 2, this.field_145849_e, ModBlocks.deco_steel);
        ChunkRadiationManager.proxy.incrementRad(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 50.0f);
        if (MobConfig.enableElementals) {
            List players = this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5)).func_72314_b(100.0, 100.0, 100.0));
            for (EntityPlayer player : players) {
                player.getEntityData().func_74775_l("PlayerPersisted").func_74757_a("radMark", true);
            }
        }
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return Vec3.func_72443_a((double)((double)this.field_145851_c - player.field_70165_t), (double)((double)this.field_145848_d - player.field_70163_u), (double)((double)this.field_145849_e - player.field_70161_v)).func_72433_c() < 20.0;
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("level")) {
            this.setTarget(data.func_74769_h("level"));
        }
        this.func_70296_d();
    }

    public void setTarget(double target) {
        this.targetLevel = target;
    }

    public void rodControl() {
        if (this.field_145850_b.field_72995_K) {
            this.lastLevel = this.level;
        } else {
            if (this.level < this.targetLevel) {
                this.level += this.speed;
                if (this.level >= this.targetLevel) {
                    this.level = this.targetLevel;
                }
            }
            if (this.level > this.targetLevel) {
                this.level -= this.speed;
                if (this.level <= this.targetLevel) {
                    this.level = this.targetLevel;
                }
            }
        }
    }

    public int[] getDisplayData() {
        int[] data = new int[]{this.totalFlux, (int)Math.round((double)this.heat * 2.0E-5 * 980.0 + 20.0)};
        return data;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return "research_reactor";
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getTemp(Context context, Arguments args) {
        return new Object[]{this.heat};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getLevel(Context context, Arguments args) {
        return new Object[]{this.level * 100.0};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getTargetLevel(Context context, Arguments args) {
        return new Object[]{this.targetLevel};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getFlux(Context context, Arguments args) {
        return new Object[]{this.totalFlux};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getInfo(Context context, Arguments args) {
        return new Object[]{this.heat, this.level, this.targetLevel, this.totalFlux};
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String[] methods() {
        return new String[]{"getTemp", "getLevel", "getTargetLevel", "getFlux", "getInfo"};
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public Object[] invoke(String method, Context context, Arguments args) throws Exception {
        switch (method) {
            case "getTemp": {
                return this.getTemp(context, args);
            }
            case "getLevel": {
                return this.getLevel(context, args);
            }
            case "getTargetLevel": {
                return this.getTargetLevel(context, args);
            }
            case "getFlux": {
                return this.getFlux(context, args);
            }
            case "getInfo": {
                return this.getInfo(context, args);
            }
        }
        throw new NoSuchMethodException();
    }

    @Callback(direct=true, limit=4)
    @Optional.Method(modid="OpenComputers")
    public Object[] setLevel(Context context, Arguments args) {
        double newLevel = args.checkDouble(0) / 100.0;
        this.targetLevel = MathHelper.func_151237_a((double)newLevel, (double)0.0, (double)1.0);
        return new Object[0];
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerReactorResearch(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIReactorResearch(player.field_71071_by, this);
    }

    @Override
    public void provideExtraInfo(NBTTagCompound data) {
        data.func_74780_a("heat", (double)Math.round((double)this.heat * 2.0E-5 * 980.0 + 20.0));
        data.func_74768_a("flux", this.totalFlux);
        data.func_74768_a("water", (int)this.water);
    }

    static {
        fuelMap.put(new RecipesCommon.ComparableStack(ModItems.plate_fuel_u233), new ItemStack(ModItems.waste_plate_u233, 1, 1));
        fuelMap.put(new RecipesCommon.ComparableStack(ModItems.plate_fuel_u235), new ItemStack(ModItems.waste_plate_u235, 1, 1));
        fuelMap.put(new RecipesCommon.ComparableStack(ModItems.plate_fuel_mox), new ItemStack(ModItems.waste_plate_mox, 1, 1));
        fuelMap.put(new RecipesCommon.ComparableStack(ModItems.plate_fuel_pu239), new ItemStack(ModItems.waste_plate_pu239, 1, 1));
        fuelMap.put(new RecipesCommon.ComparableStack(ModItems.plate_fuel_sa326), new ItemStack(ModItems.waste_plate_sa326, 1, 1));
        fuelMap.put(new RecipesCommon.ComparableStack(ModItems.plate_fuel_ra226be), new ItemStack(ModItems.waste_plate_ra226be, 1, 1));
        fuelMap.put(new RecipesCommon.ComparableStack(ModItems.plate_fuel_pu238be), new ItemStack(ModItems.waste_plate_pu238be, 1, 1));
    }
}

