/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.rbmk;

import api.hbm.fluid.IFluidStandardTransceiver;
import api.hbm.fluidmk2.FluidNode;
import api.hbm.tile.IInfoProviderEC;
import com.hbm.blocks.ModBlocks;
import com.hbm.entity.projectile.EntityRBMKDebris;
import com.hbm.handler.CompatHandler;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.container.ContainerRBMKGeneric;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUIRBMKBoiler;
import com.hbm.lib.Library;
import com.hbm.tileentity.machine.rbmk.RBMKDials;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKConsole;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKSlottedBase;
import com.hbm.uninos.UniNodespace;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")})
public class TileEntityRBMKBoiler
extends TileEntityRBMKSlottedBase
implements IControlReceiver,
IFluidStandardTransceiver,
SimpleComponent,
IInfoProviderEC,
CompatHandler.OCComponent {
    public FluidTank feed = new FluidTank(Fluids.WATER, 10000);
    public FluidTank steam = new FluidTank(Fluids.STEAM, 1000000);
    protected int consumption;
    protected int output;

    public TileEntityRBMKBoiler() {
        super(0);
    }

    @Override
    public String getName() {
        return "container.rbmkBoiler";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.consumption = 0;
            this.output = 0;
            double heatCap = TileEntityRBMKBoiler.getHeatFromSteam(this.steam.getTankType());
            double heatProvided = this.heat - heatCap;
            if (heatProvided > 0.0) {
                int waterUsed;
                int steamProduced;
                double HEAT_PER_MB_WATER = RBMKDials.getBoilerHeatConsumption(this.field_145850_b);
                double steamFactor = TileEntityRBMKBoiler.getFactorFromSteam(this.steam.getTankType());
                if (this.steam.getTankType() == Fluids.ULTRAHOTSTEAM) {
                    steamProduced = (int)Math.floor(heatProvided / HEAT_PER_MB_WATER * 100.0 / steamFactor);
                    waterUsed = (int)Math.floor((double)steamProduced / 100.0 * steamFactor);
                    if (this.feed.getFill() < waterUsed) {
                        steamProduced = (int)Math.floor((double)this.feed.getFill() * 100.0 / steamFactor);
                        waterUsed = (int)Math.floor((double)steamProduced / 100.0 * steamFactor);
                    }
                } else {
                    waterUsed = (int)Math.floor(heatProvided / HEAT_PER_MB_WATER);
                    waterUsed = Math.min(waterUsed, this.feed.getFill());
                    steamProduced = (int)Math.floor((double)waterUsed * 100.0 / steamFactor);
                }
                this.consumption = waterUsed;
                this.output = steamProduced;
                this.feed.setFill(this.feed.getFill() - waterUsed);
                this.steam.setFill(this.steam.getFill() + steamProduced);
                if (this.steam.getFill() > this.steam.getMaxFill()) {
                    this.steam.setFill(this.steam.getMaxFill());
                }
                this.heat -= (double)waterUsed * HEAT_PER_MB_WATER;
            }
            this.trySubscribe(this.feed.getTankType(), this.field_145850_b, this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, Library.NEG_Y);
            for (DirPos pos : this.getOutputPos()) {
                if (this.steam.getFill() <= 0) continue;
                this.sendFluid(this.steam, this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            }
        }
        super.func_145845_h();
    }

    public static double getHeatFromSteam(FluidType type) {
        if (type == Fluids.STEAM) {
            return 100.0;
        }
        if (type == Fluids.HOTSTEAM) {
            return 300.0;
        }
        if (type == Fluids.SUPERHOTSTEAM) {
            return 450.0;
        }
        if (type == Fluids.ULTRAHOTSTEAM) {
            return 600.0;
        }
        return 0.0;
    }

    public static double getFactorFromSteam(FluidType type) {
        if (type == Fluids.STEAM) {
            return 1.0;
        }
        if (type == Fluids.HOTSTEAM) {
            return 10.0;
        }
        if (type == Fluids.SUPERHOTSTEAM) {
            return 100.0;
        }
        if (type == Fluids.ULTRAHOTSTEAM) {
            return 1000.0;
        }
        return 0.0;
    }

    protected DirPos[] getOutputPos() {
        if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) == ModBlocks.rbmk_loader) {
            return new DirPos[]{new DirPos(this.field_145851_c, this.field_145848_d + RBMKDials.getColumnHeight(this.field_145850_b) + 1, this.field_145849_e, Library.POS_Y), new DirPos(this.field_145851_c + 1, this.field_145848_d - 1, this.field_145849_e, Library.POS_X), new DirPos(this.field_145851_c - 1, this.field_145848_d - 1, this.field_145849_e, Library.NEG_X), new DirPos(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e + 1, Library.POS_Z), new DirPos(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e - 1, Library.NEG_Z), new DirPos(this.field_145851_c, this.field_145848_d - 2, this.field_145849_e, Library.NEG_Y)};
        }
        if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 2, this.field_145849_e) == ModBlocks.rbmk_loader) {
            return new DirPos[]{new DirPos(this.field_145851_c, this.field_145848_d + RBMKDials.getColumnHeight(this.field_145850_b) + 1, this.field_145849_e, Library.POS_Y), new DirPos(this.field_145851_c + 1, this.field_145848_d - 2, this.field_145849_e, Library.POS_X), new DirPos(this.field_145851_c - 1, this.field_145848_d - 2, this.field_145849_e, Library.NEG_X), new DirPos(this.field_145851_c, this.field_145848_d - 2, this.field_145849_e + 1, Library.POS_Z), new DirPos(this.field_145851_c, this.field_145848_d - 2, this.field_145849_e - 1, Library.NEG_Z), new DirPos(this.field_145851_c, this.field_145848_d - 3, this.field_145849_e, Library.NEG_Y)};
        }
        return new DirPos[]{new DirPos(this.field_145851_c, this.field_145848_d + RBMKDials.getColumnHeight(this.field_145850_b) + 1, this.field_145849_e, Library.POS_Y)};
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.feed.readFromNBT(nbt, "feed");
        this.steam.readFromNBT(nbt, "steam");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.feed.writeToNBT(nbt, "feed");
        this.steam.writeToNBT(nbt, "steam");
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        this.steam.serialize(buf);
        this.feed.serialize(buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.steam.deserialize(buf);
        this.feed.deserialize(buf);
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return Vec3.func_72443_a((double)((double)this.field_145851_c - player.field_70165_t), (double)((double)this.field_145848_d - player.field_70163_u), (double)((double)this.field_145849_e - player.field_70161_v)).func_72433_c() < 20.0;
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("compression")) {
            this.cyceCompressor();
        }
    }

    public void cyceCompressor() {
        FluidType type = this.steam.getTankType();
        if (type == Fluids.STEAM) {
            this.steam.setTankType(Fluids.HOTSTEAM);
            this.steam.setFill(this.steam.getFill() / 10);
        }
        if (type == Fluids.HOTSTEAM) {
            this.steam.setTankType(Fluids.SUPERHOTSTEAM);
            this.steam.setFill(this.steam.getFill() / 10);
        }
        if (type == Fluids.SUPERHOTSTEAM) {
            this.steam.setTankType(Fluids.ULTRAHOTSTEAM);
            this.steam.setFill(this.steam.getFill() / 10);
        }
        if (type == Fluids.ULTRAHOTSTEAM) {
            this.steam.setTankType(Fluids.STEAM);
            this.steam.setFill(Math.min(this.steam.getFill() * 1000, this.steam.getMaxFill()));
        }
        this.func_70296_d();
    }

    @Override
    public void onMelt(int reduce) {
        int count = 1 + this.field_145850_b.field_73012_v.nextInt(2);
        for (int i = 0; i < count; ++i) {
            this.spawnDebris(EntityRBMKDebris.DebrisType.BLANK);
        }
        if (RBMKDials.getOverpressure(this.field_145850_b)) {
            for (DirPos pos : this.getOutputPos()) {
                FluidNode node = (FluidNode)UniNodespace.getNode(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), this.steam.getTankType().getNetworkProvider());
                if (node.net == null) continue;
                pipes.add(node.net);
            }
        }
        super.onMelt(reduce);
    }

    @Override
    public TileEntityRBMKConsole.ColumnType getConsoleType() {
        return TileEntityRBMKConsole.ColumnType.BOILER;
    }

    @Override
    public NBTTagCompound getNBTForConsole() {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74768_a("water", this.feed.getFill());
        data.func_74768_a("maxWater", this.feed.getMaxFill());
        data.func_74768_a("steam", this.steam.getFill());
        data.func_74768_a("maxSteam", this.steam.getMaxFill());
        data.func_74777_a("type", (short)this.steam.getTankType().getID());
        return data;
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.feed, this.steam};
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.steam};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.feed};
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return "rbmk_boiler";
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getHeat(Context context, Arguments args) {
        return new Object[]{this.heat};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getSteam(Context context, Arguments args) {
        return new Object[]{this.steam.getFill()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getSteamMax(Context context, Arguments args) {
        return new Object[]{this.steam.getMaxFill()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getWater(Context context, Arguments args) {
        return new Object[]{this.feed.getFill()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getWaterMax(Context context, Arguments args) {
        return new Object[]{this.feed.getMaxFill()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getCoordinates(Context context, Arguments args) {
        return new Object[]{this.field_145851_c, this.field_145848_d, this.field_145849_e};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getInfo(Context context, Arguments args) {
        int type_1 = (Integer)CompatHandler.steamTypeToInt(this.steam.getTankType())[0];
        return new Object[]{this.heat, this.steam.getFill(), this.steam.getMaxFill(), this.feed.getFill(), this.feed.getMaxFill(), type_1, this.field_145851_c, this.field_145848_d, this.field_145849_e};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getSteamType(Context context, Arguments args) {
        return CompatHandler.steamTypeToInt(this.steam.getTankType());
    }

    @Callback(direct=true, limit=4)
    @Optional.Method(modid="OpenComputers")
    public Object[] setSteamType(Context context, Arguments args) {
        int type = args.checkInteger(0);
        this.steam.setTankType(CompatHandler.intToSteamType(type));
        return new Object[]{true};
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerRBMKGeneric(player.field_71071_by);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIRBMKBoiler(player.field_71071_by, this);
    }

    @Override
    public void provideExtraInfo(NBTTagCompound data) {
        data.func_74780_a("consumption", (double)this.consumption);
        data.func_74780_a("outputmb", (double)this.output);
    }
}

