/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.storage;

import api.hbm.energymk2.IBatteryItem;
import api.hbm.energymk2.IEnergyConductorMK2;
import api.hbm.energymk2.IEnergyProviderMK2;
import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.energymk2.Nodespace;
import api.hbm.energymk2.PowerNetMK2;
import com.hbm.handler.CompatHandler;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.uninos.UniNodespace;
import com.hbm.util.Compat;
import com.hbm.util.EnumUtil;
import com.hbm.util.fauxpointtwelve.BlockPos;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="opencomputers")})
public abstract class TileEntityBatteryBase
extends TileEntityMachineBase
implements IEnergyConductorMK2,
IEnergyProviderMK2,
IEnergyReceiverMK2,
IControlReceiver,
IGUIProvider,
SimpleComponent,
CompatHandler.OCComponent {
    public byte lastRedstone = 0;
    public long prevPowerState = 0L;
    public static final int mode_input = 0;
    public static final int mode_buffer = 1;
    public static final int mode_output = 2;
    public static final int mode_none = 3;
    public short redLow = 0;
    public short redHigh = (short)2;
    public IEnergyReceiverMK2.ConnectionPriority priority = IEnergyReceiverMK2.ConnectionPriority.LOW;
    protected Nodespace.PowerNode node;
    private short modeCache = 0;

    public TileEntityBatteryBase(int slotCount) {
        super(slotCount);
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            byte comp;
            if (this.priority == null || this.priority.ordinal() == 0 || this.priority.ordinal() == 4) {
                this.priority = IEnergyReceiverMK2.ConnectionPriority.LOW;
            }
            if (this.node == null || this.node.expired) {
                this.node = (Nodespace.PowerNode)UniNodespace.getNode(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, Nodespace.THE_POWER_PROVIDER);
                if (this.node == null || this.node.expired) {
                    this.node = this.createNode();
                    UniNodespace.createNode(this.field_145850_b, this.node);
                }
            }
            if (this.node != null && this.node.hasValidNet()) {
                switch (this.getRelevantMode(false)) {
                    case 0: {
                        ((PowerNetMK2)this.node.net).removeProvider(this);
                        ((PowerNetMK2)this.node.net).addReceiver(this);
                        break;
                    }
                    case 2: {
                        ((PowerNetMK2)this.node.net).addProvider(this);
                        ((PowerNetMK2)this.node.net).removeReceiver(this);
                        break;
                    }
                    case 1: {
                        ((PowerNetMK2)this.node.net).addProvider(this);
                        ((PowerNetMK2)this.node.net).addReceiver(this);
                        break;
                    }
                    case 3: {
                        ((PowerNetMK2)this.node.net).removeProvider(this);
                        ((PowerNetMK2)this.node.net).removeReceiver(this);
                    }
                }
            }
            if ((comp = this.getComparatorPower()) != this.lastRedstone) {
                System.out.println(comp);
                for (BlockPos port : this.getPortPos()) {
                    TileEntity tile = Compat.getTileStandard(this.field_145850_b, port.getX(), port.getY(), port.getZ());
                    if (tile == null) continue;
                    tile.func_70296_d();
                }
            }
            this.lastRedstone = comp;
            this.prevPowerState = this.getPower();
            this.networkPackNT(100);
        }
    }

    public byte getComparatorPower() {
        double frac = (double)this.getPower() / (double)Math.max(this.getMaxPower(), 1L) * 15.0;
        return (byte)MathHelper.func_76125_a((int)((int)Math.round(frac)), (int)0, (int)15);
    }

    @Override
    public Nodespace.PowerNode createNode() {
        return new Nodespace.PowerNode(this.getPortPos()).setConnections(this.getConPos());
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K && this.node != null) {
            UniNodespace.destroyNode(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, Nodespace.THE_POWER_PROVIDER);
        }
    }

    @Override
    public boolean func_94041_b(int i, ItemStack stack) {
        return stack.func_77973_b() instanceof IBatteryItem;
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeShort((int)this.redLow);
        buf.writeShort((int)this.redHigh);
        buf.writeByte(this.priority.ordinal());
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.redLow = buf.readShort();
        this.redHigh = buf.readShort();
        this.priority = (IEnergyReceiverMK2.ConnectionPriority)((Object)EnumUtil.grabEnumSafely(IEnergyReceiverMK2.ConnectionPriority.class, buf.readByte()));
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.redLow = nbt.func_74765_d("redLow");
        this.redHigh = nbt.func_74765_d("redHigh");
        this.lastRedstone = nbt.func_74771_c("lastRedstone");
        this.priority = (IEnergyReceiverMK2.ConnectionPriority)((Object)EnumUtil.grabEnumSafely(IEnergyReceiverMK2.ConnectionPriority.class, nbt.func_74771_c("priority")));
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74777_a("redLow", this.redLow);
        nbt.func_74777_a("redHigh", this.redHigh);
        nbt.func_74774_a("lastRedstone", this.lastRedstone);
        nbt.func_74774_a("priority", (byte)this.priority.ordinal());
    }

    @Override
    public boolean allowDirectProvision() {
        return false;
    }

    @Override
    public IEnergyReceiverMK2.ConnectionPriority getPriority() {
        return this.priority;
    }

    public abstract BlockPos[] getPortPos();

    public abstract DirPos[] getConPos();

    public short getRelevantMode(boolean useCache) {
        if (useCache) {
            return this.modeCache;
        }
        boolean powered = false;
        for (BlockPos pos : this.getPortPos()) {
            if (!this.field_145850_b.func_72864_z(pos.getX(), pos.getY(), pos.getZ())) continue;
            powered = true;
            break;
        }
        this.modeCache = powered ? this.redHigh : this.redLow;
        return this.modeCache;
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return this.func_70300_a(player);
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("low")) {
            this.redLow = (short)(this.redLow + 1);
            if (this.redLow > 3) {
                this.redLow = 0;
            }
        }
        if (data.func_74764_b("high")) {
            this.redHigh = (short)(this.redHigh + 1);
            if (this.redHigh > 3) {
                this.redHigh = 0;
            }
        }
        if (data.func_74764_b("priority")) {
            int ordinal = this.priority.ordinal();
            if (++ordinal > IEnergyReceiverMK2.ConnectionPriority.HIGH.ordinal()) {
                ordinal = IEnergyReceiverMK2.ConnectionPriority.LOW.ordinal();
            }
            this.priority = (IEnergyReceiverMK2.ConnectionPriority)((Object)EnumUtil.grabEnumSafely(IEnergyReceiverMK2.ConnectionPriority.class, ordinal));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return "ntm_energy_storage";
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getEnergyInfo(Context context, Arguments args) {
        return new Object[]{this.getPower(), this.getMaxPower()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getModeInfo(Context context, Arguments args) {
        return new Object[]{this.redLow, this.redHigh, this.getPriority().ordinal() - 1};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] setModeLow(Context context, Arguments args) {
        short newMode = (short)args.checkInteger(0);
        if (newMode >= 0 && newMode <= 3) {
            this.redLow = newMode;
            return new Object[0];
        }
        return new Object[]{"Invalid mode"};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] setModeHigh(Context context, Arguments args) {
        short newMode = (short)args.checkInteger(0);
        if (newMode >= 0 && newMode <= 3) {
            this.redHigh = newMode;
            return new Object[0];
        }
        return new Object[]{"Invalid mode"};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] setPriority(Context context, Arguments args) {
        int newPriority = args.checkInteger(0);
        if (newPriority >= 0 && newPriority <= 2) {
            this.priority = (IEnergyReceiverMK2.ConnectionPriority)((Object)EnumUtil.grabEnumSafely(IEnergyReceiverMK2.ConnectionPriority.class, newPriority + 1));
            return new Object[0];
        }
        return new Object[]{"Invalid mode"};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getInfo(Context context, Arguments args) {
        return new Object[]{this.getPower(), this.getMaxPower(), this.redLow, this.redHigh, this.getPriority().ordinal() - 1};
    }
}

