/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.cli;

import com.hivemc.chunker.cli.messenger.Messenger;
import com.hivemc.chunker.conversion.WorldConverter;
import com.hivemc.chunker.conversion.encoding.EncodingType;
import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.encoding.base.writer.LevelWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import picocli.CommandLine;

public class EncodingTypeValidator
implements CommandLine.ITypeConverter<String> {
    public static List<String> getWriterIDs() {
        ArrayList<String> writers = new ArrayList<String>();
        for (EncodingType encodingType : EncodingType.getWriteableTypes()) {
            Collection<Version> versions = encodingType.getSupportedVersions();
            if (versions == null || versions.isEmpty()) {
                writers.add(encodingType.getName().toUpperCase(Locale.ROOT));
                continue;
            }
            for (Version version : versions) {
                writers.add(Messenger.toEncodedString(encodingType, version));
            }
        }
        return writers;
    }

    @Override
    public String convert(String value) throws Exception {
        WorldConverter dummy = new WorldConverter(null);
        Optional<? extends LevelWriter> writer = Messenger.findWriter(value, dummy, null);
        if (writer.isEmpty()) {
            List<String> writers = EncodingTypeValidator.getWriterIDs();
            throw new CommandLine.TypeConversionException("Invalid value '" + value + "', should be one of the following values: " + String.join((CharSequence)", ", writers));
        }
        return value;
    }
}

