/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multimaps;
import com.google.gson.JsonObject;
import com.hivemc.chunker.conversion.encoding.base.Converter;
import com.hivemc.chunker.conversion.encoding.base.reader.LevelReader;
import com.hivemc.chunker.conversion.encoding.base.writer.LevelWriter;
import com.hivemc.chunker.conversion.handlers.ColumnConversionHandler;
import com.hivemc.chunker.conversion.handlers.LevelConversionHandler;
import com.hivemc.chunker.conversion.handlers.WorldConversionHandler;
import com.hivemc.chunker.conversion.handlers.pipeline.Pipeline;
import com.hivemc.chunker.conversion.handlers.pretransform.ColumnPreTransformConversionHandler;
import com.hivemc.chunker.conversion.handlers.pretransform.ColumnPreTransformWriterConversionHandler;
import com.hivemc.chunker.conversion.handlers.writer.LevelWriterConversionHandler;
import com.hivemc.chunker.conversion.intermediate.column.chunk.ChunkCoordPair;
import com.hivemc.chunker.conversion.intermediate.column.chunk.RegionCoordPair;
import com.hivemc.chunker.conversion.intermediate.level.ChunkerLevel;
import com.hivemc.chunker.conversion.intermediate.level.ChunkerLevelSettings;
import com.hivemc.chunker.conversion.intermediate.level.map.ChunkerMap;
import com.hivemc.chunker.conversion.intermediate.world.ChunkerWorld;
import com.hivemc.chunker.conversion.intermediate.world.Dimension;
import com.hivemc.chunker.mapping.resolver.MappingsFileResolvers;
import com.hivemc.chunker.pruning.PruningConfig;
import com.hivemc.chunker.pruning.PruningRegion;
import com.hivemc.chunker.scheduling.task.Environment;
import com.hivemc.chunker.scheduling.task.Task;
import com.hivemc.chunker.scheduling.task.TaskWeight;
import com.hivemc.chunker.scheduling.task.TrackedTask;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorldConverter
implements Converter {
    public static final String SIGNAL_COMPACTION = "signal_compaction";
    private final UUID sessionID;
    @Nullable
    protected Consumer<Boolean> compactionSignalConsumer;
    @Nullable
    protected ChunkerLevel level;
    @Nullable
    protected LevelReader reader = null;
    @Nullable
    protected LevelWriter writer = null;
    @Nullable
    protected Environment environment = null;
    protected Multimap<Converter.MissingMappingType, String> missingIdentifiers = Multimaps.synchronizedSetMultimap(MultimapBuilder.enumKeys(Converter.MissingMappingType.class).hashSetValues().build());
    @Nullable
    private Map<Dimension, PruningConfig> pruningConfigs;
    @Nullable
    private Map<Dimension, Dimension> dimensionMapping;
    @Nullable
    private JsonObject changedSettings;
    @Nullable
    private List<ChunkerMap> maps;
    @Nullable
    private MappingsFileResolvers blockMappings;
    private boolean levelDBCompaction = false;
    private boolean processMaps = true;
    private boolean processItems = true;
    private boolean processEntities = true;
    private boolean processBlockEntities = true;
    private boolean processLootTables = true;
    private boolean processBiomes = true;
    private boolean processHeightMap = true;
    private boolean processLighting = true;
    private boolean processColumnPreTransform = true;
    private boolean allowNBTCopying = false;
    private boolean discardEmptyChunks = false;
    private boolean preventYBiomeBlending = false;
    private boolean customIdentifiers = true;
    private boolean exceptions = false;
    private boolean cancelled = false;

    public WorldConverter(UUID sessionID) {
        this.sessionID = sessionID;
    }

    public void setCompactionSignal(@Nullable Consumer<Boolean> compactionSignalConsumer) {
        this.compactionSignalConsumer = compactionSignalConsumer;
    }

    public void setPruningConfigs(@Nullable Map<Dimension, PruningConfig> pruningConfigs) {
        this.pruningConfigs = pruningConfigs;
    }

    public void setDimensionMapping(@Nullable Map<Dimension, Dimension> dimensionMapping) {
        this.dimensionMapping = dimensionMapping;
    }

    public void setLevelDBCompaction(boolean levelDBCompaction) {
        this.levelDBCompaction = levelDBCompaction;
    }

    public void setProcessMaps(boolean processMaps) {
        this.processMaps = processMaps;
    }

    public void setPreventYBiomeBlending(boolean preventYBiomeBlending) {
        this.preventYBiomeBlending = preventYBiomeBlending;
    }

    public void setProcessItems(boolean processItems) {
        this.processItems = processItems;
    }

    public void setProcessEntities(boolean processEntities) {
        this.processEntities = processEntities;
    }

    public void setProcessBlockEntities(boolean processBlockEntities) {
        this.processBlockEntities = processBlockEntities;
    }

    public void setProcessLootTables(boolean processLootTables) {
        this.processLootTables = processLootTables;
    }

    public void setProcessBiomes(boolean processBiomes) {
        this.processBiomes = processBiomes;
    }

    public void setProcessHeightMap(boolean processHeightMap) {
        this.processHeightMap = processHeightMap;
    }

    public void setProcessLighting(boolean processLighting) {
        this.processLighting = processLighting;
    }

    public void setAllowNBTCopying(boolean allowNBTCopying) {
        this.allowNBTCopying = allowNBTCopying;
    }

    public void setDiscardEmptyChunks(boolean discardEmptyChunks) {
        this.discardEmptyChunks = discardEmptyChunks;
    }

    public void setProcessColumnPreTransform(boolean processColumnPreTransform) {
        this.processColumnPreTransform = processColumnPreTransform;
    }

    public void setCustomIdentifiers(boolean customIdentifiers) {
        this.customIdentifiers = customIdentifiers;
    }

    @Override
    public boolean shouldLevelDBCompaction() {
        return this.levelDBCompaction;
    }

    @Override
    public boolean shouldProcessMaps() {
        return this.processMaps;
    }

    @Override
    public boolean shouldProcessItems() {
        return this.processItems;
    }

    @Override
    public boolean shouldProcessEntities() {
        return this.processEntities;
    }

    @Override
    public boolean shouldProcessBlockEntities() {
        return this.processBlockEntities;
    }

    @Override
    public boolean shouldProcessLootTables() {
        return this.processLootTables;
    }

    @Override
    public boolean shouldProcessBiomes() {
        return this.processBiomes;
    }

    @Override
    public boolean shouldProcessHeightMap() {
        return this.processHeightMap;
    }

    @Override
    public boolean shouldProcessColumnPreTransform() {
        return this.processColumnPreTransform;
    }

    @Override
    public boolean shouldProcessLighting() {
        return this.processLighting;
    }

    @Override
    public boolean shouldPreventYBiomeBlending() {
        return this.preventYBiomeBlending;
    }

    @Override
    public boolean shouldProcessDimension(Dimension dimension) {
        return this.dimensionMapping == null || this.dimensionMapping.containsKey((Object)dimension);
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean isExceptions() {
        return this.exceptions;
    }

    public Multimap<Converter.MissingMappingType, String> getMissingIdentifiers() {
        return this.missingIdentifiers;
    }

    @Override
    public boolean shouldProcessRegion(Dimension dimension, RegionCoordPair regionPair) {
        if (this.pruningConfigs == null || this.pruningConfigs.isEmpty()) {
            return true;
        }
        PruningConfig pruningConfig = this.pruningConfigs.get((Object)dimension);
        if (pruningConfig == null || pruningConfig.getRegions() == null || pruningConfig.getRegions().isEmpty()) {
            return true;
        }
        ChunkCoordPair minRegionChunk = regionPair.getChunk(0, 0);
        ChunkCoordPair maxRegionChunk = regionPair.getChunk(31, 31);
        for (PruningRegion region : pruningConfig.getRegions()) {
            if (pruningConfig.isInclude()) {
                boolean overlap = maxRegionChunk.chunkX() >= region.getMinChunkX() && minRegionChunk.chunkX() <= region.getMaxChunkX() && maxRegionChunk.chunkZ() >= region.getMinChunkZ() && minRegionChunk.chunkZ() <= region.getMaxChunkZ();
                if (!overlap) continue;
                return true;
            }
            boolean fullyContained = minRegionChunk.chunkX() >= region.getMinChunkX() && maxRegionChunk.chunkX() <= region.getMaxChunkX() && minRegionChunk.chunkZ() >= region.getMinChunkZ() && maxRegionChunk.chunkZ() <= region.getMaxChunkZ();
            if (!fullyContained) continue;
            return false;
        }
        return !pruningConfig.isInclude();
    }

    @Override
    public boolean shouldProcessColumn(Dimension dimension, ChunkCoordPair columnPair) {
        if (this.pruningConfigs == null || this.pruningConfigs.isEmpty()) {
            return true;
        }
        PruningConfig pruningConfig = this.pruningConfigs.get((Object)dimension);
        if (pruningConfig == null || pruningConfig.getRegions() == null || pruningConfig.getRegions().isEmpty()) {
            return true;
        }
        for (PruningRegion region : pruningConfig.getRegions()) {
            if (columnPair.chunkX() < region.getMinChunkX() || columnPair.chunkX() > region.getMaxChunkX() || columnPair.chunkZ() < region.getMinChunkZ() || columnPair.chunkZ() > region.getMaxChunkZ()) continue;
            return pruningConfig.isInclude();
        }
        return !pruningConfig.isInclude();
    }

    @Override
    public boolean shouldAllowNBTCopying() {
        return this.allowNBTCopying;
    }

    @Override
    public boolean shouldAllowCustomIdentifiers() {
        return this.customIdentifiers;
    }

    @Override
    @Nullable
    public MappingsFileResolvers getBlockMappings() {
        return this.blockMappings;
    }

    public void setBlockMappings(@Nullable MappingsFileResolvers blockMappings) {
        this.blockMappings = blockMappings;
    }

    @Override
    public boolean shouldDiscardEmptyChunks() {
        return this.discardEmptyChunks;
    }

    @Override
    public Optional<Dimension> getNewDimension(Dimension dimension) {
        return this.dimensionMapping == null ? Optional.of(dimension) : Optional.ofNullable(this.dimensionMapping.get((Object)dimension));
    }

    @Override
    public void logNonFatalException(Throwable throwable) {
        this.exceptions = true;
        Converter.super.logNonFatalException(throwable);
    }

    public void logFatalException(Throwable throwable) {
        this.cancel(throwable);
        this.logNonFatalException(throwable);
    }

    public void handleSignal(String signalName, Object signalValue) {
        if (signalName.equals(SIGNAL_COMPACTION)) {
            if (this.compactionSignalConsumer == null) {
                return;
            }
            this.compactionSignalConsumer.accept((Boolean)signalValue);
        }
    }

    @Override
    public void logMissingMapping(Converter.MissingMappingType type, String identifier) {
        if (this.missingIdentifiers.put(type, identifier)) {
            Converter.super.logMissingMapping(type, identifier);
        }
    }

    @Override
    public Optional<ChunkerLevel> level() {
        return Optional.ofNullable(this.level);
    }

    @Nullable
    public JsonObject getChangedSettings() {
        return this.changedSettings;
    }

    public void setChangedSettings(@Nullable JsonObject changedSettings) {
        this.changedSettings = changedSettings;
    }

    public void setMaps(@Nullable List<ChunkerMap> maps) {
        this.maps = maps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TrackedTask<Void> convert(@NotNull LevelReader reader, @NotNull LevelWriter writer) {
        this.reader = reader;
        this.writer = writer;
        this.cancelled = false;
        this.exceptions = false;
        this.missingIdentifiers.clear();
        this.environment = Task.environment("World Conversion", 8, this::logFatalException, this::handleSignal);
        try {
            LevelWriterConversionHandler writerHandler = new LevelWriterConversionHandler(writer);
            Pipeline pipeline = new Pipeline(writerHandler);
            this.level = null;
            pipeline.levelHandlers(delegate -> new LevelHandler(this, (LevelConversionHandler)delegate));
            pipeline.worldHandlers((delegate, level) -> new WorldHandler(this, (WorldConversionHandler)delegate));
            if (this.shouldProcessColumnPreTransform()) {
                pipeline.columnHandlers((delegate, world) -> new ColumnPreTransformWriterConversionHandler(writer::getPreTransformManager, (ColumnConversionHandler)delegate, true), ColumnPreTransformConversionHandler::new);
            } else {
                pipeline.columnHandlers((delegate, world) -> new ColumnPreTransformWriterConversionHandler(writer::getPreTransformManager, (ColumnConversionHandler)delegate, false));
            }
            LevelConversionHandler handler = pipeline.build();
            Task.asyncConsume("Reading Level", TaskWeight.NORMAL, reader::readLevel, handler);
            Environment environment = this.environment;
            return environment;
        }
        finally {
            this.environment.close();
            this.environment.setFreeCallback(() -> {
                try {
                    reader.free();
                }
                catch (Throwable e) {
                    try {
                        this.logNonFatalException(e);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                try {
                    writer.free();
                }
                catch (Throwable e) {
                    try {
                        this.logNonFatalException(e);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
        }
    }

    public CompletableFuture<Void> cancel(@Nullable Throwable fatalException) {
        this.cancelled = true;
        if (this.environment != null) {
            this.environment.cancel(fatalException);
            return this.environment.future();
        }
        return CompletableFuture.completedFuture(null);
    }

    static class WorldHandler
    implements WorldConversionHandler {
        private final WorldConverter worldConverter;
        private final WorldConversionHandler delegate;

        public WorldHandler(WorldConverter worldConverter, WorldConversionHandler delegate) {
            this.worldConverter = worldConverter;
            this.delegate = delegate;
        }

        @Override
        public Task<ColumnConversionHandler> convertWorld(ChunkerWorld world) {
            Optional<Dimension> newDimension = this.worldConverter.getNewDimension(world.getDimension());
            if (newDimension.isPresent()) {
                world.setDimension(newDimension.get());
                return this.delegate.convertWorld(world);
            }
            return Task.asyncUnwrap("Empty Dimension", TaskWeight.LOW, () -> null);
        }

        @Override
        public void flushWorld(ChunkerWorld world) {
            this.delegate.flushWorld(world);
        }

        @Override
        public void flushWorlds() {
            this.delegate.flushWorlds();
        }
    }

    static class LevelHandler
    implements LevelConversionHandler {
        private final WorldConverter worldConverter;
        private final LevelConversionHandler delegate;

        public LevelHandler(WorldConverter worldConverter, LevelConversionHandler delegate) {
            this.worldConverter = worldConverter;
            this.delegate = delegate;
        }

        @Override
        public Task<WorldConversionHandler> convertLevel(ChunkerLevel level) {
            if (this.worldConverter.maps != null) {
                level.setMaps(this.worldConverter.maps);
            }
            level.getMaps().removeIf(map -> {
                Optional<Dimension> newDimension = this.worldConverter.getNewDimension(map.getDimension());
                if (newDimension.isPresent()) {
                    map.setDimension(newDimension.get());
                    return false;
                }
                return true;
            });
            level.getPortals().removeIf(portal -> {
                Optional<Dimension> newDimension = this.worldConverter.getNewDimension(portal.getDimension());
                if (newDimension.isPresent()) {
                    portal.setDimension(newDimension.get());
                    return false;
                }
                return true;
            });
            JsonObject baseSettings = level.getSettings().toJSON();
            if (this.worldConverter.getChangedSettings() != null) {
                baseSettings.asMap().putAll(this.worldConverter.getChangedSettings().asMap());
            }
            level.setSettings(ChunkerLevelSettings.fromJSON(baseSettings));
            this.worldConverter.level = level;
            return this.delegate.convertLevel(level);
        }

        @Override
        public void flushLevel() {
            this.delegate.flushLevel();
        }
    }
}

