/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.base.resolver.entity;

import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.encoding.base.resolver.entity.DoNotProcessEntityHandler;
import com.hivemc.chunker.conversion.encoding.base.resolver.entity.DoNotWriteEntityHandler;
import com.hivemc.chunker.conversion.encoding.base.resolver.entity.GenerateBeforeProcessEntityHandler;
import com.hivemc.chunker.conversion.encoding.base.resolver.entity.GenerateBeforeWriteEntityHandler;
import com.hivemc.chunker.conversion.encoding.base.resolver.entity.UpdateBeforeProcessEntityHandler;
import com.hivemc.chunker.conversion.encoding.base.resolver.entity.UpdateBeforeWriteEntityHandler;
import com.hivemc.chunker.conversion.intermediate.column.ChunkerColumn;
import com.hivemc.chunker.conversion.intermediate.column.chunk.ChunkerChunk;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.ChunkerBlockIdentifier;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.ChunkerBlockType;
import com.hivemc.chunker.conversion.intermediate.column.chunk.palette.Palette;
import com.hivemc.chunker.conversion.intermediate.column.entity.Entity;
import com.hivemc.chunker.conversion.intermediate.column.entity.UnknownEntity;
import com.hivemc.chunker.conversion.intermediate.column.entity.type.ChunkerEntityType;
import com.hivemc.chunker.resolver.hierarchy.KeyedHierarchyBasedResolver;
import com.hivemc.chunker.resolver.hierarchy.TypeHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public abstract class EntityResolver<R, D>
extends KeyedHierarchyBasedResolver<R, ChunkerEntityType, D, Entity> {
    protected final boolean preserveUnknownEntities;
    protected Map<TypeHandler<R, ChunkerEntityType, D, ? extends Entity>, Map<Class<?>, Collection<Object>>> interfaceHandlerCache;
    protected Map<ChunkerBlockType, TypeHandler<R, ChunkerEntityType, D, ? extends Entity>> generateBeforeProcessEntityHandlers;
    protected Map<ChunkerBlockType, TypeHandler<R, ChunkerEntityType, D, ? extends Entity>> generateBeforeWriteEntityHandlers;

    public EntityResolver(Version version, R resolvers, boolean preserveUnknownEntities) {
        super(version, resolvers);
        this.preserveUnknownEntities = preserveUnknownEntities;
    }

    @Override
    protected void init() {
        this.interfaceHandlerCache = new ConcurrentHashMap();
        this.generateBeforeProcessEntityHandlers = new ConcurrentHashMap<ChunkerBlockType, TypeHandler<R, ChunkerEntityType, D, ? extends Entity>>();
        this.generateBeforeWriteEntityHandlers = new ConcurrentHashMap<ChunkerBlockType, TypeHandler<R, ChunkerEntityType, D, ? extends Entity>>();
    }

    @Override
    protected void register(TypeHandler<R, ChunkerEntityType, D, ? extends Entity> typeHandler) {
        Object handler;
        super.register(typeHandler);
        if (typeHandler instanceof GenerateBeforeWriteEntityHandler) {
            handler = (GenerateBeforeWriteEntityHandler)((Object)typeHandler);
            for (ChunkerBlockType type : handler.getGenerateBeforeWriteBlockTypes()) {
                this.generateBeforeWriteEntityHandlers.put(type, typeHandler);
            }
        }
        if (typeHandler instanceof GenerateBeforeProcessEntityHandler) {
            handler = (GenerateBeforeProcessEntityHandler)((Object)typeHandler);
            for (ChunkerBlockType type : handler.getGenerateBeforeProcessBlockTypes()) {
                this.generateBeforeProcessEntityHandlers.put(type, typeHandler);
            }
        }
        if (typeHandler instanceof UpdateBeforeWriteEntityHandler && (handler = (UpdateBeforeWriteEntityHandler)((Object)typeHandler)).getAdditionalHandledClass() != null && handler.getAdditionalHandledClass() != typeHandler.getHandledClass()) {
            this.classHandlerLookup.putIfAbsent(handler.getAdditionalHandledClass(), typeHandler);
        }
        this.interfaceHandlerCache.clear();
    }

    private <T> Collection<Object> generateInterfaceHandlers(Class<T> interfaceClass, TypeHandler<R, ChunkerEntityType, D, ? extends Entity> lastHandler) {
        Collection<TypeHandler<R, ChunkerEntityType, D, Entity>> handlers = this.getTypeHandlers(lastHandler);
        if (handlers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Object> copy = new ArrayList<Object>(handlers.size());
        for (TypeHandler<R, ChunkerEntityType, D, ? extends Entity> typeHandler : handlers) {
            if (!interfaceClass.isInstance(typeHandler)) continue;
            copy.add(interfaceClass.cast(typeHandler));
        }
        return copy;
    }

    public <T, U extends T> Collection<U> getInterfaceHandlers(Class<T> interfaceClass, TypeHandler<R, ChunkerEntityType, D, ? extends Entity> lastHandler) {
        Map interfaceLookup = this.interfaceHandlerCache.computeIfAbsent(lastHandler, handler -> new ConcurrentHashMap());
        Collection handlers = interfaceLookup.computeIfAbsent(interfaceClass, handler -> this.generateInterfaceHandlers(interfaceClass, lastHandler));
        return handlers;
    }

    public <T extends Entity> boolean shouldRemoveBeforeProcess(ChunkerColumn column, T entity) {
        Optional lastHandler = this.getFromTypeHandler(entity);
        if (lastHandler.isEmpty()) {
            return false;
        }
        Collection handlers = this.getInterfaceHandlers(DoNotProcessEntityHandler.class, lastHandler.get());
        if (handlers.isEmpty()) {
            return false;
        }
        for (DoNotProcessEntityHandler handler : handlers) {
            if (!handler.shouldRemoveBeforeProcess(column, entity)) continue;
            return true;
        }
        return false;
    }

    public <T extends Entity> boolean shouldRemoveBeforeWrite(ChunkerColumn column, T entity) {
        Optional lastHandler = this.getFromTypeHandler(entity);
        if (lastHandler.isEmpty()) {
            return false;
        }
        Collection handlers = this.getInterfaceHandlers(DoNotWriteEntityHandler.class, lastHandler.get());
        if (handlers.isEmpty()) {
            return false;
        }
        for (DoNotWriteEntityHandler handler : handlers) {
            if (!handler.shouldRemoveBeforeWrite(column, entity)) continue;
            return true;
        }
        return false;
    }

    public <T extends Entity> T updateBeforeProcess(ChunkerColumn column, T entity) {
        Optional lastHandler = this.getFromTypeHandler(entity);
        if (lastHandler.isEmpty()) {
            return entity;
        }
        Collection handlers = this.getInterfaceHandlers(UpdateBeforeProcessEntityHandler.class, lastHandler.get());
        if (handlers.isEmpty()) {
            return entity;
        }
        for (UpdateBeforeProcessEntityHandler handler : handlers) {
            entity = handler.updateBeforeProcess(this.resolvers, column, entity);
        }
        return entity;
    }

    public <T extends Entity> T updateBeforeWrite(ChunkerColumn column, T entity) {
        Optional lastHandler = this.getFromTypeHandler(entity);
        if (lastHandler.isEmpty()) {
            return entity;
        }
        Collection handlers = this.getInterfaceHandlers(UpdateBeforeWriteEntityHandler.class, lastHandler.get());
        if (handlers.isEmpty()) {
            return entity;
        }
        for (UpdateBeforeWriteEntityHandler handler : handlers) {
            entity = handler.updateBeforeWrite(this.resolvers, column, entity);
        }
        return entity;
    }

    public void generateBeforeProcessEntities(ChunkerColumn column, ChunkerChunk chunk) {
        Palette<ChunkerBlockIdentifier> palette = chunk.getPalette();
        if (!chunk.getPalette().containsKey(a -> this.generateBeforeProcessEntityHandlers.containsKey(a.getType()))) {
            return;
        }
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    ChunkerBlockIdentifier entry = palette.get(x, y, z, ChunkerBlockIdentifier.AIR);
                    TypeHandler<R, ChunkerEntityType, D, Entity> lastHandler = this.generateBeforeProcessEntityHandlers.get(entry.getType());
                    if (lastHandler == null) continue;
                    Entity entity = Objects.requireNonNull(lastHandler.construct());
                    entity.setPositionX(column.getPosition().chunkX() << 4 | x);
                    entity.setPositionY(chunk.getY() << 4 | y);
                    entity.setPositionZ(column.getPosition().chunkZ() << 4 | z);
                    column.getEntities().add(entity);
                    Collection handlers = this.getInterfaceHandlers(GenerateBeforeProcessEntityHandler.class, lastHandler);
                    if (handlers.isEmpty()) {
                        return;
                    }
                    for (GenerateBeforeProcessEntityHandler handler : handlers) {
                        handler.generateBeforeProcess(column, x, y, z, entity, entry);
                    }
                }
            }
        }
    }

    public void generateBeforeWriteEntities(ChunkerColumn column, ChunkerChunk chunk) {
        Palette<ChunkerBlockIdentifier> palette = chunk.getPalette();
        if (!chunk.getPalette().containsKey(a -> this.generateBeforeWriteEntityHandlers.containsKey(a.getType()))) {
            return;
        }
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                for (int z = 0; z < 16; ++z) {
                    ChunkerBlockIdentifier entry = palette.get(x, y, z, ChunkerBlockIdentifier.AIR);
                    TypeHandler<R, ChunkerEntityType, D, Entity> lastHandler = this.generateBeforeWriteEntityHandlers.get(entry.getType());
                    if (lastHandler == null) continue;
                    Entity entity = Objects.requireNonNull(lastHandler.construct());
                    entity.setPositionX(column.getPosition().chunkX() << 4 | x);
                    entity.setPositionY(chunk.getY() << 4 | y);
                    entity.setPositionZ(column.getPosition().chunkZ() << 4 | z);
                    column.getEntities().add(entity);
                    Collection handlers = this.getInterfaceHandlers(GenerateBeforeWriteEntityHandler.class, lastHandler);
                    if (handlers.isEmpty()) {
                        return;
                    }
                    for (GenerateBeforeWriteEntityHandler handler : handlers) {
                        handler.generateBeforeWrite(column, x, y, z, entity, entry);
                    }
                }
            }
        }
    }

    @Override
    public Optional<D> from(Entity input) {
        Object output;
        Optional entityHandler;
        if (input instanceof UnknownEntity && this.preserveUnknownEntities && (entityHandler = this.getFromClassTypeHandler(Entity.class)).isPresent() && (output = this.constructDataType(input.getEntityType())) != null) {
            entityHandler.get().write(this.resolvers, output, input);
            return Optional.of(output);
        }
        return super.from(input);
    }

    @Override
    public Optional<Entity> to(Class<? extends Entity> type, D input) {
        if (type == UnknownEntity.class && this.preserveUnknownEntities) {
            UnknownEntity unknownEntity = new UnknownEntity(this.getKey(input).orElse(null));
            Optional blockEntityHandler = this.getFromClassTypeHandler(Entity.class);
            if (blockEntityHandler.isPresent()) {
                blockEntityHandler.get().read(this.resolvers, input, unknownEntity);
                return Optional.of(unknownEntity);
            }
        }
        return super.to(type, input);
    }

    @Override
    public Optional<Entity> to(D input) {
        Optional<Entity> result = super.to(input);
        if (result.isEmpty() && this.preserveUnknownEntities) {
            return this.to((Class<? extends Entity>)UnknownEntity.class, input);
        }
        return result;
    }
}

