/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.base.resolver.identifier.state;

import com.google.common.base.Preconditions;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.BlockStateValue;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class TypeMapping<I, O extends BlockStateValue> {
    private final Map<List<I>, List<O>> inputToOutput;
    private final Map<List<O>, List<I>> outputToInput;
    @Nullable
    private final List<I> defaultInput;
    @Nullable
    private final List<O> defaultOutput;
    private final List<Class<? super I>> inputTypes;
    private final List<Class<? super O>> outputTypes;

    public TypeMapping(Map<List<I>, List<O>> inputToOutput, Map<List<O>, List<I>> outputToInput, @Nullable List<I> defaultInput, @Nullable List<O> defaultOutput, List<Class<? super I>> inputTypes, List<Class<? super O>> outputTypes) {
        this.inputToOutput = inputToOutput;
        this.outputToInput = outputToInput;
        this.defaultInput = defaultInput;
        this.defaultOutput = defaultOutput;
        this.inputTypes = inputTypes;
        this.outputTypes = outputTypes;
    }

    public Map<List<I>, List<O>> getInputToOutput() {
        return this.inputToOutput;
    }

    public Map<List<O>, List<I>> getOutputToInput() {
        return this.outputToInput;
    }

    @Nullable
    public List<I> getDefaultInput() {
        return this.defaultInput;
    }

    @Nullable
    public List<O> getDefaultOutput() {
        return this.defaultOutput;
    }

    public List<Class<? super I>> getInputTypes() {
        return this.inputTypes;
    }

    public List<Class<? super O>> getOutputTypes() {
        return this.outputTypes;
    }

    @SafeVarargs
    public final <I2> TypeMapping<I2, O> mapOutputsToInputs(TypeMapping<? extends I2, ? extends O> ... outputMappings) {
        List<I2> newInputList;
        BlockStateValue output;
        int i;
        Builder builder = new Builder();
        Preconditions.checkArgument(this.getOutputTypes().size() == outputMappings.length, "The number of outputs for the type must match outputMappings");
        for (Map.Entry<List<I>, List<O>> entry : this.getInputToOutput().entrySet()) {
            List<I> inputs = this.getOutputToInput().get(entry.getValue());
            if (!inputs.equals(entry.getKey())) continue;
            ArrayList<I2> newInputs = new ArrayList<I2>(outputMappings.length);
            List<O> outputs = entry.getValue();
            for (i = 0; i < outputs.size(); ++i) {
                output = (BlockStateValue)outputs.get(i);
                newInputList = outputMappings[i].getOutputToInput().get(List.of(output));
                Preconditions.checkNotNull(newInputList, "Missing output " + String.valueOf(output) + " from inputMappings[" + i + "]");
                Preconditions.checkArgument(newInputList.size() == 1, "Mapping of inputs can only use types with a single input and output");
                newInputs.add(newInputList.get(0));
            }
            builder.mapping(newInputs, outputs);
        }
        for (Map.Entry<List<Object>, List<Object>> entry : this.getOutputToInput().entrySet()) {
            List<Object> outputs = entry.getKey();
            List<O> reversedOutputs = this.getInputToOutput().get(entry.getValue());
            if (reversedOutputs.equals(outputs)) continue;
            ArrayList<I2> newInputs = new ArrayList<I2>(outputMappings.length);
            for (i = 0; i < reversedOutputs.size(); ++i) {
                output = (BlockStateValue)reversedOutputs.get(i);
                newInputList = outputMappings[i].getOutputToInput().get(List.of(output));
                Preconditions.checkNotNull(newInputList, "Missing output " + String.valueOf(output) + " from inputMappings[" + i + "]");
                Preconditions.checkArgument(newInputList.size() == 1, "Mapping of inputs can only use types with a single input and output");
                newInputs.add(newInputList.get(0));
            }
            builder.mapping(newInputs, outputs);
        }
        return builder.build();
    }

    public static final class Builder<I, O extends BlockStateValue> {
        private final Map<List<I>, List<O>> inputToOutput = new Object2ObjectOpenHashMap<List<I>, List<O>>();
        private final Map<List<O>, List<I>> outputToInput = new Object2ObjectOpenHashMap<List<O>, List<I>>();
        private List<I> defaultInput;
        private List<O> defaultOutput;
        private List<Class<? super I>> inputTypes;
        private List<Class<? super O>> outputTypes;

        private void checkInputSize(List<I> inputs) {
            if (inputs == null) {
                return;
            }
            if (this.inputTypes == null) {
                this.inputTypes = new ArrayList<Class<? super I>>(inputs.size());
                for (I input : inputs) {
                    this.inputTypes.add(input.getClass());
                }
            } else {
                Preconditions.checkArgument(this.inputTypes.size() == inputs.size(), "The number of state inputs must be consistent across all mappings, expected %s inputs.", this.inputTypes.size());
                for (int i = 0; i < inputs.size(); ++i) {
                    I input = inputs.get(i);
                    Class<I> expectedType = this.inputTypes.get(i);
                    Preconditions.checkArgument(expectedType.isAssignableFrom(input.getClass()), "Input parameter must be the same type throughout the type mapping, got %s expected %s.", input.getClass(), expectedType);
                }
            }
        }

        private void checkOutputSize(List<O> outputs) {
            if (outputs == null) {
                return;
            }
            if (this.outputTypes == null) {
                this.outputTypes = new ArrayList<Class<? super O>>(outputs.size());
                for (BlockStateValue output : outputs) {
                    this.outputTypes.add(output.getClass());
                }
            } else {
                Preconditions.checkArgument(this.outputTypes.size() == outputs.size(), "The number of state outputs must be consistent across all mappings, expected %s outputs.", this.outputTypes.size());
                for (int i = 0; i < outputs.size(); ++i) {
                    BlockStateValue output = (BlockStateValue)outputs.get(i);
                    Class<O> expectedType = this.outputTypes.get(i);
                    Preconditions.checkArgument(expectedType.isAssignableFrom(output.getClass()), "Output parameter must be the same type throughout the type mapping, got %s expected %s.", output.getClass(), expectedType);
                }
            }
        }

        public Builder<I, O> defaults(List<I> inputs, List<O> outputs) {
            Preconditions.checkArgument(this.defaultInput == null, "Default inputs have already been set!");
            Preconditions.checkArgument(this.defaultOutput == null, "Default outputs have already been set!");
            this.checkInputSize(inputs);
            this.checkOutputSize(outputs);
            this.defaultInput = inputs;
            this.defaultOutput = outputs;
            return this;
        }

        public Builder<I, O> defaults(I input, O output) {
            return this.defaults((I)List.of(input), List.of(output));
        }

        public Builder<I, O> defaults(I input1, I input2, O output) {
            return this.defaults((I)List.of(input1, input2), List.of(output));
        }

        public Builder<I, O> defaults(I input, O output1, O output2) {
            return this.defaults((I)List.of(input), List.of(output1, output2));
        }

        public Builder<I, O> defaults(List<I> inputs, O output) {
            return this.defaults((I)inputs, List.of(output));
        }

        public Builder<I, O> defaults(I input, List<O> outputs) {
            return this.defaults((I)List.of(input), outputs);
        }

        public Builder<I, O> mapping(List<I> inputs, List<O> outputs) {
            this.checkInputSize(inputs);
            this.checkOutputSize(outputs);
            List<O> originalInputToOutput = this.inputToOutput.putIfAbsent(inputs, outputs);
            List<I> originalOutputToInput = this.outputToInput.putIfAbsent(outputs, inputs);
            if (originalInputToOutput != null && originalOutputToInput != null) {
                throw new IllegalArgumentException("Duplicate mapping of " + String.valueOf(inputs) + " -> " + String.valueOf(outputs));
            }
            return this;
        }

        public Builder<I, O> invalidOutput(O output) {
            return this.mapping((I)null, List.of(output));
        }

        public Builder<I, O> mapping(I input, O output) {
            return this.mapping((I)List.of(input), List.of(output));
        }

        public Builder<I, O> mapping(I input1, I input2, O output) {
            return this.mapping((I)List.of(input1, input2), List.of(output));
        }

        public Builder<I, O> mapping(I input, O output1, O output2) {
            return this.mapping((I)List.of(input), List.of(output1, output2));
        }

        public Builder<I, O> mapping(List<I> inputs, O output) {
            return this.mapping((I)inputs, List.of(output));
        }

        public Builder<I, O> mapping(I input, List<O> outputs) {
            return this.mapping((I)List.of(input), outputs);
        }

        public Builder<I, O> generate(Consumer<Builder<I, O>> immediateConsumer) {
            immediateConsumer.accept(this);
            return this;
        }

        public TypeMapping<I, O> build() {
            Preconditions.checkArgument(!this.inputTypes.isEmpty() || !this.outputTypes.isEmpty(), "Cannot build type mapping with no determined inputs/outputs!");
            return new TypeMapping<I, O>(this.inputToOutput, this.outputToInput, this.defaultInput, this.defaultOutput, this.inputTypes, this.outputTypes);
        }
    }
}

