/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.bedrock.base.reader.pretransform.handlers;

import com.hivemc.chunker.conversion.handlers.pretransform.Edge;
import com.hivemc.chunker.conversion.handlers.pretransform.manager.handler.block.BlockPreTransformHandler;
import com.hivemc.chunker.conversion.intermediate.column.ChunkerColumn;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.ChunkerBlockIdentifier;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.ChunkerVanillaBlockGroups;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.ChunkerVanillaBlockType;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.BlockState;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.vanilla.VanillaBlockStates;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.vanilla.types.FacingDirectionHorizontal;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.vanilla.types.RedstoneConnection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class BedrockRedstonePreTransformHandler
implements BlockPreTransformHandler {
    final Map<BlockPreTransformHandler.Direction, BlockState<RedstoneConnection>> DIRECTION_TO_STATE = Map.of(BlockPreTransformHandler.Direction.NORTH, VanillaBlockStates.REDSTONE_NORTH, BlockPreTransformHandler.Direction.EAST, VanillaBlockStates.REDSTONE_EAST, BlockPreTransformHandler.Direction.SOUTH, VanillaBlockStates.REDSTONE_SOUTH, BlockPreTransformHandler.Direction.WEST, VanillaBlockStates.REDSTONE_WEST);

    @Override
    public Set<Edge> getRequiredEdges(ChunkerColumn column, int x, int y, int z, ChunkerBlockIdentifier blockIdentifier) {
        return Set.of(Edge.ALL_EDGES);
    }

    @Override
    public ChunkerBlockIdentifier handle(ChunkerColumn column, Map<Edge, ChunkerColumn> neighbours, int x, int y, int z, ChunkerBlockIdentifier blockIdentifier) {
        boolean eastWestNone;
        for (BlockPreTransformHandler.Direction direction : BlockPreTransformHandler.Direction.ALL_HORIZONTAL) {
            RedstoneConnection redstoneConnection = this.calculateConnection(blockIdentifier, direction, column, neighbours, x, y, z);
            BlockState<RedstoneConnection> state = this.DIRECTION_TO_STATE.get((Object)direction);
            blockIdentifier = blockIdentifier.copyWith(state, redstoneConnection);
        }
        boolean north = blockIdentifier.getState(VanillaBlockStates.REDSTONE_NORTH) != RedstoneConnection.NONE;
        boolean east = blockIdentifier.getState(VanillaBlockStates.REDSTONE_EAST) != RedstoneConnection.NONE;
        boolean south = blockIdentifier.getState(VanillaBlockStates.REDSTONE_SOUTH) != RedstoneConnection.NONE;
        boolean west = blockIdentifier.getState(VanillaBlockStates.REDSTONE_WEST) != RedstoneConnection.NONE;
        boolean northSouthNone = !north && !south;
        boolean bl = eastWestNone = !east && !west;
        if (!north && eastWestNone) {
            blockIdentifier = blockIdentifier.copyWith(VanillaBlockStates.REDSTONE_NORTH, RedstoneConnection.SIDE);
        }
        if (!east && northSouthNone) {
            blockIdentifier = blockIdentifier.copyWith(VanillaBlockStates.REDSTONE_EAST, RedstoneConnection.SIDE);
        }
        if (!south && eastWestNone) {
            blockIdentifier = blockIdentifier.copyWith(VanillaBlockStates.REDSTONE_SOUTH, RedstoneConnection.SIDE);
        }
        if (!west && northSouthNone) {
            blockIdentifier = blockIdentifier.copyWith(VanillaBlockStates.REDSTONE_WEST, RedstoneConnection.SIDE);
        }
        return blockIdentifier;
    }

    public RedstoneConnection calculateConnection(ChunkerBlockIdentifier source, BlockPreTransformHandler.Direction direction, ChunkerColumn column, Map<Edge, ChunkerColumn> neighbours, int x, int y, int z) {
        ChunkerBlockIdentifier relative = this.getRelative(column, neighbours, x, y, z, direction);
        if (this.canConnect(source, direction, relative)) {
            return RedstoneConnection.SIDE;
        }
        ChunkerBlockIdentifier target = this.getRelative(column, neighbours, x, y + 1, z, direction);
        ChunkerBlockIdentifier above = this.getRelative(column, neighbours, x, y, z, BlockPreTransformHandler.Direction.UP);
        if (this.canConnect(source, direction, target) && !above.getItemStackType().isAllFacesSolid()) {
            return RedstoneConnection.UP;
        }
        target = this.getRelative(column, neighbours, x, y - 1, z, direction);
        if (this.canConnect(source, direction, target) && !relative.getItemStackType().isAllFacesSolid()) {
            return RedstoneConnection.SIDE;
        }
        return RedstoneConnection.NONE;
    }

    public boolean canConnect(ChunkerBlockIdentifier source, BlockPreTransformHandler.Direction direction, ChunkerBlockIdentifier relative) {
        if (!ChunkerVanillaBlockGroups.REDSTONE_CONNECTABLE.contains(relative.getType())) {
            return false;
        }
        if (relative.getType() == ChunkerVanillaBlockType.REPEATER) {
            FacingDirectionHorizontal repeaterDirection = relative.getState(VanillaBlockStates.FACING_HORIZONTAL);
            return !Objects.requireNonNull(repeaterDirection).isAdjacent(direction.asFacingDirectionHorizontal());
        }
        if (relative.getType() == ChunkerVanillaBlockType.OBSERVER) {
            return direction.asFacingDirection() == relative.getState(VanillaBlockStates.FACING_ALL);
        }
        return true;
    }
}

