/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.bedrock.base.resolver;

import com.hivemc.chunker.conversion.encoding.base.Converter;
import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.encoding.base.resolver.blockentity.BlockEntityResolver;
import com.hivemc.chunker.conversion.encoding.base.resolver.entity.EntityResolver;
import com.hivemc.chunker.conversion.encoding.bedrock.BedrockDataVersion;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.BedrockResolvers;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.identifier.BedrockBlockCompoundTag;
import com.hivemc.chunker.conversion.handlers.pretransform.manager.PreTransformManager;
import com.hivemc.chunker.conversion.intermediate.column.biome.ChunkerBiome;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.ChunkerBlockIdentifier;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.ChunkerItemStackIdentifier;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.ChunkerItemStack;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.banner.ChunkerBannerPattern;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.enchantment.ChunkerEnchantmentType;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.potion.ChunkerEffectType;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.potion.ChunkerPotionType;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.trim.ChunkerTrimMaterial;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.trim.ChunkerTrimPattern;
import com.hivemc.chunker.conversion.intermediate.column.entity.PaintingEntity;
import com.hivemc.chunker.conversion.intermediate.column.entity.type.ChunkerEntityType;
import com.hivemc.chunker.conversion.intermediate.world.Dimension;
import com.hivemc.chunker.mapping.identifier.Identifier;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import com.hivemc.chunker.resolver.Resolver;
import java.util.Optional;
import java.util.function.Function;

public class BedrockResolversBuilder {
    private final Converter converter;
    private final Version version;
    private final boolean enableCaching;
    private Resolver<BedrockBlockCompoundTag, Identifier> nbtBlockIdentifierResolver;
    private Resolver<Identifier, ChunkerItemStack> itemIdentifierResolver;
    private Resolver<Identifier, ChunkerBlockIdentifier> blockIdentifierResolver;
    private Resolver<Identifier, ChunkerBlockIdentifier> itemBlockIdentifierResolver;
    private Resolver<String, ChunkerEntityType> entityTypeResolver;
    private Resolver<Integer, ChunkerBiome> biomeIDResolver;
    private Resolver<Integer, ChunkerEffectType> effectIDResolver;
    private Resolver<Integer, ChunkerEnchantmentType> enchantmentIDResolver;
    private Resolver<String, PaintingEntity.Motive> paintingMotiveResolver;
    private Resolver<Integer, ChunkerPotionType> potionIDResolver;
    private Resolver<String, ChunkerTrimPattern> trimPatternResolver;
    private Resolver<String, ChunkerTrimMaterial> trimMaterialResolver;
    private Resolver<String, ChunkerBannerPattern> bannerPatternResolver;
    private Function<BedrockResolvers, Resolver<CompoundTag, ChunkerItemStack>> itemStackResolverConstructor;
    private Function<BedrockResolvers, BlockEntityResolver<BedrockResolvers, CompoundTag>> blockEntityResolverConstructor;
    private Function<BedrockResolvers, EntityResolver<BedrockResolvers, CompoundTag>> entityResolverConstructor;
    private PreTransformManager preTransformManager;

    public BedrockResolversBuilder(Converter converter, Version version, boolean enableCaching) {
        this.converter = converter;
        this.version = version;
        this.enableCaching = enableCaching;
    }

    public BedrockResolvers build() {
        final Resolver<BedrockBlockCompoundTag, ChunkerBlockIdentifier> nbtChunkerBlockIdentifierResolver = this.nbtBlockIdentifierResolver.then(this.blockIdentifierResolver);
        final BedrockDataVersion dataVersion = BedrockDataVersion.getNearestVersion(this.version);
        return new BedrockResolvers(){
            private final Resolver<CompoundTag, ChunkerItemStack> itemStackResolver;
            private final BlockEntityResolver<BedrockResolvers, CompoundTag> blockEntityResolver;
            private final EntityResolver<BedrockResolvers, CompoundTag> entityResolver;
            {
                this.itemStackResolver = BedrockResolversBuilder.this.itemStackResolverConstructor.apply(this);
                this.blockEntityResolver = BedrockResolversBuilder.this.blockEntityResolverConstructor.apply(this);
                this.entityResolver = BedrockResolversBuilder.this.entityResolverConstructor.apply(this);
            }

            @Override
            public ChunkerBlockIdentifier readBlock(BedrockBlockCompoundTag input) {
                return nbtChunkerBlockIdentifierResolver.to(input).orElseGet(() -> {
                    BedrockResolversBuilder.this.converter.logMissingMapping(Converter.MissingMappingType.BLOCK, input.compoundTag().toSNBT());
                    return ChunkerBlockIdentifier.AIR;
                });
            }

            @Override
            public ChunkerBlockIdentifier readBlockIdentifier(Identifier input) {
                return BedrockResolversBuilder.this.blockIdentifierResolver.to(input).orElseGet(() -> {
                    BedrockResolversBuilder.this.converter.logMissingMapping(Converter.MissingMappingType.BLOCK, String.valueOf(input));
                    return ChunkerBlockIdentifier.AIR;
                });
            }

            @Override
            public ChunkerBlockIdentifier readItemBlockIdentifier(Identifier input) {
                return BedrockResolversBuilder.this.itemBlockIdentifierResolver.to(input).orElseGet(() -> {
                    BedrockResolversBuilder.this.converter.logMissingMapping(Converter.MissingMappingType.BLOCK, String.valueOf(input));
                    return ChunkerBlockIdentifier.AIR;
                });
            }

            @Override
            public ChunkerItemStack readItem(CompoundTag input) {
                if (!BedrockResolversBuilder.this.converter.shouldProcessItems()) {
                    return new ChunkerItemStack(ChunkerBlockIdentifier.AIR);
                }
                return this.itemStackResolver.to(input).orElseGet(() -> {
                    BedrockResolversBuilder.this.converter.logMissingMapping(Converter.MissingMappingType.ITEM, input.toSNBT());
                    return new ChunkerItemStack(ChunkerBlockIdentifier.AIR);
                });
            }

            @Override
            public ChunkerItemStack readItemIdentifier(Identifier input) {
                if (!BedrockResolversBuilder.this.converter.shouldProcessItems()) {
                    return new ChunkerItemStack(ChunkerBlockIdentifier.AIR);
                }
                Optional<ChunkerItemStack> itemStack = BedrockResolversBuilder.this.itemIdentifierResolver.to(input);
                return itemStack.orElseGet(() -> new ChunkerItemStack(this.readItemBlockIdentifier(input)));
            }

            @Override
            public ChunkerBiome readBiome(int biome, Dimension dimension) {
                return BedrockResolversBuilder.this.biomeIDResolver.to(biome).orElseGet(() -> {
                    BedrockResolversBuilder.this.converter.logMissingMapping(Converter.MissingMappingType.BIOME, String.valueOf(biome));
                    return this.getFallbackBiome(dimension);
                });
            }

            @Override
            public int writeBiomeID(ChunkerBiome biome, Dimension dimension) {
                return BedrockResolversBuilder.this.biomeIDResolver.from(biome).orElseGet(() -> {
                    BedrockResolversBuilder.this.converter.logMissingMapping(Converter.MissingMappingType.BIOME, String.valueOf(biome));
                    return BedrockResolversBuilder.this.biomeIDResolver.from(this.getFallbackBiome(dimension)).orElseThrow();
                });
            }

            @Override
            public BedrockBlockCompoundTag writeBlock(ChunkerBlockIdentifier chunkerBlockIdentifier) {
                return nbtChunkerBlockIdentifierResolver.from(chunkerBlockIdentifier).orElseGet(() -> {
                    BedrockResolversBuilder.this.converter.logMissingMapping(Converter.MissingMappingType.BLOCK, String.valueOf(chunkerBlockIdentifier));
                    return (BedrockBlockCompoundTag)nbtChunkerBlockIdentifierResolver.from(ChunkerBlockIdentifier.AIR).orElseThrow();
                });
            }

            @Override
            public Optional<Identifier> writeBlockIdentifier(ChunkerBlockIdentifier identifier, boolean reportMissing) {
                Optional<Identifier> result = BedrockResolversBuilder.this.blockIdentifierResolver.from(identifier);
                if (result.isEmpty() && reportMissing) {
                    BedrockResolversBuilder.this.converter.logMissingMapping(Converter.MissingMappingType.BLOCK, String.valueOf(identifier));
                }
                return result;
            }

            @Override
            public Optional<Identifier> writeItemBlockIdentifier(ChunkerBlockIdentifier identifier, boolean reportMissing) {
                Optional<Identifier> result = BedrockResolversBuilder.this.itemBlockIdentifierResolver.from(identifier);
                if (result.isEmpty() && reportMissing) {
                    BedrockResolversBuilder.this.converter.logMissingMapping(Converter.MissingMappingType.BLOCK, String.valueOf(identifier));
                }
                return result;
            }

            @Override
            public Optional<CompoundTag> writeItem(ChunkerItemStack chunkerItemStack) {
                return Optional.ofNullable(this.itemStackResolver.from(chunkerItemStack).orElseGet(() -> {
                    BedrockResolversBuilder.this.converter.logMissingMapping(Converter.MissingMappingType.ITEM, String.valueOf(chunkerItemStack));
                    return null;
                }));
            }

            @Override
            public Identifier writeItemIdentifier(ChunkerItemStack chunkerItemStack) {
                Optional<Identifier> itemStack = BedrockResolversBuilder.this.itemIdentifierResolver.from(chunkerItemStack);
                return itemStack.orElseGet(() -> {
                    ChunkerItemStackIdentifier patt11368$temp = chunkerItemStack.getIdentifier();
                    if (patt11368$temp instanceof ChunkerBlockIdentifier) {
                        ChunkerBlockIdentifier chunkerBlockIdentifier = (ChunkerBlockIdentifier)patt11368$temp;
                        return this.writeItemBlockIdentifier(chunkerBlockIdentifier, true).orElseGet(() -> this.writeItemBlockIdentifier(ChunkerBlockIdentifier.AIR, false).orElseThrow());
                    }
                    BedrockResolversBuilder.this.converter.logMissingMapping(Converter.MissingMappingType.ITEM, String.valueOf(chunkerItemStack));
                    return this.writeItemBlockIdentifier(ChunkerBlockIdentifier.AIR, false).orElseThrow();
                });
            }

            @Override
            public ChunkerPotionType readPotionTypeID(short potionID) {
                return BedrockResolversBuilder.this.potionIDResolver.to(Integer.valueOf(potionID)).orElseGet(() -> {
                    BedrockResolversBuilder.this.converter.logMissingMapping(Converter.MissingMappingType.POTION, String.valueOf(potionID));
                    return ChunkerPotionType.WATER;
                });
            }

            @Override
            public short writePotionTypeID(ChunkerPotionType potionType) {
                return BedrockResolversBuilder.this.potionIDResolver.from(potionType).orElseGet(() -> {
                    BedrockResolversBuilder.this.converter.logMissingMapping(Converter.MissingMappingType.POTION, String.valueOf((Object)potionType));
                    return 0;
                }).shortValue();
            }

            @Override
            public ChunkerEffectType readEffectID(int effectID) {
                return BedrockResolversBuilder.this.effectIDResolver.to(effectID).orElseGet(() -> {
                    BedrockResolversBuilder.this.converter.logMissingMapping(Converter.MissingMappingType.EFFECT, String.valueOf(effectID));
                    return ChunkerEffectType.EMPTY;
                });
            }

            @Override
            public int writeEffectID(ChunkerEffectType effect) {
                return BedrockResolversBuilder.this.effectIDResolver.from(effect).orElseGet(() -> {
                    BedrockResolversBuilder.this.converter.logMissingMapping(Converter.MissingMappingType.EFFECT, String.valueOf((Object)effect));
                    return 0;
                });
            }

            @Override
            public PaintingEntity.Motive readPaintingMotive(String identifier) {
                return BedrockResolversBuilder.this.paintingMotiveResolver.to(identifier).orElseGet(() -> {
                    BedrockResolversBuilder.this.converter.logMissingMapping(Converter.MissingMappingType.PAINTING, identifier);
                    return PaintingEntity.Motive.KEBAB;
                });
            }

            @Override
            public String writePaintingMotive(PaintingEntity.Motive motive) {
                return BedrockResolversBuilder.this.paintingMotiveResolver.from(motive).orElseGet(() -> {
                    BedrockResolversBuilder.this.converter.logMissingMapping(Converter.MissingMappingType.PAINTING, String.valueOf((Object)motive));
                    return BedrockResolversBuilder.this.paintingMotiveResolver.from(PaintingEntity.Motive.KEBAB).orElseThrow();
                });
            }

            @Override
            public BedrockDataVersion dataVersion() {
                return dataVersion;
            }

            @Override
            public BlockEntityResolver<BedrockResolvers, CompoundTag> blockEntityResolver() {
                return this.blockEntityResolver;
            }

            @Override
            public EntityResolver<BedrockResolvers, CompoundTag> entityResolver() {
                return this.entityResolver;
            }

            @Override
            public Resolver<BedrockBlockCompoundTag, Identifier> nbtBlockIdentifierResolver() {
                return BedrockResolversBuilder.this.nbtBlockIdentifierResolver;
            }

            @Override
            public Resolver<Identifier, ChunkerItemStack> chunkerItemIdentifierResolver() {
                return BedrockResolversBuilder.this.itemIdentifierResolver;
            }

            @Override
            public PreTransformManager preTransformManager() {
                return BedrockResolversBuilder.this.preTransformManager;
            }

            @Override
            public Converter converter() {
                return BedrockResolversBuilder.this.converter;
            }

            @Override
            public Resolver<String, ChunkerEntityType> entityTypeResolver() {
                return BedrockResolversBuilder.this.entityTypeResolver;
            }

            @Override
            public Resolver<Integer, ChunkerEnchantmentType> enchantmentIDResolver() {
                return BedrockResolversBuilder.this.enchantmentIDResolver;
            }

            @Override
            public Resolver<String, ChunkerTrimPattern> trimPatternResolver() {
                return BedrockResolversBuilder.this.trimPatternResolver;
            }

            @Override
            public Resolver<String, ChunkerTrimMaterial> trimMaterialResolver() {
                return BedrockResolversBuilder.this.trimMaterialResolver;
            }

            @Override
            public Resolver<String, ChunkerBannerPattern> bannerPatternResolver() {
                return BedrockResolversBuilder.this.bannerPatternResolver;
            }

            @Override
            public ChunkerBiome getFallbackBiome(Dimension dimension) {
                return switch (dimension) {
                    default -> throw new IncompatibleClassChangeError();
                    case Dimension.OVERWORLD -> ChunkerBiome.ChunkerVanillaBiome.PLAINS;
                    case Dimension.NETHER -> ChunkerBiome.ChunkerVanillaBiome.NETHER_WASTES;
                    case Dimension.THE_END -> ChunkerBiome.ChunkerVanillaBiome.THE_END;
                };
            }
        };
    }

    public BedrockResolversBuilder nbtBlockIdentifierResolver(Resolver<BedrockBlockCompoundTag, Identifier> resolver) {
        this.nbtBlockIdentifierResolver = resolver;
        return this;
    }

    public BedrockResolversBuilder itemIdentifierResolver(Resolver<Identifier, ChunkerItemStack> resolver) {
        this.itemIdentifierResolver = resolver;
        return this;
    }

    public BedrockResolversBuilder blockIdentifierResolver(Resolver<Identifier, ChunkerBlockIdentifier> resolver) {
        this.blockIdentifierResolver = this.enableCaching ? resolver.cached() : resolver;
        return this;
    }

    public BedrockResolversBuilder itemBlockIdentifierResolver(Resolver<Identifier, ChunkerBlockIdentifier> resolver) {
        this.itemBlockIdentifierResolver = this.enableCaching ? resolver.cached() : resolver;
        return this;
    }

    public BedrockResolversBuilder entityTypeResolver(Resolver<String, ChunkerEntityType> resolver) {
        this.entityTypeResolver = resolver;
        return this;
    }

    public BedrockResolversBuilder biomeIDResolver(Resolver<Integer, ChunkerBiome> resolver) {
        this.biomeIDResolver = resolver;
        return this;
    }

    public BedrockResolversBuilder effectIDResolver(Resolver<Integer, ChunkerEffectType> resolver) {
        this.effectIDResolver = resolver;
        return this;
    }

    public BedrockResolversBuilder enchantmentIDResolver(Resolver<Integer, ChunkerEnchantmentType> resolver) {
        this.enchantmentIDResolver = resolver;
        return this;
    }

    public BedrockResolversBuilder paintingMotiveResolver(Resolver<String, PaintingEntity.Motive> resolver) {
        this.paintingMotiveResolver = resolver;
        return this;
    }

    public BedrockResolversBuilder potionIDResolver(Resolver<Integer, ChunkerPotionType> resolver) {
        this.potionIDResolver = resolver;
        return this;
    }

    public BedrockResolversBuilder trimPatternResolver(Resolver<String, ChunkerTrimPattern> resolver) {
        this.trimPatternResolver = resolver;
        return this;
    }

    public BedrockResolversBuilder trimMaterialResolver(Resolver<String, ChunkerTrimMaterial> resolver) {
        this.trimMaterialResolver = resolver;
        return this;
    }

    public BedrockResolversBuilder bannerPatternResolver(Resolver<String, ChunkerBannerPattern> resolver) {
        this.bannerPatternResolver = resolver;
        return this;
    }

    public BedrockResolversBuilder itemStackResolverConstructor(Function<BedrockResolvers, Resolver<CompoundTag, ChunkerItemStack>> constructor) {
        this.itemStackResolverConstructor = constructor;
        return this;
    }

    public BedrockResolversBuilder blockEntityResolverConstructor(Function<BedrockResolvers, BlockEntityResolver<BedrockResolvers, CompoundTag>> constructor) {
        this.blockEntityResolverConstructor = constructor;
        return this;
    }

    public BedrockResolversBuilder entityResolverConstructor(Function<BedrockResolvers, EntityResolver<BedrockResolvers, CompoundTag>> constructor) {
        this.entityResolverConstructor = constructor;
        return this;
    }

    public BedrockResolversBuilder preTransformManager(PreTransformManager resolver) {
        this.preTransformManager = resolver;
        return this;
    }
}

