/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.blockentity.handlers;

import com.hivemc.chunker.conversion.encoding.base.resolver.blockentity.BlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.BedrockResolvers;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.BannerBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.BlockEntity;
import com.hivemc.chunker.nbt.tags.Tag;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import com.hivemc.chunker.util.JsonTextUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class BedrockBlockEntityHandler
extends BlockEntityHandler<BedrockResolvers, CompoundTag, BlockEntity> {
    public BedrockBlockEntityHandler() {
        super("BlockEntity", BlockEntity.class, () -> {
            throw new IllegalArgumentException("Unable to construct BlockEntity, invalid type!");
        });
    }

    @Override
    public void read(@NotNull BedrockResolvers resolvers, @NotNull CompoundTag input, @NotNull BlockEntity blockEntity) {
        if (resolvers.converter().shouldAllowNBTCopying()) {
            blockEntity.setOriginalNBT(input);
        }
        blockEntity.setX(input.getInt("x", 0));
        blockEntity.setY(input.getInt("y", 0));
        blockEntity.setZ(input.getInt("z", 0));
        blockEntity.setMovable(input.getByte("isMovable", (byte)0) == 1);
        blockEntity.setCustomName(input.getOptionalValue("CustomName", String.class).map(JsonTextUtil::fromText).orElse(null));
    }

    @Override
    public void write(@NotNull BedrockResolvers resolvers, @NotNull CompoundTag output, @NotNull BlockEntity blockEntity) {
        if (resolvers.converter().shouldAllowNBTCopying() && blockEntity.getOriginalNBT() != null) {
            for (Map.Entry<String, Tag<?>> namedPair : blockEntity.getOriginalNBT()) {
                output.put(namedPair.getKey(), (Tag<?>)namedPair.getValue().clone());
            }
        }
        output.put("x", blockEntity.getX());
        output.put("y", blockEntity.getY());
        output.put("z", blockEntity.getZ());
        output.put("isMovable", blockEntity.isMovable() ? (byte)1 : 0);
        if (blockEntity.getCustomName() != null && !(blockEntity instanceof BannerBlockEntity)) {
            output.put("CustomName", JsonTextUtil.toLegacy(blockEntity.getCustomName(), true));
        }
    }
}

