/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.blockentity.handlers;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.hivemc.chunker.conversion.encoding.base.resolver.blockentity.BlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.BedrockResolvers;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.container.randomizable.RandomizableContainerBlockEntity;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class BedrockRandomizableContainerBlockEntityHandler
extends BlockEntityHandler<BedrockResolvers, CompoundTag, RandomizableContainerBlockEntity> {
    public static final BiMap<String, String> LOOT_TABLE_OLD_NAME_TO_CHUNKER = ((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)ImmutableBiMap.builder().put("minecraft:chests/buriedtreasure", "minecraft:chests/buried_treasure")).put("minecraft:chests/dispenser_trap", "minecraft:chests/jungle_temple_dispenser")).put("minecraft:chests/shipwreck", "minecraft:chests/shipwreck_map")).put("minecraft:chests/shipwrecksupply", "minecraft:chests/shipwreck_supply")).put("minecraft:chests/shipwrecktreasure", "minecraft:chests/shipwreck_treasure")).build();
    public static final Set<String> UNSUPPORTED_LOOT_TABLES = Set.of("minecraft:chests/village/village_fisher");
    private final boolean enableLootTables;

    public BedrockRandomizableContainerBlockEntityHandler(boolean enabledLootTables) {
        super("RandomizableBlockEntity", RandomizableContainerBlockEntity.class, () -> {
            throw new IllegalArgumentException("Unable to construct RandomizableBlockEntity, invalid type!");
        });
        this.enableLootTables = enabledLootTables;
    }

    @Override
    public void read(@NotNull BedrockResolvers resolvers, @NotNull CompoundTag input, @NotNull RandomizableContainerBlockEntity blockEntity) {
        String lootTable = input.getString("LootTable", null);
        if (lootTable != null && !lootTable.isEmpty() && this.enableLootTables) {
            lootTable = lootTable.replace("loot_tables/", "minecraft:").replace(".json", "");
            lootTable = LOOT_TABLE_OLD_NAME_TO_CHUNKER.getOrDefault(lootTable, lootTable);
            blockEntity.setLootTable(lootTable);
        }
    }

    @Override
    public void write(@NotNull BedrockResolvers resolvers, @NotNull CompoundTag output, @NotNull RandomizableContainerBlockEntity blockEntity) {
        if (blockEntity.getLootTable() != null && !blockEntity.getLootTable().isEmpty() && !UNSUPPORTED_LOOT_TABLES.contains(blockEntity.getLootTable()) && this.enableLootTables) {
            Object bedrockLootTable = blockEntity.getLootTable();
            bedrockLootTable = LOOT_TABLE_OLD_NAME_TO_CHUNKER.inverse().getOrDefault(bedrockLootTable, (String)bedrockLootTable);
            if (((String)bedrockLootTable).startsWith("minecraft:")) {
                bedrockLootTable = "loot_tables/" + ((String)bedrockLootTable).substring(10);
            }
            if (!((String)bedrockLootTable).endsWith(".json")) {
                bedrockLootTable = (String)bedrockLootTable + ".json";
            }
            output.put("LootTable", (String)bedrockLootTable);
        }
    }
}

