/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.entity;

import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.encoding.base.resolver.entity.EmptyEntityHandler;
import com.hivemc.chunker.conversion.encoding.base.resolver.entity.EntityResolver;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.BedrockResolvers;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.entity.handlers.BedrockEntityHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.entity.handlers.BedrockHangingEntityHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.entity.handlers.BedrockItemFrameEntityHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.entity.handlers.BedrockPaintingEntityHandler;
import com.hivemc.chunker.conversion.intermediate.column.entity.GlowItemFrameEntity;
import com.hivemc.chunker.conversion.intermediate.column.entity.type.ChunkerEntityType;
import com.hivemc.chunker.conversion.intermediate.column.entity.type.ChunkerVanillaEntityType;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import java.util.Optional;

public class BedrockEntityResolver
extends EntityResolver<BedrockResolvers, CompoundTag> {
    public BedrockEntityResolver(Version version, BedrockResolvers resolvers) {
        super(version, resolvers, resolvers.converter().shouldAllowNBTCopying());
    }

    @Override
    protected void registerTypeHandlers(Version version) {
        this.register(new BedrockEntityHandler());
        this.register(new BedrockHangingEntityHandler());
        this.register(new BedrockPaintingEntityHandler());
        this.register(new BedrockItemFrameEntityHandler());
        this.register(new EmptyEntityHandler(ChunkerVanillaEntityType.GLOW_ITEM_FRAME, GlowItemFrameEntity.class, () -> {
            throw new IllegalArgumentException("Glow item frames cannot be read from Bedrock.");
        }));
    }

    @Override
    protected CompoundTag constructDataType(ChunkerEntityType type) {
        Optional<String> key = ((BedrockResolvers)this.resolvers).entityTypeResolver().from(type);
        if (key.isEmpty()) {
            return null;
        }
        CompoundTag compoundTag = new CompoundTag(4);
        compoundTag.put("identifier", key.get());
        return compoundTag;
    }

    @Override
    public Optional<ChunkerEntityType> getKey(CompoundTag input) {
        return input.getOptionalValue("identifier", String.class).flatMap(((BedrockResolvers)this.resolvers).entityTypeResolver()::to);
    }
}

