/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.entity;

import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.intermediate.column.entity.type.ChunkerEntityType;
import com.hivemc.chunker.conversion.intermediate.column.entity.type.ChunkerVanillaEntityType;
import com.hivemc.chunker.resolver.Resolver;
import com.hivemc.chunker.util.InvertibleMap;
import java.util.Optional;

public class BedrockEntityTypeIDResolver
implements Resolver<Integer, ChunkerEntityType> {
    private final InvertibleMap<ChunkerVanillaEntityType, Integer> mapping = InvertibleMap.enumKeys(ChunkerVanillaEntityType.class);

    public BedrockEntityTypeIDResolver(Version bedrockVersion) {
        this.mapping.put(ChunkerVanillaEntityType.CHICKEN, 10);
        this.mapping.put(ChunkerVanillaEntityType.COW, 11);
        this.mapping.put(ChunkerVanillaEntityType.PIG, 12);
        this.mapping.put(ChunkerVanillaEntityType.SHEEP, 13);
        this.mapping.put(ChunkerVanillaEntityType.WOLF, 14);
        this.mapping.put(ChunkerVanillaEntityType.VILLAGER, 15);
        this.mapping.put(ChunkerVanillaEntityType.MOOSHROOM, 16);
        this.mapping.put(ChunkerVanillaEntityType.SQUID, 17);
        this.mapping.put(ChunkerVanillaEntityType.RABBIT, 18);
        this.mapping.put(ChunkerVanillaEntityType.BAT, 19);
        this.mapping.put(ChunkerVanillaEntityType.IRON_GOLEM, 20);
        this.mapping.put(ChunkerVanillaEntityType.SNOW_GOLEM, 21);
        this.mapping.put(ChunkerVanillaEntityType.OCELOT, 22);
        this.mapping.put(ChunkerVanillaEntityType.HORSE, 23);
        this.mapping.put(ChunkerVanillaEntityType.DONKEY, 24);
        this.mapping.put(ChunkerVanillaEntityType.MULE, 25);
        this.mapping.put(ChunkerVanillaEntityType.SKELETON_HORSE, 26);
        this.mapping.put(ChunkerVanillaEntityType.ZOMBIE_HORSE, 27);
        this.mapping.put(ChunkerVanillaEntityType.POLAR_BEAR, 28);
        this.mapping.put(ChunkerVanillaEntityType.LLAMA, 29);
        this.mapping.put(ChunkerVanillaEntityType.PARROT, 30);
        this.mapping.put(ChunkerVanillaEntityType.DOLPHIN, 31);
        this.mapping.put(ChunkerVanillaEntityType.ZOMBIE, 32);
        this.mapping.put(ChunkerVanillaEntityType.CREEPER, 33);
        this.mapping.put(ChunkerVanillaEntityType.SKELETON, 34);
        this.mapping.put(ChunkerVanillaEntityType.SPIDER, 35);
        this.mapping.put(ChunkerVanillaEntityType.ZOMBIFIED_PIGLIN, 36);
        this.mapping.put(ChunkerVanillaEntityType.SLIME, 37);
        this.mapping.put(ChunkerVanillaEntityType.ENDERMAN, 38);
        this.mapping.put(ChunkerVanillaEntityType.SILVERFISH, 39);
        this.mapping.put(ChunkerVanillaEntityType.CAVE_SPIDER, 40);
        this.mapping.put(ChunkerVanillaEntityType.GHAST, 41);
        this.mapping.put(ChunkerVanillaEntityType.MAGMA_CUBE, 42);
        this.mapping.put(ChunkerVanillaEntityType.BLAZE, 43);
        this.mapping.put(ChunkerVanillaEntityType.ZOMBIE_VILLAGER, 44);
        this.mapping.put(ChunkerVanillaEntityType.WITCH, 45);
        this.mapping.put(ChunkerVanillaEntityType.STRAY, 46);
        this.mapping.put(ChunkerVanillaEntityType.HUSK, 47);
        this.mapping.put(ChunkerVanillaEntityType.WITHER_SKELETON, 48);
        this.mapping.put(ChunkerVanillaEntityType.GUARDIAN, 49);
        this.mapping.put(ChunkerVanillaEntityType.ELDER_GUARDIAN, 50);
        this.mapping.put(ChunkerVanillaEntityType.WITHER, 52);
        this.mapping.put(ChunkerVanillaEntityType.ENDER_DRAGON, 53);
        this.mapping.put(ChunkerVanillaEntityType.SHULKER, 54);
        this.mapping.put(ChunkerVanillaEntityType.ENDERMITE, 55);
        this.mapping.put(ChunkerVanillaEntityType.VINDICATOR, 57);
        this.mapping.put(ChunkerVanillaEntityType.PHANTOM, 58);
        this.mapping.put(ChunkerVanillaEntityType.RAVAGER, 59);
        this.mapping.put(ChunkerVanillaEntityType.ARMOR_STAND, 61);
        this.mapping.put(ChunkerVanillaEntityType.PLAYER, 63);
        this.mapping.put(ChunkerVanillaEntityType.ITEM, 64);
        this.mapping.put(ChunkerVanillaEntityType.TNT, 65);
        this.mapping.put(ChunkerVanillaEntityType.FALLING_BLOCK, 66);
        this.mapping.put(ChunkerVanillaEntityType.MOVING_BLOCK, 67);
        this.mapping.put(ChunkerVanillaEntityType.EXPERIENCE_BOTTLE, 68);
        this.mapping.put(ChunkerVanillaEntityType.EXPERIENCE_ORB, 69);
        this.mapping.put(ChunkerVanillaEntityType.EYE_OF_ENDER, 70);
        this.mapping.put(ChunkerVanillaEntityType.END_CRYSTAL, 71);
        this.mapping.put(ChunkerVanillaEntityType.FIREWORK_ROCKET, 72);
        this.mapping.put(ChunkerVanillaEntityType.TRIDENT, 73);
        this.mapping.put(ChunkerVanillaEntityType.TURTLE, 74);
        this.mapping.put(ChunkerVanillaEntityType.CAT, 75);
        this.mapping.put(ChunkerVanillaEntityType.SHULKER_BULLET, 76);
        this.mapping.put(ChunkerVanillaEntityType.FISHING_BOBBER, 77);
        this.mapping.put(ChunkerVanillaEntityType.DRAGON_FIREBALL, 79);
        this.mapping.put(ChunkerVanillaEntityType.ARROW, 80);
        this.mapping.put(ChunkerVanillaEntityType.SNOWBALL, 81);
        this.mapping.put(ChunkerVanillaEntityType.EGG, 82);
        this.mapping.put(ChunkerVanillaEntityType.PAINTING, 83);
        this.mapping.put(ChunkerVanillaEntityType.MINECART, 84);
        this.mapping.put(ChunkerVanillaEntityType.FIREBALL, 85);
        this.mapping.put(ChunkerVanillaEntityType.POTION, 86);
        this.mapping.put(ChunkerVanillaEntityType.ENDER_PEARL, 87);
        this.mapping.put(ChunkerVanillaEntityType.LEASH_KNOT, 88);
        this.mapping.put(ChunkerVanillaEntityType.WITHER_SKULL, 89);
        this.mapping.put(ChunkerVanillaEntityType.OAK_BOAT, 90);
        this.mapping.put(ChunkerVanillaEntityType.WITHER_SKULL_DANGEROUS, 91);
        this.mapping.put(ChunkerVanillaEntityType.LIGHTNING_BOLT, 93);
        this.mapping.put(ChunkerVanillaEntityType.SMALL_FIREBALL, 94);
        this.mapping.put(ChunkerVanillaEntityType.AREA_EFFECT_CLOUD, 95);
        this.mapping.put(ChunkerVanillaEntityType.HOPPER_MINECART, 96);
        this.mapping.put(ChunkerVanillaEntityType.TNT_MINECART, 97);
        this.mapping.put(ChunkerVanillaEntityType.CHEST_MINECART, 98);
        this.mapping.put(ChunkerVanillaEntityType.FURNACE_MINECART, 99);
        this.mapping.put(ChunkerVanillaEntityType.COMMAND_BLOCK_MINECART, 100);
        this.mapping.put(ChunkerVanillaEntityType.LINGERING_POTION, 101);
        this.mapping.put(ChunkerVanillaEntityType.LLAMA_SPIT, 102);
        this.mapping.put(ChunkerVanillaEntityType.EVOKER_FANGS, 103);
        this.mapping.put(ChunkerVanillaEntityType.EVOKER, 104);
        this.mapping.put(ChunkerVanillaEntityType.VEX, 105);
        this.mapping.put(ChunkerVanillaEntityType.PUFFERFISH, 108);
        this.mapping.put(ChunkerVanillaEntityType.SALMON, 109);
        this.mapping.put(ChunkerVanillaEntityType.DROWNED, 110);
        this.mapping.put(ChunkerVanillaEntityType.TROPICAL_FISH, 111);
        this.mapping.put(ChunkerVanillaEntityType.COD, 112);
        this.mapping.put(ChunkerVanillaEntityType.PANDA, 113);
        this.mapping.put(ChunkerVanillaEntityType.PILLAGER, 114);
        this.mapping.put(ChunkerVanillaEntityType.VILLAGER, 115);
        this.mapping.put(ChunkerVanillaEntityType.ZOMBIE_VILLAGER, 116);
        this.mapping.put(ChunkerVanillaEntityType.SHIELD, 117);
        this.mapping.put(ChunkerVanillaEntityType.WANDERING_TRADER, 118);
        if (bedrockVersion.isGreaterThanOrEqual(1, 13, 0)) {
            this.mapping.put(ChunkerVanillaEntityType.ELDER_GUARDIAN_GHOST, 120);
            this.mapping.put(ChunkerVanillaEntityType.FOX, 121);
        }
        if (bedrockVersion.isGreaterThanOrEqual(1, 14, 0)) {
            this.mapping.put(ChunkerVanillaEntityType.BEE, 122);
        }
        if (bedrockVersion.isGreaterThanOrEqual(1, 16, 0)) {
            this.mapping.put(ChunkerVanillaEntityType.PIGLIN, 123);
            this.mapping.put(ChunkerVanillaEntityType.HOGLIN, 124);
            this.mapping.put(ChunkerVanillaEntityType.STRIDER, 125);
            this.mapping.put(ChunkerVanillaEntityType.ZOGLIN, 126);
        }
        if (bedrockVersion.isGreaterThanOrEqual(1, 16, 20)) {
            this.mapping.put(ChunkerVanillaEntityType.PIGLIN_BRUTE, 127);
        }
        if (bedrockVersion.isGreaterThanOrEqual(1, 16, 200)) {
            this.mapping.put(ChunkerVanillaEntityType.GOAT, 128);
        }
        if (bedrockVersion.isGreaterThanOrEqual(1, 16, 210)) {
            this.mapping.put(ChunkerVanillaEntityType.GLOW_SQUID, 129);
        }
        if (bedrockVersion.isGreaterThanOrEqual(1, 17, 0)) {
            this.mapping.put(ChunkerVanillaEntityType.AXOLOTL, 130);
        }
        if (bedrockVersion.isGreaterThanOrEqual(1, 18, 0)) {
            this.mapping.put(ChunkerVanillaEntityType.FROG, 132);
            this.mapping.put(ChunkerVanillaEntityType.TADPOLE, 133);
        }
        if (bedrockVersion.isGreaterThanOrEqual(1, 18, 30)) {
            this.mapping.put(ChunkerVanillaEntityType.WARDEN, 131);
            this.mapping.put(ChunkerVanillaEntityType.ALLAY, 134);
        }
        if (bedrockVersion.isGreaterThanOrEqual(1, 19, 0)) {
            this.mapping.put(ChunkerVanillaEntityType.OAK_CHEST_BOAT, 136);
        }
        if (bedrockVersion.isGreaterThanOrEqual(1, 19, 10)) {
            this.mapping.put(ChunkerVanillaEntityType.TRADER_LLAMA, 137);
        }
        if (bedrockVersion.isGreaterThanOrEqual(1, 19, 50)) {
            this.mapping.put(ChunkerVanillaEntityType.CAMEL, 138);
        }
        if (bedrockVersion.isGreaterThanOrEqual(1, 19, 70)) {
            this.mapping.put(ChunkerVanillaEntityType.SNIFFER, 139);
        }
        if (bedrockVersion.isGreaterThanOrEqual(1, 20, 60)) {
            this.mapping.put(ChunkerVanillaEntityType.BREEZE, 140);
            this.mapping.put(ChunkerVanillaEntityType.BREEZE_WIND_CHARGE_PROJECTILE, 141);
            this.mapping.put(ChunkerVanillaEntityType.ARMADILLO, 142);
        }
        if (bedrockVersion.isGreaterThanOrEqual(1, 20, 70)) {
            this.mapping.put(ChunkerVanillaEntityType.WIND_CHARGE, 143);
            this.mapping.put(ChunkerVanillaEntityType.BOGGED, 144);
        }
        if (bedrockVersion.isGreaterThanOrEqual(1, 21, 0)) {
            this.mapping.put(ChunkerVanillaEntityType.OMINOUS_ITEM_SPAWNER, 145);
        }
        if (bedrockVersion.isGreaterThanOrEqual(1, 21, 50)) {
            this.mapping.put(ChunkerVanillaEntityType.CREAKING, 146);
        }
        if (bedrockVersion.isGreaterThanOrEqual(1, 21, 80)) {
            this.mapping.put(ChunkerVanillaEntityType.HAPPY_GHAST, 147);
        }
        if (bedrockVersion.isGreaterThanOrEqual(1, 21, 100)) {
            this.mapping.put(ChunkerVanillaEntityType.COPPER_GOLEM, 148);
        }
        if (bedrockVersion.isGreaterThanOrEqual(1, 21, 130)) {
            this.mapping.put(ChunkerVanillaEntityType.NAUTILUS, 149);
            this.mapping.put(ChunkerVanillaEntityType.ZOMBIE_NAUTILUS, 150);
            this.mapping.put(ChunkerVanillaEntityType.PARCHED, 151);
            this.mapping.put(ChunkerVanillaEntityType.CAMEL_HUSK, 152);
        }
    }

    @Override
    public Optional<Integer> from(ChunkerEntityType input) {
        if (input instanceof ChunkerVanillaEntityType) {
            ChunkerVanillaEntityType chunkerVanillaEntityType = (ChunkerVanillaEntityType)input;
            return Optional.ofNullable(this.mapping.forward().get(chunkerVanillaEntityType));
        }
        return Optional.empty();
    }

    @Override
    public Optional<ChunkerEntityType> to(Integer input) {
        return Optional.ofNullable((ChunkerEntityType)this.mapping.inverse().get(input));
    }
}

