/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.entity;

import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.intermediate.column.entity.PaintingEntity;
import com.hivemc.chunker.resolver.Resolver;
import com.hivemc.chunker.util.InvertibleMap;
import java.util.Optional;

public class BedrockPaintingMotiveResolver
implements Resolver<String, PaintingEntity.Motive> {
    private final InvertibleMap<PaintingEntity.Motive, String> mapping = InvertibleMap.enumKeys(PaintingEntity.Motive.class);

    public BedrockPaintingMotiveResolver(Version bedrockVersion) {
        this.mapping.put(PaintingEntity.Motive.KEBAB, "Kebab");
        this.mapping.put(PaintingEntity.Motive.AZTEC, "Aztec");
        this.mapping.put(PaintingEntity.Motive.ALBAN, "Alban");
        this.mapping.put(PaintingEntity.Motive.AZTEC2, "Aztec2");
        this.mapping.put(PaintingEntity.Motive.BOMB, "Bomb");
        this.mapping.put(PaintingEntity.Motive.PLANT, "Plant");
        this.mapping.put(PaintingEntity.Motive.WASTELAND, "Wasteland");
        this.mapping.put(PaintingEntity.Motive.WANDERER, "Wanderer");
        this.mapping.put(PaintingEntity.Motive.GRAHAM, "Graham");
        this.mapping.put(PaintingEntity.Motive.SEA, "Sea");
        this.mapping.put(PaintingEntity.Motive.CREEBET, "Creebet");
        this.mapping.put(PaintingEntity.Motive.SUNSET, "Sunset");
        this.mapping.put(PaintingEntity.Motive.COURBET, "Courbet");
        this.mapping.put(PaintingEntity.Motive.POOL, "Pool");
        this.mapping.put(PaintingEntity.Motive.EARTH, "Earth");
        this.mapping.put(PaintingEntity.Motive.FIRE, "Fire");
        this.mapping.put(PaintingEntity.Motive.WATER, "Water");
        this.mapping.put(PaintingEntity.Motive.WIND, "Wind");
        this.mapping.put(PaintingEntity.Motive.MATCH, "Match");
        this.mapping.put(PaintingEntity.Motive.BUST, "Bust");
        this.mapping.put(PaintingEntity.Motive.STAGE, "Stage");
        this.mapping.put(PaintingEntity.Motive.VOID, "Void");
        this.mapping.put(PaintingEntity.Motive.SKULL_AND_ROSES, "SkullAndRoses");
        this.mapping.put(PaintingEntity.Motive.WITHER, "Wither");
        this.mapping.put(PaintingEntity.Motive.FIGHTERS, "Fighters");
        this.mapping.put(PaintingEntity.Motive.SKELETON, "Skeleton");
        this.mapping.put(PaintingEntity.Motive.DONKEY_KONG, "DonkeyKong");
        this.mapping.put(PaintingEntity.Motive.POINTER, "Pointer");
        this.mapping.put(PaintingEntity.Motive.PIGSCENE, "Pigscene");
        this.mapping.put(PaintingEntity.Motive.BURNING_SKULL, "BurningSkull");
        if (bedrockVersion.isGreaterThanOrEqual(1, 21, 0)) {
            this.mapping.put(PaintingEntity.Motive.BACKYARD, "backyard");
            this.mapping.put(PaintingEntity.Motive.BOUQUET, "bouquet");
            this.mapping.put(PaintingEntity.Motive.CAVEBIRD, "cavebird");
            this.mapping.put(PaintingEntity.Motive.CHANGING, "changing");
            this.mapping.put(PaintingEntity.Motive.COTAN, "cotan");
            this.mapping.put(PaintingEntity.Motive.ENDBOSS, "endboss");
            this.mapping.put(PaintingEntity.Motive.FERN, "fern");
            this.mapping.put(PaintingEntity.Motive.FINDING, "finding");
            this.mapping.put(PaintingEntity.Motive.LOWMIST, "lowmist");
            this.mapping.put(PaintingEntity.Motive.ORB, "orb");
            this.mapping.put(PaintingEntity.Motive.OWLEMONS, "owlemons");
            this.mapping.put(PaintingEntity.Motive.PASSAGE, "passage");
            this.mapping.put(PaintingEntity.Motive.POND, "pond");
            this.mapping.put(PaintingEntity.Motive.SUNFLOWERS, "sunflowers");
            this.mapping.put(PaintingEntity.Motive.TIDES, "tides");
            this.mapping.put(PaintingEntity.Motive.UNPACKED, "unpacked");
            this.mapping.put(PaintingEntity.Motive.MEDITATIVE, "meditative");
            this.mapping.put(PaintingEntity.Motive.PRAIRIE_RIDE, "prairie_ride");
            this.mapping.put(PaintingEntity.Motive.HUMBLE, "humble");
            this.mapping.put(PaintingEntity.Motive.BAROQUE, "baroque");
        }
        if (bedrockVersion.isGreaterThanOrEqual(1, 21, 93)) {
            this.mapping.put(PaintingEntity.Motive.DENNIS, "dennis");
        }
    }

    @Override
    public Optional<String> from(PaintingEntity.Motive input) {
        return Optional.ofNullable(this.mapping.forward().get((Object)input));
    }

    @Override
    public Optional<PaintingEntity.Motive> to(String input) {
        return Optional.ofNullable(this.mapping.inverse().get(input));
    }
}

