/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.identifier.legacy;

import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.identifier.BedrockBlockCompoundTag;
import com.hivemc.chunker.mapping.identifier.Identifier;
import com.hivemc.chunker.mapping.identifier.states.StateValue;
import com.hivemc.chunker.mapping.identifier.states.StateValueBoolean;
import com.hivemc.chunker.mapping.identifier.states.StateValueInt;
import com.hivemc.chunker.nbt.tags.Tag;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import com.hivemc.chunker.resolver.Resolver;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Optional;

public class BedrockNBTLegacyBlockIdentifierResolver
implements Resolver<BedrockBlockCompoundTag, Identifier> {
    protected final Version version;

    public BedrockNBTLegacyBlockIdentifierResolver(Version version) {
        this.version = version;
    }

    @Override
    public Optional<Identifier> to(BedrockBlockCompoundTag input) {
        Map<Object, Object> states;
        String identifier = input.compoundTag().getString("name", null);
        if (identifier == null) {
            return Optional.empty();
        }
        CompoundTag statesTag = input.compoundTag().getCompound("states");
        if (statesTag == null) {
            states = input.compoundTag().contains("val") ? Map.of("waterlogged", input.waterlogged() ? StateValueBoolean.TRUE : StateValueBoolean.FALSE, "data", new StateValueInt(input.compoundTag().getShort("val", (short)0))) : Map.of("waterlogged", input.waterlogged() ? StateValueBoolean.TRUE : StateValueBoolean.FALSE);
        } else {
            states = new Object2ObjectOpenHashMap<String, StateValueBoolean>(statesTag.size() + 1);
            states.put("waterlogged", input.waterlogged() ? StateValueBoolean.TRUE : StateValueBoolean.FALSE);
            for (Map.Entry<String, Tag<?>> tag : statesTag) {
                states.put(tag.getKey(), StateValue.fromNBT(tag.getValue()));
            }
        }
        return Optional.of(new Identifier(identifier, states));
    }

    @Override
    public Optional<BedrockBlockCompoundTag> from(Identifier input) {
        CompoundTag output = new CompoundTag(4);
        output.put("name", input.getIdentifier());
        output.put("val", (short)input.getStates().getOrDefault("data", StateValueInt.ZERO).getValue());
        if (!input.getStates().isEmpty()) {
            CompoundTag states = new CompoundTag(input.getStates().size());
            for (Map.Entry<String, StateValue<?>> entry : input.getStates().entrySet()) {
                if (entry.getKey().equals("waterlogged")) continue;
                states.put(entry.getKey(), entry.getValue().toNBT());
            }
            output.put("states", states);
        }
        boolean waterlogged = input.getStates().getOrDefault("waterlogged", StateValueBoolean.FALSE) == StateValueBoolean.TRUE;
        return Optional.of(new BedrockBlockCompoundTag(output, waterlogged));
    }
}

