/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.itemstack;

import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.enchantment.ChunkerEnchantmentType;
import com.hivemc.chunker.resolver.Resolver;
import com.hivemc.chunker.util.InvertibleMap;
import java.util.Optional;

public class BedrockEnchantmentIDResolver
implements Resolver<Integer, ChunkerEnchantmentType> {
    private final InvertibleMap<ChunkerEnchantmentType, Integer> mapping = InvertibleMap.enumKeys(ChunkerEnchantmentType.class);

    public BedrockEnchantmentIDResolver(Version bedrockVersion) {
        this.mapping.put(ChunkerEnchantmentType.ALL_DAMAGE_PROTECTION, 0);
        this.mapping.put(ChunkerEnchantmentType.FIRE_PROTECTION, 1);
        this.mapping.put(ChunkerEnchantmentType.FALL_PROTECTION, 2);
        this.mapping.put(ChunkerEnchantmentType.BLAST_PROTECTION, 3);
        this.mapping.put(ChunkerEnchantmentType.PROJECTILE_PROTECTION, 4);
        this.mapping.put(ChunkerEnchantmentType.RESPIRATION, 6);
        this.mapping.put(ChunkerEnchantmentType.AQUA_AFFINITY, 8);
        this.mapping.put(ChunkerEnchantmentType.THORNS, 5);
        this.mapping.put(ChunkerEnchantmentType.DEPTH_STRIDER, 7);
        this.mapping.put(ChunkerEnchantmentType.SHARPNESS, 9);
        this.mapping.put(ChunkerEnchantmentType.SMITE, 10);
        this.mapping.put(ChunkerEnchantmentType.BANE_OF_ARTHROPODS, 11);
        this.mapping.put(ChunkerEnchantmentType.KNOCKBACK, 12);
        this.mapping.put(ChunkerEnchantmentType.FIRE_ASPECT, 13);
        this.mapping.put(ChunkerEnchantmentType.MOB_LOOTING, 14);
        this.mapping.put(ChunkerEnchantmentType.BLOCK_EFFICIENCY, 15);
        this.mapping.put(ChunkerEnchantmentType.SILK_TOUCH, 16);
        this.mapping.put(ChunkerEnchantmentType.UNBREAKING, 17);
        this.mapping.put(ChunkerEnchantmentType.BLOCK_FORTUNE, 18);
        this.mapping.put(ChunkerEnchantmentType.POWER_ARROWS, 19);
        this.mapping.put(ChunkerEnchantmentType.PUNCH_ARROWS, 20);
        this.mapping.put(ChunkerEnchantmentType.FLAMING_ARROWS, 21);
        this.mapping.put(ChunkerEnchantmentType.INFINITY_ARROWS, 22);
        this.mapping.put(ChunkerEnchantmentType.FISHING_LUCK, 23);
        this.mapping.put(ChunkerEnchantmentType.FISHING_SPEED, 24);
        this.mapping.put(ChunkerEnchantmentType.FROST_WALKER, 25);
        this.mapping.put(ChunkerEnchantmentType.MENDING, 26);
        this.mapping.put(ChunkerEnchantmentType.BINDING_CURSE, 27);
        this.mapping.put(ChunkerEnchantmentType.VANISHING_CURSE, 28);
        if (bedrockVersion.isGreaterThanOrEqual(1, 4, 0)) {
            this.mapping.put(ChunkerEnchantmentType.IMPALING, 29);
            this.mapping.put(ChunkerEnchantmentType.RIPTIDE, 30);
            this.mapping.put(ChunkerEnchantmentType.LOYALTY, 31);
            this.mapping.put(ChunkerEnchantmentType.CHANNELING, 32);
        }
        if (bedrockVersion.isGreaterThanOrEqual(1, 8, 0)) {
            this.mapping.put(ChunkerEnchantmentType.MULTISHOT, 33);
            this.mapping.put(ChunkerEnchantmentType.PIERCING, 34);
            this.mapping.put(ChunkerEnchantmentType.QUICK_CHARGE, 35);
        }
        if (bedrockVersion.isGreaterThanOrEqual(1, 16, 0)) {
            this.mapping.put(ChunkerEnchantmentType.SOUL_SPEED, 36);
        }
        if (bedrockVersion.isGreaterThanOrEqual(1, 19, 0)) {
            this.mapping.put(ChunkerEnchantmentType.SWIFT_SNEAK, 37);
        }
        if (bedrockVersion.isGreaterThanOrEqual(1, 21, 0)) {
            this.mapping.put(ChunkerEnchantmentType.WIND_BURST, 38);
            this.mapping.put(ChunkerEnchantmentType.DENSITY, 39);
            this.mapping.put(ChunkerEnchantmentType.BREACH, 40);
        }
        if (bedrockVersion.isGreaterThanOrEqual(1, 21, 130)) {
            this.mapping.put(ChunkerEnchantmentType.LUNGE, 41);
        }
    }

    @Override
    public Optional<Integer> from(ChunkerEnchantmentType input) {
        return Optional.ofNullable(this.mapping.forward().get((Object)input));
    }

    @Override
    public Optional<ChunkerEnchantmentType> to(Integer input) {
        return Optional.ofNullable(this.mapping.inverse().get(input));
    }
}

