/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.itemstack.legacy;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.hivemc.chunker.conversion.encoding.base.Converter;
import com.hivemc.chunker.conversion.encoding.base.resolver.itemstack.ItemStackResolver;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.BedrockResolvers;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.identifier.BedrockBlockCompoundTag;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.BlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.ChunkerBlockIdentifier;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.ChunkerItemStackIdentifier;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.vanilla.VanillaBlockStates;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.item.ChunkerVanillaItemType;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.ChunkerDyeColor;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.ChunkerItemDisplay;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.ChunkerItemProperty;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.ChunkerItemStack;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.enchantment.ChunkerEnchantmentType;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.firework.ChunkerFireworkExplosion;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.firework.ChunkerFireworkShape;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.firework.ChunkerFireworks;
import com.hivemc.chunker.conversion.intermediate.column.entity.type.ChunkerEntityType;
import com.hivemc.chunker.conversion.intermediate.level.ChunkerLevel;
import com.hivemc.chunker.conversion.intermediate.level.map.ChunkerMap;
import com.hivemc.chunker.mapping.identifier.Identifier;
import com.hivemc.chunker.nbt.TagType;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import com.hivemc.chunker.nbt.tags.collection.ListTag;
import com.hivemc.chunker.nbt.tags.primitive.StringTag;
import com.hivemc.chunker.resolver.property.PropertyHandler;
import com.hivemc.chunker.util.JsonTextUtil;
import it.unimi.dsi.fastutil.Pair;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class BedrockLegacyItemStackResolver
extends ItemStackResolver<BedrockResolvers, CompoundTag> {
    public static final Map<String, String> FIXED_LEGACY_NAMES = new ImmutableMap.Builder<String, String>().put("minecraft:concretePowder", "minecraft:concrete_powder").put("minecraft:stone_slab", "minecraft:double_stone_slab").put("minecraft:stone_slab2", "minecraft:double_stone_slab2").put("minecraft:stone_slab3", "minecraft:double_stone_slab3").put("minecraft:stone_slab4", "minecraft:double_stone_slab4").build();

    public BedrockLegacyItemStackResolver(BedrockResolvers resolvers) {
        super(resolvers);
    }

    @Override
    protected void registerHandlers(final BedrockResolvers resolvers) {
        this.registerHandler(ChunkerItemProperty.AMOUNT, new PropertyHandler<CompoundTag, Integer>(){

            @Override
            public Optional<Integer> read(@NotNull CompoundTag value) {
                return Optional.of(Integer.valueOf(value.getByte("Count", (byte)1)));
            }

            @Override
            public void write(@NotNull CompoundTag value, @NotNull Integer count) {
                value.put("Count", count.byteValue());
            }
        });
        this.registerHandler(ChunkerItemProperty.DURABILITY, new PropertyHandler<CompoundTag, Integer>(){

            @Override
            public Optional<Integer> read(@NotNull CompoundTag value) {
                return value.getOptional("tag", CompoundTag.class).flatMap(tag -> tag.getOptionalValue("Damage", Integer.class));
            }

            @Override
            public void write(@NotNull CompoundTag value, @NotNull Integer durability) {
                CompoundTag tag = value.getOrCreateCompound("tag");
                tag.put("Damage", durability);
            }
        });
        this.registerHandler(ChunkerItemProperty.DISPLAY, new PropertyHandler<CompoundTag, ChunkerItemDisplay>(){

            @Override
            public Optional<ChunkerItemDisplay> read(@NotNull CompoundTag value) {
                CompoundTag tag = value.getCompound("tag");
                if (tag == null) {
                    return Optional.empty();
                }
                JsonElement name = null;
                List lore = null;
                Color color = null;
                CompoundTag display = tag.getCompound("display");
                if (display != null) {
                    name = display.getOptionalValue("Name", String.class).map(JsonTextUtil::fromText).orElse(null);
                    List loreString = display.getListValues("Lore", StringTag.class, null);
                    if (loreString != null) {
                        lore = loreString.stream().map(JsonTextUtil::fromText).collect(Collectors.toList());
                    }
                }
                if (tag.contains("customColor")) {
                    color = new Color(tag.getInt("customColor"));
                }
                return name != null || lore != null || color != null ? Optional.of(new ChunkerItemDisplay(name, lore, color)) : Optional.empty();
            }

            @Override
            public void write(@NotNull CompoundTag value, @NotNull ChunkerItemDisplay chunkerItemDisplay) {
                CompoundTag tag = value.getOrCreateCompound("tag");
                CompoundTag display = tag.getOrCreateCompound("display");
                if (chunkerItemDisplay.displayName() != null) {
                    display.put("Name", JsonTextUtil.toLegacy(chunkerItemDisplay.displayName(), true));
                }
                if (chunkerItemDisplay.lore() != null) {
                    display.put("Lore", ListTag.fromValues(TagType.STRING, Lists.transform(chunkerItemDisplay.lore(), text -> JsonTextUtil.toLegacy(text, true))));
                }
                if (chunkerItemDisplay.color() != null) {
                    tag.put("customColor", chunkerItemDisplay.color().getRGB());
                }
            }
        });
        this.registerHandler(ChunkerItemProperty.CAN_PLACE_ON, new PropertyHandler<CompoundTag, List<ChunkerBlockIdentifier>>(){

            @Override
            public Optional<List<ChunkerBlockIdentifier>> read(@NotNull CompoundTag value) {
                List names = value.getListValues("CanPlaceOn", StringTag.class, null);
                if (names == null) {
                    return Optional.empty();
                }
                ArrayList<ChunkerBlockIdentifier> identifiers = new ArrayList<ChunkerBlockIdentifier>(names.size());
                for (String name : names) {
                    ChunkerBlockIdentifier identifier = resolvers.readItemBlockIdentifier(new Identifier(name)).copyWithout(VanillaBlockStates.WATERLOGGED);
                    if (identifier.isAir()) continue;
                    identifiers.add(identifier);
                }
                return Optional.of(identifiers);
            }

            @Override
            public void write(@NotNull CompoundTag value, @NotNull List<ChunkerBlockIdentifier> chunkerBlockIdentifiers) {
                ArrayList<String> identifiers = new ArrayList<String>(chunkerBlockIdentifiers.size());
                for (ChunkerBlockIdentifier chunkerBlockIdentifier : chunkerBlockIdentifiers) {
                    Optional<Identifier> identifier = resolvers.writeItemBlockIdentifier(chunkerBlockIdentifier, true);
                    if (!identifier.isPresent() || identifier.get().getIdentifier().equals("minecraft:air")) continue;
                    identifiers.add(identifier.get().getIdentifier());
                }
                value.put("CanPlaceOn", ListTag.fromValues(TagType.STRING, identifiers));
            }
        });
        this.registerHandler(ChunkerItemProperty.CAN_DESTROY, new PropertyHandler<CompoundTag, List<ChunkerBlockIdentifier>>(){

            @Override
            public Optional<List<ChunkerBlockIdentifier>> read(@NotNull CompoundTag value) {
                List names = value.getListValues("CanDestroy", StringTag.class, null);
                if (names == null) {
                    return Optional.empty();
                }
                ArrayList<ChunkerBlockIdentifier> identifiers = new ArrayList<ChunkerBlockIdentifier>(names.size());
                for (String name : names) {
                    ChunkerBlockIdentifier identifier = resolvers.readItemBlockIdentifier(new Identifier(name)).copyWithout(VanillaBlockStates.WATERLOGGED);
                    if (identifier.isAir()) continue;
                    identifiers.add(identifier);
                }
                return Optional.of(identifiers);
            }

            @Override
            public void write(@NotNull CompoundTag value, @NotNull List<ChunkerBlockIdentifier> chunkerBlockIdentifiers) {
                ArrayList<String> identifiers = new ArrayList<String>(chunkerBlockIdentifiers.size());
                for (ChunkerBlockIdentifier chunkerBlockIdentifier : chunkerBlockIdentifiers) {
                    Optional<Identifier> identifier = resolvers.writeItemBlockIdentifier(chunkerBlockIdentifier, true);
                    if (!identifier.isPresent() || identifier.get().getIdentifier().equals("minecraft:air")) continue;
                    identifiers.add(identifier.get().getIdentifier());
                }
                value.put("CanDestroy", ListTag.fromValues(TagType.STRING, identifiers));
            }
        });
        this.registerHandler(ChunkerItemProperty.REPAIR_COST, new PropertyHandler<CompoundTag, Integer>(){

            @Override
            public Optional<Integer> read(@NotNull CompoundTag value) {
                return value.getOptional("tag", CompoundTag.class).flatMap(tag -> tag.getOptionalValue("RepairCost", Integer.class));
            }

            @Override
            public void write(@NotNull CompoundTag value, @NotNull Integer repairCost) {
                value.getOrCreateCompound("tag").put("RepairCost", repairCost);
            }
        });
        this.registerHandler(ChunkerItemProperty.ENCHANTMENTS, new PropertyHandler<CompoundTag, Map<ChunkerEnchantmentType, Integer>>(){

            @Override
            public Optional<Map<ChunkerEnchantmentType, Integer>> read(@NotNull CompoundTag value) {
                CompoundTag tag = value.getCompound("tag");
                if (tag == null) {
                    return Optional.empty();
                }
                ListTag enchantmentTags = tag.getList("ench", CompoundTag.class, null);
                if (enchantmentTags == null) {
                    return Optional.empty();
                }
                EnumMap<ChunkerEnchantmentType, Integer> enchantments = new EnumMap<ChunkerEnchantmentType, Integer>(ChunkerEnchantmentType.class);
                for (CompoundTag enchantment : enchantmentTags) {
                    short id = enchantment.getShort("id", (short)-1);
                    if (id == -1) continue;
                    Optional<ChunkerEnchantmentType> enchantmentType = resolvers.enchantmentIDResolver().to(Integer.valueOf(id));
                    if (enchantmentType.isEmpty()) {
                        resolvers.converter().logMissingMapping(Converter.MissingMappingType.ENCHANTMENT, String.valueOf(id));
                        continue;
                    }
                    short level = enchantment.getShort("lvl", (short)1);
                    enchantments.put(enchantmentType.get(), Integer.valueOf(level));
                }
                return Optional.of(enchantments);
            }

            @Override
            public void write(@NotNull CompoundTag value, @NotNull Map<ChunkerEnchantmentType, Integer> enchantments) {
                ListTag enchantmentsTag = new ListTag(TagType.COMPOUND, value.size());
                for (Map.Entry<ChunkerEnchantmentType, Integer> enchantment : enchantments.entrySet()) {
                    Optional<Integer> id = resolvers.enchantmentIDResolver().from(enchantment.getKey());
                    if (id.isEmpty()) {
                        resolvers.converter().logMissingMapping(Converter.MissingMappingType.ENCHANTMENT, String.valueOf((Object)enchantment.getKey()));
                        continue;
                    }
                    CompoundTag enchantmentTag = new CompoundTag(2);
                    enchantmentTag.put("id", id.get().shortValue());
                    enchantmentTag.put("lvl", enchantment.getValue().shortValue());
                    enchantmentsTag.add(enchantmentTag);
                }
                value.getOrCreateCompound("tag").put("ench", enchantmentsTag);
            }
        });
        this.registerHandler(ChunkerItemProperty.MAP_INDEX, new PropertyHandler<CompoundTag, Integer>(){

            @Override
            public Optional<Integer> read(@NotNull CompoundTag value) {
                CompoundTag tag = value.getCompound("tag");
                if (tag == null) {
                    return Optional.empty();
                }
                Optional<Long> uuid = tag.getOptionalValue("map_uuid", Long.class);
                if (uuid.isPresent() && resolvers.converter().level().isPresent()) {
                    ChunkerLevel level = resolvers.converter().level().get();
                    return level.findMapIndexByOriginalID(uuid.get());
                }
                return Optional.empty();
            }

            @Override
            public void write(@NotNull CompoundTag value, @NotNull Integer index) {
                if (resolvers.converter().level().isPresent()) {
                    Optional<ChunkerMap> chunkerMap = resolvers.converter().level().get().getMapByIndex(index);
                    chunkerMap.ifPresent(map -> {
                        CompoundTag tag = value.getOrCreateCompound("tag");
                        tag.put("map_uuid", map.getId());
                        tag.put("map_name_index", index);
                    });
                }
            }
        });
        this.registerContextualHandler(ChunkerItemProperty.SPAWN_EGG_MOB, new PropertyHandler<Pair<ChunkerItemStack, CompoundTag>, ChunkerEntityType>(){

            @Override
            public Optional<ChunkerEntityType> read(@NotNull Pair<ChunkerItemStack, CompoundTag> state) {
                return state.right().getOptionalValue("ItemIdentifier", String.class).flatMap(identifier -> {
                    Optional<ChunkerEntityType> type = resolvers.entityTypeResolver().to((String)identifier);
                    if (type.isEmpty()) {
                        resolvers.converter().logMissingMapping(Converter.MissingMappingType.ENTITY_TYPE, (String)identifier);
                        if (((ChunkerItemStack)state.key()).getIdentifier() == ChunkerVanillaItemType.SPAWN_EGG) {
                            state.key(null);
                        }
                    }
                    return type;
                });
            }

            @Override
            public void write(@NotNull Pair<ChunkerItemStack, CompoundTag> state, @NotNull ChunkerEntityType entityType) {
                Optional<String> type = resolvers.entityTypeResolver().from(entityType);
                if (type.isPresent()) {
                    state.right().put("ItemIdentifier", type.get());
                } else {
                    resolvers.converter().logMissingMapping(Converter.MissingMappingType.ENTITY_TYPE, String.valueOf(entityType));
                    if (state.key().getIdentifier() == ChunkerVanillaItemType.SPAWN_EGG) {
                        state.value(null);
                    }
                }
            }
        });
        this.registerHandler(ChunkerItemProperty.BOOK_TITLE, new PropertyHandler<CompoundTag, String>(){

            @Override
            public Optional<String> read(@NotNull CompoundTag value) {
                CompoundTag tag = value.getCompound("tag");
                if (tag == null) {
                    return Optional.empty();
                }
                return tag.getOptionalValue("title", String.class);
            }

            @Override
            public void write(@NotNull CompoundTag value, @NotNull String title) {
                value.getOrCreateCompound("tag").put("title", title);
            }
        });
        this.registerHandler(ChunkerItemProperty.BOOK_AUTHOR, new PropertyHandler<CompoundTag, String>(){

            @Override
            public Optional<String> read(@NotNull CompoundTag value) {
                CompoundTag tag = value.getCompound("tag");
                if (tag == null) {
                    return Optional.empty();
                }
                return tag.getOptionalValue("author", String.class);
            }

            @Override
            public void write(@NotNull CompoundTag value, @NotNull String author) {
                value.getOrCreateCompound("tag").put("author", author);
            }
        });
        this.registerHandler(ChunkerItemProperty.BOOK_PAGES, new PropertyHandler<CompoundTag, List<JsonElement>>(){

            @Override
            public Optional<List<JsonElement>> read(@NotNull CompoundTag value) {
                CompoundTag tag = value.getCompound("tag");
                if (tag == null) {
                    return Optional.empty();
                }
                ListTag pages = tag.getList("pages", CompoundTag.class, null);
                if (pages == null) {
                    return Optional.empty();
                }
                ArrayList pagesJSON = new ArrayList(pages.size());
                for (CompoundTag page : pages) {
                    page.getOptionalValue("text", String.class).map(JsonTextUtil::fromText).ifPresent(pagesJSON::add);
                }
                return Optional.of(pagesJSON);
            }

            @Override
            public void write(@NotNull CompoundTag value, @NotNull List<JsonElement> values) {
                ListTag pages = new ListTag(TagType.COMPOUND, values.size());
                for (JsonElement text : values) {
                    CompoundTag page = new CompoundTag(2);
                    page.put("photoname", "");
                    page.put("text", JsonTextUtil.toLegacy(text, true));
                    pages.add(page);
                }
                value.getOrCreateCompound("tag").put("pages", pages);
            }
        });
        this.registerHandler(ChunkerItemProperty.FIREWORKS, new PropertyHandler<CompoundTag, ChunkerFireworks>(){

            @Override
            public Optional<ChunkerFireworks> read(@NotNull CompoundTag value) {
                Optional component = value.getOptional("tag", CompoundTag.class).flatMap(tag -> tag.getOptional("Fireworks", CompoundTag.class));
                if (component.isEmpty()) {
                    return Optional.empty();
                }
                byte duration = ((CompoundTag)component.get()).getByte("Flight", (byte)1);
                List<ChunkerFireworkExplosion> explosions = Collections.emptyList();
                ListTag explosionsTag = ((CompoundTag)component.get()).getList("Explosions", CompoundTag.class, null);
                if (explosionsTag != null) {
                    explosions = new ArrayList<ChunkerFireworkExplosion>(explosionsTag.size());
                    for (CompoundTag explosionTag : explosionsTag) {
                        ChunkerFireworkShape shape = explosionTag.getOptionalValue("FireworkType", Byte.class).map(Byte::intValue).flatMap(ChunkerFireworkShape::getByID).orElse(ChunkerFireworkShape.SMALL_BALL);
                        byte[] colorsRGB = explosionTag.getByteArray("FireworkColor", null);
                        List<Color> colors = colorsRGB == null ? Collections.emptyList() : BedrockLegacyItemStackResolver.this.mapFireworkColors(colorsRGB);
                        byte[] fadeColorsRGB = explosionTag.getByteArray("FireworkFade", null);
                        List<Color> fadeColors = fadeColorsRGB == null ? Collections.emptyList() : BedrockLegacyItemStackResolver.this.mapFireworkColors(fadeColorsRGB);
                        boolean trail = explosionTag.getByte("FireworkTrail", (byte)0) == 1;
                        boolean twinkle = explosionTag.getByte("FireworkFlicker", (byte)0) == 1;
                        explosions.add(new ChunkerFireworkExplosion(shape, colors, fadeColors, trail, twinkle));
                    }
                }
                return Optional.of(new ChunkerFireworks(duration, explosions));
            }

            @Override
            public void write(@NotNull CompoundTag value, @NotNull ChunkerFireworks chunkerFireworks) {
                if (chunkerFireworks.getExplosions().isEmpty() && chunkerFireworks.getFlightDuration() == 0) {
                    return;
                }
                CompoundTag tag = value.getOrCreateCompound("tag").getOrCreateCompound("Fireworks");
                tag.put("Flight", chunkerFireworks.getFlightDuration());
                if (!chunkerFireworks.getExplosions().isEmpty()) {
                    ListTag explosions = new ListTag(TagType.COMPOUND, chunkerFireworks.getExplosions().size());
                    for (ChunkerFireworkExplosion chunkerFireworkExplosion : chunkerFireworks.getExplosions()) {
                        CompoundTag explosion = new CompoundTag(5);
                        explosion.put("FireworkType", (byte)chunkerFireworkExplosion.getShape().getID());
                        explosion.put("FireworkColor", BedrockLegacyItemStackResolver.this.mapFireworkColors(chunkerFireworkExplosion.getColors(), true));
                        explosion.put("FireworkFade", BedrockLegacyItemStackResolver.this.mapFireworkColors(chunkerFireworkExplosion.getFadeColors(), false));
                        explosion.put("FireworkTrail", chunkerFireworkExplosion.isTrail() ? (byte)1 : 0);
                        explosion.put("FireworkFlicker", chunkerFireworkExplosion.isTwinkle() ? (byte)1 : 0);
                        explosions.add(explosion);
                    }
                    tag.put("Explosions", explosions);
                }
            }
        });
        this.registerHandler(ChunkerItemProperty.FIREWORK_EXPLOSION, new PropertyHandler<CompoundTag, ChunkerFireworkExplosion>(){

            @Override
            public Optional<ChunkerFireworkExplosion> read(@NotNull CompoundTag value) {
                Optional component = value.getOptional("tag", CompoundTag.class).flatMap(tag -> tag.getOptional("FireworksItem", CompoundTag.class));
                if (component.isEmpty()) {
                    return Optional.empty();
                }
                CompoundTag explosionTag = (CompoundTag)component.get();
                ChunkerFireworkShape shape = explosionTag.getOptionalValue("FireworkType", Byte.class).map(Byte::intValue).flatMap(ChunkerFireworkShape::getByID).orElse(ChunkerFireworkShape.SMALL_BALL);
                byte[] colorsRGB = explosionTag.getByteArray("FireworkColor", null);
                List<Color> colors = colorsRGB == null ? Collections.emptyList() : BedrockLegacyItemStackResolver.this.mapFireworkColors(colorsRGB);
                byte[] fadeColorsRGB = explosionTag.getByteArray("FireworkFade", null);
                List<Color> fadeColors = fadeColorsRGB == null ? Collections.emptyList() : BedrockLegacyItemStackResolver.this.mapFireworkColors(fadeColorsRGB);
                boolean trail = explosionTag.getByte("FireworkTrail", (byte)0) == 1;
                boolean twinkle = explosionTag.getByte("FireworkFlicker", (byte)0) == 1;
                return Optional.of(new ChunkerFireworkExplosion(shape, colors, fadeColors, trail, twinkle));
            }

            @Override
            public void write(@NotNull CompoundTag value, @NotNull ChunkerFireworkExplosion chunkerFireworkExplosion) {
                CompoundTag explosion = value.getOrCreateCompound("tag").getOrCreateCompound("FireworksItem");
                explosion.put("FireworkType", (byte)chunkerFireworkExplosion.getShape().getID());
                explosion.put("FireworkColor", BedrockLegacyItemStackResolver.this.mapFireworkColors(chunkerFireworkExplosion.getColors(), true));
                explosion.put("FireworkFade", BedrockLegacyItemStackResolver.this.mapFireworkColors(chunkerFireworkExplosion.getFadeColors(), false));
                explosion.put("FireworkTrail", chunkerFireworkExplosion.isTrail() ? (byte)1 : 0);
                explosion.put("FireworkFlicker", chunkerFireworkExplosion.isTwinkle() ? (byte)1 : 0);
            }
        });
        this.registerContextualHandler(ChunkerItemProperty.BLOCK_ENTITY, new PropertyHandler<Pair<ChunkerItemStack, CompoundTag>, BlockEntity>(){

            @Override
            public Optional<BlockEntity> read(@NotNull Pair<ChunkerItemStack, CompoundTag> state) {
                Optional<Class<BlockEntity>> blockEntityClass = resolvers.blockEntityResolver().getBlockEntityClass(state.key().getIdentifier().getItemStackType());
                if (blockEntityClass.isEmpty()) {
                    return Optional.empty();
                }
                CompoundTag blockEntityTag = state.value().getCompound("tag");
                Optional<Object> generated = Optional.empty();
                if (blockEntityTag != null) {
                    generated = resolvers.blockEntityResolver().to(blockEntityClass.get(), blockEntityTag);
                }
                generated = resolvers.blockEntityResolver().generateFromItemNBT(blockEntityClass.get(), state.key(), generated.orElse(null), state.value());
                return generated.map(blockEntity -> resolvers.blockEntityResolver().updateBeforeProcess((CompoundTag)state.value(), (ChunkerItemStack)state.key(), blockEntity));
            }

            @Override
            public void write(@NotNull Pair<ChunkerItemStack, CompoundTag> state, @NotNull BlockEntity value) {
                Optional<CompoundTag> blockEntityTag;
                value = resolvers.blockEntityResolver().updateBeforeWrite(state.value(), state.key(), value);
                boolean writeBlockEntityData = resolvers.blockEntityResolver().writeToItemNBT(state.key(), value, state.value());
                if (writeBlockEntityData && (blockEntityTag = resolvers.blockEntityResolver().from(value)).isPresent()) {
                    CompoundTag tag = blockEntityTag.get();
                    tag.remove("x");
                    tag.remove("y");
                    tag.remove("z");
                    tag.remove("facing");
                    tag.remove("Rotation");
                    tag.remove("Rot");
                    tag.remove("isMovable");
                    tag.remove("id");
                    state.value().put("tag", tag);
                }
            }
        });
    }

    public List<Color> mapFireworkColors(byte[] colorIndexes) {
        ArrayList<Color> colors = new ArrayList<Color>(colorIndexes.length);
        for (byte colorIndex : colorIndexes) {
            ChunkerDyeColor dyeColor = ChunkerDyeColor.getColorByReversedID(colorIndex).orElseThrow();
            colors.add(new Color(dyeColor.getJavaRGB()));
        }
        return colors;
    }

    public byte[] mapFireworkColors(List<Color> colors, boolean defaultBlack) {
        if (defaultBlack && colors.isEmpty()) {
            return new byte[]{(byte)ChunkerDyeColor.BLACK.getReversedID()};
        }
        byte[] mapped = new byte[colors.size()];
        for (int i = 0; i < colors.size(); ++i) {
            ChunkerDyeColor dyeColor = ChunkerDyeColor.findClosestDyeColor(colors.get(i));
            mapped[i] = (byte)dyeColor.getReversedID();
        }
        return mapped;
    }

    @Override
    protected Optional<ChunkerItemStack> createPropertyHolder(CompoundTag input) {
        Identifier identifier;
        CompoundTag blockCompound = input.getCompound("Block");
        if (blockCompound != null) {
            Optional<Identifier> blockIdentifier = ((BedrockResolvers)this.resolvers).nbtBlockIdentifierResolver().to(new BedrockBlockCompoundTag(blockCompound, false));
            if (blockIdentifier.isEmpty()) {
                return Optional.empty();
            }
            identifier = blockIdentifier.get();
        } else if (input.contains("Name")) {
            String name = input.getString("Name");
            if (name.isEmpty()) {
                name = "minecraft:air";
            }
            identifier = Identifier.fromData(name, OptionalInt.of(input.getShort("Damage", (short)0)));
        } else {
            return Optional.empty();
        }
        return Optional.of(((BedrockResolvers)this.resolvers).readItemIdentifier(identifier));
    }

    @Override
    protected Optional<CompoundTag> createOutput(ChunkerItemStack input) {
        CompoundTag output = new CompoundTag(3);
        Optional<Identifier> itemIdentifier = ((BedrockResolvers)this.resolvers).chunkerItemIdentifierResolver().from(input);
        if (itemIdentifier.isPresent()) {
            output.put("Name", itemIdentifier.get().getIdentifier());
            output.put("Damage", (short)itemIdentifier.get().getDataValue().orElse(0));
            return Optional.of(output);
        }
        ChunkerItemStackIdentifier chunkerItemStackIdentifier = input.getIdentifier();
        if (chunkerItemStackIdentifier instanceof ChunkerBlockIdentifier) {
            ChunkerBlockIdentifier chunkerBlockIdentifier = (ChunkerBlockIdentifier)chunkerItemStackIdentifier;
            Optional<Identifier> blockIdentifier = ((BedrockResolvers)this.resolvers).writeItemBlockIdentifier(chunkerBlockIdentifier, false);
            if (blockIdentifier.isEmpty()) {
                return Optional.empty();
            }
            Optional<BedrockBlockCompoundTag> blockCompoundTag = ((BedrockResolvers)this.resolvers).nbtBlockIdentifierResolver().from(blockIdentifier.get());
            if (blockCompoundTag.isEmpty()) {
                return Optional.empty();
            }
            String blockName = blockIdentifier.get().getIdentifier();
            output.put("Block", blockCompoundTag.get().compoundTag());
            output.put("Name", FIXED_LEGACY_NAMES.getOrDefault(blockName, blockName));
            output.put("Damage", (short)0);
            return Optional.of(output);
        }
        return Optional.empty();
    }
}

