/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.bedrock.base.writer;

import com.hivemc.chunker.conversion.encoding.base.Converter;
import com.hivemc.chunker.conversion.encoding.base.writer.ColumnWriter;
import com.hivemc.chunker.conversion.encoding.base.writer.WorldWriter;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.BedrockResolvers;
import com.hivemc.chunker.conversion.encoding.bedrock.base.writer.BedrockColumnWriter;
import com.hivemc.chunker.conversion.intermediate.world.ChunkerWorld;
import com.hivemc.chunker.conversion.intermediate.world.Dimension;
import java.io.File;
import java.util.concurrent.atomic.AtomicInteger;
import org.iq80.leveldb.DB;

public class BedrockWorldWriter
implements WorldWriter {
    protected final File outputFolder;
    protected final Converter converter;
    protected final BedrockResolvers resolvers;
    protected final DB database;
    protected final AtomicInteger entityID = new AtomicInteger(0);

    public BedrockWorldWriter(File outputFolder, Converter converter, BedrockResolvers resolvers, DB database) {
        this.outputFolder = outputFolder;
        this.converter = converter;
        this.resolvers = resolvers;
        this.database = database;
    }

    @Override
    public ColumnWriter writeWorld(ChunkerWorld chunkerWorld) {
        return this.createColumnWriter(chunkerWorld.getDimension());
    }

    public BedrockColumnWriter createColumnWriter(Dimension dimension) {
        return new BedrockColumnWriter(this, this.converter, this.resolvers, this.database, dimension);
    }

    public long generateUniqueEntityID() {
        return 0xFFFFFFFF00000000L | (long)this.entityID.getAndIncrement();
    }
}

