/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.bedrock.v1_17.writer;

import com.hivemc.chunker.conversion.encoding.base.Converter;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.BedrockResolvers;
import com.hivemc.chunker.conversion.encoding.bedrock.base.writer.BedrockChunkWriter;
import com.hivemc.chunker.conversion.encoding.bedrock.base.writer.BedrockWorldWriter;
import com.hivemc.chunker.conversion.encoding.bedrock.util.LevelDBChunkType;
import com.hivemc.chunker.conversion.encoding.bedrock.util.LevelDBKey;
import com.hivemc.chunker.conversion.encoding.bedrock.v1_17.writer.ChunkWriter;
import com.hivemc.chunker.conversion.intermediate.column.ChunkerColumn;
import com.hivemc.chunker.conversion.intermediate.world.Dimension;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.WriteBatch;

public class ColumnWriter
extends com.hivemc.chunker.conversion.encoding.bedrock.v1_16.writer.ColumnWriter {
    public ColumnWriter(BedrockWorldWriter parent, Converter converter, BedrockResolvers resolvers, DB database, Dimension dimension) {
        super(parent, converter, resolvers, database, dimension);
    }

    protected boolean isWriteBlendingData() {
        return this.converter.level().map(level -> level.getSettings().CavesAndCliffs).orElse(true);
    }

    @Override
    protected void writeMetadata(ChunkerColumn chunkerColumn) throws Exception {
        try (WriteBatch writeBatch = this.database.createWriteBatch();){
            if (this.isWriteBlendingData()) {
                writeBatch.put(LevelDBKey.key(this.dimension, chunkerColumn.getPosition(), LevelDBChunkType.GENERATED_PRE_CAVES_AND_CLIFFS_BLENDING), new byte[]{0});
                writeBatch.put(LevelDBKey.key(this.dimension, chunkerColumn.getPosition(), LevelDBChunkType.VERSION), new byte[]{37});
            }
            writeBatch.put(LevelDBKey.key(this.dimension, chunkerColumn.getPosition(), LevelDBChunkType.LEGACY_VERSION), new byte[]{7});
            this.database.write(writeBatch);
        }
    }

    @Override
    public BedrockChunkWriter createChunkWriter(ChunkerColumn column) {
        return new ChunkWriter(this.converter, this.resolvers, this.database, this.dimension, column);
    }
}

