/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.java;

import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.nbt.tags.Tag;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public class JavaDataVersion
implements Comparable<JavaDataVersion> {
    private static final TreeMap<Integer, JavaDataVersion> DATA_VERSION_LOOKUP = new TreeMap();
    private static final TreeMap<Version, JavaDataVersion> VERSION_LOOKUP = new TreeMap();
    public static final JavaDataVersion V1_8_8 = JavaDataVersion.register(0, new Version(1, 8, 8));
    public static final JavaDataVersion V1_9 = JavaDataVersion.register(169, new Version(1, 9, 0));
    public static final JavaDataVersion V1_9_1 = JavaDataVersion.register(175, new Version(1, 9, 1));
    public static final JavaDataVersion V1_9_2 = JavaDataVersion.register(176, new Version(1, 9, 2));
    public static final JavaDataVersion V1_9_4 = JavaDataVersion.register(184, new Version(1, 9, 4));
    public static final JavaDataVersion V1_9_3 = JavaDataVersion.register(183, new Version(1, 9, 3));
    public static final JavaDataVersion V1_10 = JavaDataVersion.register(510, new Version(1, 10, 0));
    public static final JavaDataVersion V1_10_1 = JavaDataVersion.register(511, new Version(1, 10, 1));
    public static final JavaDataVersion V1_10_2 = JavaDataVersion.register(512, new Version(1, 10, 2));
    public static final JavaDataVersion V1_11 = JavaDataVersion.register(819, new Version(1, 11, 0));
    public static final JavaDataVersion V1_11_1 = JavaDataVersion.register(921, new Version(1, 11, 1));
    public static final JavaDataVersion V1_11_2 = JavaDataVersion.register(922, new Version(1, 11, 2));
    public static final JavaDataVersion V1_12 = JavaDataVersion.register(1139, new Version(1, 12, 0));
    public static final JavaDataVersion V1_12_1 = JavaDataVersion.register(1241, new Version(1, 12, 1));
    public static final JavaDataVersion V1_12_2 = JavaDataVersion.register(1343, new Version(1, 12, 2));
    public static final JavaDataVersion V1_13 = JavaDataVersion.register(1519, new Version(1, 13, 0));
    public static final JavaDataVersion V1_13_1 = JavaDataVersion.register(1628, new Version(1, 13, 1));
    public static final JavaDataVersion V1_13_2 = JavaDataVersion.register(1631, new Version(1, 13, 2));
    public static final JavaDataVersion V1_14 = JavaDataVersion.register(1952, new Version(1, 14, 0));
    public static final JavaDataVersion V1_14_1 = JavaDataVersion.register(1957, new Version(1, 14, 1));
    public static final JavaDataVersion V1_14_2 = JavaDataVersion.register(1963, new Version(1, 14, 2));
    public static final JavaDataVersion V1_14_3 = JavaDataVersion.register(1968, new Version(1, 14, 3));
    public static final JavaDataVersion V1_14_4 = JavaDataVersion.register(1976, new Version(1, 14, 4));
    public static final JavaDataVersion V1_15 = JavaDataVersion.register(2225, new Version(1, 15, 0));
    public static final JavaDataVersion V1_15_1 = JavaDataVersion.register(2227, new Version(1, 15, 1));
    public static final JavaDataVersion V1_15_2 = JavaDataVersion.register(2230, new Version(1, 15, 2));
    public static final JavaDataVersion V1_16 = JavaDataVersion.register(2566, new Version(1, 16, 0));
    public static final JavaDataVersion V1_16_1 = JavaDataVersion.register(2567, new Version(1, 16, 1));
    public static final JavaDataVersion V1_16_2 = JavaDataVersion.register(2578, new Version(1, 16, 2));
    public static final JavaDataVersion V1_16_3 = JavaDataVersion.register(2580, new Version(1, 16, 3));
    public static final JavaDataVersion V1_16_4 = JavaDataVersion.register(2584, new Version(1, 16, 4));
    public static final JavaDataVersion V1_16_5 = JavaDataVersion.register(2586, new Version(1, 16, 5));
    public static final JavaDataVersion V1_17 = JavaDataVersion.register(2724, new Version(1, 17, 0));
    public static final JavaDataVersion V1_17_1 = JavaDataVersion.register(2730, new Version(1, 17, 1));
    public static final JavaDataVersion V1_18 = JavaDataVersion.register(2860, new Version(1, 18, 0));
    public static final JavaDataVersion V1_18_1 = JavaDataVersion.register(2865, new Version(1, 18, 1));
    public static final JavaDataVersion V1_18_2 = JavaDataVersion.register(2975, new Version(1, 18, 2));
    public static final JavaDataVersion V1_19 = JavaDataVersion.register(3105, new Version(1, 19, 0));
    public static final JavaDataVersion V1_19_1 = JavaDataVersion.register(3117, new Version(1, 19, 1));
    public static final JavaDataVersion V1_19_2 = JavaDataVersion.register(3120, new Version(1, 19, 2));
    public static final JavaDataVersion V1_19_3 = JavaDataVersion.register(3218, new Version(1, 19, 3));
    public static final JavaDataVersion V1_19_4 = JavaDataVersion.register(3337, new Version(1, 19, 4));
    public static final JavaDataVersion V1_20 = JavaDataVersion.register(3463, new Version(1, 20, 0));
    public static final JavaDataVersion V1_20_1 = JavaDataVersion.register(3465, new Version(1, 20, 1));
    public static final JavaDataVersion V1_20_2 = JavaDataVersion.register(3578, new Version(1, 20, 2));
    public static final JavaDataVersion V1_20_3 = JavaDataVersion.register(3698, new Version(1, 20, 3));
    public static final JavaDataVersion V1_20_4 = JavaDataVersion.register(3700, new Version(1, 20, 4));
    public static final JavaDataVersion V1_20_5 = JavaDataVersion.register(3837, new Version(1, 20, 5));
    public static final JavaDataVersion V1_20_6 = JavaDataVersion.register(3839, new Version(1, 20, 6));
    public static final JavaDataVersion V1_21 = JavaDataVersion.register(3953, new Version(1, 21, 0));
    public static final JavaDataVersion V1_21_1 = JavaDataVersion.register(3955, new Version(1, 21, 1));
    public static final JavaDataVersion V1_21_2 = JavaDataVersion.register(4080, new Version(1, 21, 2));
    public static final JavaDataVersion V1_21_3 = JavaDataVersion.register(4082, new Version(1, 21, 3));
    public static final JavaDataVersion V1_21_4 = JavaDataVersion.register(4189, new Version(1, 21, 4));
    public static final JavaDataVersion V1_21_5 = JavaDataVersion.register(4325, new Version(1, 21, 5));
    public static final JavaDataVersion V1_21_6 = JavaDataVersion.register(4435, new Version(1, 21, 6));
    public static final JavaDataVersion V1_21_7 = JavaDataVersion.register(4438, new Version(1, 21, 7));
    public static final JavaDataVersion V1_21_8 = JavaDataVersion.register(4440, new Version(1, 21, 8));
    public static final JavaDataVersion V1_21_9 = JavaDataVersion.register(4554, new Version(1, 21, 9));
    public static final JavaDataVersion V1_21_10 = JavaDataVersion.register(4556, new Version(1, 21, 10));
    public static final JavaDataVersion V1_21_11 = JavaDataVersion.register(4663, new Version(1, 21, 11));
    public static final int LAST_ANVIL_FILE_VERSION = 19133;
    private final int dataVersion;
    private final Version version;

    public JavaDataVersion(int dataVersion, Version version) {
        this.dataVersion = dataVersion;
        this.version = version;
    }

    public static JavaDataVersion register(int dataVersion, Version javaVersion) {
        JavaDataVersion javaDataVersion = new JavaDataVersion(dataVersion, javaVersion);
        DATA_VERSION_LOOKUP.put(dataVersion, javaDataVersion);
        VERSION_LOOKUP.put(javaDataVersion.getVersion(), javaDataVersion);
        return javaDataVersion;
    }

    public static JavaDataVersion oldest() {
        return DATA_VERSION_LOOKUP.firstEntry().getValue();
    }

    public static JavaDataVersion latest() {
        return DATA_VERSION_LOOKUP.lastEntry().getValue();
    }

    public static JavaDataVersion getNearestVersion(int dataVersion) {
        Map.Entry<Integer, JavaDataVersion> entry = DATA_VERSION_LOOKUP.floorEntry(dataVersion);
        return entry == null ? JavaDataVersion.oldest() : entry.getValue();
    }

    public static JavaDataVersion getNearestVersion(Version version) {
        Map.Entry<Version, JavaDataVersion> entry = VERSION_LOOKUP.floorEntry(version);
        return entry == null ? JavaDataVersion.oldest() : entry.getValue();
    }

    public static Collection<JavaDataVersion> getVersions() {
        return Collections.unmodifiableCollection(DATA_VERSION_LOOKUP.values());
    }

    public static Optional<JavaDataVersion> detect(File directory) {
        try {
            CompoundTag level = Tag.readGZipJavaNBT(new File(directory, "level.dat"));
            CompoundTag versionTag = Objects.requireNonNull(level).getCompound("Version");
            if (versionTag == null) {
                if (level.getInt("version", -1) != 19133) {
                    return Optional.empty();
                }
                return Optional.ofNullable(JavaDataVersion.getNearestVersion(0));
            }
            return versionTag.getOptionalValue("Id", Integer.class).map(JavaDataVersion::getNearestVersion);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public int getDataVersion() {
        return this.dataVersion;
    }

    public Version getVersion() {
        return this.version;
    }

    public String toString() {
        return "JavaDataVersion{dataVersion=" + this.dataVersion + ", version=" + String.valueOf(this.version) + "}";
    }

    @Override
    public int compareTo(@NotNull JavaDataVersion o) {
        return this.version.compareTo(o.getVersion());
    }
}

